/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-02-14 15:24:19 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `webpyme_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=881 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2093 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=500 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_snippets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tags` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scope` varchar(15) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'global',
  `priority` smallint NOT NULL DEFAULT '10',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `revision` bigint NOT NULL DEFAULT '1',
  `cloud_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_wpforms_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `types` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint DEFAULT NULL,
  `entry_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_wpforms_payment_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `payment_id` bigint NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_wpforms_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `discount_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `total_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `entry_id` bigint NOT NULL DEFAULT '0',
  `gateway` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `mode` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `transaction_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `customer_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_wpforms_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_wpmailsmtp_debug_events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_520_ci,
  `initiator` text COLLATE utf8mb4_unicode_520_ci,
  `event_type` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `webpyme_wpmailsmtp_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: webpyme_actionscheduler_actions */
INSERT INTO `webpyme_actionscheduler_actions` VALUES("54", "action_scheduler/migration_hook", "failed", "2025-01-08 18:00:57", "2025-01-08 18:00:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1736359257;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1736359257;}", "1", "1", "2025-01-08 18:01:41", "2025-01-08 18:01:41", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("64", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-01-16 14:13:25", "2025-01-16 14:13:25", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737036805;s:18:\"\0*\0first_timestamp\";i:1736412665;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737036805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-01-16 16:52:30", "2025-01-16 16:52:30", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("69", "wp_mail_smtp_admin_notifications_update", "complete", "2025-01-14 15:23:10", "2025-01-14 15:23:10", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1736868190;s:18:\"\0*\0first_timestamp\";i:1736359361;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1736868190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-01-14 16:08:49", "2025-01-14 16:08:49", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("70", "wpforms_process_forms_locator_scan", "complete", "2025-01-14 15:23:10", "2025-01-14 15:23:10", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1736868190;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1736868190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-14 16:08:49", "2025-01-14 16:08:49", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("71", "wpforms_process_purge_spam", "complete", "2025-01-14 15:23:10", "2025-01-14 15:23:10", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1736868190;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1736868190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-14 16:08:49", "2025-01-14 16:08:49", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("72", "wp_mail_smtp_summary_report_email", "complete", "2025-01-20 15:23:10", "2025-01-20 15:23:10", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737386590;s:18:\"\0*\0first_timestamp\";i:1736776800;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737386590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-01-21 16:16:20", "2025-01-21 16:16:20", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("74", "wp_mail_smtp_admin_notifications_update", "complete", "2025-01-15 16:08:49", "2025-01-15 16:08:49", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1736957329;s:18:\"\0*\0first_timestamp\";i:1736359361;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1736957329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-01-16 16:52:29", "2025-01-16 16:52:29", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("75", "wpforms_process_forms_locator_scan", "complete", "2025-01-15 16:08:49", "2025-01-15 16:08:49", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1736957329;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1736957329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-16 16:52:30", "2025-01-16 16:52:30", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("76", "wpforms_process_purge_spam", "complete", "2025-01-15 16:08:49", "2025-01-15 16:08:49", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1736957329;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1736957329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-16 16:52:30", "2025-01-16 16:52:30", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("77", "wpforms_admin_notifications_update", "complete", "2025-01-14 16:09:41", "2025-01-14 16:09:41", "10", "{\"tasks_meta_id\":6}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-01-14 16:09:44", "2025-01-14 16:09:44", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("78", "wp_mail_smtp_admin_notifications_update", "complete", "2025-01-17 16:52:29", "2025-01-17 16:52:29", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737132749;s:18:\"\0*\0first_timestamp\";i:1736359361;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737132749;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-01-17 19:12:00", "2025-01-17 19:12:00", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("79", "wpforms_process_forms_locator_scan", "complete", "2025-01-17 16:52:30", "2025-01-17 16:52:30", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737132750;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737132750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-17 19:12:00", "2025-01-17 19:12:00", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("80", "wpforms_process_purge_spam", "complete", "2025-01-17 16:52:30", "2025-01-17 16:52:30", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737132750;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737132750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-17 19:12:00", "2025-01-17 19:12:00", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("81", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-01-23 16:52:30", "2025-01-23 16:52:30", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737651150;s:18:\"\0*\0first_timestamp\";i:1736412665;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737651150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-02-06 14:45:42", "2025-02-06 14:45:42", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("82", "wpforms_admin_notifications_update", "complete", "2025-01-16 16:53:02", "2025-01-16 16:53:02", "10", "{\"tasks_meta_id\":7}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-01-16 16:53:06", "2025-01-16 16:53:06", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("83", "wp_mail_smtp_admin_notifications_update", "complete", "2025-01-18 19:12:00", "2025-01-18 19:12:00", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737227520;s:18:\"\0*\0first_timestamp\";i:1736359361;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737227520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-01-19 17:20:04", "2025-01-19 17:20:04", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("84", "wpforms_process_forms_locator_scan", "complete", "2025-01-18 19:12:00", "2025-01-18 19:12:00", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737227520;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737227520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-19 17:20:04", "2025-01-19 17:20:04", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("85", "wpforms_process_purge_spam", "complete", "2025-01-18 19:12:00", "2025-01-18 19:12:00", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737227520;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737227520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-19 17:20:04", "2025-01-19 17:20:04", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("86", "wp_mail_smtp_admin_notifications_update", "complete", "2025-01-20 17:20:04", "2025-01-20 17:20:04", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737393604;s:18:\"\0*\0first_timestamp\";i:1736359361;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737393604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-01-21 16:16:21", "2025-01-21 16:16:21", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("87", "wpforms_process_forms_locator_scan", "complete", "2025-01-20 17:20:04", "2025-01-20 17:20:04", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737393604;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737393604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-21 16:16:21", "2025-01-21 16:16:21", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("88", "wpforms_process_purge_spam", "complete", "2025-01-20 17:20:04", "2025-01-20 17:20:04", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737393604;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737393604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-21 16:16:21", "2025-01-21 16:16:21", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("89", "wp_mail_smtp_summary_report_email", "complete", "2025-01-28 16:16:20", "2025-01-28 16:16:20", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1738080980;s:18:\"\0*\0first_timestamp\";i:1736776800;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1738080980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-02-06 14:45:42", "2025-02-06 14:45:42", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("90", "wp_mail_smtp_admin_notifications_update", "complete", "2025-01-22 16:16:21", "2025-01-22 16:16:21", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737562581;s:18:\"\0*\0first_timestamp\";i:1736359361;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737562581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-01-23 15:47:21", "2025-01-23 15:47:21", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("91", "wpforms_process_forms_locator_scan", "complete", "2025-01-22 16:16:21", "2025-01-22 16:16:21", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737562581;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737562581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-23 15:47:21", "2025-01-23 15:47:21", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("92", "wpforms_process_purge_spam", "complete", "2025-01-22 16:16:21", "2025-01-22 16:16:21", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737562581;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737562581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-23 15:47:21", "2025-01-23 15:47:21", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("93", "wpforms_admin_notifications_update", "complete", "2025-01-21 16:16:56", "2025-01-21 16:16:56", "10", "{\"tasks_meta_id\":8}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-01-21 16:17:01", "2025-01-21 16:17:01", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("94", "wp_mail_smtp_admin_notifications_update", "complete", "2025-01-24 15:47:21", "2025-01-24 15:47:21", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737733641;s:18:\"\0*\0first_timestamp\";i:1736359361;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737733641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-02-06 14:45:42", "2025-02-06 14:45:42", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("95", "wpforms_process_forms_locator_scan", "complete", "2025-01-24 15:47:21", "2025-01-24 15:47:21", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737733641;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737733641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-02-06 14:45:42", "2025-02-06 14:45:42", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("96", "wpforms_process_purge_spam", "complete", "2025-01-24 15:47:21", "2025-01-24 15:47:21", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737733641;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737733641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-02-06 14:45:42", "2025-02-06 14:45:42", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("97", "wpforms_admin_notifications_update", "complete", "2025-01-23 15:47:56", "2025-01-23 15:47:56", "10", "{\"tasks_meta_id\":9}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-01-23 15:49:01", "2025-01-23 15:49:01", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("98", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-02-13 14:45:42", "2025-02-13 14:45:42", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1739457942;s:18:\"\0*\0first_timestamp\";i:1736412665;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1739457942;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-02-14 14:55:07", "2025-02-14 14:55:07", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("99", "wp_mail_smtp_admin_notifications_update", "complete", "2025-02-07 14:45:42", "2025-02-07 14:45:42", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1738939542;s:18:\"\0*\0first_timestamp\";i:1736359361;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1738939542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-02-14 14:55:07", "2025-02-14 14:55:07", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("100", "wpforms_process_forms_locator_scan", "complete", "2025-02-07 14:45:42", "2025-02-07 14:45:42", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1738939542;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1738939542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-02-14 14:55:07", "2025-02-14 14:55:07", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("101", "wpforms_process_purge_spam", "complete", "2025-02-07 14:45:42", "2025-02-07 14:45:42", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1738939542;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1738939542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-02-14 14:55:07", "2025-02-14 14:55:07", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("102", "wp_mail_smtp_summary_report_email", "complete", "2025-02-13 14:45:42", "2025-02-13 14:45:42", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1739457942;s:18:\"\0*\0first_timestamp\";i:1736776800;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1739457942;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-02-14 14:55:07", "2025-02-14 14:55:07", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("103", "wp_mail_smtp_admin_notifications_update", "pending", "2025-02-15 14:55:07", "2025-02-15 14:55:07", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1739631307;s:18:\"\0*\0first_timestamp\";i:1736359361;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1739631307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("104", "wpforms_process_forms_locator_scan", "pending", "2025-02-15 14:55:07", "2025-02-15 14:55:07", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1739631307;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1739631307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("105", "wpforms_process_purge_spam", "pending", "2025-02-15 14:55:07", "2025-02-15 14:55:07", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1739631307;s:18:\"\0*\0first_timestamp\";i:1736359407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1739631307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("106", "wpforms_email_summaries_fetch_info_blocks", "pending", "2025-02-21 14:55:07", "2025-02-21 14:55:07", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1740149707;s:18:\"\0*\0first_timestamp\";i:1736412665;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1740149707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("107", "wp_mail_smtp_summary_report_email", "pending", "2025-02-21 14:55:07", "2025-02-21 14:55:07", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1740149707;s:18:\"\0*\0first_timestamp\";i:1736776800;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1740149707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `webpyme_actionscheduler_actions` VALUES("108", "wpforms_admin_notifications_update", "complete", "2025-02-14 14:58:01", "2025-02-14 14:58:01", "10", "{\"tasks_meta_id\":10}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-02-14 14:58:05", "2025-02-14 14:58:05", "0", NULL);

/* INSERT TABLE DATA: webpyme_actionscheduler_groups */
INSERT INTO `webpyme_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `webpyme_actionscheduler_groups` VALUES("2", "wp_mail_smtp");
INSERT INTO `webpyme_actionscheduler_groups` VALUES("3", "wpforms");

/* INSERT TABLE DATA: webpyme_actionscheduler_logs */
INSERT INTO `webpyme_actionscheduler_logs` VALUES("4", "54", "action created", "2025-01-08 17:59:57", "2025-01-08 17:59:57");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("7", "54", "action started via WP Cron", "2025-01-08 18:01:41", "2025-01-08 18:01:41");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("8", "54", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-01-08 18:01:41", "2025-01-08 18:01:41");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("26", "64", "action created", "2025-01-09 14:13:25", "2025-01-09 14:13:25");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("41", "69", "action created", "2025-01-13 15:23:10", "2025-01-13 15:23:10");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("44", "70", "action created", "2025-01-13 15:23:10", "2025-01-13 15:23:10");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("47", "71", "action created", "2025-01-13 15:23:10", "2025-01-13 15:23:10");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("50", "72", "action created", "2025-01-13 15:23:10", "2025-01-13 15:23:10");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("54", "69", "action started via WP Cron", "2025-01-14 16:08:48", "2025-01-14 16:08:48");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("55", "69", "action complete via WP Cron", "2025-01-14 16:08:49", "2025-01-14 16:08:49");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("56", "74", "action created", "2025-01-14 16:08:49", "2025-01-14 16:08:49");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("57", "70", "action started via WP Cron", "2025-01-14 16:08:49", "2025-01-14 16:08:49");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("58", "70", "action complete via WP Cron", "2025-01-14 16:08:49", "2025-01-14 16:08:49");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("59", "75", "action created", "2025-01-14 16:08:49", "2025-01-14 16:08:49");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("60", "71", "action started via WP Cron", "2025-01-14 16:08:49", "2025-01-14 16:08:49");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("61", "71", "action complete via WP Cron", "2025-01-14 16:08:49", "2025-01-14 16:08:49");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("62", "76", "action created", "2025-01-14 16:08:49", "2025-01-14 16:08:49");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("63", "77", "action created", "2025-01-14 16:09:41", "2025-01-14 16:09:41");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("64", "77", "action started via Async Request", "2025-01-14 16:09:44", "2025-01-14 16:09:44");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("65", "77", "action complete via Async Request", "2025-01-14 16:09:44", "2025-01-14 16:09:44");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("66", "74", "action started via WP Cron", "2025-01-16 16:52:29", "2025-01-16 16:52:29");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("67", "74", "action complete via WP Cron", "2025-01-16 16:52:29", "2025-01-16 16:52:29");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("68", "78", "action created", "2025-01-16 16:52:29", "2025-01-16 16:52:29");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("69", "75", "action started via WP Cron", "2025-01-16 16:52:29", "2025-01-16 16:52:29");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("70", "75", "action complete via WP Cron", "2025-01-16 16:52:30", "2025-01-16 16:52:30");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("71", "79", "action created", "2025-01-16 16:52:30", "2025-01-16 16:52:30");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("72", "76", "action started via WP Cron", "2025-01-16 16:52:30", "2025-01-16 16:52:30");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("73", "76", "action complete via WP Cron", "2025-01-16 16:52:30", "2025-01-16 16:52:30");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("74", "80", "action created", "2025-01-16 16:52:30", "2025-01-16 16:52:30");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("75", "64", "action started via WP Cron", "2025-01-16 16:52:30", "2025-01-16 16:52:30");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("76", "64", "action complete via WP Cron", "2025-01-16 16:52:30", "2025-01-16 16:52:30");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("77", "81", "action created", "2025-01-16 16:52:30", "2025-01-16 16:52:30");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("78", "82", "action created", "2025-01-16 16:53:02", "2025-01-16 16:53:02");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("79", "82", "action started via Async Request", "2025-01-16 16:53:06", "2025-01-16 16:53:06");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("80", "82", "action complete via Async Request", "2025-01-16 16:53:06", "2025-01-16 16:53:06");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("81", "78", "action started via WP Cron", "2025-01-17 19:12:00", "2025-01-17 19:12:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("82", "78", "action complete via WP Cron", "2025-01-17 19:12:00", "2025-01-17 19:12:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("83", "83", "action created", "2025-01-17 19:12:00", "2025-01-17 19:12:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("84", "79", "action started via WP Cron", "2025-01-17 19:12:00", "2025-01-17 19:12:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("85", "79", "action complete via WP Cron", "2025-01-17 19:12:00", "2025-01-17 19:12:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("86", "84", "action created", "2025-01-17 19:12:00", "2025-01-17 19:12:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("87", "80", "action started via WP Cron", "2025-01-17 19:12:00", "2025-01-17 19:12:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("88", "80", "action complete via WP Cron", "2025-01-17 19:12:00", "2025-01-17 19:12:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("89", "85", "action created", "2025-01-17 19:12:00", "2025-01-17 19:12:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("90", "83", "action started via WP Cron", "2025-01-19 17:20:03", "2025-01-19 17:20:03");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("91", "83", "action complete via WP Cron", "2025-01-19 17:20:04", "2025-01-19 17:20:04");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("92", "86", "action created", "2025-01-19 17:20:04", "2025-01-19 17:20:04");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("93", "84", "action started via WP Cron", "2025-01-19 17:20:04", "2025-01-19 17:20:04");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("94", "84", "action complete via WP Cron", "2025-01-19 17:20:04", "2025-01-19 17:20:04");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("95", "87", "action created", "2025-01-19 17:20:04", "2025-01-19 17:20:04");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("96", "85", "action started via WP Cron", "2025-01-19 17:20:04", "2025-01-19 17:20:04");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("97", "85", "action complete via WP Cron", "2025-01-19 17:20:04", "2025-01-19 17:20:04");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("98", "88", "action created", "2025-01-19 17:20:04", "2025-01-19 17:20:04");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("99", "72", "action started via WP Cron", "2025-01-21 16:16:20", "2025-01-21 16:16:20");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("100", "72", "action complete via WP Cron", "2025-01-21 16:16:20", "2025-01-21 16:16:20");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("101", "89", "action created", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("102", "86", "action started via WP Cron", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("103", "86", "action complete via WP Cron", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("104", "90", "action created", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("105", "87", "action started via WP Cron", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("106", "87", "action complete via WP Cron", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("107", "91", "action created", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("108", "88", "action started via WP Cron", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("109", "88", "action complete via WP Cron", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("110", "92", "action created", "2025-01-21 16:16:21", "2025-01-21 16:16:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("111", "93", "action created", "2025-01-21 16:16:56", "2025-01-21 16:16:56");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("112", "93", "action started via Async Request", "2025-01-21 16:17:01", "2025-01-21 16:17:01");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("113", "93", "action complete via Async Request", "2025-01-21 16:17:01", "2025-01-21 16:17:01");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("114", "90", "action started via WP Cron", "2025-01-23 15:47:21", "2025-01-23 15:47:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("115", "90", "action complete via WP Cron", "2025-01-23 15:47:21", "2025-01-23 15:47:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("116", "94", "action created", "2025-01-23 15:47:21", "2025-01-23 15:47:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("117", "91", "action started via WP Cron", "2025-01-23 15:47:21", "2025-01-23 15:47:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("118", "91", "action complete via WP Cron", "2025-01-23 15:47:21", "2025-01-23 15:47:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("119", "95", "action created", "2025-01-23 15:47:21", "2025-01-23 15:47:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("120", "92", "action started via WP Cron", "2025-01-23 15:47:21", "2025-01-23 15:47:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("121", "92", "action complete via WP Cron", "2025-01-23 15:47:21", "2025-01-23 15:47:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("122", "96", "action created", "2025-01-23 15:47:21", "2025-01-23 15:47:21");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("123", "97", "action created", "2025-01-23 15:47:56", "2025-01-23 15:47:56");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("124", "97", "action started via WP Cron", "2025-01-23 15:49:00", "2025-01-23 15:49:00");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("125", "97", "action complete via WP Cron", "2025-01-23 15:49:01", "2025-01-23 15:49:01");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("126", "81", "action started via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("127", "81", "action complete via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("128", "98", "action created", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("129", "94", "action started via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("130", "94", "action complete via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("131", "99", "action created", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("132", "95", "action started via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("133", "95", "action complete via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("134", "100", "action created", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("135", "96", "action started via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("136", "96", "action complete via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("137", "101", "action created", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("138", "89", "action started via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("139", "89", "action complete via WP Cron", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("140", "102", "action created", "2025-02-06 14:45:42", "2025-02-06 14:45:42");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("141", "99", "action started via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("142", "99", "action complete via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("143", "103", "action created", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("144", "100", "action started via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("145", "100", "action complete via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("146", "104", "action created", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("147", "101", "action started via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("148", "101", "action complete via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("149", "105", "action created", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("150", "98", "action started via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("151", "98", "action complete via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("152", "106", "action created", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("153", "102", "action started via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("154", "102", "action complete via WP Cron", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("155", "107", "action created", "2025-02-14 14:55:07", "2025-02-14 14:55:07");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("156", "108", "action created", "2025-02-14 14:58:01", "2025-02-14 14:58:01");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("157", "108", "action started via Async Request", "2025-02-14 14:58:04", "2025-02-14 14:58:04");
INSERT INTO `webpyme_actionscheduler_logs` VALUES("158", "108", "action complete via Async Request", "2025-02-14 14:58:05", "2025-02-14 14:58:05");

/* INSERT TABLE DATA: webpyme_comments */
INSERT INTO `webpyme_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-01-07 16:54:46", "2025-01-07 16:54:46", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: webpyme_duplicator_packages */
INSERT INTO `webpyme_duplicator_packages` VALUES("1", "BACKUP_cpingenieria", "387484cac5f645935418_20250214152412", "23", "2025-02-14 15:24:19", "webmaster", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-02-14 15:24:12\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.34\";s:10:\"VersionPHP\";s:6:\"8.1.31\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:19:\"BACKUP_cpingenieria\";s:4:\"Hash\";s:35:\"387484cac5f645935418_20250214152412\";s:8:\"NameHash\";s:55:\"BACKUP_cpingenieria_387484cac5f645935418_20250214152412\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:65:\"BACKUP_cpingenieria_387484cac5f645935418_20250214152412_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.5\";s:6:\"WPUser\";s:9:\"webmaster\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:1;s:4:\"File\";s:67:\"BACKUP_cpingenieria_387484cac5f645935418_20250214152412_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:32:\"/home/cypingen/public_html/sitio\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:0;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:0;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-02-14 15:24:12\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.34\";s:10:\"VersionPHP\";s:6:\"8.1.31\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"BACKUP_cpingenieria\";s:4:\"Hash\";s:35:\"387484cac5f645935418_20250214152412\";s:8:\"NameHash\";s:55:\"BACKUP_cpingenieria_387484cac5f645935418_20250214152412\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:73:\"BACKUP_cpingenieria_387484cac5f645935418_20250214152412_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:46:\"/home/cypingen/public_html/sitio/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:68:\"BACKUP_cpingenieria_387484cac5f645935418_20250214152412_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:133:\"/home/cypingen/public_html/sitio/wp-content/backups-dup-lite/tmp/BACKUP_cpingenieria_387484cac5f645935418_20250214152412_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:41:\"/home/cypingen/public_html/sitio/wp-admin\";i:1;s:44:\"/home/cypingen/public_html/sitio/wp-includes\";i:2;s:53:\"/home/cypingen/public_html/sitio/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:32:\"/home/cypingen/public_html/sitio\";i:1;s:32:\"/home/cypingen/public_html/sitio\";i:2;s:43:\"/home/cypingen/public_html/sitio/wp-content\";i:3;s:51:\"/home/cypingen/public_html/sitio/wp-content/uploads\";i:4;s:51:\"/home/cypingen/public_html/sitio/wp-content/plugins\";i:5;s:54:\"/home/cypingen/public_html/sitio/wp-content/mu-plugins\";i:6;s:50:\"/home/cypingen/public_html/sitio/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:64:\"/home/cypingen/public_html/sitio/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: webpyme_options */
INSERT INTO `webpyme_options` VALUES("1", "cron", "a:13:{i:1739546689;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1739548487;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1739552086;a:2:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1739552087;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1739552141;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1739552164;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1739552165;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1739750400;a:2:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}s:33:\"wpforms_weekly_entries_count_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1739800800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1739897690;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1739902204;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1739984086;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `webpyme_options` VALUES("2", "siteurl", "https://cpingenieria.cl/sitio", "on");
INSERT INTO `webpyme_options` VALUES("3", "home", "https://cpingenieria.cl/sitio", "on");
INSERT INTO `webpyme_options` VALUES("4", "blogname", "C&P INGENIERIA", "on");
INSERT INTO `webpyme_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `webpyme_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `webpyme_options` VALUES("7", "admin_email", "webmaster@web-pyme.cl", "on");
INSERT INTO `webpyme_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `webpyme_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `webpyme_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `webpyme_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `webpyme_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `webpyme_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `webpyme_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `webpyme_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `webpyme_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `webpyme_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `webpyme_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `webpyme_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `webpyme_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `webpyme_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `webpyme_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `webpyme_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `webpyme_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `webpyme_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `webpyme_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `webpyme_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `webpyme_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `webpyme_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `webpyme_options` VALUES("30", "rewrite_rules", "a:92:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=8&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `webpyme_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `webpyme_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `webpyme_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `webpyme_options` VALUES("34", "active_plugins", "a:12:{i:0;s:47:\"better-search-replace/better-search-replace.php\";i:1;s:31:\"code-snippets/code-snippets.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:33:\"kadence-blocks/kadence-blocks.php\";i:5;s:45:\"page-loading-effects/page-loading-effects.php\";i:6;s:41:\"web-pyme-webmaster/web-pyme-copyright.php\";i:7;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:8;s:24:\"wp-whatsapp/whatsapp.php\";i:9;s:35:\"wpcf7-recaptcha/wpcf7-recaptcha.php\";i:10;s:33:\"wpcf7-redirect/wpcf7-redirect.php\";i:11;s:24:\"wpforms-lite/wpforms.php\";}", "on");
INSERT INTO `webpyme_options` VALUES("35", "category_base", "", "on");
INSERT INTO `webpyme_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `webpyme_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `webpyme_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `webpyme_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `webpyme_options` VALUES("40", "recently_edited", "a:3:{i:0;s:74:\"/home/cypingen/public_html/sitio/wp-content/themes/kadence-child/style.css\";i:1;s:68:\"/home/cypingen/public_html/sitio/wp-content/themes/kadence/style.css\";i:3;s:0:\"\";}", "off");
INSERT INTO `webpyme_options` VALUES("41", "template", "kadence", "on");
INSERT INTO `webpyme_options` VALUES("42", "stylesheet", "kadence-child", "on");
INSERT INTO `webpyme_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `webpyme_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `webpyme_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `webpyme_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `webpyme_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `webpyme_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `webpyme_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `webpyme_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `webpyme_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `webpyme_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `webpyme_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `webpyme_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `webpyme_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `webpyme_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `webpyme_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `webpyme_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `webpyme_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `webpyme_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `webpyme_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `webpyme_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `webpyme_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `webpyme_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `webpyme_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `webpyme_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `webpyme_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `webpyme_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `webpyme_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `webpyme_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `webpyme_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `webpyme_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `webpyme_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `webpyme_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `webpyme_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `webpyme_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `webpyme_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("80", "uninstall_plugins", "a:0:{}", "off");
INSERT INTO `webpyme_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `webpyme_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `webpyme_options` VALUES("83", "page_on_front", "8", "on");
INSERT INTO `webpyme_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `webpyme_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `webpyme_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `webpyme_options` VALUES("87", "site_icon", "54", "on");
INSERT INTO `webpyme_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `webpyme_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `webpyme_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `webpyme_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `webpyme_options` VALUES("92", "admin_email_lifespan", "1751820886", "on");
INSERT INTO `webpyme_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `webpyme_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `webpyme_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `webpyme_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `webpyme_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `webpyme_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `webpyme_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `webpyme_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `webpyme_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `webpyme_options` VALUES("102", "webpyme_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `webpyme_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `webpyme_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `webpyme_options` VALUES("105", "widget_block", "a:9:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;i:8;a:1:{s:7:\"content\";s:343:\"<!-- wp:image {\"id\":27,\"width\":\"239px\",\"height\":\"auto\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://cpingenieria.cl/sitio/wp-content/uploads/2025/01/logo-cpingenieria-246x168-1.jpg\" alt=\"\" class=\"wp-image-27\" style=\"width:239px;height:auto\"/></figure>\n<!-- /wp:image -->\";}i:9;a:1:{s:7:\"content\";s:2196:\"<!-- wp:kadence/iconlist {\"uniqueID\":\"block-9_68c146-77\"} -->\n<div class=\"wp-block-kadence-iconlist kt-svg-icon-list-items kt-svg-icon-list-itemsblock-9_68c146-77 kt-svg-icon-list-columns-1 alignnone\"><ul class=\"kt-svg-icon-list\"><!-- wp:kadence/listitem {\"uniqueID\":\"3c8bc4-af\",\"icon\":\"fe_smartphone\",\"link\":\"tel:984156890\",\"size\":28,\"color\":\"palette1\"} -->\n<li class=\"wp-block-kadence-listitem kt-svg-icon-list-item-wrap kt-svg-icon-list-item-3c8bc4-af\"><a href=\"tel:984156890\" class=\"kt-svg-icon-link\"><span data-name=\"fe_smartphone\" data-stroke=\"USE_PARENT_DEFAULT_WIDTH\" data-class=\"kt-svg-icon-list-single\" class=\"kadence-dynamic-icon\"></span><span class=\"kt-svg-icon-list-text\"><strong>9 8415 6890</strong></span></a></li>\n<!-- /wp:kadence/listitem -->\n\n<!-- wp:kadence/listitem {\"uniqueID\":\"2c4a74-f0\",\"icon\":\"fe_mail\",\"link\":\"mailto:ventas@cpingenieria.cl\",\"size\":28,\"color\":\"palette1\"} -->\n<li class=\"wp-block-kadence-listitem kt-svg-icon-list-item-wrap kt-svg-icon-list-item-2c4a74-f0\"><a href=\"mailto:ventas@cpingenieria.cl\" class=\"kt-svg-icon-link\"><span data-name=\"fe_mail\" data-stroke=\"USE_PARENT_DEFAULT_WIDTH\" data-class=\"kt-svg-icon-list-single\" class=\"kadence-dynamic-icon\"></span><span class=\"kt-svg-icon-list-text\"><strong>ventas@cpingenieria.cl</strong></span></a></li>\n<!-- /wp:kadence/listitem -->\n\n<!-- wp:kadence/listitem {\"uniqueID\":\"13c790-20\",\"icon\":\"fe_mapPin\",\"link\":\"https://cpingenieria.cl/sitio/contactenos/#:~:text=Mar%C3%ADa%20del%20Pilar%203638%C2%A0%20Recoleta%20%E2%80%93%20Santiago\",\"target\":\"_blank\",\"size\":28,\"color\":\"palette1\"} -->\n<li class=\"wp-block-kadence-listitem kt-svg-icon-list-item-wrap kt-svg-icon-list-item-13c790-20\"><a href=\"https://cpingenieria.cl/sitio/contactenos/#:~:text=Mar%C3%ADa%20del%20Pilar%203638%C2%A0%20Recoleta%20%E2%80%93%20Santiago\" class=\"kt-svg-icon-link\" target=\"_blank\" rel=\"noopener noreferrer\"><span data-name=\"fe_mapPin\" data-stroke=\"USE_PARENT_DEFAULT_WIDTH\" data-class=\"kt-svg-icon-list-single\" class=\"kadence-dynamic-icon\"></span><span class=\"kt-svg-icon-list-text\"><strong>María del Pilar 3638, Recoleta – Santiago</strong></span></a></li>\n<!-- /wp:kadence/listitem --></ul></div>\n<!-- /wp:kadence/iconlist -->\";}i:10;a:1:{s:7:\"content\";s:705:\"<!-- wp:image {\"lightbox\":{\"enabled\":false},\"id\":67,\"width\":\"247px\",\"height\":\"auto\",\"sizeSlug\":\"full\",\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><a href=\"https://www.google.com/maps/place/Blanco+Fombona+2265,+8390442+Independencia,+Regi%C3%B3n+Metropolitana/@-33.4144211,-70.6667817,18z/data=!4m6!3m5!1s0x9662c5d2f5a4e533:0xfac090d9f140b5f3!8m2!3d-33.4145039!4d-70.6664223!16s%2Fg%2F11cslmkzz4?entry=ttu&amp;g_ep=EgoyMDI1MDEwMi4wIKXMDSoASAFQAw%3D%3D\" target=\"_blank\" rel=\" noreferrer noopener\"><img src=\"https://cpingenieria.cl/sitio/wp-content/uploads/2025/01/mapa1.jpg\" alt=\"\" class=\"wp-image-67\" style=\"width:247px;height:auto\"/></a></figure>\n<!-- /wp:image -->\";}}", "on");
INSERT INTO `webpyme_options` VALUES("106", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar-primary\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:17:\"sidebar-secondary\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:7:\"footer1\";a:1:{i:0;s:7:\"block-8\";}s:7:\"footer2\";a:1:{i:0;s:7:\"block-9\";}s:7:\"footer3\";a:1:{i:0;s:8:\"block-10\";}s:7:\"footer4\";a:0:{}s:7:\"footer5\";a:0:{}s:7:\"footer6\";a:0:{}s:13:\"array_version\";i:3;}", "on");
INSERT INTO `webpyme_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("121", "recovery_keys", "a:0:{}", "off");
INSERT INTO `webpyme_options` VALUES("122", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1736269077;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `webpyme_options` VALUES("123", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.7.1\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `webpyme_options` VALUES("130", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"6f18fc519a95436387b4c316e77ebf29\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `webpyme_options` VALUES("131", "WPLANG", "es_ES", "yes");
INSERT INTO `webpyme_options` VALUES("151", "can_compress_scripts", "1", "on");
INSERT INTO `webpyme_options` VALUES("164", "finished_updating_comment_type", "1", "auto");
INSERT INTO `webpyme_options` VALUES("175", "current_theme", "Kadence Child", "auto");
INSERT INTO `webpyme_options` VALUES("176", "theme_mods_kadence-child", "a:61:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:6:\"mobile\";i:2;}s:15:\"initial_version\";s:6:\"1.2.14\";s:18:\"custom_css_post_id\";i:65;s:11:\"custom_logo\";i:27;s:10:\"logo_width\";a:3:{s:4:\"size\";a:3:{s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";i:133;}s:4:\"unit\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:4:\"flag\";b:1;}s:11:\"logo_layout\";a:3:{s:7:\"include\";a:3:{s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";s:9:\"logo_only\";}s:6:\"layout\";a:3:{s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";s:8:\"standard\";}s:4:\"flag\";b:1;}s:19:\"header_html_content\";s:166:\"| <a href=\"https://maps.app.goo.gl/2UxXxYP2ERsDomfn6\" target=\"_blank\" rel=\"noopener\">María del Pilar 3638,  Recoleta</a> | <a href=\"tel:984156890\">9 8415 6890</a> |\";s:21:\"header_top_background\";a:2:{s:7:\"desktop\";a:2:{s:5:\"color\";s:8:\"palette6\";s:4:\"type\";s:5:\"color\";}s:4:\"flag\";b:0;}s:20:\"header_desktop_items\";a:4:{s:3:\"top\";a:5:{s:8:\"top_left\";a:0:{}s:15:\"top_left_center\";a:0:{}s:10:\"top_center\";a:0:{}s:16:\"top_right_center\";a:0:{}s:9:\"top_right\";a:1:{i:0;s:4:\"html\";}}s:4:\"main\";a:5:{s:9:\"main_left\";a:1:{i:0;s:4:\"logo\";}s:16:\"main_left_center\";a:0:{}s:11:\"main_center\";a:0:{}s:17:\"main_right_center\";a:0:{}s:10:\"main_right\";a:1:{i:0;s:10:\"navigation\";}}s:6:\"bottom\";a:5:{s:11:\"bottom_left\";a:0:{}s:18:\"bottom_left_center\";a:0:{}s:13:\"bottom_center\";a:0:{}s:19:\"bottom_right_center\";a:0:{}s:12:\"bottom_right\";a:0:{}}s:4:\"flag\";b:1;}s:22:\"header_html_typography\";a:15:{s:4:\"size\";a:1:{s:7:\"desktop\";i:14;}s:10:\"lineHeight\";a:1:{s:7:\"desktop\";d:1.3979999999999999094058011905872263014316558837890625;}s:6:\"family\";s:7:\"inherit\";s:6:\"google\";b:0;s:6:\"weight\";s:0:\"\";s:7:\"variant\";s:0:\"\";s:5:\"color\";s:8:\"palette1\";s:8:\"sizeType\";s:2:\"px\";s:8:\"lineType\";s:1:\"-\";s:13:\"letterSpacing\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"spacingType\";s:2:\"em\";s:5:\"style\";s:6:\"normal\";s:9:\"transform\";s:0:\"\";s:8:\"fallback\";s:0:\"\";s:4:\"flag\";b:1;}s:22:\"header_html_link_color\";a:2:{s:5:\"color\";s:8:\"palette1\";s:5:\"hover\";s:8:\"palette2\";}s:35:\"primary_navigation_vertical_spacing\";a:2:{s:4:\"size\";d:0.689999999999999946709294817992486059665679931640625;s:4:\"unit\";s:2:\"em\";}s:26:\"primary_navigation_spacing\";a:2:{s:4:\"size\";d:2.54000000000000003552713678800500929355621337890625;s:4:\"unit\";s:2:\"em\";}s:29:\"primary_navigation_typography\";a:14:{s:4:\"size\";a:1:{s:7:\"desktop\";i:22;}s:10:\"lineHeight\";a:1:{s:7:\"desktop\";i:1;}s:6:\"family\";s:7:\"inherit\";s:6:\"google\";b:0;s:6:\"weight\";s:0:\"\";s:7:\"variant\";s:0:\"\";s:8:\"sizeType\";s:2:\"px\";s:8:\"lineType\";s:1:\"-\";s:13:\"letterSpacing\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"spacingType\";s:2:\"em\";s:5:\"style\";s:6:\"normal\";s:9:\"transform\";s:0:\"\";s:8:\"fallback\";s:0:\"\";s:4:\"flag\";b:1;}s:29:\"primary_navigation_background\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"hover\";s:8:\"palette6\";s:6:\"active\";s:0:\"\";}s:30:\"dropdown_navigation_typography\";a:14:{s:4:\"size\";a:1:{s:7:\"desktop\";i:22;}s:10:\"lineHeight\";a:1:{s:7:\"desktop\";i:1;}s:6:\"family\";s:7:\"inherit\";s:6:\"google\";b:0;s:6:\"weight\";s:0:\"\";s:7:\"variant\";s:0:\"\";s:8:\"sizeType\";s:2:\"px\";s:8:\"lineType\";s:1:\"-\";s:13:\"letterSpacing\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"spacingType\";s:2:\"em\";s:5:\"style\";s:6:\"normal\";s:9:\"transform\";s:0:\"\";s:8:\"fallback\";s:0:\"\";s:4:\"flag\";b:1;}s:25:\"dropdown_navigation_width\";a:2:{s:4:\"size\";i:350;s:4:\"unit\";s:2:\"px\";}s:24:\"primary_navigation_color\";a:3:{s:5:\"color\";s:8:\"palette1\";s:5:\"hover\";s:8:\"palette1\";s:6:\"active\";s:8:\"palette2\";}s:25:\"dropdown_navigation_color\";a:3:{s:5:\"color\";s:8:\"palette1\";s:5:\"hover\";s:8:\"palette1\";s:6:\"active\";s:8:\"palette1\";}s:30:\"dropdown_navigation_background\";a:3:{s:5:\"color\";s:8:\"palette9\";s:5:\"hover\";s:8:\"palette6\";s:6:\"active\";s:8:\"palette7\";}s:36:\"dropdown_navigation_vertical_spacing\";a:2:{s:4:\"size\";d:0.59999999999999997779553950749686919152736663818359375;s:4:\"unit\";s:2:\"em\";}s:25:\"header_main_bottom_border\";a:2:{s:7:\"desktop\";a:4:{s:5:\"width\";i:1;s:4:\"unit\";s:2:\"px\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:8:\"palette1\";}s:4:\"flag\";b:1;}s:13:\"header_sticky\";s:4:\"main\";s:17:\"page_title_height\";a:3:{s:4:\"size\";a:3:{s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";i:100;}s:4:\"unit\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:4:\"flag\";b:1;}s:21:\"page_vertical_padding\";s:4:\"hide\";s:15:\"page_title_font\";a:15:{s:4:\"size\";a:1:{s:7:\"desktop\";s:0:\"\";}s:10:\"lineHeight\";a:1:{s:7:\"desktop\";s:0:\"\";}s:6:\"family\";s:7:\"inherit\";s:6:\"google\";b:0;s:6:\"weight\";s:0:\"\";s:7:\"variant\";s:0:\"\";s:5:\"color\";s:8:\"palette1\";s:8:\"sizeType\";s:2:\"px\";s:8:\"lineType\";s:1:\"-\";s:13:\"letterSpacing\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"spacingType\";s:2:\"em\";s:5:\"style\";s:6:\"normal\";s:9:\"transform\";s:0:\"\";s:8:\"fallback\";s:0:\"\";s:4:\"flag\";b:0;}s:19:\"footer_html_content\";s:359:\"<table>\n<tbody>\n<tr>\n<td>{copyright} {year} {site-title} –  Desarrollado por <a href=\"https://web-pyme.cl/\" target=\"_blank\" rel=\"noreferrer noopener\">Web-PYME</a> | <a href=\"https://www.cpingenieria.cl/sitio/wp-login.php\" target=\"_blank\" rel=\"noopener\">Admin </a>| <a href=\"https://www.cpingenieria.cl/webmail\">WebMail</a></td>\n</tr>\n</tbody>\n</table>\";s:22:\"footer_wrap_background\";a:2:{s:7:\"desktop\";a:2:{s:5:\"color\";s:8:\"palette6\";s:4:\"type\";s:5:\"color\";}s:4:\"flag\";b:0;}s:12:\"footer_items\";a:4:{s:3:\"top\";a:5:{s:5:\"top_1\";a:0:{}s:5:\"top_2\";a:0:{}s:5:\"top_3\";a:0:{}s:5:\"top_4\";a:0:{}s:5:\"top_5\";a:0:{}}s:6:\"middle\";a:5:{s:8:\"middle_1\";a:1:{i:0;s:14:\"footer-widget1\";}s:8:\"middle_2\";a:1:{i:0;s:14:\"footer-widget2\";}s:8:\"middle_3\";a:1:{i:0;s:14:\"footer-widget3\";}s:8:\"middle_4\";a:0:{}s:8:\"middle_5\";a:0:{}}s:6:\"bottom\";a:5:{s:8:\"bottom_1\";a:1:{i:0;s:11:\"footer-html\";}s:8:\"bottom_2\";a:0:{}s:8:\"bottom_3\";a:0:{}s:8:\"bottom_4\";a:0:{}s:8:\"bottom_5\";a:0:{}}s:4:\"flag\";b:0;}s:26:\"footer_middle_widget_title\";a:15:{s:4:\"size\";a:1:{s:7:\"desktop\";s:0:\"\";}s:10:\"lineHeight\";a:1:{s:7:\"desktop\";s:0:\"\";}s:6:\"family\";s:7:\"inherit\";s:6:\"google\";b:0;s:6:\"weight\";s:0:\"\";s:7:\"variant\";s:0:\"\";s:5:\"color\";s:8:\"palette1\";s:8:\"sizeType\";s:2:\"px\";s:8:\"lineType\";s:1:\"-\";s:13:\"letterSpacing\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"spacingType\";s:2:\"em\";s:5:\"style\";s:6:\"normal\";s:9:\"transform\";s:0:\"\";s:8:\"fallback\";s:0:\"\";s:4:\"flag\";b:0;}s:28:\"footer_middle_widget_content\";a:15:{s:4:\"size\";a:1:{s:7:\"desktop\";i:24;}s:10:\"lineHeight\";a:1:{s:7:\"desktop\";s:0:\"\";}s:6:\"family\";s:7:\"inherit\";s:6:\"google\";b:0;s:6:\"weight\";s:0:\"\";s:7:\"variant\";s:0:\"\";s:5:\"color\";s:8:\"palette1\";s:8:\"sizeType\";s:2:\"px\";s:8:\"lineType\";s:1:\"-\";s:13:\"letterSpacing\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"spacingType\";s:2:\"em\";s:5:\"style\";s:6:\"normal\";s:9:\"transform\";s:0:\"\";s:8:\"fallback\";s:0:\"\";s:4:\"flag\";b:1;}s:25:\"footer_middle_link_colors\";a:2:{s:5:\"color\";s:8:\"palette1\";s:5:\"hover\";s:8:\"palette2\";}s:24:\"footer_middle_link_style\";s:6:\"noline\";s:28:\"footer_bottom_bottom_spacing\";a:3:{s:4:\"size\";a:3:{s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";i:0;}s:4:\"unit\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:4:\"flag\";b:1;}s:28:\"footer_bottom_widget_content\";a:15:{s:4:\"size\";a:1:{s:7:\"desktop\";s:0:\"\";}s:10:\"lineHeight\";a:1:{s:7:\"desktop\";s:0:\"\";}s:6:\"family\";s:7:\"inherit\";s:6:\"google\";b:0;s:6:\"weight\";s:0:\"\";s:7:\"variant\";s:0:\"\";s:5:\"color\";s:8:\"palette7\";s:8:\"sizeType\";s:2:\"px\";s:8:\"lineType\";s:1:\"-\";s:13:\"letterSpacing\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"spacingType\";s:2:\"em\";s:5:\"style\";s:6:\"normal\";s:9:\"transform\";s:0:\"\";s:8:\"fallback\";s:0:\"\";s:4:\"flag\";b:1;}s:25:\"footer_bottom_link_colors\";a:2:{s:5:\"color\";s:8:\"palette7\";s:5:\"hover\";s:8:\"palette9\";}s:24:\"footer_bottom_background\";a:2:{s:7:\"desktop\";a:2:{s:5:\"color\";s:8:\"palette1\";s:4:\"type\";s:5:\"color\";}s:4:\"flag\";b:0;}s:22:\"footer_html_link_style\";s:5:\"plain\";s:18:\"footer_html_margin\";a:4:{s:4:\"size\";a:4:{i:0;i:-20;i:1;i:0;i:2;i:-20;i:3;i:0;}s:4:\"unit\";s:2:\"px\";s:6:\"locked\";b:0;s:4:\"flag\";b:1;}s:20:\"footer_bottom_height\";a:3:{s:4:\"size\";a:3:{s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";i:10;}s:4:\"unit\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:4:\"flag\";b:1;}s:20:\"footer_middle_layout\";a:4:{s:6:\"mobile\";s:3:\"row\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";s:11:\"center-half\";s:4:\"flag\";b:1;}s:19:\"mobile_trigger_icon\";s:5:\"menu2\";s:24:\"mobile_trigger_icon_size\";a:2:{s:4:\"size\";i:40;s:4:\"unit\";s:2:\"px\";}s:20:\"mobile_trigger_color\";a:2:{s:5:\"color\";s:8:\"palette1\";s:5:\"hover\";s:8:\"palette6\";}s:23:\"header_popup_background\";a:2:{s:7:\"desktop\";a:2:{s:5:\"color\";s:8:\"palette6\";s:4:\"type\";s:5:\"color\";}s:4:\"flag\";b:0;}s:28:\"mobile_navigation_typography\";a:14:{s:4:\"size\";a:1:{s:7:\"desktop\";i:20;}s:10:\"lineHeight\";a:1:{s:7:\"desktop\";d:0.8000000000000000444089209850062616169452667236328125;}s:6:\"family\";s:7:\"inherit\";s:6:\"google\";b:0;s:6:\"weight\";s:0:\"\";s:7:\"variant\";s:0:\"\";s:8:\"sizeType\";s:2:\"px\";s:8:\"lineType\";s:1:\"-\";s:13:\"letterSpacing\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"spacingType\";s:2:\"em\";s:5:\"style\";s:6:\"normal\";s:9:\"transform\";s:0:\"\";s:8:\"fallback\";s:0:\"\";s:4:\"flag\";b:1;}s:23:\"mobile_navigation_color\";a:3:{s:5:\"color\";s:8:\"palette1\";s:5:\"hover\";s:8:\"palette3\";s:6:\"active\";s:8:\"palette1\";}s:25:\"mobile_navigation_divider\";a:5:{s:4:\"flag\";b:1;s:5:\"width\";i:1;s:4:\"unit\";s:2:\"px\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:8:\"palette9\";}s:26:\"mobile_navigation_collapse\";b:0;s:18:\"buttons_background\";a:2:{s:5:\"color\";s:8:\"palette1\";s:5:\"hover\";s:8:\"palette6\";}s:24:\"footer_middle_top_border\";a:2:{s:7:\"desktop\";a:4:{s:5:\"width\";i:1;s:4:\"unit\";s:2:\"px\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:8:\"palette1\";}s:4:\"flag\";b:1;}s:13:\"buttons_color\";a:2:{s:5:\"color\";s:8:\"palette9\";s:5:\"hover\";s:8:\"palette2\";}s:21:\"buttons_border_colors\";a:2:{s:5:\"color\";s:8:\"palette2\";s:5:\"hover\";s:8:\"palette2\";}s:9:\"scroll_up\";b:1;s:14:\"scroll_up_icon\";s:9:\"arrow-up2\";s:21:\"scroll_up_side_offset\";a:3:{s:4:\"size\";a:3:{s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";i:42;}s:4:\"unit\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:4:\"flag\";b:0;}s:23:\"scroll_up_bottom_offset\";a:3:{s:4:\"size\";a:3:{s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";i:114;}s:4:\"unit\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:4:\"flag\";b:0;}s:15:\"scroll_up_style\";s:6:\"filled\";s:20:\"scroll_up_background\";a:2:{s:5:\"color\";s:8:\"palette1\";s:5:\"hover\";s:8:\"palette2\";}s:16:\"scroll_up_radius\";a:4:{s:4:\"size\";a:4:{i:0;i:8;i:1;i:8;i:2;i:8;i:3;i:8;}s:4:\"unit\";s:2:\"px\";s:6:\"locked\";b:1;s:4:\"flag\";b:0;}}", "on");
INSERT INTO `webpyme_options` VALUES("177", "theme_switched", "", "auto");
INSERT INTO `webpyme_options` VALUES("189", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `webpyme_options` VALUES("196", "kadence_starter_plugin_notice", "1", "off");
INSERT INTO `webpyme_options` VALUES("197", "site_logo", "27", "auto");
INSERT INTO `webpyme_options` VALUES("198", "kadence_global_palette", "{\"palette\":[{\"color\":\"#086eb6\",\"slug\":\"palette1\",\"name\":\"Palette Color 1\"},{\"color\":\"#215387\",\"slug\":\"palette2\",\"name\":\"Palette Color 2\"},{\"color\":\"#1A202C\",\"slug\":\"palette3\",\"name\":\"Palette Color 3\"},{\"color\":\"#2D3748\",\"slug\":\"palette4\",\"name\":\"Palette Color 4\"},{\"color\":\"#4A5568\",\"slug\":\"palette5\",\"name\":\"Palette Color 5\"},{\"color\":\"#bfe5ef\",\"slug\":\"palette6\",\"name\":\"Palette Color 6\"},{\"color\":\"#EDF2F7\",\"slug\":\"palette7\",\"name\":\"Palette Color 7\"},{\"color\":\"#F7FAFC\",\"slug\":\"palette8\",\"name\":\"Palette Color 8\"},{\"color\":\"#ffffff\",\"slug\":\"palette9\",\"name\":\"Palette Color 9\"}],\"second-palette\":[{\"color\":\"#2B6CB0\",\"slug\":\"palette1\",\"name\":\"Palette Color 1\"},{\"color\":\"#215387\",\"slug\":\"palette2\",\"name\":\"Palette Color 2\"},{\"color\":\"#1A202C\",\"slug\":\"palette3\",\"name\":\"Palette Color 3\"},{\"color\":\"#2D3748\",\"slug\":\"palette4\",\"name\":\"Palette Color 4\"},{\"color\":\"#4A5568\",\"slug\":\"palette5\",\"name\":\"Palette Color 5\"},{\"color\":\"#718096\",\"slug\":\"palette6\",\"name\":\"Palette Color 6\"},{\"color\":\"#EDF2F7\",\"slug\":\"palette7\",\"name\":\"Palette Color 7\"},{\"color\":\"#F7FAFC\",\"slug\":\"palette8\",\"name\":\"Palette Color 8\"},{\"color\":\"#ffffff\",\"slug\":\"palette9\",\"name\":\"Palette Color 9\"}],\"third-palette\":[{\"color\":\"#2B6CB0\",\"slug\":\"palette1\",\"name\":\"Palette Color 1\"},{\"color\":\"#215387\",\"slug\":\"palette2\",\"name\":\"Palette Color 2\"},{\"color\":\"#1A202C\",\"slug\":\"palette3\",\"name\":\"Palette Color 3\"},{\"color\":\"#2D3748\",\"slug\":\"palette4\",\"name\":\"Palette Color 4\"},{\"color\":\"#4A5568\",\"slug\":\"palette5\",\"name\":\"Palette Color 5\"},{\"color\":\"#718096\",\"slug\":\"palette6\",\"name\":\"Palette Color 6\"},{\"color\":\"#EDF2F7\",\"slug\":\"palette7\",\"name\":\"Palette Color 7\"},{\"color\":\"#F7FAFC\",\"slug\":\"palette8\",\"name\":\"Palette Color 8\"},{\"color\":\"#ffffff\",\"slug\":\"palette9\",\"name\":\"Palette Color 9\"}],\"active\":\"palette\"}", "on");
INSERT INTO `webpyme_options` VALUES("208", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `webpyme_options` VALUES("209", "recently_activated", "a:0:{}", "off");
INSERT INTO `webpyme_options` VALUES("225", "kadence_blocks_schema_version", "1", "auto");
INSERT INTO `webpyme_options` VALUES("226", "stellarwp_telemetry_last_send", "", "auto");
INSERT INTO `webpyme_options` VALUES("227", "stellarwp_telemetry", "a:1:{s:7:\"plugins\";a:1:{s:14:\"kadence-blocks\";a:2:{s:7:\"wp_slug\";s:33:\"kadence-blocks/kadence-blocks.php\";s:5:\"optin\";b:0;}}}", "auto");
INSERT INTO `webpyme_options` VALUES("228", "stellarwp_telemetry_kadence-blocks_show_optin", "1", "auto");
INSERT INTO `webpyme_options` VALUES("229", "kadenceblocks_data_settings", "a:4:{s:10:\"db_version\";i:0;s:15:\"version_history\";a:1:{i:0;s:3:\"new\";}s:13:\"prior_version\";s:3:\"new\";s:15:\"current_version\";s:5:\"3.4.3\";}", "auto");
INSERT INTO `webpyme_options` VALUES("238", "wpcf7", "a:6:{s:7:\"version\";s:5:\"6.0.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1736273021;s:7:\"version\";s:5:\"6.0.2\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}s:23:\"recaptcha_v2_v3_warning\";b:0;s:15:\"iqfix_recaptcha\";i:2;s:22:\"iqfix_recaptcha_source\";s:10:\"google.com\";s:9:\"recaptcha\";a:1:{s:40:\"6LcXYFcpAAAAAIl-eu6rFLybg30PejpHy_LvUUvB\";s:40:\"6LcXYFcpAAAAACDyxOJzqBbnG-UsmUGjNTlSABvr\";}}", "auto");
INSERT INTO `webpyme_options` VALUES("247", "wpcf7_redirect_install", "1736273038", "auto");
INSERT INTO `webpyme_options` VALUES("256", "_install", "1736273039", "auto");
INSERT INTO `webpyme_options` VALUES("257", "wpcf7_redirect_dismiss_banner", "0", "auto");
INSERT INTO `webpyme_options` VALUES("258", "wpcf7_redirect_version", "3.1.9", "auto");
INSERT INTO `webpyme_options` VALUES("279", "njt_wa_review", "1736359477", "auto");
INSERT INTO `webpyme_options` VALUES("280", "njt_wa_first_time_active", "1", "auto");
INSERT INTO `webpyme_options` VALUES("281", "njt_popup_filebird_cross", "1736359477", "auto");
INSERT INTO `webpyme_options` VALUES("282", "njt_notification_filebird_cross", "1736359477", "auto");
INSERT INTO `webpyme_options` VALUES("283", "njt_wa_version", "3.6.9", "auto");
INSERT INTO `webpyme_options` VALUES("285", "nta_wa_restored", "1", "auto");
INSERT INTO `webpyme_options` VALUES("296", "code_snippets_version", "3.6.6.1", "auto");
INSERT INTO `webpyme_options` VALUES("298", "code_snippets_settings", "a:3:{s:5:\"debug\";a:0:{}s:7:\"general\";a:8:{s:19:\"activate_by_default\";b:1;s:11:\"enable_tags\";b:1;s:18:\"enable_description\";b:1;s:18:\"visual_editor_rows\";i:5;s:10:\"list_order\";s:12:\"priority-asc\";s:13:\"disable_prism\";b:0;s:17:\"hide_upgrade_menu\";b:0;s:18:\"complete_uninstall\";b:0;}s:6:\"editor\";a:11:{s:5:\"theme\";s:7:\"default\";s:16:\"indent_with_tabs\";b:1;s:8:\"tab_size\";i:4;s:11:\"indent_unit\";i:4;s:10:\"wrap_lines\";b:1;s:12:\"code_folding\";b:1;s:12:\"line_numbers\";b:1;s:19:\"auto_close_brackets\";b:1;s:27:\"highlight_selection_matches\";b:1;s:21:\"highlight_active_line\";b:1;s:6:\"keymap\";s:7:\"default\";}}", "auto");
INSERT INTO `webpyme_options` VALUES("523", "secret_key", "dtk5sxlFP(Y&n^zZd}c./vDE+kEP2Q`I+}wIq{aXDI:[pU=RCYchX;Y1rfCv=90)", "off");
INSERT INTO `webpyme_options` VALUES("540", "_transient_health-check-site-status-result", "{\"good\":18,\"recommended\":3,\"critical\":2}", "on");
INSERT INTO `webpyme_options` VALUES("565", "action_scheduler_hybrid_store_demarkation", "52", "auto");
INSERT INTO `webpyme_options` VALUES("566", "schema-ActionScheduler_StoreSchema", "7.0.1736359129", "auto");
INSERT INTO `webpyme_options` VALUES("567", "schema-ActionScheduler_LoggerSchema", "3.0.1736359129", "auto");
INSERT INTO `webpyme_options` VALUES("568", "wp_mail_smtp_initial_version", "4.3.0", "off");
INSERT INTO `webpyme_options` VALUES("569", "wp_mail_smtp_version", "4.3.0", "off");
INSERT INTO `webpyme_options` VALUES("570", "wp_mail_smtp", "a:20:{s:4:\"mail\";a:6:{s:10:\"from_email\";s:22:\"ventas@cpingenieria.cl\";s:9:\"from_name\";s:14:\"C&P INGENIERIA\";s:6:\"mailer\";s:4:\"smtp\";s:11:\"return_path\";b:0;s:16:\"from_email_force\";b:1;s:15:\"from_name_force\";b:0;}s:4:\"smtp\";a:7:{s:7:\"autotls\";b:1;s:4:\"auth\";b:1;s:4:\"host\";s:20:\"mail.cpingenieria.cl\";s:4:\"port\";i:587;s:10:\"encryption\";s:3:\"tls\";s:4:\"user\";s:22:\"ventas@cpingenieria.cl\";s:4:\"pass\";s:80:\"hyESAT3OofaNLmBegSBcCKK9thQw3Z1rANMlhZkceUgdjWN1tBDhiR+siBeQ3BpCLH2vaNQw5MCVeg==\";}s:7:\"general\";a:1:{s:29:\"summary_report_email_disabled\";b:0;}s:9:\"sendlayer\";a:1:{s:7:\"api_key\";s:0:\"\";}s:7:\"smtpcom\";a:2:{s:7:\"api_key\";s:0:\"\";s:7:\"channel\";s:0:\"\";}s:10:\"sendinblue\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:7:\"mailgun\";a:3:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:7:\"mailjet\";a:2:{s:7:\"api_key\";s:0:\"\";s:10:\"secret_key\";s:0:\"\";}s:8:\"sendgrid\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:7:\"smtp2go\";a:1:{s:7:\"api_key\";s:0:\"\";}s:9:\"sparkpost\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:8:\"postmark\";a:2:{s:16:\"server_api_token\";s:0:\"\";s:14:\"message_stream\";s:0:\"\";}s:9:\"amazonses\";a:3:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:6:\"region\";s:9:\"us-east-1\";}s:12:\"elasticemail\";a:1:{s:7:\"api_key\";s:0:\"\";}s:5:\"gmail\";a:8:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:12:\"access_token\";a:0:{}s:13:\"refresh_token\";s:0:\"\";s:12:\"user_details\";a:1:{s:5:\"email\";s:0:\"\";}s:23:\"one_click_setup_enabled\";b:0;s:27:\"one_click_setup_credentials\";a:2:{s:3:\"key\";s:0:\"\";s:5:\"token\";s:0:\"\";}s:28:\"one_click_setup_user_details\";a:1:{s:5:\"email\";s:0:\"\";}}s:7:\"outlook\";a:8:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:12:\"access_token\";a:0:{}s:13:\"refresh_token\";s:0:\"\";s:12:\"user_details\";a:1:{s:5:\"email\";s:0:\"\";}s:23:\"one_click_setup_enabled\";b:0;s:27:\"one_click_setup_credentials\";a:3:{s:12:\"access_token\";s:0:\"\";s:13:\"refresh_token\";s:0:\"\";s:7:\"expires\";s:0:\"\";}s:28:\"one_click_setup_user_details\";a:1:{s:5:\"email\";s:0:\"\";}}s:4:\"zoho\";a:6:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:6:\"domain\";s:3:\"com\";s:12:\"access_token\";a:0:{}s:13:\"refresh_token\";s:0:\"\";s:12:\"user_details\";a:1:{s:5:\"email\";s:0:\"\";}}s:4:\"logs\";a:5:{s:7:\"enabled\";b:0;s:17:\"log_email_content\";b:0;s:16:\"save_attachments\";b:0;s:19:\"open_email_tracking\";b:0;s:19:\"click_link_tracking\";b:0;}s:11:\"alert_email\";a:2:{s:7:\"enabled\";b:0;s:11:\"connections\";a:0:{}}s:7:\"license\";a:4:{s:3:\"key\";s:0:\"\";s:10:\"is_expired\";b:0;s:11:\"is_disabled\";b:0;s:10:\"is_invalid\";b:0;}}", "off");
INSERT INTO `webpyme_options` VALUES("571", "wp_mail_smtp_activated_time", "1736359129", "off");
INSERT INTO `webpyme_options` VALUES("572", "wp_mail_smtp_activated", "a:1:{s:4:\"lite\";i:1736359129;}", "auto");
INSERT INTO `webpyme_options` VALUES("577", "action_scheduler_lock_async-request-runner", "67af601c580e74.60069345|1739546712", "no");
INSERT INTO `webpyme_options` VALUES("582", "wp_mail_smtp_migration_version", "5", "on");
INSERT INTO `webpyme_options` VALUES("583", "wp_mail_smtp_debug_events_db_version", "1", "on");
INSERT INTO `webpyme_options` VALUES("584", "wp_mail_smtp_activation_prevent_redirect", "1", "auto");
INSERT INTO `webpyme_options` VALUES("585", "wp_mail_smtp_setup_wizard_stats", "a:3:{s:13:\"launched_time\";i:1736359142;s:14:\"completed_time\";i:1736359443;s:14:\"was_successful\";b:1;}", "off");
INSERT INTO `webpyme_options` VALUES("587", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `webpyme_options` VALUES("589", "wp_mail_smtp_mail_key", "8QZ3BiZrgA5a4p6e+X1giJ6zow3xNMYGcNLILNLCZVY=", "auto");
INSERT INTO `webpyme_options` VALUES("592", "wpforms_activation_redirect", "1", "auto");
INSERT INTO `webpyme_options` VALUES("593", "wpforms_installation_source", "wp-mail-smtp-setup-wizard", "auto");
INSERT INTO `webpyme_options` VALUES("594", "wpforms_version", "1.9.2.3", "auto");
INSERT INTO `webpyme_options` VALUES("595", "wpforms_version_lite", "1.9.2.3", "auto");
INSERT INTO `webpyme_options` VALUES("596", "wpforms_activated", "a:1:{s:4:\"lite\";i:1736359344;}", "auto");
INSERT INTO `webpyme_options` VALUES("601", "wpforms_versions_lite", "a:14:{s:5:\"1.5.9\";i:0;s:7:\"1.6.7.2\";i:0;s:5:\"1.6.8\";i:0;s:5:\"1.7.5\";i:0;s:7:\"1.7.5.1\";i:0;s:5:\"1.7.7\";i:0;s:5:\"1.8.2\";i:0;s:5:\"1.8.3\";i:0;s:5:\"1.8.4\";i:0;s:5:\"1.8.6\";i:0;s:5:\"1.8.7\";i:0;s:5:\"1.9.1\";i:0;s:5:\"1.9.2\";i:0;s:7:\"1.9.2.3\";i:1736359407;}", "auto");
INSERT INTO `webpyme_options` VALUES("602", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("603", "wpforms_settings", "a:3:{s:13:\"modern-markup\";s:1:\"1\";s:20:\"modern-markup-is-set\";b:1;s:26:\"modern-markup-hide-setting\";b:1;}", "auto");
INSERT INTO `webpyme_options` VALUES("605", "wpforms_admin_notices", "a:1:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1736359407;s:9:\"dismissed\";b:0;}}", "auto");
INSERT INTO `webpyme_options` VALUES("606", "wp_mail_smtp_notifications", "a:4:{s:6:\"update\";i:1739544907;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `webpyme_options` VALUES("607", "wpforms_process_forms_locator_status", "completed", "auto");
INSERT INTO `webpyme_options` VALUES("613", "wp_mail_smtp_debug", "a:0:{}", "off");
INSERT INTO `webpyme_options` VALUES("614", "wp_mail_smtp_lite_sent_email_counter", "9", "on");
INSERT INTO `webpyme_options` VALUES("615", "wp_mail_smtp_lite_weekly_sent_email_counter", "a:5:{s:2:\"02\";i:3;s:2:\"03\";i:1;s:2:\"04\";i:2;s:2:\"06\";i:1;s:2:\"07\";i:2;}", "on");
INSERT INTO `webpyme_options` VALUES("617", "wp_mail_smtp_review_notice", "a:2:{s:4:\"time\";i:1736359483;s:9:\"dismissed\";b:0;}", "auto");
INSERT INTO `webpyme_options` VALUES("618", "wpforms_notifications", "a:4:{s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}s:6:\"update\";i:1739545085;}", "auto");
INSERT INTO `webpyme_options` VALUES("670", "ple_option_1", "", "on");
INSERT INTO `webpyme_options` VALUES("671", "ple_option_2", "", "on");
INSERT INTO `webpyme_options` VALUES("672", "ple_option_3", "99", "on");
INSERT INTO `webpyme_options` VALUES("673", "ple_option_4", "#086eb6", "on");
INSERT INTO `webpyme_options` VALUES("674", "ple_option_5", "#bfe5ef", "on");
INSERT INTO `webpyme_options` VALUES("675", "ple_option_6", "", "on");
INSERT INTO `webpyme_options` VALUES("676", "ple_option_7", "", "on");
INSERT INTO `webpyme_options` VALUES("677", "ple_options", "Array", "on");
INSERT INTO `webpyme_options` VALUES("684", "nta_wa_widget_styles", "a:22:{s:5:\"title\";s:26:\"Comenzar una conversación\";s:12:\"responseText\";s:42:\"El equipo suele responder en unos minutos.\";s:11:\"description\";s:96:\"¡Hola! Haz clic en uno de nuestros miembros de abajo para chatear por <strong>WhatsApp</strong>\";s:15:\"backgroundColor\";s:7:\"#2db742\";s:9:\"textColor\";s:4:\"#fff\";s:9:\"titleSize\";s:2:\"18\";s:15:\"accountNameSize\";s:2:\"14\";s:19:\"descriptionTextSize\";s:2:\"12\";s:15:\"regularTextSize\";s:2:\"11\";s:12:\"scrollHeight\";s:3:\"500\";s:12:\"isShowScroll\";s:3:\"OFF\";s:18:\"isShowResponseText\";s:3:\"OFF\";s:15:\"isShowPoweredBy\";s:2:\"ON\";s:8:\"btnLabel\";s:55:\"¿Necesitas ayuda? <strong>Chatea con nosotros</strong>\";s:13:\"btnLabelWidth\";s:3:\"156\";s:11:\"btnPosition\";s:5:\"right\";s:15:\"btnLeftDistance\";s:2:\"30\";s:16:\"btnRightDistance\";s:2:\"30\";s:17:\"btnBottomDistance\";s:2:\"30\";s:14:\"isShowBtnLabel\";s:2:\"ON\";s:10:\"isShowGDPR\";s:3:\"OFF\";s:11:\"gdprContent\";s:130:\"Acepta primero nuestra <a href=\"https://ninjateam.org/privacy-policy/\">política de privacidad</a> para iniciar una conversación.\";}", "auto");
INSERT INTO `webpyme_options` VALUES("963", "_wpforms_transient_wpforms_htaccess_file", "a:3:{s:4:\"size\";i:737;s:5:\"mtime\";i:1736432005;s:5:\"ctime\";i:1736432005;}", "on");
INSERT INTO `webpyme_options` VALUES("964", "wpforms_email_summaries_fetch_info_blocks_last_run", "1739544907", "auto");
INSERT INTO `webpyme_options` VALUES("1466", "wp_mail_smtp_summary_report_email_last_sent_week", "07", "auto");
INSERT INTO `webpyme_options` VALUES("1485", "themeisle_sdk_notifications", "a:2:{s:17:\"last_notification\";a:2:{s:2:\"id\";s:26:\"wpcf7_redirect_logger_flag\";s:10:\"display_at\";i:1739545081;}s:24:\"last_notification_active\";i:1737476216;}", "auto");
INSERT INTO `webpyme_options` VALUES("1755", "wpcf7_redirect_review_flag", "no", "auto");
INSERT INTO `webpyme_options` VALUES("1938", "_site_transient_timeout_g_url_details_response_0505490c4177de08607c21d37ff3b872", "1737651163", "off");
INSERT INTO `webpyme_options` VALUES("1980", "_transient_timeout_wpcf7_redirect_all_languages", "1740149706", "off");
INSERT INTO `webpyme_options` VALUES("1981", "_transient_wpcf7_redirect_all_languages", "a:1:{s:12:\"translations\";a:11:{i:0;a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2022-07-22 15:10:49\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}}i:1;a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2024-06-04 10:52:04\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:2;a:7:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2022-07-22 15:11:16\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:3;a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2024-12-14 08:03:51\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:4;a:7:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2022-07-22 15:11:05\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}}i:5;a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2022-07-22 15:11:08\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}}i:6;a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2024-08-12 16:22:05\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:7;a:7:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2024-08-13 10:36:00\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:88:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:8;a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2022-07-22 15:11:10\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}}i:9;a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2023-06-18 18:39:09\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}}i:10;a:7:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"3.1.9\";s:7:\"updated\";s:19:\"2024-06-05 05:17:19\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpcf7-redirect/3.1.9/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}}}}", "off");
INSERT INTO `webpyme_options` VALUES("1982", "_transient_timeout_tisdk_has_support_page", "1740149706", "off");
INSERT INTO `webpyme_options` VALUES("1983", "_transient_tisdk_has_support_page", "no", "off");
INSERT INTO `webpyme_options` VALUES("1984", "_transient_timeout_tsk_attachment_count", "1739631306", "off");
INSERT INTO `webpyme_options` VALUES("1985", "_transient_tsk_attachment_count", "32", "off");
INSERT INTO `webpyme_options` VALUES("1986", "_transient_timeout_tsk_posts_count", "1739631306", "off");
INSERT INTO `webpyme_options` VALUES("1987", "_transient_tsk_posts_count", "a:2:{s:11:\"total_posts\";i:1;s:9:\"old_posts\";i:0;}", "off");
INSERT INTO `webpyme_options` VALUES("1989", "_site_transient_timeout_available_translations", "1739555706", "off");
INSERT INTO `webpyme_options` VALUES("1990", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.9/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 09:05:28\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.5/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.26/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-12 07:32:34\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-11 11:12:13\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-23 15:46:02\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-11 08:34:45\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-04 15:09:31\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-30 01:15:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 18:11:40\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-03 07:45:57\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-08 01:15:14\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-08 01:13:58\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.7.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 18:08:14\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.7.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-23 00:05:55\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-08 19:43:34\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-15 22:47:35\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 20:17:10\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-06 16:38:21\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 00:03:39\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-20 19:38:18\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-02 23:11:20\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-04 14:46:26\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-05 15:56:22\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.16/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.21/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-09 22:28:42\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-30 07:43:09\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-01 20:26:01\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-23 15:37:32\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-30 10:07:14\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-10 01:30:52\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-27 13:02:04\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-12 22:29:22\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-06 14:03:49\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.6/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-29 23:44:41\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-31 07:07:30\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.33\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.33/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-01 09:14:16\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-22 18:23:30\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-31 11:29:26\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-16 18:27:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-07 13:30:47\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-01 06:53:56\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.21/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-16 17:32:57\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-11 06:34:23\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-04 13:14:22\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.7.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-11 17:53:34\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.7.1/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 13:11:03\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-02 13:58:02\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.9/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-10-05 15:57:37\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-09 17:43:36\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.15\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.15/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-07 23:57:02\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-08-30 11:32:23\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-08 02:42:50\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-08 03:02:52\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-11 13:37:10\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-10 11:19:42\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.34\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.34/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 09:42:36\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-03 15:04:58\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-01 14:10:09\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-10 15:43:56\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-30 08:56:10\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.16/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-10 11:39:57\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-09-21 09:44:08\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-08-30 07:14:35\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-30 10:26:38\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-09-20 22:15:56\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-03 17:00:50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-02 07:29:05\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.25/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-06 13:44:46\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-03 01:12:45\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-03-06 18:52:07\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.16/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-02-11 06:35:32\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-23 16:50:06\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-12 05:35:18\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "off");
INSERT INTO `webpyme_options` VALUES("1991", "_site_transient_timeout_theme_roots", "1739546707", "off");
INSERT INTO `webpyme_options` VALUES("1992", "_site_transient_theme_roots", "a:5:{s:13:\"kadence-child\";s:7:\"/themes\";s:7:\"kadence\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `webpyme_options` VALUES("2002", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"webmaster@web-pyme.cl\";s:7:\"version\";s:5:\"6.7.2\";s:9:\"timestamp\";i:1739544914;}", "off");
INSERT INTO `webpyme_options` VALUES("2003", "_site_transient_timeout_php_check_feede18ab91a39786f5028b7215ed6a6", "1740149716", "off");
INSERT INTO `webpyme_options` VALUES("2004", "_site_transient_php_check_feede18ab91a39786f5028b7215ed6a6", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `webpyme_options` VALUES("2008", "_transient_timeout_code_snippets_welcome_data", "1739717879", "off");
INSERT INTO `webpyme_options` VALUES("2009", "_transient_code_snippets_welcome_data", "a:5:{s:6:\"banner\";a:9:{s:3:\"key\";s:12:\"backtonormal\";s:14:\"start_datetime\";O:17:\"DateTimeImmutable\":3:{s:4:\"date\";s:26:\"2025-01-24 07:00:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:12:\"end_datetime\";O:17:\"DateTimeImmutable\":3:{s:4:\"date\";s:26:\"2025-07-05 16:00:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:9:\"text_free\";s:79:\"Code Without Limits – Experience Ultimate Flexibility with Code Snippets Pro!\";s:15:\"action_url_free\";s:22:\"https://snipco.de/TFHM\";s:17:\"action_label_free\";s:10:\"Go Pro now\";s:8:\"text_pro\";s:73:\"Enjoying the Power of Pro? Make It Yours Forever with a Lifetime Upgrade!\";s:14:\"action_url_pro\";s:22:\"https://snipco.de/TFIP\";s:16:\"action_label_pro\";s:10:\"Go Pro now\";}s:9:\"hero-item\";a:3:{s:4:\"name\";s:26:\"Code Snippet AI is here…\";s:10:\"follow_url\";s:54:\"https://codesnippets.pro/blog/code-snippet-ai-is-here/\";s:9:\"image_url\";s:71:\"https://codesnippets.pro/wp-content/uploads/2024/05/cs_ai_demo_full.gif\";}s:8:\"features\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"Pssss... Get Secret Discount\";s:10:\"follow_url\";s:22:\"https://snipco.de/TFIG\";s:9:\"image_url\";s:81:\"https://codesnippets.pro/wp-content/uploads/2024/09/Promotions_Hero_All_Plans.png\";s:8:\"category\";s:5:\"offer\";s:11:\"description\";s:100:\"Get secret discount on all Code Snippets Pro plans. Just use coupon code \'General5\' at the checkout!\";}i:1;a:5:{s:5:\"title\";s:25:\"Add Unsplash to WordPress\";s:10:\"follow_url\";s:22:\"https://snipco.de/Mind\";s:9:\"image_url\";s:53:\"https://i3.ytimg.com/vi/kRSwWDanX0A/maxresdefault.jpg\";s:8:\"category\";s:3:\"tip\";s:11:\"description\";s:70:\"Code Snippet to Add Unsplash to WordPress - Find and Download Images..\";}i:2;a:5:{s:5:\"title\";s:30:\"Code Snippet Cloud Setup Guide\";s:10:\"follow_url\";s:22:\"https://snipco.de/Mine\";s:9:\"image_url\";s:149:\"https://cdn.getgist.com/attachment_images/76ca6cef08ca8e69ac1e7fbc15004bebbd08ad595ee67e0d7b55d1a9555354bfScreenshot%202023-11-23%20at%2000.50.02.png\";s:8:\"category\";s:5:\"guide\";s:11:\"description\";s:143:\"We have done our best to make the cloud set up as smooth and easy as possible. This guide below will walk you through the process step by step.\";}i:3;a:5:{s:5:\"title\";s:14:\"Cloud and AI +\";s:10:\"follow_url\";s:22:\"https://snipco.de/Minf\";s:9:\"image_url\";s:53:\"https://i3.ytimg.com/vi/rEOC2bIwY-w/maxresdefault.jpg\";s:8:\"category\";s:11:\"new feature\";s:11:\"description\";s:68:\"Code Snippets 3.6 Announcement - AI CodeSnippets - Generate AI Code!\";}}s:8:\"partners\";a:4:{i:0;a:3:{s:5:\"title\";s:9:\"Elementor\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3d\";s:9:\"image_url\";s:76:\"https://codesnippets.pro/wp-content/uploads/2024/05/Elementor-logo-green.png\";}i:1;a:3:{s:5:\"title\";s:7:\"InstaWP\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3n\";s:9:\"image_url\";s:68:\"https://codesnippets.pro/wp-content/uploads/2024/05/instawp-logo.png\";}i:2;a:3:{s:5:\"title\";s:8:\"Codeable\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3j\";s:9:\"image_url\";s:69:\"https://codesnippets.pro/wp-content/uploads/2024/05/codeable-logo.png\";}i:3;a:3:{s:5:\"title\";s:10:\"Crocoblock\";s:10:\"follow_url\";s:22:\"https://snipco.de/KK3l\";s:9:\"image_url\";s:71:\"https://codesnippets.pro/wp-content/uploads/2024/05/crocoblock-logo.png\";}}s:9:\"changelog\";a:3:{s:5:\"3.6.6\";a:2:{s:7:\"Changed\";a:1:{s:4:\"core\";a:2:{i:0;s:51:\"Improved compatability with modern versions of PHP.\";i:1;s:46:\"Extended welcome API to include admin notices.\";}}s:5:\"Fixed\";a:1:{s:4:\"core\";a:5:{i:0;s:86:\"Memory issue from checking aggregate posts while loading front-end syntax highlighter.\";i:1;s:98:\"Translation functions being called too early on upgrade, resulting in localisation loading errors.\";i:2;s:89:\"Bug preventing the \'share on network\' status of network snippets from correctly updating.\";i:3;s:98:\"Incorrect logic controlling when to display \'Save Changes\' or \'Save Changes and Activate\' buttons.\";i:4;s:76:\"Old notices persisting when switching between editing and creating snippets.\";}}}s:5:\"3.6.5\";a:1:{s:5:\"Added\";a:1:{s:4:\"core\";a:1:{i:0;s:96:\"New admin menu providing useful resources and updates on the Code Snippets plugin and community.\";}}}s:5:\"3.6.4\";a:3:{s:5:\"Added\";a:1:{s:3:\"pro\";a:2:{i:0;s:51:\"AI generation for all snippet types: HTML, CSS, JS.\";i:1;s:86:\"Button to create a cloud connection directly from the Snippets menu when disconnected.\";}}s:7:\"Changed\";a:1:{s:3:\"pro\";a:2:{i:0;s:95:\"Increment the revision number of CSS and JS snippet when using the \'Reset Caches\' debug action.\";i:1;s:67:\"UX in generate dialog, such as allowing \'Enter\' to submit the form.\";}}s:5:\"Fixed\";a:2:{s:4:\"core\";a:2:{i:0;s:58:\"Minor type compatability issue with newer versions of PHP.\";i:1;s:57:\"Translations not loading for strings in JavaScript files.\";}s:3:\"pro\";a:2:{i:0;s:53:\"Undefined array key issue when initiating cloud sync.\";i:1;s:58:\"Bug preventing downloading a single snippet from a bundle.\";}}}}}", "off");
INSERT INTO `webpyme_options` VALUES("2010", "_site_transient_timeout_browser_b9cbd8dc13f19f9e7eb854f472bfa274", "1740149881", "off");
INSERT INTO `webpyme_options` VALUES("2011", "_site_transient_browser_b9cbd8dc13f19f9e7eb854f472bfa274", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"109.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `webpyme_options` VALUES("2012", "_transient_timeout_action_scheduler_last_pastdue_actions_check", "1739566681", "off");
INSERT INTO `webpyme_options` VALUES("2013", "_transient_action_scheduler_last_pastdue_actions_check", "1739545081", "off");
INSERT INTO `webpyme_options` VALUES("2014", "_transient_timeout_wp_mail_smtp_error_debug_events_transient_30-days", "1739548681", "off");
INSERT INTO `webpyme_options` VALUES("2015", "_transient_wp_mail_smtp_error_debug_events_transient_30-days", "0", "off");
INSERT INTO `webpyme_options` VALUES("2016", "_transient_timeout_feed_9bc1b9ec726e1f508c5207949084454a", "1739588282", "off");
INSERT INTO `webpyme_options` VALUES("2017", "_transient_feed_9bc1b9ec726e1f508c5207949084454a", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Themeisle Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://themeisle.com/blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WordPress Tutorials and Reviews for Beginners and Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Feb 2025 08:52:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=6.5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://themeisle.com/blog/wp-content/uploads/2019/05/cropped-cropped-favicon-2-32x32.png\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Themeisle Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://themeisle.com/blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:62:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Neve 4.0 ‘Sarmizegetusa’: A Smarter WordPress Theme Experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://themeisle.com/blog/neve-4-0-sarmizegetusa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://themeisle.com/blog/neve-4-0-sarmizegetusa/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Feb 2025 10:00:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"WordPress Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=109432\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:331:\"<p>Neve 4.0. A smarter, faster way to build exceptional websites that stand out from the crowd.</p>\n<p>The post <a href=\"https://themeisle.com/blog/neve-4-0-sarmizegetusa/\">Neve 4.0 &#8216;Sarmizegetusa&#8217;: A Smarter WordPress Theme Experience</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Harshit Arora\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://themeisle.com/blog/neve-4-0-sarmizegetusa/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"7 Vulnerabilities Your WordPress Security Plugins Can’t Protect You From (And How to Fix Them Manually)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://themeisle.com/blog/manually-harden-wordpress-security/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://themeisle.com/blog/manually-harden-wordpress-security/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jan 2025 09:38:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Resources\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=109289\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:681:\"<p>If you\'re like many WordPress users then you\'ve probably installed a security plugin to help keep your website safe. This is an excellent first step. It will handle much of your protection, but if you truly care about your site\'s security then you need to implement some manual changes at the server level. In this tutorial I\'ll show you how (don\'t worry, it\'s not as difficult as it may sound).</p>\n<p>The post <a href=\"https://themeisle.com/blog/manually-harden-wordpress-security/\">7 Vulnerabilities Your WordPress Security Plugins Can&#8217;t Protect You From (And How to Fix Them Manually)</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://themeisle.com/blog/manually-harden-wordpress-security/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"AI Agents Coming to a Website Near You\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://themeisle.com/blog/ai-agents-coming-to-a-website-near-you/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://themeisle.com/blog/ai-agents-coming-to-a-website-near-you/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Jan 2025 10:24:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"AI Innovations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=109158\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"<p>Learn how to prepare your website for intelligent agents that prioritize structured data and APIs over traditional web design elements, demanding new strategies for website optimization.</p>\n<p>The post <a href=\"https://themeisle.com/blog/ai-agents-coming-to-a-website-near-you/\">AI Agents Coming to a Website Near You</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Sabina Ionescu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://themeisle.com/blog/ai-agents-coming-to-a-website-near-you/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"2024 WordPress Recap: A Lot More Happened Than Just #WPDrama\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://themeisle.com/blog/wordpress-2024-recap/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://themeisle.com/blog/wordpress-2024-recap/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jan 2025 11:23:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=108826\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:592:\"<p>As we kick off the 22nd year of WordPress, many people are anxious about the ongoing #wpdrama. But it\'s important to remember that there were almost ten months of exciting things happening in WordPress before Matt fired shots at WP Engine. In an effort to provide some counterbalance, I present to you a recap of what happened in the world of WordPress throughout 2024.</p>\n<p>The post <a href=\"https://themeisle.com/blog/wordpress-2024-recap/\">2024 WordPress Recap: A Lot More Happened Than Just #WPDrama</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://themeisle.com/blog/wordpress-2024-recap/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"If You Could Only Choose 5 WordPress Plugins, What Would They Be?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://themeisle.com/blog/only-choose-5-wordpress-plugins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://themeisle.com/blog/only-choose-5-wordpress-plugins/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jan 2025 08:22:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=109098\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"<p>I recently stumbled upon a Reddit thread that asked a simple but really compelling question. You can see it in the headline: If you could only choose 5 WordPress plugins, which ones would you pick?</p>\n<p>The post <a href=\"https://themeisle.com/blog/only-choose-5-wordpress-plugins/\">If You Could Only Choose 5 WordPress Plugins, What Would They Be?</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Karol K\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://themeisle.com/blog/only-choose-5-wordpress-plugins/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"WordPress Ticket #30465 Was Opened 10 Years Ago – Is 2025 Going to Be the Year It Finally Gets Resolved?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://themeisle.com/blog/wordpress-ticket-30465/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://themeisle.com/blog/wordpress-ticket-30465/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Jan 2025 13:12:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=108611\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:699:\"<p>Back in November 2014, a WordPress developer named Sergej Mueller raised what seemed like a reasonable concern: users had no way of knowing if a plugin they were using had been removed from the official repository - even if it was removed for security reasons. His ticket - officially #30465 - was closed relatively soon after, but with no resolution. Little did Sergej know that it would be reopened almost ten years later.</p>\n<p>The post <a href=\"https://themeisle.com/blog/wordpress-ticket-30465/\">WordPress Ticket #30465 Was Opened 10 Years Ago &#8211; Is 2025 Going to Be the Year It Finally Gets Resolved?</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://themeisle.com/blog/wordpress-ticket-30465/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"10 WordPress Influencers Who Made Waves in 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://themeisle.com/blog/wordpress-influencers-of-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://themeisle.com/blog/wordpress-influencers-of-2024/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Dec 2024 10:15:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=108683\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:597:\"<p>If you\'re a follower of our blog, then you already know that our main niche starts with a Word and ends in a Press. And while there are plenty of noteworthy WordPress stories that made headlines this past year, it\'s easy to make the argument that this was very much a personality-driven year. Let\'s take a look at the individuals who had the biggest impact on WordPress in 2024.</p>\n<p>The post <a href=\"https://themeisle.com/blog/wordpress-influencers-of-2024/\">10 WordPress Influencers Who Made Waves in 2024</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://themeisle.com/blog/wordpress-influencers-of-2024/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Let’s All Laugh Together, Or Not Laugh at All: An Essay on Pineapples, WordPress and Humor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://themeisle.com/blog/wordpress-pineapple-is-delicious-on-pizza/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://themeisle.com/blog/wordpress-pineapple-is-delicious-on-pizza/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Dec 2024 16:13:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=108619\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:585:\"<p>A new week, a new chapter of the Matt Mullenweg vs WP Engine saga unfolds. This time, the plot twist involved the tropical fruit, pineapple. For the past three days, if you wanted to log in to your WordPress.org account, you\'d have to agree to a controversial statement, \"Pineapple is delicious on pizza.\"</p>\n<p>The post <a href=\"https://themeisle.com/blog/wordpress-pineapple-is-delicious-on-pizza/\">Let&#8217;s All Laugh Together, Or Not Laugh at All: An Essay on Pineapples, WordPress and Humor</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Sabina Ionescu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://themeisle.com/blog/wordpress-pineapple-is-delicious-on-pizza/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"My 5 Favorite WP Simple Pay Alternatives for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://themeisle.com/blog/wp-simple-pay-alternatives/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://themeisle.com/blog/wp-simple-pay-alternatives/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Dec 2024 12:31:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=108349\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:617:\"<p>WP Simple Pay has been a staple payment processor plugin for many years now. While we can admire its longevity, it\'s not without its faults. You\'re likely aware of them already. Otherwise you wouldn\'t be here looking for alternatives. Well, let me not keep you waiting any longer. Here are my five favorite payment processors for WordPress users that I like better than WP Simple Pay - and why.</p>\n<p>The post <a href=\"https://themeisle.com/blog/wp-simple-pay-alternatives/\">My 5 Favorite WP Simple Pay Alternatives for WordPress</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://themeisle.com/blog/wp-simple-pay-alternatives/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Are Block Themes Better Than Classic Themes? Here’s What People Think\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://themeisle.com/blog/block-themes-vs-classic-themes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://themeisle.com/blog/block-themes-vs-classic-themes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Dec 2024 09:31:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=106706\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:660:\"<p>Twenty Twenty-Two was the first official default block theme that was released with WordPress 5.9. Ever since then, WordPress aficionados have been going back and forth on whether block themes are better than classic themes or vice versa. I have my own thoughts, which I\'ll share, but I also reached out to my colleagues and other WordPress professionals to crowdsource some opinions. Here\'s what I discovered...</p>\n<p>The post <a href=\"https://themeisle.com/blog/block-themes-vs-classic-themes/\">Are Block Themes Better Than Classic Themes? Here&#8217;s What People Think</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://themeisle.com/blog/block-themes-vs-classic-themes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://themeisle.com/blog/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:14:{s:4:\"date\";s:29:\"Fri, 14 Feb 2025 14:58:02 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:7:\"x-verti\";s:120:\"If you\'re reading this, you should visit https://careers.vertistudio.com/jobs and apply to join us, mention this header.\";s:27:\"access-control-allow-origin\";s:1:\"*\";s:4:\"link\";s:111:\"<https://themeisle.com/blog/wp-json/>; rel=\"https://api.w.org/\", <https://themeisle.com/blog/>; rel=\"canonical\"\";s:13:\"last-modified\";s:29:\"Wed, 12 Feb 2025 14:57:16 GMT\";s:13:\"cache-control\";s:35:\"public, max-age=0, s-maxage=2592000\";s:15:\"cf-cache-status\";s:3:\"HIT\";s:3:\"age\";s:5:\"14679\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"911de9fafd9ee9ba-SCL\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}}s:5:\"build\";i:1727767220;s:21:\"cache_expiration_time\";i:1739588282;s:23:\"__cache_expiration_time\";i:1739588282;}", "off");
INSERT INTO `webpyme_options` VALUES("2018", "_transient_timeout_feed_mod_9bc1b9ec726e1f508c5207949084454a", "1739588282", "off");
INSERT INTO `webpyme_options` VALUES("2019", "_transient_feed_mod_9bc1b9ec726e1f508c5207949084454a", "1739545082", "off");
INSERT INTO `webpyme_options` VALUES("2020", "_transient_timeout_feed_41e43183af30f3b40ed25f48cc2ea3f8", "1739588282", "off");
INSERT INTO `webpyme_options` VALUES("2021", "_transient_feed_41e43183af30f3b40ed25f48cc2ea3f8", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"WPShout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"https://wpshout.com/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"A hub for advanced WordPress users, developers & savvy business owners.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Feb 2025 09:26:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=6.4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wpshout.com/wp-content/uploads/2024/04/cropped-main-icon1x-32x32.png\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"WPShout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"https://wpshout.com/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:8:{i:0;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"How to Remove Unwanted Elements From Screenshots in 20 Seconds Without AI or Image Editing Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wpshout.com/easily-remove-unwanted-elements-from-screenshots/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wpshout.com/easily-remove-unwanted-elements-from-screenshots/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Feb 2025 09:26:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Quick Guides\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=147457\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:818:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/02/Remove-Unwanted-Elements-From-Screenshots.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"Remove Unwanted Elements From Screenshots\" decoding=\"async\" />If you work in content or social media and you often have to take screenshots of other websites then you know how annoying it is when you come across a page with random obstructions. Whether its a giant banner announcing a seasonal sale, a popup window, a sidebar widget, or some awkwardly inserted Google ad - it doesn\'t matter. The point is that you don\'t want it there. You want a nice, clean image. Fortunately, there is a very quick and very easy way to do it. Here\'s how.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wpshout.com/easily-remove-unwanted-elements-from-screenshots/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:191:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/02/Remove-Unwanted-Elements-From-Screenshots.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:191:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/02/Remove-Unwanted-Elements-From-Screenshots.png\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Remove Unwanted Elements From Screenshots\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Almost Pwned: How a Sophisticated Google Scam Nearly Fooled a Seasoned Programmer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wpshout.com/google-phishing-scam-targets-founder-of-hack-club/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wpshout.com/google-phishing-scam-targets-founder-of-hack-club/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jan 2025 19:27:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=147237\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:673:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/01/Almost-Pwned.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"Almost Pwned\" decoding=\"async\" />Sometimes the difference between security and compromise comes down to a single click - and a healthy dose of suspicion. And it\'s because scammers are getting increasingly sophisticated with their phishing attempts. It\'s to the point where even following standard security best practices isn\'t enough to protect you. Case in point: last week\'s near-successful phishing attack on Zach Latta.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wpshout.com/google-phishing-scam-targets-founder-of-hack-club/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:162:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/Almost-Pwned.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:162:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/Almost-Pwned.png\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Almost Pwned\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"Everyone Is Talking About DeepSeek AI, but Is It Really THAT Good? I Tested It Against GPT-o1 and Claude\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://wpshout.com/deepseek-ai/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wpshout.com/deepseek-ai/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jan 2025 12:35:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Software & Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=147178\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:636:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/01/DeepSeek-R1.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"DeepSeek R1\" decoding=\"async\" />The new DeepSeek R1 model from China launched last week. If you\'re into AI or even into technology more broadly, it was hard to miss the news. Everyone was talking about it. But it\'s not just that. It\'s the way everyone was talking about it. I was left with the impression that DeepSeek is going to drive a stake through the heart of OpenAI and Anthropic.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://wpshout.com/deepseek-ai/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:161:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/DeepSeek-R1.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:161:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/DeepSeek-R1.png\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"DeepSeek R1\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Google Says They Updated Their Site Reputation Abuse Policy…Nothing Actually Changed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wpshout.com/google-site-reputation-abuse-policy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wpshout.com/google-site-reputation-abuse-policy/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jan 2025 13:09:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=146940\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:508:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/01/Google-Site-Reputation-Abuse-Policy.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"Google Site Reputation Abuse Policy\" decoding=\"async\" />This morning, I came across some interesting news about Google\'s updated site reputation abuse policies. Apparently, they\'ve revised their main guidelines with some fresh updates.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Karol K\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wpshout.com/google-site-reputation-abuse-policy/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:185:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/Google-Site-Reputation-Abuse-Policy.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:185:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/Google-Site-Reputation-Abuse-Policy.png\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Google Site Reputation Abuse Policy\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"The Real AI Threat Isn’t Coming – It’s Already Here: 3 Cases of Algorithms Destroying Lives\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wpshout.com/when-algorithms-destroy-lives/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wpshout.com/when-algorithms-destroy-lives/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jan 2025 10:50:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Ideas & Inspiration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=145955\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:718:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/01/The-Real-AI-Threat.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"The Real AI Threat\" decoding=\"async\" />While the web buzzes with anxiety about AI taking our jobs or achieving consciousness, real artificial intelligence systems have already been making life-altering decisions about healthcare, housing, and basic human rights – often with devastating consequences.In this article I\'m going to examine three real-life cases where AI systems destroyed thousands of lives. Then I\'ll share my opinion on what we can do about it.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wpshout.com/when-algorithms-destroy-lives/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:168:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/The-Real-AI-Threat.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:168:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/The-Real-AI-Threat.png\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"The Real AI Threat\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Google Now Requires JavaScript Because “Security”…They’re Not Telling the Entire Truth\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wpshout.com/google-now-requires-javascript/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wpshout.com/google-now-requires-javascript/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jan 2025 13:51:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=146789\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:728:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/01/Google-Now-Requires-JavaScript.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"Google Now Requires JavaScript\" decoding=\"async\" />Google has made a significant change: you now need to enable JavaScript to use Google Search. According to them, this move is about security and improving the experience for users like you and me. By requiring JavaScript, Google says it can better protect its platform against spam, bots, and other types of abuse. It also claims this change ensures you get “the most relevant and up-to-date information.”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Karol K\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wpshout.com/google-now-requires-javascript/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:180:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/Google-Now-Requires-JavaScript.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:180:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/Google-Now-Requires-JavaScript.png\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Google Now Requires JavaScript\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Automattic Cuts Weekly Contributor Hours to WordPress.org by 99% – Community Members Fear ‘Beginning of the End’\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wpshout.com/automattic-cuts-weekly-contributor-hours-to-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wpshout.com/automattic-cuts-weekly-contributor-hours-to-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jan 2025 13:03:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=146729\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:624:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/01/Automattic-Cuts-Weekly-Contributor-Hours.jpg\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"Automattic-Cuts-Weekly-Contributor-Hours\" decoding=\"async\" />Last week, Automattic announced that they\'d be cutting their weekly contributor hours to WordPress.org from roughly 4,000 to a mere 45. This is a massive shift in how open-source WordPress has functioned for over a decade. Let\'s explore four possible implications of this major change.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wpshout.com/automattic-cuts-weekly-contributor-hours-to-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:190:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/Automattic-Cuts-Weekly-Contributor-Hours.jpg\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:190:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2025/01/Automattic-Cuts-Weekly-Contributor-Hours.jpg\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Automattic-Cuts-Weekly-Contributor-Hours\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"The Rise of “GEO” – or How AI is Transforming Search Engine Optimization\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wpshout.com/generative-engine-optimization/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wpshout.com/generative-engine-optimization/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Jan 2025 12:40:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=145919\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:856:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2024/12/the-rise-of-GEO.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"the rise of GEO\" decoding=\"async\" />If you\'ve used Google lately, you\'ve probably noticed a change: instead of just getting a mix of links and snippets, you\'re now seeing AI-generated responses that synthesize information from multiple sources right there in your results. This is what\'s known as generative search and it\'s changing how we optimize content for search engines. In this post, I\'ll explain how traditional SEO differs from GEO and where the concept of GEO originated from. Then I\'ll go over some best practices so you can improve your odds of getting featured in generative search results.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wpshout.com/generative-engine-optimization/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:165:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2024/12/the-rise-of-GEO.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:165:\"https://iotvnaw69daj.i.optimole.com/cb:mLvy.66914/w:150/h:150/q:90/rt:fill/g:ce/f:best/https://wpshout.com/wpshout.com/wp-content/uploads/2024/12/the-rise-of-GEO.png\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"the rise of GEO\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:25:\"https://wpshout.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:14:{s:4:\"date\";s:29:\"Fri, 14 Feb 2025 14:58:02 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:7:\"x-verti\";s:120:\"If you\'re reading this, you should visit https://careers.vertistudio.com/jobs and apply to join us, mention this header.\";s:27:\"access-control-allow-origin\";s:1:\"*\";s:4:\"link\";s:97:\"<https://wpshout.com/wp-json/>; rel=\"https://api.w.org/\", <https://wpshout.com/>; rel=\"canonical\"\";s:13:\"last-modified\";s:29:\"Thu, 13 Feb 2025 10:33:38 GMT\";s:13:\"cache-control\";s:35:\"public, max-age=0, s-maxage=2592000\";s:15:\"cf-cache-status\";s:3:\"HIT\";s:3:\"age\";s:4:\"5497\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"911de9ff1cf8e798-SCL\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}}s:5:\"build\";i:1727767220;s:21:\"cache_expiration_time\";i:1739588282;s:23:\"__cache_expiration_time\";i:1739588282;}", "off");
INSERT INTO `webpyme_options` VALUES("2022", "_transient_timeout_feed_mod_41e43183af30f3b40ed25f48cc2ea3f8", "1739588282", "off");
INSERT INTO `webpyme_options` VALUES("2023", "_transient_feed_mod_41e43183af30f3b40ed25f48cc2ea3f8", "1739545082", "off");
INSERT INTO `webpyme_options` VALUES("2024", "_transient_timeout_themeisle_sdk_feed_items", "1739717882", "off");
INSERT INTO `webpyme_options` VALUES("2025", "_transient_themeisle_sdk_feed_items", "a:5:{i:0;a:3:{s:5:\"title\";s:96:\"How to Remove Unwanted Elements From Screenshots in 20 Seconds Without AI or Image Editing Tools\";s:4:\"date\";i:1738920398;s:4:\"link\";s:69:\"https://wpshout.com/easily-remove-unwanted-elements-from-screenshots/\";}i:1;a:3:{s:5:\"title\";s:66:\"Neve 4.0 ‘Sarmizegetusa’: A Smarter WordPress Theme Experience\";s:4:\"date\";i:1738576858;s:4:\"link\";s:50:\"https://themeisle.com/blog/neve-4-0-sarmizegetusa/\";}i:2;a:3:{s:5:\"title\";s:81:\"Almost Pwned: How a Sophisticated Google Scam Nearly Fooled a Seasoned Programmer\";s:4:\"date\";i:1738265231;s:4:\"link\";s:70:\"https://wpshout.com/google-phishing-scam-targets-founder-of-hack-club/\";}i:3;a:3:{s:5:\"title\";s:104:\"Everyone Is Talking About DeepSeek AI, but Is It Really THAT Good? I Tested It Against GPT-o1 and Claude\";s:4:\"date\";i:1738067724;s:4:\"link\";s:32:\"https://wpshout.com/deepseek-ai/\";}i:4;a:3:{s:5:\"title\";s:105:\"7 Vulnerabilities Your WordPress Security Plugins Can’t Protect You From (And How to Fix Them Manually)\";s:4:\"date\";i:1737970716;s:4:\"link\";s:62:\"https://themeisle.com/blog/manually-harden-wordpress-security/\";}}", "off");
INSERT INTO `webpyme_options` VALUES("2026", "_transient_timeout_themeisle_sdk_products", "1739566683", "off");
INSERT INTO `webpyme_options` VALUES("2027", "_transient_themeisle_sdk_products", "a:6:{i:0;a:4:{s:4:\"name\";s:4:\"Neve\";s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:4:\"neve\";s:8:\"installs\";i:300000;}i:1;a:4:{s:4:\"name\";s:6:\"Hestia\";s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:6:\"hestia\";s:8:\"installs\";i:100000;}i:2;a:4:{s:4:\"name\";s:22:\"Orbit Fox by ThemeIsle\";s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:19:\"themeisle-companion\";s:8:\"installs\";i:200000;}i:3;a:4:{s:4:\"name\";s:82:\"Otter Blocks &#8211; Gutenberg Blocks, Page Builder for Gutenberg Editor &amp; FSE\";s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:12:\"otter-blocks\";s:8:\"installs\";i:300000;}i:4;a:4:{s:4:\"name\";s:98:\"RSS Aggregator by Feedzy – Feed to Post, Autoblogging, News &amp; YouTube Video Feeds Aggregator\";s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:16:\"feedzy-rss-feeds\";s:8:\"installs\";i:50000;}i:5;a:4:{s:4:\"name\";s:51:\"Visualizer: Tables and Charts Manager for WordPress\";s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:10:\"visualizer\";s:8:\"installs\";i:30000;}}", "off");
INSERT INTO `webpyme_options` VALUES("2028", "_site_transient_timeout_community-events-db012286762e3c16c3ab27d6b333ff73", "1739588287", "off");
INSERT INTO `webpyme_options` VALUES("2029", "_site_transient_community-events-db012286762e3c16c3ab27d6b333ff73", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"200.120.79.0\";}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `webpyme_options` VALUES("2030", "_transient_timeout_feed_69c933d8a78805efd0abe985766ffb51", "1739588287", "off");
INSERT INTO `webpyme_options` VALUES("2031", "_transient_feed_69c933d8a78805efd0abe985766ffb51", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress.org España\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://es.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Español\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Feb 2025 20:25:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"es\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.8-alpha-59821\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress.org España\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://es.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:82:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"WordPress 6.7.2 – Versión de mantenimiento\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://es.wordpress.org/2025/02/11/wordpress-6-7-2-version-de-mantenimiento/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://es.wordpress.org/2025/02/11/wordpress-6-7-2-version-de-mantenimiento/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Feb 2025 20:24:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:15:\"Actualizaciones\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Mantenimiento\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"6.7.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=671489\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"WordPress 6.7.2 is now available! Esta versión menor incluye&#160;35 correcciones a fallos, solucionando problemas que afectaban a varios componentes, incluidos el editor de bloques, la API HTML y el personalizador. WordPress 6.7.2 es una versión de ciclo corto. La próxima versión mayor será la 6.8, planificada para el 15 de abril de 2025. Si tienes [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Fernando Tellado\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9177:\"\n<h2 class=\"wp-block-heading\">WordPress 6.7.2 is now available!</h2>\n\n\n\n<p>Esta versión menor incluye&nbsp;<a href=\"https://make.wordpress.org/core/tag/6-7-2/\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">35 correcciones a fallos</a>, solucionando problemas que afectaban a varios componentes, incluidos el editor de bloques, la API HTML y el personalizador.</p>\n\n\n\n<p>WordPress 6.7.2 es una versión de ciclo corto. La próxima versión mayor será la <a href=\"https://make.wordpress.org/core/6-8/\">6.8</a>, planificada para el 15 de abril de 2025.</p>\n\n\n\n<p>Si tienes sitios con las actualizaciones automáticas en segundo plano activas, el proceso de actualización empezará automáticamente.</p>\n\n\n\n<p>Puedes&nbsp;<a href=\"https://es.wordpress.org/latest-es_ES.zip\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">descargar WordPress 6.7.2 desde WordPress.org</a>, o visitar tu escritorio de WordPress, hacer clic en  «Actualizaciones» y luego hacer clic en «Actualizar ahora». Para más información sobre esta versión&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-7-2\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">visita el sitio del centro de ayuda</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Gracias a estos contribuidores de WordPress</h2>\n\n\n\n<p>Esta versión la lideró&nbsp;<a href=\"https://profiles.wordpress.org/jorbin/\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.7.2 no habría sido posible sin las contribuciones de las siguientes personas. Su coordinación asíncrona a la hora de convertir correcciones de mantenimiento en una versión estable es la constatación del poder y capacidad de la comunidad WordPress.  </p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ajlende\">Alex Lende</a>,&nbsp;<a href=\"https://profiles.wordpress.org/alexandrebuffet\">Alexandre Buffet</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bowedk\">Andreas Pedersen</a>,&nbsp;<a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ankitkumarshah\">Ankit Kumar Shah</a>,&nbsp;<a href=\"https://profiles.wordpress.org/apermo\">apermo</a>,&nbsp;<a href=\"https://profiles.wordpress.org/benniledl\">Benedikt Ledl</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>,&nbsp;<a href=\"https://profiles.wordpress.org/cbravobernal\">Carlos Bravo</a>,&nbsp;<a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coquardcyr\">Cyrille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/danielpost\">Daniel Post</a>,&nbsp;<a href=\"https://profiles.wordpress.org/darerodz\">darerodz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dpcalhoun\">David Calhoun</a>,&nbsp;<a href=\"https://profiles.wordpress.org/get_dave\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dhewercorus\">dhewercorus</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix\">Ella</a>,&nbsp;<a href=\"https://profiles.wordpress.org/im3dabasia1\">Eshaan Dabasiya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gaambo\">Fabian Todt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ffffelix\">Felix Renicks</a>,&nbsp;<a href=\"https://profiles.wordpress.org/franciscabusas22\">Francis Cabusas</a>,&nbsp;<a href=\"https://profiles.wordpress.org/frankbiganski\">Frank B.</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ghinamt\">ghinamt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/glynnquelch\">Glynn Quelch</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jameskoster\">James Koster</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jsnajdr\">Jarda Snajdr</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jdnd\">jdnd</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jeryj\">jeryj</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanwp22\">juanwp22</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jrf\">Juliette Reinders Folmer</a>,&nbsp;<a href=\"https://profiles.wordpress.org/karthickmurugan\">Karthick</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mt8biz\">Kazuto Takeshita</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ryelle\">Kelly Choyce-Dwan</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ketanniruke\">Ketan Niruke</a>,&nbsp;<a href=\"https://profiles.wordpress.org/0mirka00\">Lena Morita</a>,&nbsp;<a href=\"https://profiles.wordpress.org/levskipg\">levskipg</a>,&nbsp;<a href=\"https://profiles.wordpress.org/maciejmackowiak\">Maciej Ma?kowiak</a>,&nbsp;<a href=\"https://profiles.wordpress.org/santosguillamot\">Mario Santos</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mayanktripathi32\">Mayank Tripathi</a>,&nbsp;<a href=\"https://profiles.wordpress.org/czapla\">Michal Czaplinski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>,&nbsp;<a href=\"https://profiles.wordpress.org/presstoke\">Mitchell Austin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mreishus\">mreishus</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/assassinateur\">Nadir Seghir a11n</a>,&nbsp;<a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nareshbheda\">Naresh Bheda</a>,&nbsp;<a href=\"https://profiles.wordpress.org/neotrope\">neotrope</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ndiego\">Nick Diego</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oglekler\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/parthvataliya\">Parth vataliya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/paullb\">paullb</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pitamdey\">Pitam Dey</a>,&nbsp;<a href=\"https://profiles.wordpress.org/redkite\">redkite</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rishavdutta\">Rishav Dutta</a>,&nbsp;<a href=\"https://profiles.wordpress.org/robertstaddon\">robertstaddon</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rvoigt\">rvoigt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mi5t4n\">Sagar Tamang</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sainathpoojary\">Sainath Poojary</a>,&nbsp;<a href=\"https://profiles.wordpress.org/seanlanglands\">seanlanglands</a>,&nbsp;<a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/shyamkariya\">Shyam Kariya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sukhendu2002\">Sukhendu Sekhar Guria</a>,&nbsp;<a href=\"https://profiles.wordpress.org/TobiasBg\">TobiasBg</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>,&nbsp;<a href=\"https://profiles.wordpress.org/vishy-moghan\">Vishy Moghan</a>,&nbsp;<a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wongjn\">wongjn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/yogeshbhutkar\">Yogesh Bhutkar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/zaoyao\">zaoyao</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Cómo contribuir</h2>\n\n\n\n<p>Para involucrarte en el desarrollo del núcleo de WordPress, pásate por el Trac, <a href=\"https://core.trac.wordpress.org/report/6\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">elige un ticket</a> y únete a la conversión en los canales <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">#core</a> y <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">#6-8-release-leads</a>. ¿Necesitas ayuda? Echa un vistazo al <a href=\"https://make.wordpress.org/core/handbook/\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">manual del contribuidor al núcleo</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://es.wordpress.org/2025/02/11/wordpress-6-7-2-version-de-mantenimiento/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"671489\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WordCamp Zaragoza 2025: El día de los IAnamorados\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://es.wordpress.org/2025/02/06/wordcamp-zaragoza-2025-el-dia-de-los-ianamorados/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://es.wordpress.org/2025/02/06/wordcamp-zaragoza-2025-el-dia-de-los-ianamorados/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Feb 2025 07:17:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=671413\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"IAnamórate de la WordCampZaragoza 2025 (#WCZGZ25) y descubre cómo la IA está revolucionando WordPress. Nos vemos el 14 y 15 de febrero en ETOPIA.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"lualvarimp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5463:\"\n<pre class=\"wp-block-verse\">¿No es cierto, ángel de amor,<br>que en esta apartada orilla<br>más pura la IA brilla<br>y se respira mejor?</pre>\n\n\n\n<p>¿Se te ocurre alguna forma más bonita y poética para empezar este artículo?</p>\n\n\n\n<p>Supongo que será casualidad que la <strong>WordCamp Zaragoza 2025</strong> haya coincidido con una fecha tan especial como lo es el <strong>14 de febrero</strong>, el día de los enamorados, pero hay que reconocer que existe cierta poesía en todo ello.</p>\n\n\n\n<p><a href=\"https://zaragoza.wordcamp.org/2025/comprar-entradas/\" target=\"_blank\" rel=\"noreferrer noopener\">Comprar entradas</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Enamórate de la inteligencia artificial</h2>\n\n\n\n<p>Y también hay algo de realidad porque la temática que abordará la gente de Zaragoza en este evento, la <strong>inteligencia artificial</strong>, es algo que está enamorando a la inmensa mayoría de usuarios de WordPress y de todo el mundo.</p>\n\n\n\n<p>Nos estamos IAnamorando.</p>\n\n\n\n<p>Pero, ¿qué es esto de la inteligencia artificial?… Sabemos que nos rodea desde hace tiempo y que ahora ha florecido de un modo enorme hasta tenerla ya por todas partes.</p>\n\n\n\n<p>Además, no pasa ni un solo día sin que nazca una nueva IA que realice una función específica hasta ahora impensable o que mejore de forma exponencial lo que ya hacía otra parecida hace tan sólo dos semanas.</p>\n\n\n\n<p><a href=\"https://zaragoza.wordcamp.org/2025/comprar-entradas/\" target=\"_blank\" rel=\"noreferrer noopener\">Comprar entradas</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Una escalada sin precedentes</h2>\n\n\n\n<p>Es como una loca carrera a contrarreloj con miles y miles de participantes compitiendo en otros tantos miles de modalidades, cada una realizando una pequeña revolución que reconstruirá los cimientos de este mundo informatizado.</p>\n\n\n\n<p>Y cuando crees que, dentro de este gran caos, todo está más o menos asentado, de repente aparecen los chinos con unos modelos de código abierto que rivalizan y hasta superan a los preestablecidos gigantes norteamericanos en pruebas de rendimiento y razonamiento.</p>\n\n\n\n<p>¿Es que esto no va a tener fin?</p>\n\n\n\n<p><a href=\"https://zaragoza.wordcamp.org/2025/comprar-entradas/\" target=\"_blank\" rel=\"noreferrer noopener\">Comprar entradas</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">El evento que nos traerá la paz</h2>\n\n\n\n<p>Pues es más que evidente que no, pero no te vuelvas loco, porque para eso está la gente de la <strong>WordCamp Zaragoza 2025</strong> que <strong>los días 14 y 15 de febrero</strong>, <strong>en ETOPIA</strong>, compartirán sus conocimientos con nosotros sobre tan amplia e interesante materia.</p>\n\n\n\n<p>Va a ser una auténtica locura pero, voy a serte sincero, si hay alguien en este mundo capaz de realizar semejante tarea, ese es un maño.</p>\n\n\n\n<p>¡Porque los maños están hechos de una pasta especial!</p>\n\n\n\n<p>Y, además, lo harán con un cariño entrañable porque, como ya he dicho al principio, la fecha que han ido a escoger para su evento tiene un algo mágico que te remueve el corazoncito.</p>\n\n\n\n<p>Así que ya lo sabes, no debes faltar a la WordCamp Zaragoza 2025, el <strong>14 y 15 de febrero</strong>, <strong>en ETOPIA</strong>.</p>\n\n\n\n<p>Y ahora es cuando llega el momento de que mi mente divague y se pierda en sus propios recovecos y…</p>\n\n\n\n<p>Estoy convencido de que, si José Zorrilla hubiera nacido en los años 90 y hubiera escrito su obra «<em>Don Juan Tenorio</em>», ambientándola en Zaragoza en lugar de en Sevilla, uno de sus más conocidos versos sonaría algo parecido a esto: </p>\n\n\n\n<pre class=\"wp-block-verse\">¿No es cierto, Zaragoza mía,<br>que en este apartado evento<br>más tenue sopla el viento<br>y se hablará de IA?</pre>\n\n\n\n<p><a href=\"https://zaragoza.wordcamp.org/2025/comprar-entradas/\" target=\"_blank\" rel=\"noreferrer noopener\">Comprar entradas</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">¿Qué nos vamos a encontrar?</h2>\n\n\n\n<p>En fin, tonterías aparte, en esta WordCamp Zaragoza se tratará el tema de la <strong>inteligencia artificial y de cómo va a revolucionar y mejorar tu forma de trabajar con WordPress</strong>: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>El día <strong>14 de febrero</strong> lo dedicarán al <strong>WordPress Day</strong>, un evento gratuito en el que te enseñarán a <strong>crear una web con IA</strong> en modo copiloto y en el que también estará presente el <strong>Contributor Day</strong>.</li>\n\n\n\n<li>El día <strong>15 de febrero</strong> vendrá el plato fuerte del evento, con un programa de lo más completo en el que te enseñarán desde términos técnicos,<strong> generación de imágenes</strong> profesionales, <strong>impulso a las ventas</strong>, <strong>mejora del copywriting</strong>, <strong>escritura de código</strong>, etc…</li>\n</ul>\n\n\n\n<p><a href=\"https://zaragoza.wordcamp.org/2025/comprar-entradas/\" target=\"_blank\" rel=\"noreferrer noopener\">Comprar entradas</a></p>\n\n\n\n<p>Vamos&#8230; ¡Una pasada!</p>\n\n\n\n<p>En resumen, esta WordCamp te mostrará cómo, a través de la IA, las reglas del juego han cambiado y seguirán cambiando.</p>\n\n\n\n<p>¿De verdad te la vas a querer perder?</p>\n\n\n\n<p>Yo ya me he apuntado.</p>\n\n\n\n<p>Y, además, ahora estoy terminando de escribir unos cuantos versos románticos más.</p>\n\n\n\n<p><a href=\"https://zaragoza.wordcamp.org/2025/comprar-entradas/\" target=\"_blank\" rel=\"noreferrer noopener\">Comprar entradas</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://es.wordpress.org/2025/02/06/wordcamp-zaragoza-2025-el-dia-de-los-ianamorados/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"671413\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Meetup y WordCamp en España – Febrero 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://es.wordpress.org/2025/02/01/meetup-wordcamp-espana-febrero-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://es.wordpress.org/2025/02/01/meetup-wordcamp-espana-febrero-2025/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Feb 2025 11:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=671377\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:365:\"¡Llegó febrero! El mes donde las emociones están a flor de piel y donde nuestros corazones se aceleran&#8230; Sabes por qué, ¿verdad? Venga, dime por qué&#8230; &#8211; ¿Porque se celebra el Día Mundial del Ukelele? Mmmm&#8230; Podría ser (hazte mirar tu nivel de frikismo), pero no me refiero a eso. Piensa&#8230;, ¿qué evento importante tiene [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Cris Quintero\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9225:\"\n<p>¡Llegó febrero! El mes donde las emociones están a flor de piel y donde nuestros corazones se aceleran&#8230; Sabes por qué, ¿verdad? Venga, dime por qué&#8230;</p>\n\n\n\n<span id=\"more-671377\"></span>\n\n\n\n<p><em>&#8211; ¿Porque se celebra el Día Mundial del Ukelele? <br></em>Mmmm&#8230; Podría ser (hazte mirar tu nivel de frikismo), pero no me refiero a eso. Piensa&#8230;, ¿qué evento importante tiene lugar a mediados de mes?</p>\n\n\n\n<p><em>&#8211; ¡Es el día del cóctel Margarita!</em><br>Vale, ya has demostrado con creces que mereces un lugar destacado en el ranking de raritos de la comunidad WordPress. Pero tampoco (además, te pasaste de fecha, el día del Margarita es el 22).</p>\n\n\n\n<p>Aunque, en realidad, podrías tener razón, porque tanto lo primero como lo segundo hacen brotar las emociones y disparar el corazón (no sé si en el buen sentido o en el contrario).</p>\n\n\n\n<p>Pero yo me estoy refiriendo a esa fecha que no debes olvidar jamás, donde surge el amor en cada frase, lo ves todo de color rosa y te pasas el día con una sonrisa de oreja a oreja.</p>\n\n\n\n<p>¡Exacto! ¡La WordCamp Zaragoza! <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f64c-1f3fb.png\" alt=\"🙌🏻\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <br>Eventazo donde los haya, que este año se celebra el 14 y 15 de febrero y en el que te esperan con los brazos abiertos cual amor platónico corriendo por la playa en pleno verano.</p>\n\n\n\n<p>Y si no puedes asistir porque tienes algún otro plan (sinceramente, no sé qué plan puede haber mejor que este), siempre puedes acudir a alguna de las Meetup programadas para febrero, que son eventos más pequeños, pero también organizados con todo el amor del mundo para hacerte feliz:</p>\n\n\n\n<h2 class=\"wp-block-heading has-black-color has-text-color has-link-color wp-elements-65accf52e625b0a114630fa0da4b9a6d\" id=\"meetups_mesuales\">Meetup de febrero de 2025</h2>\n\n\n\n<figure class=\"wp-block-table\"><table><thead><tr><th><strong>Fecha / Hora</strong></th><th><strong>Ciudad</strong></th><th><strong>Título del evento</strong></th><th><strong>Ponente</strong></th></tr></thead><tbody><tr><td>03/02/2025<br>20:00 h</td><td>Online</td><td><a href=\"https://www.meetup.com/quedadas-wordpress-en-espanol/events/305795303/\" target=\"_blank\" rel=\"noreferrer noopener\">La señora de los plugins: la comunidad de WordPress</a></td><td>Paula Carmona</td></tr><tr><td>04/02/2025<br>18:30 h</td><td>Bilbao</td><td><a href=\"https://www.meetup.com/wordpress-bilbao/events/305396083\" target=\"_blank\" rel=\"noreferrer noopener\">¿Sin experiencia? Aprende a demostrar tu talento y conseguir trabajo</a></td><td>Iñaki Lázaro</td></tr><tr><td>04/02/2025<br>18:30 h</td><td>Terrassa</td><td><a href=\"https://www.meetup.com/terrassa-wordpress-meetup/events/304955148\" target=\"_blank\" rel=\"noreferrer noopener\">Piérdele el miedo al nuevo Editor del Sitio de WordPress</a></td><td>Celi Garoe</td></tr><tr><td>05/02/2025<br>18:00 h</td><td>Cartagena</td><td><a href=\"https://www.meetup.com/wordpress-cartagena/events/305474893\" target=\"_blank\" rel=\"noreferrer noopener\">Descubre la magia interior de CHATGPT</a></td><td>Sergio Candela</td></tr><tr><td>06/02/2025<br>17:00 h</td><td>Cuenca</td><td><a href=\"https://www.meetup.com/wordpress-castilla-la-mancha/events/305828261\" target=\"_blank\" rel=\"noreferrer noopener\">Aprende lo esencial para triunfar con WordPress</a></td><td>&#8211;</td></tr><tr><td>06/02/2025<br>18:00 h</td><td>Huelva</td><td><a href=\"https://www.meetup.com/huelva-wordpress-meetup/events/305567230\" target=\"_blank\" rel=\"noreferrer noopener\">Cómo tu web con WordPress ayuda a&nbsp;tu&nbsp;negocio (HWM #19)</a></td><td>Juan M. Alonso</td></tr><tr><td>06/02/2025<br>18:30 h</td><td>Valencia</td><td><a href=\"https://www.meetup.com/wordpress-valencia-meetup/events/304869054\" target=\"_blank\" rel=\"noreferrer noopener\">Ciberseguridad en WordPress: Riesgos y Protecciones</a></td><td>Sara Martínez</td></tr><tr><td>06/02/2025<br>19:00 h</td><td>Málaga</td><td><a href=\"https://www.meetup.com/wordpress-malaga/events/305843622\" target=\"_blank\" rel=\"noreferrer noopener\">Preguntas y respuestas sobre WordPress</a></td><td>&#8211;</td></tr><tr><td>07/02/2025<br>18:00 h</td><td>Cádiz</td><td><a href=\"https://www.meetup.com/cadiz-wordpress/events/305882614\" target=\"_blank\" rel=\"noreferrer noopener\">Tardeo con WordPress Cádiz</a></td><td>&#8211;</td></tr><tr><td>11/02/2025<br>19:00 h</td><td>Granada</td><td><a href=\"https://www.meetup.com/granada-wordpress-meetup/events/305877698\" target=\"_blank\" rel=\"noreferrer noopener\">Agile Testing, pero de verdad</a></td><td>Fran Guerrero</td></tr><tr><td>12/02/2025<br>19:30 h</td><td>Ourense</td><td><a href=\"https://www.meetup.com/wordpressourense/events/305922456\" target=\"_blank\" rel=\"noreferrer noopener\">Cómo emprender con una enfermedad crónica: 8 años emprendiendo con fibromialgia</a></td><td>Ángel Cabaleiro</td></tr><tr><td>14/02/2025<br>19:30 h</td><td>Santiago de Compostela</td><td><a href=\"https://www.meetup.com/es-ES/santiago-de-compostela-wordpress-meetup-group/events/305917529/\" target=\"_blank\" rel=\"noreferrer noopener\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1fa84.png\" alt=\"🪄\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> Te enseño a que tu marca arrase en Instagram sin invertir ni 1€ en publicidad</a></td><td>Kevin Nicastro</td></tr><tr><td>20/02/2025<br>18:30 h</td><td>Griñón</td><td><a href=\"https://www.meetup.com/wordpress-grinon/events/305791004\" target=\"_blank\" rel=\"noreferrer noopener\">Sube a tu E-Commerce más de 7.000 productos de manera eficiente</a></td><td>José Ángel Romero</td></tr><tr><td>20/02/2025<br>18:30 h</td><td>Mataró</td><td><a href=\"https://www.meetup.com/wordpress-mataro/events/305898506\" target=\"_blank\" rel=\"noreferrer noopener\">Què són els Custom Post Types i com fer-ne el primer</a></td><td>Amadeu Arderiu</td></tr><tr><td>21/02/2025<br>18:00 h</td><td>Barcelona</td><td><a href=\"https://www.meetup.com/wordpressbcn/events/305733185\" target=\"_blank\" rel=\"noreferrer noopener\">Un diseño de Elementor con (solo) bloques de WordPress, ¿será verdad?</a></td><td>Celi Garoe</td></tr><tr><td>21/02/2025<br>19:00 h</td><td>Igualada</td><td><a href=\"https://www.meetup.com/igualada-wordpress-meetup/events/305796759\" target=\"_blank\" rel=\"noreferrer noopener\">Crea una Landing Page Profesional en 30 Minutos</a></td><td>Dani Rodríguez</td></tr><tr><td>21/02/2025<br>19:30 h</td><td>Ferrol</td><td><a href=\"https://www.meetup.com/ferrolterrawordpress/events/305920811\" target=\"_blank\" rel=\"noreferrer noopener\">Productividad real, sin dramas</a></td><td>Marga Carballo</td></tr><tr><td>27/02/2025<br>18:30 h</td><td>Granollers</td><td><a href=\"https://www.meetup.com/wordpressgranollers/events/302266640\" target=\"_blank\" rel=\"noreferrer noopener\">Com funciona una IA per dins?</a></td><td>Amadeu Arderiu</td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading has-black-color has-text-color has-link-color wp-elements-8cb220809b8d58f8b2ebfeb0865dc23b\">WordCamp y Eventos de febrero de 2025</h2>\n\n\n\n<figure class=\"wp-block-table\"><table><thead><tr><th><strong>Fecha / Hora</strong></th><th><strong>Ciudad</strong></th><th><strong>Título del evento</strong></th></tr></thead><tbody><tr><td>14 y 15 de febrero de 2025<br>10:00 h</td><td>Zaragoza</td><td><a href=\"https://zaragoza.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp Zaragoza 2025</a></td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Meetup y WordCamp en otras fechas</h2>\n\n\n\n<p>¿Te pica la curiosidad de qué nos depara el futuro en lo que a eventos se refiere? ¿Quieres consultar algún evento pasado? </p>\n\n\n\n<p>Haz clic en el botonaco de aquí abajo y aparecerás como por arte de magia en una página donde encontrarás todas las Meetup, WordCamp y Eventos bien ordenaditos por meses:</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size is-style-fill has-eb-garamond-font-family\" style=\"font-size:24px\"><a class=\"wp-block-button__link has-white-color has-text-color has-background has-link-color wp-element-button\" href=\"https://es.wordpress.org/2024/09/10/meetups-y-wordcamps/\" style=\"border-radius:10px;background-color:#0073aa\">Ver todas las Meetup y WordCamp Programadas</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" style=\"margin-top:var(--wp--preset--spacing--40)\" />\n\n\n\n<p class=\"has-text-align-center\">Te animamos a que acudas a todos los eventos que puedas.<br><em>Porque la vida es más diver si se comparte.</em></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--30)\" />\n\n\n\n<p><em>* Este post se publica a principios de mes. Si das una ponencia que se haya anunciado más tarde y que no está en el listado, o ves que se me ha escapado incluir algún evento, deja un comentario aquí abajo y lo añado antes de que te des cuenta.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://es.wordpress.org/2025/02/01/meetup-wordcamp-espana-febrero-2025/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"671377\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n		\n		\n					\n		\n		\n		\n				\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"10 ejemplos de blogs de éxito para inspirarte\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://es.wordpress.org/2025/01/24/blogs-ejemplos/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://es.wordpress.org/2025/01/24/blogs-ejemplos/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jan 2025 15:18:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=662025\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:343:\"Si necesitas inspiración para crear tu propio blog, te mostraré varios ejemplos de blogs que destacan por su diseño, contenido y estrategias. Desde blogs de viajes hasta tecnología, vamos a ver qué han hecho bien para atraer a miles de lectores, qué tienen en común y qué lecciones puedes aplicar en tu propio proyecto. Tener [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Ana Patricia G. C.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:21469:\"\n<p>Si necesitas inspiración para crear tu propio blog, te mostraré varios <strong>ejemplos de blogs que destacan por su diseño, contenido y estrategias</strong>. Desde blogs de viajes hasta tecnología, vamos a ver qué han hecho bien para atraer a miles de lectores, qué tienen en común y qué lecciones puedes aplicar en tu propio proyecto.</p>\n\n\n\n<p>Tener un blog puede ser una de las mejores formas de compartir tus ideas, conectar con otras personas y, por qué no, incluso ganarte la vida. Si buscas un poquito de motivación, sigue leyendo.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Ejemplos de blogs que triunfan</h2>\n\n\n\n<p>Si quieres crear tu propio blog, no hay mejor forma de aprender que observando a quienes ya tienen éxito. Bueno, quizás sería mejor decir que ¡lo están petando!</p>\n\n\n\n<p>Hay muchísimos otros, pero estos blogs españoles han logrado destacar en sus respectivos sectores y son un claro ejemplo de que, con buen contenido y estrategia, se puede <strong>alcanzar una audiencia fiel y masiva</strong>.</p>\n\n\n\n<p>Estos <strong>10 ejemplos de blogs</strong> que han logrado destacarse por su diseño, contenido, tráfico orgánico o por estar a la vanguardia de las últimas novedades en su nicho.</p>\n\n\n\n<h3 class=\"wp-block-heading\">1 &#8211; Ejemplo de blog de tecnología</h3>\n\n\n\n<p>Un espacio dedicado a lo último en gadgets, software y novedades del mundo tecnológico. Este blog destaca por su <strong>diseño limpio y funcional</strong>, con una estructura que facilita la navegación entre sus numerosas categorías.</p>\n\n\n\n<p>Han sabido construir una comunidad enorme gracias a su <strong>contenido útil y actualizado</strong>, cubriendo desde lanzamientos hasta análisis de productos y noticias del sector.</p>\n\n\n\n<p>La <strong>especialización y enfoque en contenido de calidad</strong> atraen a una audiencia fiel, especialmente en nichos tan competidos. Si lo tuyo es la tecnología, este blog es tu modelo a seguir.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/blog-tecnologia.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"891\" height=\"517\" src=\"https://es.wordpress.org/files/2025/01/blog-tecnologia.png\" alt=\"Un blog de tecnología con mucho éxito.\" class=\"wp-image-670861\" srcset=\"https://es.wordpress.org/files/2025/01/blog-tecnologia.png 891w, https://es.wordpress.org/files/2025/01/blog-tecnologia-300x174.png 300w, https://es.wordpress.org/files/2025/01/blog-tecnologia-768x446.png 768w\" sizes=\"(max-width: 891px) 100vw, 891px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">2 &#8211; Blog de viajes</h3>\n\n\n\n<p>El sueño de muchos: viajar por el mundo y contarlo en un blog. Y este lo ha conseguido con éxito, compartiendo sus experiencias y consejos de viaje de una forma cercana y visualmente atractiva.</p>\n\n\n\n<p>Este blog no solo ofrece recomendaciones de rutas y destinos, sino que también ha sabido <strong>monetizar el contenido con guías de viaje, afiliación y colaboraciones con marcas</strong> turísticas.</p>\n\n\n\n<p>Si te apasiona el mundo de los viajes, este es el blog que te demostrará que se puede vivir de ello. La especialización en un nicho concreto puede ser una gran ventaja para atraer a una audiencia específica que busca información relevante.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2024/10/ejemplo-blog-viajes-1.jpg\"><img decoding=\"async\" width=\"680\" height=\"401\" src=\"https://es.wordpress.org/files/2024/10/ejemplo-blog-viajes-1.jpg\" alt=\"Blog de viajes\" class=\"wp-image-662495\" srcset=\"https://es.wordpress.org/files/2024/10/ejemplo-blog-viajes-1.jpg 680w, https://es.wordpress.org/files/2024/10/ejemplo-blog-viajes-1-300x177.jpg 300w\" sizes=\"(max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">3 &#8211; Blog de marketing digital</h3>\n\n\n\n<p>En el mundo del marketing digital, este blog es un referente para quienes buscan estar al día en estrategias de SEO, publicidad online y gestión de redes sociales.</p>\n\n\n\n<p>Su contenido está siempre actualizado y estructurado de manera que tanto principiantes como expertos puedan aprovecharlo. Utiliza muchos estudios de caso y guías prácticas que aportan valor a los lectores, ayudando a entender conceptos complejos de manera sencilla.</p>\n\n\n\n<p>Su alto tráfico orgánico demuestra que un <strong>enfoque de calidad y regularidad</strong> puede generar grandes resultados en el ámbito del marketing.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" width=\"680\" height=\"394\" src=\"https://es.wordpress.org/files/2024/10/ejemplo-blog-marketing.jpg\" alt=\"Blog de marketing digital\" class=\"wp-image-662496\" srcset=\"https://es.wordpress.org/files/2024/10/ejemplo-blog-marketing.jpg 680w, https://es.wordpress.org/files/2024/10/ejemplo-blog-marketing-300x174.jpg 300w\" sizes=\"(max-width: 680px) 100vw, 680px\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3 class=\"wp-block-heading\">4 &#8211; Blog de videojuegos</h3>\n\n\n\n<p>Este es uno de esos blogs interesantes que ha captado la atención de miles de gamers gracias a sus análisis de juegos, noticias y recomendaciones sobre lo último en consolas y títulos.</p>\n\n\n\n<p><strong>Su tono cercano y su habilidad para conectar con la comunidad</strong> gaming les ha permitido crecer de forma constante, convirtiéndose en una referencia en el sector de los videojuegos.</p>\n\n\n\n<p>Desde los títulos más populares hasta joyas independientes, este blog ofrece una visión completa del universo gamer, haciendo que su contenido sea imprescindible para cualquier aficionado.</p>\n\n\n\n<p>Este es uno de esos ejemplos de blogs que demuestra que, ofrecer contenido especializado y auténtico, además de construir una comunidad alrededor de una pasión compartida, puede llevar a un crecimiento continuo y a convertirse en una referencia.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"450\" src=\"https://es.wordpress.org/files/2024/11/ejemplo-blog-gaming.jpg\" alt=\"Ejemplo de blog de gamers\" class=\"wp-image-667044\" srcset=\"https://es.wordpress.org/files/2024/11/ejemplo-blog-gaming.jpg 680w, https://es.wordpress.org/files/2024/11/ejemplo-blog-gaming-300x199.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3 class=\"wp-block-heading\">5 &#8211; Ejemplo de blog de estilo de vida</h3>\n\n\n\n<p>El autor de este ejemplo de blog personal comparte su experiencia de haber dejado un trabajo convencional para construir un estilo de vida más libre y satisfactorio.</p>\n\n\n\n<p>A través de artículos inspiradores, ofrece <strong>consejos sobre emprendimiento, productividad y cómo convertir tus pasiones en una fuente de ingresos</strong>.</p>\n\n\n\n<p>Sus contenidos incluyen desde guías para crear negocios online, hasta reflexiones profundas sobre la vida y el éxito, lo que se ha convertido en una fuente de motivación para quienes buscan cambiar su estilo de vida.</p>\n\n\n\n<p><strong>Inspirar a través de la experiencia personal y compartir aprendizajes</strong> es una manera poderosa de conectar con los lectores.</p>\n\n\n\n<p>Este es un buen ejemplo de blog WordPress que demuestra que un enfoque auténtico, puede atraer a una audiencia comprometida.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"892\" height=\"545\" src=\"https://es.wordpress.org/files/2025/01/Blog-viajes.png\" alt=\"Ejemplo de blog de estilo de vida\" class=\"wp-image-670862\" srcset=\"https://es.wordpress.org/files/2025/01/Blog-viajes.png 892w, https://es.wordpress.org/files/2025/01/Blog-viajes-300x183.png 300w, https://es.wordpress.org/files/2025/01/Blog-viajes-768x469.png 768w\" sizes=\"auto, (max-width: 892px) 100vw, 892px\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3 class=\"wp-block-heading\">6 &#8211; Blog de fitness y salud</h3>\n\n\n\n<p>A través de un enfoque basado en la ciencia, su autor ofrece desde rutinas de ejercicios funcionales hasta consejos sobre nutrición, todo orientado a mejorar la salud de manera eficiente y natural.</p>\n\n\n\n<p>Lo que distingue a este blog es su capacidad para <strong>cuestionar los métodos convencionales y ofrecer alternativas innovadoras y bien documentadas</strong>, lo que ha creado una comunidad fiel y en constante crecimiento.</p>\n\n\n\n<p>Este blog no solo inspira a aquellos que buscan un cambio en su estilo de vida, sino que lo hace desde un rigor científico que le otorga credibilidad y confianza.</p>\n\n\n\n<p>En un nicho tan competitivo como el fitness, desafiar lo establecido y ofrecer contenido basado en la ciencia es una estrategia ganadora.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"1196\" height=\"661\" src=\"https://es.wordpress.org/files/2025/01/blog-alimentacion.png\" alt=\"Ejemplo de blog sobre fitness y salud\" class=\"wp-image-670863\" srcset=\"https://es.wordpress.org/files/2025/01/blog-alimentacion.png 1196w, https://es.wordpress.org/files/2025/01/blog-alimentacion-300x166.png 300w, https://es.wordpress.org/files/2025/01/blog-alimentacion-1024x566.png 1024w, https://es.wordpress.org/files/2025/01/blog-alimentacion-768x424.png 768w\" sizes=\"auto, (max-width: 1196px) 100vw, 1196px\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3 class=\"wp-block-heading\">7 &#8211; Blog de cocina</h3>\n\n\n\n<p>La autora de este blog ofrece recetas sencillas, bien explicadas y, sobre todo, deliciosas, que permiten a cualquier persona, independientemente de su habilidad culinaria, disfrutar de la cocina casera.</p>\n\n\n\n<p>Lo que hace que destaque este blog que he traído como ejemplo es <strong>la cercanía con sus lectores</strong>, ya que comparte recetas tradicionales <strong>con su toque personal</strong>, lo que ha cautivado a una audiencia fiel.</p>\n\n\n\n<p>Además de las recetas, monetiza su blog a través de colaboraciones y menciones de productos, demostrando que el mundo culinario también puede ser una vía para emprender y generar ingresos.</p>\n\n\n\n<p>Al conectar con la audiencia y ofrecer contenido práctico y accesible, es posible <strong>construir una marca personal</strong> en un nicho tan competitivo como la cocina y monetizarlo de manera efectiva.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"952\" height=\"550\" src=\"https://es.wordpress.org/files/2025/01/blog-cocina.png\" alt=\"Ejemplo de un blog de cocina con éxito.\" class=\"wp-image-670864\" srcset=\"https://es.wordpress.org/files/2025/01/blog-cocina.png 952w, https://es.wordpress.org/files/2025/01/blog-cocina-300x173.png 300w, https://es.wordpress.org/files/2025/01/blog-cocina-768x444.png 768w\" sizes=\"auto, (max-width: 952px) 100vw, 952px\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3 class=\"wp-block-heading\">8 &#8211; Blog de tutoriales </h3>\n\n\n\n<p>Este es un ejemplo de blog WordPress polifacético que abarca una gran variedad de temas.</p>\n\n\n\n<p>Con varios años de trayectoria, se ha consolidado como un referente en el sector de los blogs de tutoriales en España.</p>\n\n\n\n<p>Lo que hace que este blog sea tan apreciado es su capacidad para <strong>ofrecer soluciones útiles y prácticas a problemas cotidianos</strong> relacionados con las manualidades DIY, llegando a ser un recurso valorado tanto por expertos como por usuarios novatos.</p>\n\n\n\n<p>Su contenido, siempre accesible y directo, ha logrado construir una base de lectores fieles que confían en el blog como fuente de información y aprendizaje continuo.</p>\n\n\n\n<p>En este ejemplo de blogging, la <strong>variedad temática, combinada con la capacidad de resolver problemas</strong> de forma efectiva, es una fórmula ganadora para mantener la relevancia en un sector tan competido.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"450\" src=\"https://es.wordpress.org/files/2024/11/blog-ejemplo-tutoriales.jpg\" alt=\"Ejemplo de blog de tutoriales\" class=\"wp-image-667045\" srcset=\"https://es.wordpress.org/files/2024/11/blog-ejemplo-tutoriales.jpg 680w, https://es.wordpress.org/files/2024/11/blog-ejemplo-tutoriales-300x199.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3 class=\"wp-block-heading\">9 &#8211; Blog de diseño, arte y cultura</h3>\n\n\n\n<p>Con un enfoque creativo y poco convencional, el contenido de este ejemplo de blog temático abarca desde diseño y arte hasta innovación, cultura y tecnología, siempre con una perspectiva fresca y original.</p>\n\n\n\n<p>A lo largo de los años ha conseguido captar la atención de una comunidad comprometida gracias a su <strong>estilo único y visualmente atractivo</strong>.</p>\n\n\n\n<p>Los artículos que publica son una mezcla de inspiración, crítica y análisis, siempre con una apuesta por <strong>la calidad y la creatividad</strong>.</p>\n\n\n\n<p>Su diseño limpio y atractivo también juega un papel importante en su éxito, convirtiéndolo en <strong>un lugar donde los lectores buscan tanto información como inspiración</strong>.</p>\n\n\n\n<p>La originalidad y el enfoque visual son potentes herramientas para diferenciarse en un mercado saturado, incluso cuando los temas que cubre son tan diversos como el diseño, la cultura y la innovación.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"450\" src=\"https://es.wordpress.org/files/2024/10/blog-cultura.jpg\" alt=\"Blog de cultura y arte\" class=\"wp-image-662502\" srcset=\"https://es.wordpress.org/files/2024/10/blog-cultura.jpg 680w, https://es.wordpress.org/files/2024/10/blog-cultura-300x199.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3 class=\"wp-block-heading\">10 &#8211; Blog de ciclismo y aventura</h3>\n\n\n\n<p>Este es un blog único donde su creador combina dos de sus grandes pasiones: el ciclismo y los viajes con su perro.</p>\n\n\n\n<p>A lo largo de sus aventuras por el mundo, ha sabido <strong>construir una comunidad de seguidores que comparten su amor por un tema específico</strong>, en este caso los animales, la naturaleza y el estilo de vida nómada.</p>\n\n\n\n<p>Otro ejemplo de blog en WordPress en el que el autor no solo relata sus experiencias en la carretera, sino que también inspira a otros a lanzarse a la aventura sobre dos ruedas, con la compañía fiel de sus mascotas.</p>\n\n\n\n<p>Con un enfoque personal y cercano, narra sus vivencias de una forma auténtica, lo que ha permitido que el blog se convierta en un referente, <strong>creando una comunidad de fans, motivando a otros a seguir caminos poco convencionales y disfrutar de sus aventuras</strong>.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"882\" height=\"516\" src=\"https://es.wordpress.org/files/2025/01/blog-aventuras.png\" alt=\"Blog de aventuras\" class=\"wp-image-670865\" srcset=\"https://es.wordpress.org/files/2025/01/blog-aventuras.png 882w, https://es.wordpress.org/files/2025/01/blog-aventuras-300x176.png 300w, https://es.wordpress.org/files/2025/01/blog-aventuras-768x449.png 768w\" sizes=\"auto, (max-width: 882px) 100vw, 882px\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Qué tienen en común estos ejemplos de blogs</h2>\n\n\n\n<p>Si echamos un vistazo a todos estos blogs personales y de nicho, puede parecer que no tienen mucho en común a simple vista. Después de todo, ¿qué podrían compartir un blog de viajes en bici con uno de tecnología o recetas?</p>\n\n\n\n<p>¡Pues más de lo que crees!</p>\n\n\n\n<p>Todos estos blogs tienen ciertos factores que los han llevado al éxito, independientemente del tema que traten.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Autenticidad</h3>\n\n\n\n<p>Los creadores de estos blogs no sólo escriben sobre sus temas; lo viven.</p>\n\n\n\n<p class=\"has-charcoal-0-color has-text-color has-link-color wp-elements-fc05007e8610b70335341a450a510245\">Ángel nos cuenta cómo dejar el trabajo que odias para vivir de lo que te apasiona. Pablo comparte sus aventuras con su perro. Rebeca comparte sus dotes culinarias.</p>\n\n\n\n<p><strong>Cada blog muestra la verdadera pasión de su creador</strong>. Esa autenticidad se nota y los lectores la valoran.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Conexión con la audiencia</h3>\n\n\n\n<p>Todos estos blogs tienen un punto en común: conectan con su audiencia.</p>\n\n\n\n<p>Saben <strong>quiénes son sus lectores, qué les interesa</strong> y les ofrecen exactamente lo que buscan.</p>\n\n\n\n<p>Tanto si es un análisis técnico, una receta casera o consejos sobre fitness, <strong>logran que sus lectores se sientan identificados</strong> y parte de una comunidad.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Contenido de calidad</h3>\n\n\n\n<p>Y es que no se trata solo de publicar por publicar; estos blogs dedican tiempo a <strong>investigar, redactar y presentar información de valor</strong>.</p>\n\n\n\n<p>Guías completas, consejos útiles o análisis detallados, el contenido está bien trabajado y pensado para resolver las dudas y necesidades de sus lectores.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Consistencia</h3>\n\n\n\n<p>El éxito no llega de la noche a la mañana. Estos blogs han sabido <strong>mantenerse en el tiempo, publicando de manera constante, sin perder la calidad</strong>.</p>\n\n\n\n<p>Esa consistencia les ha permitido crear una audiencia fiel, que vuelve una y otra vez porque sabe que encontrará contenido nuevo y relevante.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Adaptación y evolución</h3>\n\n\n\n<p>Estos blogueros han sabido <strong>adaptarse a los cambios del mercado y de las necesidades de su audiencia</strong>.</p>\n\n\n\n<p>Ajustando el formato de sus publicaciones, explorando nuevos temas o aprovechando nuevas plataformas (¡hola, podcasts y redes sociales!), han evolucionado para seguir siendo relevantes en sus respectivos nichos.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Monetización inteligente</h3>\n\n\n\n<p>Aunque su contenido es lo más importante, todos estos ejemplos de blogs también han encontrado maneras de <strong>monetizar de forma natural</strong>.</p>\n\n\n\n<p>A través de colaboraciones con marcas, productos propios o programas de afiliados, lo hacen sin sacrificar la calidad ni la confianza que han construido con su audiencia.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Tu blog también puede ser un ejemplo</h2>\n\n\n\n<p>Es momento de recordarte que tu blog también puede ser parte de esta lista de blogs exitosos. Con dedicación y pasión, tu blog puede resonar entre tus lectores.</p>\n\n\n\n<p>Aquí te dejo algunas ideas para tener en cuenta al <strong>crear un blog que destaque</strong>:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Encuentra tu voz: <strong>La autenticidad es clave</strong> en el mundo del blogging. Comparte tus experiencias, opiniones y conocimientos de manera genuina. Esto te ayudará a conectar con tu audiencia y a convertir tu blog en un ejemplo a seguir.</li>\n\n\n\n<li>Ofrece valor: Pregúntate qué necesitas transmitir. Asegúrate de que cada publicación <strong>aporte algo útil o inspirador</strong> para tus lectores, convirtiendo tu contenido en una referencia dentro de tu sector.</li>\n\n\n\n<li>Construye una comunidad: <strong>Fomenta la interacción</strong> en tu blog y en tus redes sociales. Responde a comentarios, crea encuestas y anímalos a compartir sus experiencias. Una comunidad activa puede ser la clave para el éxito de tu blog personal.</li>\n\n\n\n<li>Sé constante: <strong>Publicar regularmente</strong> mantendrá a tus lectores interesados y volver a por más. La consistencia construye confianza y es fundamental para que tu blog sea considerado un ejemplo de éxito.</li>\n\n\n\n<li>Aprende y adapta: El mundo digital cambia rápidamente. Mantente actualizado con las tendencias de tu nicho y <strong>ajusta tu contenido para mantener su relevancia</strong>. La adaptación es esencial para el crecimiento de cualquier blog.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Conclusión sobre los ejemplos de blogging</h2>\n\n\n\n<p>Ahora me dirás: claro, pero no todos esos blogs de los ejemplos están hechos con WordPress. Cierto, alguno tiene otro CMS, aunque la mayoría de los mencionados sí llevan WordPress.</p>\n\n\n\n<p>Con WordPress tenemos la gran ventaja de que <strong>podemos hacer prácticamente cualquier diseño y adaptarlo a nuestras necesidades</strong>. Disponemos de <a href=\"https://es.wordpress.org/themes/\" target=\"_blank\" rel=\"noreferrer noopener\">temas</a> y un repositorio de todos los <a href=\"https://es.wordpress.org/plugins/\" target=\"_blank\" rel=\"noreferrer noopener\">plugins WordPress</a> que puedas necesitar, que se actualizan a menudo para hacer nuestra web completamente personalizada.</p>\n\n\n\n<p>No olvides que cada gran proyecto empezó con un primer paso. <a href=\"https://es.wordpress.org/download/\" target=\"_blank\" rel=\"noreferrer noopener\">Descarga la última versión de WordPress</a> en tu blog y ponte manos a la obra.</p>\n\n\n\n<p>¡Tu blog puede ser el siguiente gran ejemplo que inspire a otros a crear su propio espacio en el universo del blogging!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://es.wordpress.org/2025/01/24/blogs-ejemplos/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"662025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Qué es un portafolio y cómo hacer que te convierta en una autoridad en tu sector\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://es.wordpress.org/2025/01/17/que-es-un-portafolio-como-hacer-uno-para-ganar-autoridad/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://es.wordpress.org/2025/01/17/que-es-un-portafolio-como-hacer-uno-para-ganar-autoridad/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jan 2025 09:13:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Marketing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=667295\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:330:\"Quieres saber qué es un portafolio porque, probablemente te han pedido hacer uno. O puede que hayas visto escrita la palabra en algún lado y no sepas qué significa. Pues ya puedes relajarte, porque estás en el lugar adecuado, a solo unos minutos de convertirte en una eminencia en portafolios. Es normal que no sepas [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"John Mejías\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:67730:\"\n<p><em>Quieres saber qué es un portafolio porque, probablemente te han pedido hacer uno. O puede que hayas visto escrita la palabra en algún lado y no sepas qué significa. Pues ya puedes relajarte, porque estás en el lugar adecuado, a solo unos minutos de convertirte en una eminencia en portafolios.</em></p>\n\n\n\n<p>Es normal que no sepas qué es un portafolio. Y es que un portafolio puede ser muchas cosas según el contexto en el que te encuentres. Pero todas tienen un hilo conductor y todas hacen referencia a lo mismo: a una agrupación de información con fines específicos.</p>\n\n\n\n<p>Aquí no solo te explicaremos el significado de portfolio y te mostraremos con ejemplos los tipos de portafolios más populares que existen, sino que te enseñaremos a crear el portafolio definitivo. Uno con el que podrás conseguir cualquier cosa que te propongas. Pero para eso hay que ponerse en marcha y sudar la camiseta, así que toma papel y lápiz que empezamos (¿quién demonios sigue escribiendo a lápiz?).</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://es.wordpress.org/files/2025/01/Que-es-un-portafolio.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://es.wordpress.org/files/2025/01/Que-es-un-portafolio-1024x576.jpg\" alt=\"\" class=\"wp-image-670242\" srcset=\"https://es.wordpress.org/files/2025/01/Que-es-un-portafolio-1024x576.jpg 1024w, https://es.wordpress.org/files/2025/01/Que-es-un-portafolio-300x169.jpg 300w, https://es.wordpress.org/files/2025/01/Que-es-un-portafolio-768x432.jpg 768w, https://es.wordpress.org/files/2025/01/Que-es-un-portafolio-1536x864.jpg 1536w, https://es.wordpress.org/files/2025/01/Que-es-un-portafolio.jpg 1920w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\">1. Qué es un portafolio: significado</h2>\n\n\n\n<p>Un portafolio es, en definitiva, una carpeta diseñada para portar hojas. Este es el significado más literal, ya que el término viene de la palabra francesa <em>portefeuille</em>, que significa justo eso: porta hojas.</p>\n\n\n\n<p>Pero, a pesar de que seguimos usando el vocablo para describir al objeto en el que transportamos los folios, hoy lo usamos principalmente para referirnos a un catálogo de trabajos profesionales, a un escaparate de nuestro buen hacer como profesional o como académico, a un showcase.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Así pues, en la mayoría de los casos y siempre que no estemos hablando con el dependiente de una papelería, un portafolio es un dossier con una colección de trabajos realizados con anterioridad que compartimos como prueba de nuestro desempeño y profesionalidad.</p>\n</blockquote>\n\n\n\n<p>Se trata de una herramienta indispensable para vender tus servicios si eres freelance, para conseguir empleos de alto valor si estás buscando un cambio laboral y para acceder a los organismos e instituciones más selectivas.</p>\n\n\n\n<p>Y por eso estás aquí. Porque, además de querer entender qué es un portafolio, quieres saber cómo puedes hacer uno para convencer a tus primeros clientes, para lograr el trabajo de tus sueños o para que te acepten en esa escuela tan prestigiosa y tan solicitada.</p>\n\n\n\n<p>Pero antes hablemos de qué otros tipos de portafolios existen. Porque el término <em>portafolio</em> siempre simboliza un conjunto de documentos, pero lo cierto es que no siempre se refiere a trabajos realizados. Según el contexto en el que se englobe, ese conjunto de documentos puede ser un catálogo de trabajos u otra cosa completamente diferente.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>La palabra <em>portafolio</em> puedes verla escrita de muchas maneras, algunas correctas y otras incorrectas, pero todas sinónimos y formas de decir lo mismo. Porta folio, porfolio, portfolio, port-folio, port folio, portafoli, portfoli, porfoli, portfolo, porflio, portoflio, portfilio, pofolio…</p>\n</blockquote>\n\n\n\n<p>Si quieres nombrar o escribir el término sin miedo a cometer errores ortográficos ni gramaticales, quédate con porfolio.</p>\n\n\n\n<h2 class=\"wp-block-heading\">2. Tipos de portafolios y ejemplos</h2>\n\n\n\n<p>Cuando alguien te diga que revises el portafolio de alguien, te pida tu portafolio o te sugiera que te hagas un portafolio, en la mayoría de los casos se referirá a un dossier que recopile tus mejores trabajos o los de una persona o empresa concretas. Incluso cuando leas la palabra en algún texto, este se referirá casi seguro a dicho dossier.</p>\n\n\n\n<p>Pero, en algunas ocasiones especiales, sobre todo si el término va acompañado de ciertos adjetivos, podemos estar hablando de cosas distintas, de diferentes tipos de portafolio, ejemplo de lo cual se aprecia en el sector médico, donde la palabra también se usa para referirse al historial de un paciente, o en el educativo, para referirse al historial de logros de los alumnos durante su aprendizaje.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Conocer los tipos de portafolios, para qué sirve cada uno y algunos ejemplos estratégicos te ayudará a entender el significado de portfolio en todas sus variantes y con todos sus matices.</p>\n</blockquote>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.1-Portafolio-profesional.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"417\" src=\"https://es.wordpress.org/files/2025/01/2.1-Portafolio-profesional.jpg\" alt=\"\" class=\"wp-image-670226\" srcset=\"https://es.wordpress.org/files/2025/01/2.1-Portafolio-profesional.jpg 680w, https://es.wordpress.org/files/2025/01/2.1-Portafolio-profesional-300x184.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.1. Portafolio profesional</h3>\n\n\n\n<p>Un portafolio profesional es aquel que recoge un conjunto de trabajos profesionales, realizados por un trabajador, por un profesional independiente o por una empresa durante el desempeño de su actividad laboral.</p>\n\n\n\n<p>La inmensa mayoría de portafolios que existen son portafolios profesionales, creados por personas o empresas para presentar a clientes potenciales o a reclutadores de recursos humanos productos o servicios destacados realizados con anterioridad, con el fin de cerrar una venta o de conseguir un empleo.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.2-Portafolio-academico.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"546\" src=\"https://es.wordpress.org/files/2025/01/2.2-Portafolio-academico.jpg\" alt=\"\" class=\"wp-image-670227\" srcset=\"https://es.wordpress.org/files/2025/01/2.2-Portafolio-academico.jpg 680w, https://es.wordpress.org/files/2025/01/2.2-Portafolio-academico-300x241.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.2. Portafolio académico</h3>\n\n\n\n<p>El portafolio académico incluye información sobre la evolución y los logros académicos de estudiantes, investigadores y profesionales titulados.</p>\n\n\n\n<p>En esta ocasión no se recoge información sobre trabajos hechos, sino sobre formaciones cursadas, sobre las habilidades aprendidas en ellas, sobre la evaluación obtenida, sobre las certificaciones logradas y sobre las investigaciones o ensayos llevados a cabo.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.3-Portafolio-personal.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"543\" src=\"https://es.wordpress.org/files/2025/01/2.3-Portafolio-personal.jpg\" alt=\"\" class=\"wp-image-670228\" srcset=\"https://es.wordpress.org/files/2025/01/2.3-Portafolio-personal.jpg 680w, https://es.wordpress.org/files/2025/01/2.3-Portafolio-personal-300x240.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.3. Portafolio personal</h3>\n\n\n\n<p>Intuyo que no es necesario que explique qué es un portfolio personal, pero lo haré de todas formas.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Se trata de portafolios profesionales y académicos que agrupan los trabajos y logros académicos de una persona en particular.</p>\n</blockquote>\n\n\n\n<p>Todos deberíamos tener un portafolio personal con nuestros mejores trabajos y con los hitos conseguidos en nuestra experiencia educativa y laboral. En muchas disciplinas, el portfolio es el primer filtro de selección de personal y el único capaz de convencer a un cliente de que eres su mejor opción.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.4-Portafolio-de-empresa.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"339\" src=\"https://es.wordpress.org/files/2025/01/2.4-Portafolio-de-empresa.jpg\" alt=\"\" class=\"wp-image-670229\" srcset=\"https://es.wordpress.org/files/2025/01/2.4-Portafolio-de-empresa.jpg 680w, https://es.wordpress.org/files/2025/01/2.4-Portafolio-de-empresa-300x150.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.4. Portafolio de empresa</h3>\n\n\n\n<p>Es exactamente igual que un portafolio personal, pero este recoge el dossier de empresa, es decir, los trabajos e hitos destacables de una corporación, y no de un individuo en particular.</p>\n\n\n\n<p>Los portafolios de empresa suelen incluir también una descripción de la entidad, de su actividad, de los sectores en los que esté presente, de los objetivos que persigue, de sus valores y de las diferencias que la distinguen de la competencia.</p>\n\n\n\n<h3 class=\"wp-block-heading\">2.5. Portafolio CV (Curriculum Vitae)</h3>\n\n\n\n<p>El portafolio CV es prácticamente un curriculum vitae al uso, pero vitaminado con muestras de los trabajos realizados mientras cursamos nuestros estudios y durante nuestro periplo laboral en otras empresas.&nbsp;</p>\n\n\n\n<p>Un currículum estándar solo contiene un listado con los estudios cursados y los centros donde los hemos cursado, y otro con las empresas en las que hemos trabajado y la actividad que hemos desempeñado en ellas. Pero los <em>head hunters</em> de empresas de RR. HH. necesitarán ver tus trabajos más destacados para comprender si eres la opción que están buscando, sobre todo cuando quieren cubrir puestos creativos (diseñadores, escritores, fotógrafos, pintores…).</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.6-Portafolio-educativo.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"444\" src=\"https://es.wordpress.org/files/2025/01/2.6-Portafolio-educativo.jpg\" alt=\"\" class=\"wp-image-670230\" srcset=\"https://es.wordpress.org/files/2025/01/2.6-Portafolio-educativo.jpg 680w, https://es.wordpress.org/files/2025/01/2.6-Portafolio-educativo-300x196.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.6. Portafolio educativo</h3>\n\n\n\n<p>También conocido como portafolio escolar, portafolio de estudiante o portfolio de alumno. Se trata de una herramienta de síntesis y análisis que ayuda a los alumnos y a los docentes en sus labores formativas.</p>\n\n\n\n<p>Existen diferentes tipos de portafolios escolares con estructuras y objetivos variados según sea el caso. Estos son los ejemplos de portfolio en educación más habituales:&nbsp;&nbsp;</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.6.1-Portafolio-de-aprendizaje.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"680\" src=\"https://es.wordpress.org/files/2025/01/2.6.1-Portafolio-de-aprendizaje.jpg\" alt=\"\" class=\"wp-image-670231\" srcset=\"https://es.wordpress.org/files/2025/01/2.6.1-Portafolio-de-aprendizaje.jpg 680w, https://es.wordpress.org/files/2025/01/2.6.1-Portafolio-de-aprendizaje-300x300.jpg 300w, https://es.wordpress.org/files/2025/01/2.6.1-Portafolio-de-aprendizaje-150x150.jpg 150w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h4 class=\"wp-block-heading\">2.6.1. Portafolio de aprendizaje</h4>\n\n\n\n<p>El portafolio de aprendizaje o portfolio didáctico es como un dosier educativo, que recoge todos los hitos conseguidos por el alumno durante su formación.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Un ejemplo de portafolio del alumno puede contener temas aprendidos, exámenes realizados, prácticas cumplimentadas o aptitudes que el estudiante ha tenido en el centro.</p>\n</blockquote>\n\n\n\n<p>Es una especie de ficha del alumno, que le sirve, tanto a este como al profesor, para ver de un vistazo la evolución desde el comienzo del curso hasta la fecha presente y para evaluar el desempeño. Con este dossier el formador puede puntuar fácilmente al estudiante en cada evaluación, además de orientarlo y apoyarlo más eficazmente.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.6.2. Portafolio de trabajo</h4>\n\n\n\n<p>El portafolio educativo de trabajo, o portafolio de desempeño, resume los trabajos realizados por el alumno durante su formación, con muestras y extractos reales cuando se trata de tareas creativas o de investigación.</p>\n\n\n\n<p>Gracias a este tipo de portafolio, los formadores podrán ver la comprensión y dominio que tiene el alumno de los temas enseñados, su destreza para aplicarlos de forma práctica y la evolución ejecutiva que este ha tenido.</p>\n\n\n\n<p>Ya ves que en este caso no son importantes los aprendizajes, sino los trabajos realizados con esos aprendizajes. ¿De qué vale aprobar todos los exámenes si luego hacemos cosas mediocres con lo aprendido?</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.6.3. Portafolio de presentación</h4>\n\n\n\n<p>Se trata de un tipo de portfolio que preparan los alumnos para presentar un trabajo ante el profesorado. Los candidatos a un empleo también preparan portafolios de presentación para convencer a los reclutadores de que son la persona ideal para el puesto.</p>\n\n\n\n<p>En el primer caso, el objetivo es informar del trabajo que se ha realizado y de cómo se ha realizado, buscando siempre la aprobación de los docentes y que estos no tengan ninguna duda de que el alumno conoce en profundidad la materia.</p>\n\n\n\n<p>El segundo caso es una adaptación de un portafolio profesional, que recoge solo la información que puede ser útil para conseguir el trabajo, potenciando las experiencias y actitudes que buscan los reclutadores. En resumen, es un portafolio personalizado y optimizado para una oferta de empleo concreta.</p>\n\n\n\n<p>También se conoce como portafolio demostrativo, ya que su objetivo es demostrar la suficiencia del alumno o del candidato en un tema, en una disciplina o en una actividad.</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.6.4. Portafolio de evaluación</h4>\n\n\n\n<p>Los portafolios de aprendizaje, de trabajo y de presentación son herramientas muy potentes para evaluar a un estudiante. Pero no hay mejor herramienta que un portfolio adaptado específicamente al tipo evaluación que realiza un profesor en particular.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>El portfolio de evaluación es justo eso. Un documento diseñado para recoger el desempeño en cada uno de los criterios específicos que serán usados para evaluar a un alumno.</p>\n</blockquote>\n\n\n\n<p>Directo al grano, sin rodeos. Un portafolio personalizado por un profesor o por un comité para obtener de forma clara la información que necesita para evaluar.</p>\n\n\n\n<p>Por ejemplo, ¿por qué pedir un portafolio de trabajo si el formador solo quiere tener en cuenta la presentación del trabajo y no la calidad de este? Menos es más.</p>\n\n\n\n<h3 class=\"wp-block-heading\">2.7. Portafolio de talentos</h3>\n\n\n\n<p>Aquí hablamos de un dossier creado para destacar los talentos de una persona o empresa. Sus conocimientos, sus virtudes, sus aptitudes.</p>\n\n\n\n<p>A veces necesitamos presentar cuáles son nuestras habilidades, tanto blandas y duras, para convencer a alguien de que somos la persona ideal para hacer un trabajo. Así que no necesitamos recopilar todos los trabajos realizados ni todos los puestos que hemos ocupado. Basta con hacer una relación de nuestros talentos y añadir solo aquellos trabajos que los resalten.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.8-Portafolio-de-productos.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"595\" src=\"https://es.wordpress.org/files/2025/01/2.8-Portafolio-de-productos.jpg\" alt=\"\" class=\"wp-image-670232\" srcset=\"https://es.wordpress.org/files/2025/01/2.8-Portafolio-de-productos.jpg 680w, https://es.wordpress.org/files/2025/01/2.8-Portafolio-de-productos-300x263.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.8. Portafolio de productos</h3>\n\n\n\n<p>Nos referimos a un portafolio de productos cuando los trabajos que recopila este son muestras de productos físicos o digitales.</p>\n\n\n\n<p>Sí. Sé lo que estás pensando. Crees que un portfolio de productos es lo que se conoce comúnmente como catálogo. Y no te equivocas. Es exactamente eso.</p>\n\n\n\n<p>Si eres una empresa fabricante o un artesano, lo que necesitas es un dossier con muestras de los productos que manufacturas. Las muestras en este tipo de catálogos suelen ser imágenes, vídeos y descripciones, pero si puedes apoyar tu portfolio con muestras reales de producto, sobre todo de los que estás más orgulloso, estarás más cerca de conseguir tu objetivo.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.9-Portafolio-de-servicios.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"499\" src=\"https://es.wordpress.org/files/2025/01/2.9-Portafolio-de-servicios.jpg\" alt=\"\" class=\"wp-image-670233\" srcset=\"https://es.wordpress.org/files/2025/01/2.9-Portafolio-de-servicios.jpg 680w, https://es.wordpress.org/files/2025/01/2.9-Portafolio-de-servicios-300x220.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.9. Portafolio de servicios</h3>\n\n\n\n<p>Es lo mismo que un portafolio de productos, pero esta vez compuesto por servicios que has prestado a otros clientes.</p>\n\n\n\n<p>¿Y cómo puedo hacer una relación de los servicios prestados a otros clientes, si siempre realizo el mismo servicio? En primer lugar, recuerda que el valor principal de este dossier es que tus clientes potenciales conozcan los clientes con los que has trabajado y el trabajo que has realizado para ellos. Aunque siempre hayas prestado el mismo tipo de servicio, describe cómo lo has hecho para cada cliente y justifica los resultados que este ha obtenido gracias a haberte contratado.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.10-Portafolio-creativo.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"347\" src=\"https://es.wordpress.org/files/2025/01/2.10-Portafolio-creativo.jpg\" alt=\"\" class=\"wp-image-670234\" srcset=\"https://es.wordpress.org/files/2025/01/2.10-Portafolio-creativo.jpg 680w, https://es.wordpress.org/files/2025/01/2.10-Portafolio-creativo-300x153.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.10. Portafolio creativo</h3>\n\n\n\n<p>No es lo mismo contratar a un notario que a un fotógrafo. No necesitas ver los trabajos previos que ha realizado el notario para saber si va a cumplir con su cometido, pero si no ves los trabajos realizados anteriormente por el fotógrafo no sabrás si estás contratando al adecuado.</p>\n\n\n\n<p>Esto ocurre porque los trabajos creativos requieren de una validación sensorial, es decir, necesitamos, según sea el caso, verlos, oírlos, olerlos, degustarlos o tocarlos para decidir si nos gustan.</p>\n\n\n\n<p>El mejor portafolio de un fotógrafo debería ser un dossier con sus mejores fotografías y el de un chef debería ser un menú degustación preparado en exclusiva para la persona que va a contratarlo como profesional.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Así pues, para definir qué es un porfolio creativo, podemos decir que es aquel que incluye de forma gráfica, audiovisual o sensitiva los trabajos creativos de un profesional creativo.</p>\n</blockquote>\n\n\n\n<p>Te encontrarás con muchos tipos diferentes. Aquí te listamos algunos de ellos.</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.10.1. Portafolio artístico</h4>\n\n\n\n<p>El que incluye trabajos artísticos, enmarcados en alguna de las 7 disciplinas artísticas conocidas: pintura, escultura, arquitectura, música, danza, literatura y cine.</p>\n\n\n\n<p>Si soy diseñador gráfico, ¿un portfolio con mis diseños es un portfolio artístico? Si somos puristas tenemos que decir que no. Se trata de un portafolio creativo sin lugar a dudas, pero muy a mi pesar el diseño gráfico no es considerado un arte (de momento, y ya están tardando en cambiar eso).</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.10.2. Portafolio fotográfico</h4>\n\n\n\n<p>Como su propio nombre indica, se trata de un portafolio con fotografías y colecciones fotográficas realizadas por un fotógrafo durante su carrera profesional.</p>\n\n\n\n<p><em><strong>&gt;&gt;&gt;&gt;FOTO con leyenda: Uno de los cientos de ejemplos de portafolio fotográfico</strong></em></p>\n\n\n\n<p>Los fotógrafos fueron los que ampliaron el significado portfolio original, que hasta entonces no era otra cosa que una carpeta contenedora de hojas.</p>\n\n\n\n<p>Ante la necesidad de dar a conocer su trabajo públicamente para conseguir contrataciones, crearon una especie de álbum de fotos que llevaban consigo a cada entrevista de trabajo, al que llamaron portafolio por su parecido con carpeta portadora de folios.</p>\n\n\n\n<p>Llevar encima originales o copias de tus mejores obras terminó siendo una incomodidad, así que aprovecharon las ventajas de internet para digitalizar su trabajo y subirlo a la red, dando lugar a lo que hoy conocemos como portafolio, que ha sido imitado en todas las profesiones, disciplinas académicas y situaciones en las que se necesita entregar muestras de trabajos realizados.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.10.3. Portafolio de vídeo</h4>\n\n\n\n<p>Es un dosier audiovisual. Una recopilación de todos o los mejores trabajos audiovisuales realizados por un profesional. Lo único que lo diferencia del resto de portafolios es el formato en el que se entregan dichos trabajos.</p>\n\n\n\n<p>Como esta vez los trabajos necesitan ser reproducidos, a día de hoy, los portfolios de vídeo son exclusivamente portfolios digitales, algunos entregados en una memoria USB, otros publicados en una página web y unos cuantos enviados en un email lleno de enlaces que llevan a la reproducción de los metrajes.</p>\n\n\n\n<p>Si eres director de cine, cámara, editor o simplemente un fotógrafo que ofrece vídeo-reportajes para bodas, este es el porfolio que tienes que tener.</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.10.4. Portafolio de animación</h4>\n\n\n\n<p>Un portfolio igual que los anteriores, pero que incluye animaciones.&nbsp;</p>\n\n\n\n<p>Los animadores hacen trabajos para multitud de plataformas: páginas webs, aplicaciones móviles, videojuegos, películas, series. Un portafolio de animación debe permitir a tus potenciales clientes ver en movimiento tus animaciones, ya sea en el producto acabado, por ejemplo, en una app para iPhone, o en una simulación digital.</p>\n\n\n\n<p>Debido a esto, los formatos preferidos por los animadores para presentar sus trabajos son el formato web, una presentación digital (PowerPoint, Google Slides o Canva) y un vídeo recopilatorio de menos de 2 minutos.</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.10.5. Portafolio de dibujo o ilustración</h4>\n\n\n\n<p>Su nombre lo dice todo. Un portafolio compuesto por dibujos e ilustraciones realizadas por un artista para mostrar su trabajo a potenciales compradores de las obras y a potenciales empleadores.</p>\n\n\n\n<p>Es igual que un portafolio de fotos, pero con dibujos e ilustraciones.</p>\n\n\n\n<p>A pesar de que observar de primera mano las obras originales aporta mucha más información de la calidad del trabajo, no podemos olvidar las ventajas de tener un portafolio online con digitalizaciones de cada dibujo.</p>\n\n\n\n<p>Gracias a los fotógrafos y a las artísticas del dibujo y la pintura ha llegado a nosotros con tanta fuerza esta forma de validación profesional, que sigue suponiendo el factor principal a la hora de la toma de decisiones de compra y contratación.</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.10.6. Portafolio de pinturas</h4>\n\n\n\n<p>Es exactamente igual que el portafolio anterior, pero esta vez hecho con pinturas, en lugar de con dibujos e ilustraciones.</p>\n\n\n\n<p>Hasta hace poco, la manera tradicional de vender las obras de un pintor y de promocionar a un artista gráfico, era a través de exposiciones. Es cierto que la mejor forma de valorar una obra es sentirla enfrentándonos a ella, situándonos frente al original. Pero esto dejaba fuera del mercado a todos los artistas que no estaban apadrinados por los grandes museos y galerías del mundo.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>El portafolio de pinturas democratizó el arte, permitiendo a cualquier pintor exponer su obra al mundo a través de reproducciones y digitalizaciones en menor escala.</p>\n</blockquote>\n\n\n\n<p>Hoy se venden muchas más pinturas a través de internet que en exposiciones físicas, así que no era tan importante enfrentarse cara a cara a la obra original para tomar la decisión de compra, ¿verdad?</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.10.7. Portafolio de escritura</h4>\n\n\n\n<p>El portafolio que deberías crear si eres escritor o copywriter.</p>\n\n\n\n<p>Lectores, editoriales y clientes necesitan ver cómo escribes para darte su voto de confianza, así que prepara un dossier con tus mejores trabajos, donde puedan verse tu estilo y tu profesionalidad a la hora de comunicar, entretener, orientar, ayudar y persuadir a través del lenguaje escrito.</p>\n\n\n\n<p>Los portafolios de escritura que, además, incluyen un listado de concursos en los que has participado como autor, uno de premios ganados y otro de medios en los que has aparecido, tienen muchas más posibilidades de dar en el clavo.</p>\n\n\n\n<h4 class=\"wp-block-heading\">2.10.8. Portafolio de diseños</h4>\n\n\n\n<p>En este tipo de portafolios entran todos los trabajos artísticos que requieran de un diseño original y que no encajen en ninguno de los anteriores. Podemos estar hablando del portafolios de un diseñador web, de un diseñador gráfico, de un diseñador de vestuario o de un diseñador industrial.</p>\n\n\n\n<p>Sean páginas web, logotipos, vestidos futuristas o una silla ergonómica; si recopilas todos los diseños en una presentación, tienes un portafolio de diseños.</p>\n\n\n\n<p>Según el diseño, el formato del portafolio debe ser uno u otro, siempre buscando la correcta reproducción de los trabajos y el impacto positivo en su espectador.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.11-Portafolio-de-modelo.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"703\" src=\"https://es.wordpress.org/files/2025/01/2.11-Portafolio-de-modelo.jpg\" alt=\"\" class=\"wp-image-670235\" srcset=\"https://es.wordpress.org/files/2025/01/2.11-Portafolio-de-modelo.jpg 500w, https://es.wordpress.org/files/2025/01/2.11-Portafolio-de-modelo-213x300.jpg 213w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.11. Portafolio de modelo</h3>\n\n\n\n<p>¿Qué es el portfolio de modelo? Esto sí que no lo habías escuchado antes.</p>\n\n\n\n<p>El también conocido como portafolio de moda no es otra cosa que un book de fotos donde el modelo o la modelo aparece en diferentes entornos, con diferente ropa, poniendo diferentes expresiones y representando diferentes poses.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>El objetivo es convencer a las marcas de la versatilidad de la persona para hacer campañas de publicidad, catálogos editoriales y pasarela.</p>\n</blockquote>\n\n\n\n<p>En resumen, es un portafolio fotográfico creado con el fin de destacar las virtudes físicas y profesionales de un/a modelo.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.12-Portafolio-de-marketing.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"588\" src=\"https://es.wordpress.org/files/2025/01/2.12-Portafolio-de-marketing.jpg\" alt=\"\" class=\"wp-image-670236\" srcset=\"https://es.wordpress.org/files/2025/01/2.12-Portafolio-de-marketing.jpg 680w, https://es.wordpress.org/files/2025/01/2.12-Portafolio-de-marketing-300x259.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.12. Portafolio de marketing</h3>\n\n\n\n<p>¿Qué es un porfolio de marketing? En este caso, hablamos de un dossier con una recopilación de campañas de marketing y publicidad realizadas por una empresa o profesional del sector, que tiene como objeto presentar su experiencia a clientes potenciales y convencerlos de su capacidad para realizar un trabajo.</p>\n\n\n\n<p>Porque ya no basta con decir que hemos trabajado con este o aquel gran cliente. Ahora es necesario justificar qué hemos hecho para cada cliente, las creatividades producidas durante el trabajo y los resultados obtenidos.</p>\n\n\n\n<p>Cuanto mayor sea el proyecto, más atenderán a lo que aparece en tu portafolio de marketing, así que selecciona muy bien lo que incluir él.</p>\n\n\n\n<p>Haz lo posible por trabajar con marcas reconocibles, aunque tengas que ajustar los precios e incluso hacerlo gratis, ya que esto te abrirá puertas a muchos otros proyectos interesantes. Y no te olvides de pedir testimonios a todos tus clientes satisfechos para añadirlos al dossier.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.13-Portafolio-de-inversion.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"567\" src=\"https://es.wordpress.org/files/2025/01/2.13-Portafolio-de-inversion.jpg\" alt=\"\" class=\"wp-image-670237\" srcset=\"https://es.wordpress.org/files/2025/01/2.13-Portafolio-de-inversion.jpg 680w, https://es.wordpress.org/files/2025/01/2.13-Portafolio-de-inversion-300x250.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.13. Portafolio de inversión</h3>\n\n\n\n<p>Aquí la palabra <em>portafolio</em> tiene un significado ligeramente diferente al resto de casos.&nbsp;</p>\n\n\n\n<p>Cuando hablamos de portafolio de inversión nos referimos a un dossier con todos nuestros activos financieros (acciones, fondos, bonos…), pero no para justificar lo buenos inversores que somos ante otras personas o entidades, sino para tener un control de dónde está nuestro dinero con el fin de diversificar las inversiones, minimizar los riesgos y maximizar la rentabilidad.</p>\n\n\n\n<p>Esta vez el portafolio es de uso personal. A muchos inversores les encanta compartir el suyo para presumir, pero lo que en realidad buscan es la validación de otros inversores y es ahí donde toma sentido el término.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.14-Portafolio-digital.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"453\" src=\"https://es.wordpress.org/files/2025/01/2.14-Portafolio-digital.jpg\" alt=\"\" class=\"wp-image-670238\" srcset=\"https://es.wordpress.org/files/2025/01/2.14-Portafolio-digital.jpg 680w, https://es.wordpress.org/files/2025/01/2.14-Portafolio-digital-300x200.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.14. Portafolio digital</h3>\n\n\n\n<p>Responder qué es un portafolio digital es absurdamente fácil, porque su nombre simplemente hace referencia a todos los portafolios que se crean y muestran en soporte digital. En una página web, en una plataforma online de empleo, en un perfil de una red social, en un entregable por email, en una memoria USB externa…&nbsp;</p>\n\n\n\n<p>Es muy extraño ver en la actualidad un portafolio físico, con una muestra física de los trabajos realizados, sobre todo en tiempos en los que el reclutamiento profesional se realiza de forma telemática y no presencial. Así que no sería muy arriesgado afirmar que casi la totalidad de portafolios activos que existen son 100% digitales.</p>\n\n\n\n<p>Como no solo se trata de convencer, sino de sorprender, si eres un profesional que realiza tareas creativas, prueba a enviar tu portfolio físico por mensajería a tus potenciales contratantes. Seguro que tu nombre se graba a fuego en sus mentes y la hazaña no queda sin recompensa.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.15-Portafolio-online.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"453\" src=\"https://es.wordpress.org/files/2025/01/2.15-Portafolio-online.jpg\" alt=\"\" class=\"wp-image-670239\" srcset=\"https://es.wordpress.org/files/2025/01/2.15-Portafolio-online.jpg 680w, https://es.wordpress.org/files/2025/01/2.15-Portafolio-online-300x200.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.15. Portafolio online</h3>\n\n\n\n<p>Se trata de todos esos portafolios digitales que están publicados online y que son visibles a través de internet.</p>\n\n\n\n<p>Puedes tener tu portafolio alojado en tu página web propia, en la web de una plataforma de empleo o de trabajos freelance, en el perfil de la red social que uses profesionalmente o en un archivo descargable subido a la nube.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Siempre que sea público y pueda ser visto en alguna dirección web, es un portafolio online. Y es la forma más cómoda y efectiva de acceder a toda tu obra en cualquier momento y desde cualquier lugar.</p>\n</blockquote>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.16-Portafolio-web.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"351\" src=\"https://es.wordpress.org/files/2025/01/2.16-Portafolio-web.jpg\" alt=\"\" class=\"wp-image-670240\" srcset=\"https://es.wordpress.org/files/2025/01/2.16-Portafolio-web.jpg 680w, https://es.wordpress.org/files/2025/01/2.16-Portafolio-web-300x155.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.16. Portafolio web</h3>\n\n\n\n<p>Básicamente, es una página web hecha en forma de portafolio para agrupar y exponer todos o una selección de tus trabajos anteriores.</p>\n\n\n\n<p>Un portfolio web es un portfolio digital y también un portfolio online, pero no son lo mismo. Se les llama portfolios web cuando el portafolio ocupa la web por completo. Si tienes una página web de venta de tus productos y servicios, y en una sección de la misma publicas tu portafolio, no podríamos decir que tienes un portafolio web.</p>\n\n\n\n<p>De todas formas, no entremos en discusiones lingüísticas. Quédate con que tu mejor baza para conseguir el trabajo de tus sueños o captar a tu cliente ideal, es tener un portafolio disponible en internet. Da igual si está en una web exclusiva o si es parte de tu web corporativa, lo importante es que sea fácil de encontrar y que esté hecho de forma estratégica para ayudarte a lograr tus metas.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://es.wordpress.org/files/2025/01/2.17-Portafolio-audiovisual.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"680\" height=\"356\" src=\"https://es.wordpress.org/files/2025/01/2.17-Portafolio-audiovisual.jpg\" alt=\"\" class=\"wp-image-670241\" srcset=\"https://es.wordpress.org/files/2025/01/2.17-Portafolio-audiovisual.jpg 680w, https://es.wordpress.org/files/2025/01/2.17-Portafolio-audiovisual-300x157.jpg 300w\" sizes=\"auto, (max-width: 680px) 100vw, 680px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">2.17. Portafolio audiovisual</h3>\n\n\n\n<p>Después de hablar de diferentes formatos y soportes de portafolios, vamos a acabar con uno de los tipos que está tomando la delantera en los últimos años.</p>\n\n\n\n<p>Aquí no nos referimos a un dossier con trabajos audiovisuales creativos. Esto ya lo comentamos en otros tipos de portafolios. Nos referimos a que el propio portafolio sea una obra audiovisual, aunque los trabajos que en él se exponen no lo sean.</p>\n\n\n\n<p>Si eres arquitecto, puedes hacer tu portafolio profesional con planos y fotografías de los proyectos en los que has participado (aburrido). Pero también puedes hacer un vídeo donde se muestre cómo haces los planos, donde aparezcas explicando el trabajo de diseño a tu cliente, donde se te vea con un casco supervisando la obra y que acabe con una ruta por toda la construcción.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Con técnicas de vídeo, de sonido y de storytelling, puedes convertir ese trabajo en una obra cinematográfica express que despierte en tus clientes potenciales un interés genuino.</p>\n</blockquote>\n\n\n\n<h2 class=\"wp-block-heading\">3. Ventajas de tener un portafolio</h2>\n\n\n\n<p>Hacer un portafolio de forma estratégica tiene muchas ventajas para ti y para tu negocio. Un portfolio profesional es lo que te separa de la vida que quieres tener. Suena muy dramático, pero no lo es.</p>\n\n\n\n<p>Claro que tienes que ser un buen profesional para conseguir tus objetivos vitales, pero si eres Picasso y tiene un portfolio malo, nadie te va a contratar, pero si dibujas como un niño pequeño harto de galletas de chocolate y sabes jugar bien tus cartas en el desarrollo del portafolio, conseguir contratos como churros.</p>\n\n\n\n<p>Estas son algunas de las ventajas destacables.</p>\n\n\n\n<p><em>Disclamer: En ese apartado me voy a centrar en las ventajas de los portafolios profesionales, para convencerte de que hagas el tuyo lo antes posible y empieces a labrarte el futuro que ansías. Los portafolios de estudio también tienen muchas ventajas, pero la mayoría son para tus formadores, así que no pierdas el tiempo con ellos, salvo que te pidan hacerlos en tu centro formativo o salvo que quieras evaluar por ti mismo tu progreso. Tampoco incluiremos aquí las ventajas de tener un portfolio de inversión, que ya comenté en el apartado 2.13.</em></p>\n\n\n\n<h3 class=\"wp-block-heading\">3.1. Enseña tus trabajos a terceros</h3>\n\n\n\n<p>Parece el beneficio más obvio, pero con él empieza todo.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Quienes tengan dudas de tu forma de trabajar y de la calidad de tus trabajos, se apoyarán en tu portfolio para tomar la decisión de contratarte o de enviarte a paseo.</p>\n</blockquote>\n\n\n\n<p>Si no tienes portafolio, otros que sí lo tengan ganarán puestos en la selección, eso si es que no es obligatorio, ya que hoy muchas empresas ponen como condición sine qua non entregar un portfolio como parte del proceso de selección, descalificando directamente a quien no lo haga.</p>\n\n\n\n<p>¿Y qué ocurre con las personas que no requieren de un portafolio para contratar? Podemos caer en el error de pensar que es mejor para nosotros, porque nuestra experiencia anterior no influirá en conseguir el trabajo, pero ¿es mejor que te contrate alguien que conoce tus trabajos previos o alguien que no los conoce?</p>\n\n\n\n<p>Si ya llevas un tiempo en el sector sabrás la importancia de hacer un buen match con el cliente y de evitar sorpresas. Si no conocen tus virtudes ni valoran tu recorrido, prepárate para tener que hacer casi cualquier cosa que te pidan.</p>\n\n\n\n<p>Además, hay un activador muy potente de la motivación y son los halagos y las alabanzas, sobre todo si vienen de gente a la que queremos y a la que admiramos. ¿Cómo van a felicitarte por tu trabajo si no se los enseñas?</p>\n\n\n\n<h3 class=\"wp-block-heading\">3.2. Mejora tu autoridad y marca personal</h3>\n\n\n\n<p>La autoridad es esa influencia que tienes en la decisión de compra o de contratación de tus clientes. Es una clase de prestigio que, aparentemente, solo puede ser otorgado por tus logros y por otros profesionales del sector que validen tu profesionalidad.</p>\n\n\n\n<p>Puedes aumentar tu autoridad por el camino tradicional, ser el mejor en tu trabajo y trabajar como un poseso hasta que los frutos empiecen a llegar. Pero también puedes hacerlo por el camino estratégico, modulando la percepción que los demás tienen de ti para acelerar los resultados.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Es posible adquirir autoridad de muchas formas y todas más efectivas que el trabajo duro. Apareciendo en prensa, en Wikipedia, organizando eventos, escribiendo un ensayo, realizando un estudio, optimizando tus perfiles en redes sociales, haciendo concursos, creando contenidos, colaborando con otros profesionales afines y un largo etcétera.&nbsp;</p>\n</blockquote>\n\n\n\n<p>Y creando un portafolio estratégico es una de las mejores. Tu nivel profesional percibido es algo que puedes manipular a tu antojo con un portafolio si conoces bien a tu público objetivo y si tocas las teclas adecuadas.</p>\n\n\n\n<h3 class=\"wp-block-heading\">3.3. Aumenta tu visibilidad</h3>\n\n\n\n<p>Un portafolio no solo se usa para mostrar tus trabajos a quien te lo pida. Con un portafolio online publicado en tu web y en algunas plataformas de empleo claves, no solo llegarán a ti los clientes con los que ya tratas personalmente, sino también todos los que busquen un perfil como el tuyo o unos trabajos como los que haces.</p>\n\n\n\n<p>Con un poco de trabajo SEO en tu web para que aparezcas en los resultados de búsqueda cuando alguien busque lo que ofreces, y con una personalización estratégica del porfolio para cada plataforma de empleo según su operatividad y según lo que mejor funcione en cada una, tus obras serán visionadas por una gran cantidad de potenciales clientes.</p>\n\n\n\n<h3 class=\"wp-block-heading\">3.4. Destaca tus virtudes y minimiza tus defectos</h3>\n\n\n\n<p>Si un cliente pudiera ver todo tu historial profesional de principio a fin, puede que nunca te contratase. Ojalá estuviésemos orgullosos de cada paso que hemos dado en nuestra carrera profesional y de obra realizada, pero la realidad es bien distinta.</p>\n\n\n\n<p>Y, aunque estuvieras orgulloso de todos tus talentos y de todo lo que has hecho, ¿no crees que es mejor mostrar a cada tipo de cliente una visión única de ti como profesional, que coincida todo lo posible con lo que están buscando?</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>El portafolio nos permite destacar los talentos y trabajos que queremos, ignorando todo aquello que pueda ser objeto de duda o que no beneficie a nuestra causa.</p>\n</blockquote>\n\n\n\n<p>Pero también nos permite agrupar esos talentos y trabajos en función de las diferentes personas que van a analizarlos. Para ello solo necesitas crear secciones en tu portfolio según tus intereses y dirigir a cada cliente a la sección estratégica hecha expresamente para convencerlo.</p>\n\n\n\n<h3 class=\"wp-block-heading\">3.5. Aumenta tu potencial de contratación</h3>\n\n\n\n<p>Esta es la ventaja más importante y el motivo por el cual todos los profesionales, sean de la especialidad, sector y mercado que sean, deberían tener un portafolio actualizado.</p>\n\n\n\n<p>Como consecuencia de todos los beneficios anteriores, tus posibilidades de ser contratado aumentan exponencialmente. No es necesario explicar mucho más.</p>\n\n\n\n<p>Si puedes enseñar tus trabajos a todos tus clientes, mejoras la autoridad y la marca personal ante ellos, aumentas tu visibilidad online, destacas tus virtudes y minimizas tus defectos, el número de clientes que se pondrán en contacto contigo aumentará y también lo hará el número de ellos que dicen que sí.</p>\n\n\n\n<p>Si, además, te comprometes a tener un portafolio completo y actualizado, tus clientes no tendrán duda de lo buen trabajador que eres, de que tu experiencia es amplia y de que sigues en activo.</p>\n\n\n\n<h3 class=\"wp-block-heading\">3.6. Ahorra tiempo</h3>\n\n\n\n<p>Si los clientes con los que tratas no conocen tu trabajo, la relación profesional empieza con una flagrante desventaja. Tú tendrás que convencer desde el principio a tu interlocutor de que eres su mejor opción para el trabajo. Es decir, eres tú el que tiene que hacer el esfuerzo de vender.</p>\n\n\n\n<p>Si un cliente te contacta tras haber visto tu portfolio, es que le interesa lo que haces, así que la relación da un giro siendo él el que necesita comprar y no tú el que necesita vender. No te imaginas lo que se reducen los tiempos de negociación en estos casos.</p>\n\n\n\n<p>Además, cada cliente que vea tus trabajos y no te contacte después, no te quitará ni un segundo de tu tiempo. Cliente no potencial filtrado de forma automática.</p>\n\n\n\n<p>Por otro lado, sin portfolio tendrás que preparar una propuesta personalizada con trabajos anteriores para cada cliente. Con lo fácil que es darles a todos una dirección web para que se deleiten con tu portfolio online y que sea este el que haga todo el trabajo.</p>\n\n\n\n<h3 class=\"wp-block-heading\">3.7. Permite ver tu evolución</h3>\n\n\n\n<p>La vida personal da muchas vueltas y la vida profesional más aún. Con un vistazo a tu portfolio, podrás ver hacia dónde te diriges.</p>\n\n\n\n<p>Todos solemos aceptar clientes y proyectos que no nos motivan y que nos alejan de las especialidades en las que queremos desarrollarnos. En ocasiones, incluso son esos proyectos “no deseados” los que copan todo nuestro horario.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Analizando la evolución de los trabajos realizados, podemos atajar a tiempo un cambio de rumbo perjudicial para nuestro desarrollo profesional y potenciar aquellos trabajos que más nos acerquen a nuestros propósitos.</p>\n</blockquote>\n\n\n\n<p>Pero este análisis no solo te sirve a ti. Todos tus clientes, potenciales o en cartera, podrán observar esa evolución y usarla en su favor. Para explicarlo de otra manera, si algunos de los clientes que ya te han contratado como ilustrador ven que añades un trabajo de generación de imágenes con IA en tu portafolio, las posibilidades de que te contraten como generador de imágenes IA aumentan.</p>\n\n\n\n<h3 class=\"wp-block-heading\">3.8. Mejora tus habilidades</h3>\n\n\n\n<p>Ver todos tus trabajos juntos, te permite ver qué habilidades tienes que mejorar. Esa perspectiva general se pierde si no tienes portafolio, porque tu atención siempre estará puesta en los trabajos que estés realizando en cada momento.</p>\n\n\n\n<p>Si al ver tu portafolio de diseñador gráfico, ves que algunos de los colores usados en tus proyectos no te permiten leer correctamente los textos, ya sabes que tienes que mejorar la combinación de colores y la accesibilidad para pasar al siguiente nivel.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>La propia construcción del portafolio te hará mejorar como profesional, porque sintetizarás lo importante de tu trayectoria, analizarás a tus competidores, estudiarás a tu cliente objetivo y aprenderás a crear una experiencia valiosa para él.</p>\n</blockquote>\n\n\n\n<p>En el siguiente apartado veremos los puntos clave para que sepas cómo hacer un portfolio que triunfe, sea cual sea tu situación.</p>\n\n\n\n<h2 class=\"wp-block-heading\">4. Características de un portafolio ganador</h2>\n\n\n\n<p>Como los portafolios más completos y versátiles son los portafolios web, tenemos más probabilidades de crear un portafolio ganador si nos decantamos por un portafolio digital.</p>\n\n\n\n<p>Ya hemos repasado todas las teorías y visto más de un ejemplo de portafolio digital para que quede claro qué es un porfolio. Ahora viene la pregunta crucial: ¿Cómo hacer un portafolio digital para disfrutar de todos los beneficios aquí mencionados? Sobre todo, el de aumentar las contrataciones, que, seamos sinceros, es el único motivo por el que te has leído toda la parrafada anterior. ¿O no te la has leído?.</p>\n\n\n\n<p>Bueno, pues la respuesta es rápida. No hay una única solución para todo el mundo. Pero tengo una buena noticia. Si te aseguras de incluir los siguientes elementos en él, y lo haces siguiendo mis consejos, estás muy cerca de oler el laurel.</p>\n\n\n\n<p>Esta es mi versión del portafolio ganador. En ella integro algunas técnicas y recursos para construir autoridad que te situarán por encima del resto.</p>\n\n\n\n<p>Seguro que tendrás algunos ajustes que hacer para adaptar la estructura y contenidos del portafolio a tu negocio, pero no será nada que no puedas hacer fácilmente.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4.1. Diseño</h3>\n\n\n\n<p>El diseño es importante. Un buen diseño tiene el poder de hacer que lo bueno parezca mejor, pero el poder de un mal diseño es el de hacer que lo bueno parezca malo. Siendo claros, si el diseño de tu portafolio no es agradable, los trabajos que aparezcan en él parecerán mucho peores de lo que son.</p>\n\n\n\n<p>Y no hablemos ya si eres un profesional creativo. Tus clientes potenciales y todo el que vea tu dossier entenderá de forma subconsciente que el diseño del portafolio es tu trabajo artístico más reciente, así que más te vale que sea bueno.</p>\n\n\n\n<p>Asegúrate de que las creatividades tengan un diseño actual y de que estén en sintonía con los trabajos que realizas. Y los textos deben ser claros y perfectamente legibles.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Cualquier diseño moderno, bonito y equilibrado puede funcionar, siempre que la navegabilidad sea cómoda e intuitiva.</p>\n</blockquote>\n\n\n\n<p>La autoridad que te confiere tener un portafolio que sea percibido como profesional es equivalente a la que te conferiría aparecer con un BMW a una entrevista de trabajo. Pensarán que, si has podido contratar a diseñadores y desarrolladores web de nivel, es porque te va bien, y te va bien porque eres bueno en tu trabajo.</p>\n\n\n\n<p>Si el diseño no es uno de tus fuertes o simplemente no tienes tiempo para diseñar tu portafolio desde cero, puedes elegir entre los <a href=\"https://es.wordpress.org/themes/tags/portfolio/\">miles de plantillas de portfolio web disponibles para WordPress.</a> Muchas de ellas, completamente gratuitas.</p>\n\n\n\n<p>WordPress es el software de creación de páginas web más utilizado en todo el mundo. Y es de código abierto y libre distribución. Lo que quiere decir que puedes modificar libremente el código, además de instalarlo gratuitamente en el servidor que prefieras y crear tu propia página web en minutos.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4.2. Foto profesional</h3>\n\n\n\n<p>Si hay algo imprescindible a la hora de seleccionar perfiles para un trabajo, sea para cubrir un puesto en una empresa como para contratarlos como freelancers, es verle la cara al candidato.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Una imagen transmite mucha información a los clientes y a los reclutadores, alguna de forma consciente y otra de forma subconsciente. Pero todo lo podemos resumir en la siguiente afirmación: a todos les gustan las caras bonitas con pinta de buena persona.</p>\n</blockquote>\n\n\n\n<p>Y no me refiero solo a todos los clientes y a todos los reclutadores. Me refiero a todas las personas sobre la faz de la Tierra. Es pura psicología y escapa de nuestro control.</p>\n\n\n\n<p>Es como la portada de un disco o de un libro. Si no atrae, estás perdido. Así que elige una foto en la que parezcas más guapo que de costumbre, en la que salgas vestido formalmente y con la sonrisa más luminosa y amable que se te ocurra. Debe ser como la foto que te gustaría haber visto cuando te mostraron al pretendiente de tu hermana pequeña.</p>\n\n\n\n<p>Si tienes cierta popularidad como profesional en alguna red social, siempre que sea posible y que no se desvíe mucho de lo anterior, puedes usar en el portafolio la misma foto de perfil que tengas en la red social. Si te reconocen, aunque solo logres resultar familiar, tu autoridad aumentará de golpe.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4.3. Biografía</h3>\n\n\n\n<p>Algo parecido a la biografía que tienes en LinkedIn… Si es que tienes biografía… Si es que tienes LinkedIn.</p>\n\n\n\n<p>Prepara una biografía resumida, de no más de 2 párrafos, donde hables de tu experiencia laboral, de tus habilidades, de los hitos más importantes que has logrado.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Solo destaca lo importante y llamativo. Con la biografía también buscamos aumentar la autoridad percibida por tus clientes y por los head hunters, por lo que los datos que no te ayuden, sobran.</p>\n</blockquote>\n\n\n\n<p>Solo si tienes algo de lo que presumir en tu etapa formativa, inclúyelo también en la bio. Si no es así, es mejor que tus trabajos hablen por ti mismo y que su evaluación no se vea influenciada por el nivel de titulitis del espectador.</p>\n\n\n\n<p>Y por mucho que te lo recomienden en otros sitios, que no se te ocurra incluir tus aspiraciones profesionales ni en la biografía ni en el portafolio. Ya sé que es algo de interés para muchas de las personas y empresas que contratan, pero te sitúa en una posición de escasez, porque da a entender que no estás donde quieres estar, o, dicho de otra forma, que no eres exitoso. Patada baja a la autoridad de tu marca.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4.4. Competencias</h3>\n\n\n\n<p>¿Qué tareas o trabajos desempeñas? ¿Cuáles son tus especialidades? ¿Qué tecnologías dominas? ¿Qué herramientas manejas?</p>\n\n\n\n<p>Debes hacer un listado de competencias tan corto como un elevator pitch y tan específico como el prospecto de un medicamento. Y “específico” no quiere decir “técnico”. Debes expresarlo, como mucho, con el mismo nivel técnico que tenga tu cliente ideal o tu reclutador.</p>\n\n\n\n<p>No caigas en la trampa de pensar que los tecnicismos aumentarán tu autoridad. Solo lo harán ante un público con tu mismo nivel técnico. Y seguro que no es un público muy amplio. Y tampoco creo que muchos de tus clientes estén entre ellos.</p>\n\n\n\n<p>Si la persona que lea tu portafolio no entiende lo que ve, automáticamente serás eliminado de su selección, ya que el trabajo de comprender si eres un candidato válido no compensa el esfuerzo. Y huye de los clientes que quieran contratarte sin entender lo que haces.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4.5. Trabajos</h3>\n\n\n\n<p>En definitiva, ¿un portafolio qué es sin una buena sección de trabajos realizados?</p>\n\n\n\n<p>Esta es la parte decisiva de tu portafolio digital. Si la selección que hagas de todos tus trabajos no es buena, o si la presentas de la forma incorrecta, el cliente o el reclutador puede pensar que no sabes hacer las tareas que necesitan asignar, o que tu estilo no es lo que están buscando.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Empieza por hacer una lista de todos los trabajos que has realizado, de los que tienes una muestra o una copia, y ordena la lista cronológicamente.</p>\n</blockquote>\n\n\n\n<p>Ahora descarta todos los que crees que te perjudicarían o los que no enseñarías a alguien al que admiras. Abajo sentimentalismos. Todo lo que no suma, sobra. Es mejor tener que hacer nuevos trabajos que sean impactantes, aunque sea a bajo precio, para tener un portafolio efectivo que atraiga contrataciones, que aferrarse a trabajos de los que no estás orgulloso y estancar tu carrera profesional.</p>\n\n\n\n<p>Añade tu lista infalible de trabajos en el portafolio y busca una imagen, vídeo, extracto o muestra de cada trabajo. Este es un punto clave y merece toda tu atención. Tus trabajos no solo deben ser impactantes, sino que deben ser presentados con el mayor cuidado para resaltar las virtudes y que no se vean los defectos.</p>\n\n\n\n<p>Si tus trabajos son creativos, asegúrate de incluir imágenes y archivos en máxima resolución y solo los que sean o parezcan profesionales. Y ojo con complicar la reproducción o visionado de las obras con formatos raros y con elementos dinámicos que ralentizan la carga de la web. Nadie gastará más de 3 segundos en intentar ver tus trabajos. Si no puede reproducirlos, te enviará a ti y a tu portafolio al fondo del olvido.</p>\n\n\n\n<p>Es hora de incorporar la siguiente información a las imágenes: empresa o proyecto para el que desempeñaste el trabajo, lo que te solicitaron, cómo lo abordaste y, siempre que sea posible, los resultados obtenidos gracias a tu solución.</p>\n\n\n\n<p>Volveré a pedirte aquí que seas escueto. Cuanta más información des, más probabilidad tienes de equivocarte y de hacer saltar alguna alerta.</p>\n\n\n\n<p>Y, por favor, olvídate de explicaciones rimbombantes intentando demostrar tu profesionalidad o remarcando la importancia que tuviste en este o en aquel proyecto. Dime de qué presumes y te diré de qué careces. Los referentes de un sector tienen tanta autoridad que no necesitan dar argumentos para justificar su obra. Si aún no eres uno de ellos, actúa como si lo fueras.</p>\n\n\n\n<p>Y que ni se te ocurra incluir un enlace a tu curriculum vitae como recomiendan por ahí. ¿Has visto alguna vez el curriculum vitae de alguien famoso? Pues eso. Es síntoma de poca experiencia laboral y también de poca estabilidad profesional. Si algún reclutador te lo pide y te interesa el puesto que oferta, envíaselo, pero nunca lo tengas accesible desde tu portfolio y, a ser posible, que no sea accesible públicamente.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4.6. Colaboraciones destacadas</h3>\n\n\n\n<p>Este apartado solo existe para aumentar tu autoridad y con ello la confianza que tendrán en ti tus clientes potenciales y los reclutadores que lleguen a tu portafolio.</p>\n\n\n\n<p>Aquí debes poner un listado de los artículos que hayas redactado como invitado en otras webs, tus intervenciones en medios de prensa y cualquier otra aparición destacable, como apariciones en radio, en pódcasts, en cursos o en canales sociales estratégicos.</p>\n\n\n\n<p>¿Que no has colaborado como autor invitado en ninguna web? ¿A qué esperas? Haz un listado de las webs de tu sector que aumentaría tu autoridad y envía una propuesta de redacción personalizada a cada una para escribir como invitado. Cuanto mayor sea el nivel del sitio, más interesante debe ser tu propuesta.</p>\n\n\n\n<p>¿Que no has aparecido en medios de prensa? Aparecer en medios de prensa hablando como un experto en tu disciplina es, tal vez, la acción que mayor autoridad otorga a un profesional.&nbsp;</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Puedes usar cualquier técnica de Media Authority Building para lograr aparecer en medios. Es más fácil de lo que crees.</p>\n</blockquote>\n\n\n\n<p>También puedes contratar publicaciones y preparar artículos estratégicos para transmitir autoridad. Hoy en día puedes publicar en diarios digitales de renombre por menos de 50 €.</p>\n\n\n\n<p>¿Que no has aparecido en radio, pódcasts, cursos ni en canales sociales estratégicos? Pues ya estás tardando.</p>\n\n\n\n<p>Ármate de valor y contacta a 100 personas que compartan audiencia contigo, es decir, que su cliente potencial sea el mismo que el tuyo, y que tengan programas de radios, pódcasts, canales de YouTube, de Instagram o cualquier otro canal de difusión, y ofréceles dar valor a su público.</p>\n\n\n\n<p>Una entrevista, una masterclass, una consultoría gratis, una técnica ganadora… La estadística dice que al menos 10 de esas personas te dirán que sí, y una vez aparezcas a su lado, su autoridad se te transferirá por arte de magia.</p>\n\n\n\n<p>La transferencia de autoridad es algo que ocurre involuntariamente en el cerebro. No le des más vueltas y aprovéchalo.</p>\n\n\n\n<p>Si en tu apartado de colaboraciones destacadas aparecen webs conocidas en tu sector, medios de prensa conocidos nacional o internacionalmente y colaboradores con expertos reconocidos profesionalmente, no te será muy difícil conseguir nuevos clientes y nuevos trabajos.</p>\n\n\n\n<p>El esfuerzo de crear esta parte del portafolio merece la pena y mucho. Cada logro que consigas pasará a formar parte de tu huella digital y podrá servirte como muestra de autoridad y profesionalidad toda la vida.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4.7. Obras publicadas</h3>\n\n\n\n<p>Es otro de esos apartados que, si no lo tienes, por el bien de tu autoridad, deberías trabajar para tenerlo.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Si logras que tu nombre aparezca como autor en cualquier obra editada o en cualquier investigación publicada, la certeza de tus clientes y reclutadores de que eres un profesional como la copa de un pino quedará fuera de toda duda.</p>\n</blockquote>\n\n\n\n<p>Y para eso, solo tienes que poner en marcha 2 de mis técnicas de Media Authority Building favoritas. La autoedición de un libro y el desarrollo y publicación de un estudio.</p>\n\n\n\n<p>Tener un libro a la venta en Amazon es pan comido, aunque no lo parezca. Busca un tema de interés para tu público y escribe unas 40.000 palabras aportándoles valor sobre él, asegurándote de que el texto te coloque como una autoridad en tu trabajo.</p>\n\n\n\n<p>Piensa que en este artículo ya llevo casi 8.000 palabras escritas, así que 40.000 no son tantas. Y no tienes que inventar la rueda. Con recopilar información de otras fuentes, ordenarla y adaptarla a tu estilo, ya lo tienes.</p>\n\n\n\n<p>Sí. Ya sé lo que te pasa por la cabeza. ¿Cómo voy a ser capaz de hacer un estudio valioso para mi sector si soy un impostor?</p>\n\n\n\n<p>En primer lugar, todos somos impostores. Y en segundo lugar, los estudios están sobrevalorados y ahí está la gracia de esta técnica. Parece que son extremadamente difíciles y que solo están reservados para las grandes mentes de cada país. Pero la realidad está muy lejos de ser así.</p>\n\n\n\n<p>No te digo que hagas una investigación que cambie el mundo para siempre, pero piensa en un experimento que puedas hacer por tus medios, cuyo resultado podría interesar a otros colegas del sector. A veces es suficiente con hacer una encuesta o con poner a prueba alguna idea.</p>\n\n\n\n<p>Investiga un poco sobre la metodología científica para preparar la investigación con todo el rigor posible, registrando cada paso y cada resultado de la forma adecuada, y para redactar el estudio, ofreciendo el máximo valor a los que lo lean y colocándote como una autoridad indiscutible.</p>\n\n\n\n<p>El efecto sobre tu marca personal será enorme, por muy pequeña que sea tu aportación.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4.8. Premios y reconocimientos</h3>\n\n\n\n<p>Efectivamente, eso es. Un listado de todos los premios que has ganado en tu carrera profesional y de todos los reconocimientos que has recibido.</p>\n\n\n\n<p>¿Y si no tienes ninguno? Puedes ignorar esta sección, pero no voy a decirte que no es importante, porque te mentiría. Junto con las 2 secciones anteriores, es tu mejor oportunidad para diferenciarte de tu competencia y para entrar por la puerta grande en la mente de los que buscan contratarte.</p>\n\n\n\n<p>Es obvio que ganar premios no es una técnica de construcción de autoridad, porque ganarlos o perderlos no depende de ti, pero sí depende de ti presentarte a cada maldito concurso y certamen profesional que encuentres, y esto sí es una técnica de Media Authority Building.</p>\n\n\n\n<p>Te sorprenderías con la cantidad de premios que se ganan casi sin mover un dedo, muchas veces presentando trabajos realizados con anterioridad. Y te gustará saber que, en ocasiones, serás la única persona que se presente al concurso.</p>\n\n\n\n<p>Es cierto que no siempre será fácil y de vez en cuando tendrás que hacer trabajos exclusivos para un certamen, pero, en el peor de los casos, estos trabajos pueden engrosar la sección de muestras de tu portafolio. Y en el mejor, podrás presumir de ser un fuera de serie.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Cuantos más premios ganes, más colaboraciones estratégicas hagas y más obras publiques, más clientes conseguirás y más podrás subir tus tarifas.</p>\n</blockquote>\n\n\n\n<p>Y todo gracias a la bendita autoridad (y a este artículo, claro).</p>\n\n\n\n<h3 class=\"wp-block-heading\">4.9. Formas de contacto</h3>\n\n\n\n<p>¿De qué sirve todo el trabajo que hemos hecho hasta ahora si todos esos clientes a los que hemos convencido no saben cómo contactar con nosotros?</p>\n\n\n\n<p>Coloca un formulario de contacto al final de cada bloque de información del portafolio web. Usa un botón que destaque y que tenga una llama a la acción clara (por ejemplo, “Enviar mensaje”).</p>\n\n\n\n<p>Coloca también todos tus datos de contacto en el pie del portafolio web. Así estarán visibles para todo el mundo en todas las páginas de la web.</p>\n\n\n\n<p>Y, por último, diseña una página de contacto atractiva a la que pueda accederse desde cualquier lugar a través de un botón en el menú principal. Todas las facilidades son pocas cuando se trata de recibir clientes y contrataciones.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Comparte todas las formas de contacto a tu alcance: formulario, email, redes sociales, teléfono, fax, señales de humo, cuervo…</p>\n</blockquote>\n\n\n\n<p>Si el cliente al que acabas de convencer no encuentra la forma de contacto que utiliza habitualmente, puede que posponga contactarte y termine por olvidarse de ti.</p>\n\n\n\n<p>Este artículo está llegando a su fin. Pero para ti puede ser un gran nuevo comienzo.</p>\n\n\n\n<p>Espero que te vayas de aquí sabiendo qué es un portafolio y para qué sirve, conociendo los tipos de portafolios más populares, entendiendo las ventajas de un portafolio y dominando el arte de crear uno que dispare tu autoridad y tus ventas.</p>\n\n\n\n<p><strong>Referencias:</strong></p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Abrami, P., &amp; Barrett, H. (2005). Directions for Research and Development on Electronic Portfolios. <em>Canadian Journal Of Learning And Technology</em>, <em>31</em>(3). <a href=\"https://doi.org/10.21432/t2rk5k\" target=\"_blank\" rel=\"noreferrer noopener\">https://doi.org/10.21432/t2rk5k</a>&nbsp;</li>\n\n\n\n<li>Calimag, M. M. P. (2020). The ePortfolio. En <em>Advances in mobile and distance learning book series</em> (pp. 149-170). <a href=\"https://doi.org/10.4018/978-1-7998-4769-4.ch006\" target=\"_blank\" rel=\"noreferrer noopener\">https://doi.org/10.4018/978-1-7998-4769-4.ch006</a>&nbsp;</li>\n\n\n\n<li>Clarke University. (2022, 14 diciembre). <em>What is a Portfolio?</em> <a href=\"https://clarke.edu/academics/careers-internships/student-checklist/resume-writing-and-portfolios/what-is-a-portfolio/\" target=\"_blank\" rel=\"noreferrer noopener\">https://clarke.edu/academics/careers-internships/student-checklist/resume-writing-and-portfolios/what-is-a-portfolio/</a>&nbsp;</li>\n\n\n\n<li><em>The Open University</em>. (s. f.). <a href=\"https://help.open.ac.uk/create-professional-profile-portfolio-for-job-applications\">https://help.open.ac.uk/create-professional-profile-portfolio-for-job-applications</a>&nbsp;</li>\n</ol>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://es.wordpress.org/2025/01/17/que-es-un-portafolio-como-hacer-uno-para-ganar-autoridad/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"667295\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Meetup y WordCamp en España – Enero 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://es.wordpress.org/2025/01/01/meetup-y-wordcamp-en-espana-enero-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://es.wordpress.org/2025/01/01/meetup-y-wordcamp-en-espana-enero-2025/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Jan 2025 13:13:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=667095\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:280:\"Dicen que enero es un mes malo, en el que hay que subir una cuesta muy hacia arriba, con mucho frío y poco dinero en el bolsillo, ¿pero cuándo has hecho tú caso a lo que dicen los demás? Todo depende del prisma con el que se mire, y los de la comunidad de WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Cris Quintero\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8767:\"\n<p class=\"has-charcoal-0-color has-text-color has-link-color wp-elements-7cb2e9a005b8348ccdd73f8dad0dbae3\">Dicen que enero es un mes malo, en el que hay que subir una cuesta muy hacia arriba, con mucho frío y poco dinero en el bolsillo, ¿pero cuándo has hecho tú caso a lo que dicen los demás?</p>\n\n\n\n<p class=\"has-charcoal-0-color has-text-color has-link-color wp-elements-6043b122f77722f17d2fc32f0404ade8\">Todo depende del prisma con el que se mire, y los de la comunidad de WordPress nos caracterizamos por ir un poco a contracorriente, por lo que nuestro enero es más un mes de nuevos comienzos, nuevas oportunidades, nuevas quedadas con los colegas de las Meetup y nuevas WordCamp a las que ir a relacionarnos y a practicar el pasilleo que tanto nos gusta.</p>\n\n\n\n<p>Espero que estas navidades hayan sido divertidas, pero si no, no te preocupes, lo mejor siempre está por llegar&#8230; Y para muestra, un boton:</p>\n\n\n\n<h2 class=\"wp-block-heading has-charcoal-0-color has-text-color has-link-color wp-elements-95fc1befa35e863184bc14d77960fa10\" id=\"meetups_mesuales\">Meetup de enero de 2025</h2>\n\n\n\n<figure class=\"wp-block-table\"><table><thead><tr><th><strong>Fecha / Hora</strong></th><th><strong>Ciudad</strong></th><th><strong>Título del evento</strong></th><th><strong>Ponente</strong></th></tr></thead><tbody><tr><td>08/01/2025<br>18:30 h</td><td>Terrassa</td><td><a href=\"https://www.meetup.com/terrassa-wordpress-meetup/events/304951584\" target=\"_blank\" rel=\"noreferrer noopener\">Aprende a auditar WordPress para mejorar el rendimiento. ¡Casos reales!&nbsp;</a></td><td>Joan Vega</td></tr><tr><td>09/01/2025<br>19:00 h</td><td>Málaga</td><td><a href=\"https://www.meetup.com/wordpress-malaga/events/303564646\" target=\"_blank\" rel=\"noreferrer noopener\">JetEngine: No solo Custom Post Types</a></td><td>Delia Carballo</td></tr><tr><td>10/01/2025<br>19:00 h</td><td>Barcelona</td><td><a href=\"https://www.meetup.com/igualada-wordpress-meetup/events/304500450\" target=\"_blank\" rel=\"noreferrer noopener\">Preguntas y respuestas sobre WordPress &#8211; Christmas Edition</a></td><td>&#8211;</td></tr><tr><td>13/01/2025<br>20:00 h</td><td>Online</td><td><a href=\"https://www.meetup.com/es-ES/quedadas-wordpress-en-espanol/events/305332011/\" target=\"_blank\" rel=\"noreferrer noopener\">La estructura de todos nuestros proyectos de plugin a medida</a></td><td>Amadeu Arderiu</td></tr><tr><td>15/01/2025<br>19:00 h</td><td>Alcalá de Henares</td><td><a href=\"https://www.meetup.com/alcala-de-henares-wordpress-meetup-group/events/305346831\" target=\"_blank\" rel=\"noreferrer noopener\">¡Construyamos juntos la web de nuestra Meetup!</a></td><td>&#8211;</td></tr><tr><td>16/01/2025<br>19:00 h</td><td>Tarragona</td><td><a href=\"https://www.meetup.com/wordpresstarragona/events/305590059\" target=\"_blank\" rel=\"noreferrer noopener\">WordPress &amp; Beers – Enero 2025</a></td><td>&#8211;</td></tr><tr><td>17/01/2025<br>19:30 h</td><td>Ferrol</td><td><a href=\"https://www.meetup.com/ferrolterrawordpress/events/305514917\" target=\"_blank\" rel=\"noreferrer noopener\">Cómo empezar hoy mismo un negocio digital con WordPress</a></td><td>David Cuesta</td></tr><tr><td>22/01/2025<br>18:00 h</td><td>Cartagena</td><td><a href=\"https://www.meetup.com/wordpress-cartagena/events/305474893\" target=\"_blank\" rel=\"noreferrer noopener\">Descubre la magia interior de CHATGPT, primera meetup del 2025</a></td><td>Sergio Candela</td></tr><tr><td>22/01/2025<br>18:00 h</td><td>Irún</td><td><a href=\"https://www.meetup.com/irun-wordpress/events/305018324\">Irun WordPress Meetup: Episodio I &#8211; El despertar de&nbsp;la&nbsp;comunidad</a></td><td>&#8211;</td></tr><tr><td>22/01/2025<br>19:00 h</td><td>Ourense</td><td><a href=\"https://www.meetup.com/wordpressourense/events/305133594\" target=\"_blank\" rel=\"noreferrer noopener\">Domina el arte de la venta</a></td><td>Yolanda Pazos</td></tr><tr><td>23/01/2025<br>18:30 h</td><td>Madrid</td><td><a href=\"https://www.meetup.com/wordpress-madrid/events/305586529\" target=\"_blank\" rel=\"noreferrer noopener\">¿Cómo comenzar tu viaje como colaborador de WordPress?</a></td><td>Ha San</td></tr><tr><td>23/01/2025<br>18:30 h</td><td>Griñón</td><td><a href=\"https://www.meetup.com/wordpress-grinon/events/305482007\" target=\"_blank\" rel=\"noreferrer noopener\">No es solo tu Web, Es tu negocio: Aprende a atraer más clientes con SEO</a></td><td>Fernando López</td></tr><tr><td>23/01/2025<br>19:30 h</td><td>A Coruña</td><td><a href=\"https://www.meetup.com/wordpresscoruna/events/305473148\" target=\"_blank\" rel=\"noreferrer noopener\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f525.png\" alt=\"🔥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> Cómo crear un calendario de contenidos mensual para RRSS en menos de una hora</a></td><td>Úrsula Estévez</td></tr><tr><td>24/01/2025<br>18:00 h</td><td>Barcelona</td><td><a href=\"https://www.meetup.com/wordpressbcn/events/305589940\" target=\"_blank\" rel=\"noreferrer noopener\">Aprèn a auditar WordPress per a millorar el rendiment</a></td><td>Joan Vega</td></tr><tr><td>30/01/2025<br>18:30 h</td><td>Granollers</td><td><a href=\"https://www.meetup.com/wordpressgranollers/events/302266626\" target=\"_blank\" rel=\"noreferrer noopener\">Si no fas això, no sortiràs primer a Google</a></td><td>Toni Estirado</td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading has-charcoal-0-color has-text-color has-link-color wp-elements-e13198117574c44521cae03cb1d5d20f\">Próximas WordCamp y Eventos de 2025</h2>\n\n\n\n<p class=\"has-charcoal-0-color has-text-color has-link-color wp-elements-034e495a4001804f8324df71a7bdebb4\">En este mes de enero no hay ninguna WordCamp programada, pero sí un eventazo especial. Además, tenemos novedades (y muy jugosas) para ti&#8230;</p>\n\n\n\n<p>Ya se vislumbran en el horizonte algunos de los eventos más esperados del año, así que no dejes pasar mucho el tiempo y vete reservando ya las entradas, proponiéndote como voluntario, o como ponente, o como patrocinador&#8230; ¡Lo que veas, pero participa! Porque perderse cualquiera de estas citas debería estar penado legalmente.</p>\n\n\n\n<figure class=\"wp-block-table\"><table><thead><tr><th><strong>Fecha / Hora</strong></th><th><strong>Ciudad</strong></th><th><strong>Título del evento</strong></th></tr></thead><tbody><tr><td>16/01/2025<br>17:30 h</td><td>Valencia</td><td><a href=\"https://www.meetup.com/wordpress-valencia-meetup/events/303723034\" target=\"_blank\" rel=\"noreferrer noopener\">Las Dos Caras de la Inteligencia Artificial. WordPress Day Valencia</a><br>Eric Seguí y Fernando Tellado</td></tr><tr><td>14-15 de febrero de 2025</td><td>Zaragoza</td><td><a href=\"https://zaragoza.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp Zaragoza 2025</a></td></tr><tr><td>07-08 de marzo de 2025</td><td>Madrid</td><td><a href=\"https://madrid.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp Madrid, Spain</a></td></tr><tr><td>26-27 de abril de 2025</td><td>Málaga</td><td><a href=\"https://malaga.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp Málaga 2025</a></td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Meetup y WordCamp en otras fechas</h2>\n\n\n\n<p>Si quieres consultar los próximos eventos de la comunidad de WordPress (o los pasados), dale al botón de aquí abajo.</p>\n\n\n\n<p>Te llevaremos a una página donde encontrarás todas las Meetup, WordCamp y Eventos bien ordenaditos por meses:</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-2 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size is-style-fill has-eb-garamond-font-family\" style=\"font-size:24px\"><a class=\"wp-block-button__link has-white-color has-text-color has-background has-link-color wp-element-button\" href=\"https://es.wordpress.org/2024/09/10/meetups-y-wordcamps/\" style=\"border-radius:10px;background-color:#0073aa\">Ver todas las Meetup y WordCamp Programadas</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" style=\"margin-top:var(--wp--preset--spacing--40)\" />\n\n\n\n<p class=\"has-text-align-center\">Te animamos a que acudas a todos los eventos que puedas.<br><em>Porque la vida es más diver si se comparte.</em></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--30)\" />\n\n\n\n<p><em>* Este post se publica a principios de mes. Si das una ponencia que se haya anunciado más tarde y que no está en el listado, o ves que se me ha escapado incluir algún evento, deja un comentario aquí abajo y lo añado antes de que te des cuenta.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://es.wordpress.org/2025/01/01/meetup-y-wordcamp-en-espana-enero-2025/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"667095\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Cómo configurar la identificación en dos pasos (2FA) en WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://es.wordpress.org/2024/12/05/como-configurar-la-autenticacion-en-dos-pasos-2fa-en-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://es.wordpress.org/2024/12/05/como-configurar-la-autenticacion-en-dos-pasos-2fa-en-wordpress/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Dec 2024 10:51:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Seguridad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=667075\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"Guía paso a paso para mejorar la seguridad de tu sitio WordPress con la autenticación en dos pasos (2FA)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"fabiocchetti\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3821:\"\n<p>La seguridad en línea es más importante que nunca. En este artículo, exploraremos cómo agregar <strong>una de las medidas de seguridad más efectivas</strong> a tu sitio WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">¿Qué es la identificación en dos pasos (2FA)?</h2>\n\n\n\n<p>La autenticación en dos pasos (2FA), también conocida como identificación multifactor (MFA), es una medida de seguridad que requiere dos o más formas de identificación para iniciar sesión.</p>\n\n\n\n<p>El primer factor suele ser algo que conoces, como un nombre de usuario y contraseña. El segundo factor puede ser algo que posees (un dispositivo externo, un teléfono o una llave USB que genera un código de un solo uso) o algo inherente a ti (huella dactilar, reconocimiento facial o cualquier dato biométrico).</p>\n\n\n\n<p>La 2FA añade <strong>una capa extra de seguridad a tu cuenta</strong>. Incluso si alguien obtiene tus credenciales de inicio de sesión (el primer factor), aún necesitará el segundo factor para acceder, lo que dificulta enormemente que usuarios no autorizados entren a tu cuenta de administrador o editor en WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Cómo instalar y configurar la 2FA en tu sitio WordPress</h2>\n\n\n\n<h3 class=\"wp-block-heading\">1. Instala un plugin gratuito</h3>\n\n\n\n<p>Inicia sesión en el panel de control de WordPress y ve a «Plugins &gt; Añadir nuevo». Escribe «Two-Factor» en la barra de búsqueda, instala y activa el plugin.</p>\n\n\n\n<h3 class=\"wp-block-heading\">2. Configura el plugin</h3>\n\n\n\n<p>Después de activar el plugin, ve a «Usuarios &gt; Tu perfil» y localiza la nueva sección «Opciones de identificación en dos pasos». Aquí encontrarás diferentes métodos como correo electrónico, contraseña de un solo uso basada en tiempo (TOTP) y segundo factor universal (U2F).</p>\n\n\n\n<h3 class=\"wp-block-heading\">3. Selecciona y configura tu método preferido</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Método por correo electrónico:</strong> Simplemente asegúrate de que el correo asociado a tu cuenta de WordPress esté activo. Recibirás un código único por correo electrónico cada vez que inicies sesión.</li>\n\n\n\n<li><strong>Método TOTP:</strong> Requiere una aplicación de autenticación en tu dispositivo móvil como Google Authenticator, Microsoft Authenticator o Twilio Authy. Al seleccionar esta opción, se generará un código QR en la página. Escanéalo con tu app de identificación preferida, configúralo y úsala cada vez que inicies sesión.</li>\n\n\n\n<li><strong>Método U2F:</strong> Requiere una llave de seguridad física (USB) que deberás insertar en tu ordenador o tocar si es inalámbrica. Este método es probablemente el más seguro, pero necesitarás tener el dispositivo a mano cada vez que quieras iniciar sesión.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">4. Asegúrate de que todo funcione correctamente</h3>\n\n\n\n<p>Es crucial probar el método seleccionado para asegurarte de que funciona correctamente. Usa el botón «Probar» en la página de configuración del método de identificación habilitado.</p>\n\n\n\n<h3 class=\"wp-block-heading\">5. Descarga tus códigos de respaldo</h3>\n\n\n\n<p>El plugin «Two-Factor» te permite generar códigos de respaldo. Estos son esenciales si pierdes acceso a tu método principal de 2FA. Descárgalos y guárdalos en un lugar seguro.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Disfruta de tu cuenta protegida</h3>\n\n\n\n<p>Haz clic en «Actualizar perfil» al final de la página para confirmar la configuración. ¡Y listo! La próxima vez que inicies sesión en tu sitio WordPress, verás un paso adicional de identificación.</p>\n\n\n\n<p>Has añadido con éxito una capa extra de seguridad a tu sitio WordPress. Con la 2FA, reduces significativamente el riesgo de accesos no autorizados.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://es.wordpress.org/2024/12/05/como-configurar-la-autenticacion-en-dos-pasos-2fa-en-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"667075\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n		\n		\n					\n		\n		\n		\n				\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Meetup y WordCamp en España – Diciembre 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://es.wordpress.org/2024/12/01/meetup-wordcamp-diciembre-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://es.wordpress.org/2024/12/01/meetup-wordcamp-diciembre-2024/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Dec 2024 12:13:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=667021\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:294:\"Si no eres de esos que viven en la España vaciada y te asomas ahora mismo a la ventana, seguramente notes un fogonazo tan potente que te haga recular y volver a meterte en tu oscura y calentita cueva. No, no te busca la poli (espero), simplemente es que el tiempo pasa, ya estamos en [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Cris Quintero\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10655:\"\n<p class=\"has-black-color has-text-color has-link-color wp-elements-b079969bc17f264b2be2e139b208eca5\">Si no eres de esos que viven en la España vaciada y te asomas ahora mismo a la ventana, seguramente notes un fogonazo tan potente que te haga recular y volver a meterte en tu oscura y calentita cueva.</p>\n\n\n\n<p>No, no te busca la poli (espero), simplemente es que el tiempo pasa, ya estamos en diciembre (sí, hijo, sí) y las calles se han petado de luces más brillantes de lo que podemos soportar y de gente que acude desesperada al llamado, como Carol Anne en un día sin tele.</p>\n\n\n\n<p>¡Venga, hay que ir espabilando!, que te quedan dos telediarios para comprar cosas reguleras para sorprender a gente que agradecería más que le dieras un sobre con los dinerinchis (seamos sinceros).</p>\n\n\n\n<p>Y, si tenemos en cuenta la cantidad de eventos de WordPress que tienes para apuntarte en el calendario de adviento, entre Meetup, comidas y cenas navideñas de los diferentes grupos, me da a mí que vas un poquito pillado de tiempo&#8230;</p>\n\n\n\n<p>¡Apunta!</p>\n\n\n\n<h2 class=\"wp-block-heading has-black-color has-text-color has-link-color wp-elements-4a694e9d6e2ea491fcb9000975af64cf\" id=\"meetups_mesuales\">Meetup de diciembre de 2024</h2>\n\n\n\n<figure class=\"wp-block-table\"><table><thead><tr><th><strong>Fecha / Hora</strong></th><th><strong>Ciudad</strong></th><th><strong>Título del evento</strong></th><th><strong>Ponente</strong></th></tr></thead><tbody><tr><td>03/12/2024<br>18:30 h</td><td>Bilbao</td><td><a href=\"https://www.meetup.com/wordpress-bilbao/events/304264349\" target=\"_blank\" rel=\"noreferrer noopener\">Comienza a ser rebelde y a decir que NO</a></td><td>Ibon Azkoitia</td></tr><tr><td>03/12/2024<br>18:30 h</td><td>Terrassa</td><td><a href=\"https://www.meetup.com/terrassa-wordpress-meetup/events/303762662\" target=\"_blank\" rel=\"noreferrer noopener\">Bases para construir interfaces y buscadores semánticos con IA en WordPress</a></td><td>Amadeu Arderiu y Ana Cirujano</td></tr><tr><td>04/12/2024<br>17:00 h</td><td>Castellón</td><td><a href=\"https://www.meetup.com/meetup-wordpress-castello/events/304827935\" target=\"_blank\" rel=\"noreferrer noopener\">Posicionamiento SEO con WordPress</a></td><td>&#8211;</td></tr><tr><td>04/12/2024<br>19:00 h</td><td>Ourense</td><td><a href=\"https://www.meetup.com/wordpressourense/events/304382444\">10 accións que DEBES FACER se queres ARRUINAR a túa páxina web</a></td><td>Anxo Sánchez</td></tr><tr><td>05/12/2024<br>20:00 h</td><td>Las Palmas de Gran Canaria</td><td><a href=\"https://www.meetup.com/wordpress-las-palmas-de-gran-canaria/events/304810053\" target=\"_blank\" rel=\"noreferrer noopener\">Vulnerabilidades en WordPress: Pesadilla antes de Navidad</a></td><td>Néstor Angulo</td></tr><tr><td>06/12/2024<br>18:30 h</td><td>Palma de Mallorca</td><td><a href=\"https://www.meetup.com/mallorca-wordpress-meetup/events/304566279\" target=\"_blank\" rel=\"noreferrer noopener\">WordPress &amp; Cañas</a></td><td>&#8211;</td></tr><tr><td>12/12/2024<br>18:30</td><td>Mataró</td><td><a href=\"https://www.meetup.com/es-ES/wordpress-mataro/events/304875321/\">¡Torna la Meetup Mataró!</a></td><td>&#8211;</td></tr><tr><td>12/12/2024<br>19:30</td><td>A Coruña</td><td><a href=\"https://www.meetup.com/wordpresscoruna/events/304756112\" target=\"_blank\" rel=\"noreferrer noopener\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f525.png\" alt=\"🔥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> Marketing de guerrilla para cuando estás empezando (y no tienes ni un duro)</a></td><td>Sergio Ramírez</td></tr><tr><td>13/12/2024<br>18:00 h</td><td>Barcelona</td><td><a href=\"https://www.meetup.com/wordpressbcn/events/304777550\" target=\"_blank\" rel=\"noreferrer noopener\">Cómo la IA comprende el mundo: Una introducción a los embeddings</a></td><td>Amadeu Arderiu, Joan Rodas y Albert Tarrés</td></tr><tr><td>13/12/2024<br>19:00 h</td><td>Igualada</td><td><a href=\"https://www.meetup.com/igualada-wordpress-meetup/events/304500450\" target=\"_blank\" rel=\"noreferrer noopener\">Preguntas y respuestas sobre WordPress &#8211; Christmas Edition</a></td><td>&#8211;</td></tr><tr><td>13/12/2024<br>19:00 h</td><td>Pontevedra</td><td><a href=\"https://www.meetup.com/es-ES/pontevedra-wordpress-meetup/events/304857908/\" target=\"_blank\" rel=\"noreferrer noopener\">Crea tu podcast desde cero (sin gastar ni una rupia)</a></td><td>María José Bermúdez (Seu)</td></tr><tr><td>13/12/2024<br>21:00 h</td><td>Málaga</td><td><a href=\"https://www.meetup.com/es-ES/wordpress-malaga/events/304917655/\" target=\"_blank\" rel=\"noreferrer noopener\">Quedada navideña en Málaga</a></td><td>&#8211;</td></tr><tr><td>18/12/2024<br>18:00</td><td>Sevilla</td><td><a href=\"https://www.meetup.com/wordpress-sevilla/events/305046773\" target=\"_blank\" rel=\"noreferrer noopener\">Paseo fotográfico navideño + francachela</a></td><td>Nilo Vélez</td></tr><tr><td>18/12/2024<br>18:00</td><td>Cartagena</td><td><a href=\"https://www.meetup.com/wordpress-cartagena/events/305004248\" target=\"_blank\" rel=\"noreferrer noopener\">Reels y Tiktoks que Petan : Creación,Estructura y Edición</a></td><td>Patricia Rodrigues</td></tr><tr><td>18/12/2024<br>19:00</td><td>Lugo</td><td><a href=\"https://www.meetup.com/wordpresslugo/events/304986290\" target=\"_blank\" rel=\"noreferrer noopener\">Este Nadal envía algo que ninguén espera&#8230; e feito con WordPress!</a></td><td>Carlos Longarela</td></tr><tr><td>18/12/2024<br>19:00</td><td>Alcalá de Henares</td><td><a href=\"https://www.meetup.com/alcala-de-henares-wordpress-meetup-group/events/304897952\" target=\"_blank\" rel=\"noreferrer noopener\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f384.png\" alt=\"🎄\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2728.png\" alt=\"✨\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> Meetup Networking y Cena Navideña <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2728.png\" alt=\"✨\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f384.png\" alt=\"🎄\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a></td><td>&#8211;</td></tr><tr><td>18/12/2024<br>19:30</td><td>Santiago de Compostela</td><td><a href=\"https://www.meetup.com/santiago-de-compostela-wordpress-meetup-group/events/304595443\" target=\"_blank\" rel=\"noreferrer noopener\"><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f92f.png\" alt=\"🤯\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> Te propongo un reto: Dime tu proyecto y te diré cómo hacer la web</a></td><td>Ángel Cabaleiro</td></tr><tr><td>19/12/2024<br>18:30</td><td>Bilbao</td><td><a href=\"https://www.meetup.com/wordpress-bilbao/events/305012634\" target=\"_blank\" rel=\"noreferrer noopener\">Joakim Navarro: Cómo consumir y procesar datos abiertos de WordPress</a></td><td>Joakim Navarro</td></tr><tr><td>19/12/2024<br>18:30</td><td>Valencia</td><td><a href=\"https://www.meetup.com/wordpress-valencia-meetup/events/304811975\" target=\"_blank\" rel=\"noreferrer noopener\">¡Último meetup del año 2024! WordPress &amp; Beers</a></td><td>&#8211;</td></tr><tr><td>19/12/2024<br>19:00</td><td>Vigo</td><td><a href=\"https://www.meetup.com/vigo-wordpress-meetup/events/305092692\" target=\"_blank\" rel=\"noreferrer noopener\">El bienestar corporativo y como multiplicar los resultados de la empresa</a></td><td>Ricardo Velasco</td></tr><tr><td>19/12/2024<br>19:45</td><td>Griñón</td><td><a href=\"https://www.meetup.com/es-ES/wordpress-grinon/events/304857877/\" target=\"_blank\" rel=\"noreferrer noopener\">Bebida y Picoteo en Griñón ¿Te apuntas?</a></td><td>&#8211;</td></tr><tr><td>20/12/2024<br>19:30</td><td>Ferrol</td><td><a href=\"https://www.meetup.com/ferrolterrawordpress/events/305001469\" target=\"_blank\" rel=\"noreferrer noopener\">Cómo marcarnos objetivos y cumplirlos</a></td><td>Marga Carballo</td></tr><tr><td>23/12/2024<br>20:00 h</td><td>Online</td><td><a href=\"https://www.meetup.com/es-ES/quedadas-wordpress-en-espanol/events/304828516/\">Quedada Navideña 2024</a></td><td>&#8211;</td></tr></tbody></table></figure>\n\n\n\n<p class=\"has-black-color has-text-color has-link-color wp-elements-caea12212bfb707b9bbddc09fd52de59\">Por un tema de organización, y para ayudarte un poquito con la digestión durante las fiestas, los eventos especiales y las WordCamp se van a tomar un descansito hasta el año que viene, que suena a muy lejos, pero si cuentas en días, no es para tanto, no te agobies&#8230;</p>\n\n\n\n<h2 class=\"wp-block-heading has-black-color has-text-color has-link-color wp-elements-4842d4c9b495ccc41710fb733f5c3322\">Meetup y WordCamp en otras fechas</h2>\n\n\n\n<p>Vale, que te pica el gusanillo y quieres saber qué eventos de la comunidad de WordPress hay programados (o los que te has perdido)&#8230; No tienes más que darle al botón de aquí abajo.</p>\n\n\n\n<p>Aterrizarás en una página donde encontrarás todas las Meetup, WordCamp y Eventos bien ordenaditos por meses:</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-3 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size is-style-fill has-eb-garamond-font-family\" style=\"font-size:24px\"><a class=\"wp-block-button__link has-white-color has-text-color has-background has-link-color wp-element-button\" href=\"https://es.wordpress.org/2024/09/10/meetups-y-wordcamps/\" style=\"border-radius:10px;background-color:#0073aa\">Ver todas las Meetup y WordCamp Programadas</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" style=\"margin-top:var(--wp--preset--spacing--40)\" />\n\n\n\n<p class=\"has-text-align-center\">Te animamos a que acudas a todos los eventos que puedas.<br><em>Porque la vida es más diver si se comparte, sobre todo en Navidad</em>.</p>\n\n\n\n<p class=\"has-text-align-center\"><strong>¡Felices Fiestas!</strong><br><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f3b6.png\" alt=\"🎶\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <em>Fun fun fun</em> (leído en inglés es, sin duda, es más diver)</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--30)\" />\n\n\n\n<p><em>* Este post se publica a principios de mes. Si das una ponencia que se haya anunciado más tarde y que no está en el listado, o ves que se me ha escapado incluir algún evento, deja un comentario aquí abajo y lo añado antes de que te des cuenta.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://es.wordpress.org/2024/12/01/meetup-wordcamp-diciembre-2024/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"667021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Publicación de recomendaciones para mejorar la inclusividad en los eventos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://es.wordpress.org/2024/11/28/publicacion-de-recomendaciones-para-mejorar-la-inclusividad-en-los-eventos/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://es.wordpress.org/2024/11/28/publicacion-de-recomendaciones-para-mejorar-la-inclusividad-en-los-eventos/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Nov 2024 09:24:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:13:\"Accesibilidad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Comunidad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=666687\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Cómo se creó el documento sobre recomendaciones para la inclusividad en eventos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Joakim Navarro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4189:\"\n<p>En mi opinión, y no soy el único, <strong>es importante que nuestra comunidad sea proactiva e inclusiva</strong>, asegurando que todas las personas, independientemente de sus diferencias, se sientan bienvenidas y apoyadas en eventos como las WordCamps. Así que, con la mirada puesta en el próximo vento, comencé a reflexionar sobre cómo podríamos mejorar, especialmente en términos de <strong>accesibilidad e inclusividad</strong>.</p>\n\n\n\n<p>Como parte de este proceso, decidí ponerme en contacto con Elena Fenoll, una valiosa integrante de la comunidad que además, es autista y Doctora en Educación Inclusiva  y con la que ya había tenido gratas interacciones, para recoger sus ideas y sugerencias.</p>\n\n\n\n<p>Pronto me di cuenta que las pautas compartidas no solo eran realmente útiles para mejorar nuestra WordCamp, sino que también tenían el potencial de servir como un texto inspirador para toda la comunidad.</p>\n\n\n\n<p>Inicialmente, pensamos en publicarlas directamente en el blog. Sin embargo, tras una reunión con el área de marketing, procedimos a realizar el quinto punto de un artículo previo que habíamos redactado: transformar esas recomendaciones del artículo, en una guía completa.</p>\n\n\n\n<p>Coincidimos en vislumbrar la oportunidad de<strong> crear un recurso valioso siempre a mano</strong> y descargable que facilitaría a organizadores a priorizar la accesibilidad y la inclusión en sus propios eventos por todo el territorio español, y quién sabe si más allá.</p>\n\n\n\n<p>Es aquí cuando decidimos incorporar a Eneko Garrido, otro activo contribuidor de la comunidad WordPress, también en el espectro autista.</p>\n\n\n\n<p>Elena y Eneko se pusieron manos a la obra y ampliaron y mejoraron sustancialmente el texto inicial, además de dotarlo de un formato guía más elaborado. Acto seguido, recogí su trabajó y lo transformé en un PDF más vistoso, listo para su potencial impresión y distribución.</p>\n\n\n\n<p>A Marta Torre, de Diversidad, también le gustó la propuesta y nos ayudó a subirla a los repositorios Git de documentación, además de enseñarnos cómo funcionan estos procesos de validación a nivel interno.</p>\n\n\n\n<p>En este punto, fue el equipo de Documentación el que nos dio las pautas necesarias para, por fin, poder subir el documento a su correspondiente sección dentro de los manuales, a través de GitHub con formato markdown.</p>\n\n\n\n<p>Cabe decir que la comunidad de WordPress es orgánica, siempre cambiante, y algunos de estos procesos están aún por hacer (¡cualquiera puede ser un pionero/a!) por lo que <strong>hubo un interesante debate</strong> que se resolvió con su ubicación adecuada y las revisiones pertinentes. Cabría destacar la entrega y la guía de Josep Morán, Javier Casares, Rocío Valdivia y Nilo Vélez.</p>\n\n\n\n<p>¡Ta-da! El documento ya se subió al repositorio con todas las aprobaciones y correcciones pertinentes. Lo podéis encontrar ya publicado aquí: <a href=\"https://es.wordpress.org/team/handbook/eventos/inclusion/\">Eventos más inclusivos</a>.</p>\n\n\n\n<p>Ya para terminar, el equipo de Marketing ya había accedido a que publiquemos este post del blog, que servirá tanto para anunciar la iniciativa y la disponibilidad del documento (ya oficial), como para describir el proceso colaborativo que una propuesta de estas características atraviesa por varios niveles de la comunidad WordPress.</p>\n\n\n\n<p>Álvaro Torres fue el que proactivamente nos contactó y el que inmediatamente me dio acceso como autor al panel de control del blog. </p>\n\n\n\n<p>Como colofón, me gustaría destacar que la comunidad WordPress hispana ofrece infinitas posibilidades para contribuir y crecer por el camino. Involucrarte te permite no solo aportar tus habilidades y conocimientos, sino también aprender, enfrentando desafíos y descubriendo nuevas áreas de interés.</p>\n\n\n\n<p>Además, es una oportunidad única para conectar con personas apasionadas y diversas, cada una con sus propias historias y experiencias. A través de estas interacciones, no solo amplías tu red, sino que también <strong>encuentras inspiración y apoyo</strong> en un entorno colaborativo y enriquecedor.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"https://es.wordpress.org/2024/11/28/publicacion-de-recomendaciones-para-mejorar-la-inclusividad-en-los-eventos/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"666687\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:82:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WordPress 6.7.1 – Actualización de mantenimiento\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://es.wordpress.org/2024/11/21/wordpress-6-7-1-actualizacion-de-mantenimiento/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://es.wordpress.org/2024/11/21/wordpress-6-7-1-actualizacion-de-mantenimiento/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Nov 2024 16:27:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:15:\"Actualizaciones\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Mantenimiento\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"6.7.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://es.wordpress.org/?p=667036\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:419:\"¡Ya está disponible WordPress 6.7.1! Esta versión menor incluye 16 correcciones de errores en todo el núcleo y el editor de bloques . WordPress 6.7.1 es una versión de continuidad rápida que se centra estrictamente en los errores introducidos en WordPress 6.7. La próxima versión importante será la 6.8 , prevista para abril de 2025 . Si tienes sitios que admiten actualizaciones automáticas [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Fernando Tellado\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8798:\"\n<h2 class=\"wp-block-heading\">¡Ya está disponible WordPress 6.7.1!</h2>\n\n\n\n<p>Esta versión menor incluye 16 correcciones de errores <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.7.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">en todo el núcleo</a> y <a href=\"https://github.com/WordPress/wordpress-develop/pull/7851\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">el editor de bloques</a> .</p>\n\n\n\n<p>WordPress 6.7.1 es una versión de continuidad rápida que se centra estrictamente en los errores introducidos en WordPress 6.7. La próxima versión importante será <a href=\"https://make.wordpress.org/core/6-8/\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">la 6.8</a> , <a href=\"https://make.wordpress.org/core/2024/11/19/proposal-major-releases-for-2025/\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">prevista para abril de 2025</a> .</p>\n\n\n\n<p>Si tienes sitios que admiten actualizaciones automáticas en segundo plano, el proceso de actualización comenzará automáticamente.</p>\n\n\n\n<p>Puedes <a href=\"https://es.wordpress.org/latest.zip\" rel=\"nofollow\">descargar WordPress 6.7.1 desde WordPress.org</a> o visitar su escritorio de WordPress, hacer clic en «Actualizaciones» y luego en «Actualizar ahora».</p>\n\n\n\n<p>Para obtener más información sobre esta versión, <a href=\"https://wordpress.org/support/wordpress-version/version-6-7-1\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">visita el centro de ayuda</a> . Puedes encontrar un resumen de las actualizaciones de mantenimiento de esta versión en el <a href=\"https://make.wordpress.org/core/?p=116365\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">anuncio de la versión candidata a definitiva</a> .</p>\n\n\n\n<h2 class=\"wp-block-heading\">Gracias a estos colaboradores de WordPress</h2>\n\n\n\n<p>Esta versión la lideraron <a href=\"https://profiles.wordpress.org/desrosj/\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">Jonathan Desrosiers</a> y <a href=\"https://profiles.wordpress.org/cbravobernal/\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">Carlos Bravo</a> .</p>\n\n\n\n<p>WordPress 6.7.1 no hubiera sido posible sin las contribuciones de las siguientes personas. Su coordinación asincrónica para entregar correcciones de mantenimiento en una versión estable es un testimonio del potencial y la capacidad de la comunidad de WordPress.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/abcsun/\">abcsun</a> , <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> , <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> , <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> , <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a> , <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> , <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> , <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> , <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a> , <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> , <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> , <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a> , <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> , <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> , <a href=\"https://profiles.wordpress.org/dhewercorus/\">dhewercorus</a> , <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> , <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> , <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a> , <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> , <a href=\"https://profiles.wordpress.org/flixos90/\">Félix Arntz</a> , <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a> , <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> , <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> , <a href=\"https://profiles.wordpress.org/glynnquelch/\">glynnquelch</a> , <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> , <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> , <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> , <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> , <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a> , <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> , <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> , <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> , <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn , </a><a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> , <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> , <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> , <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> , <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> , <a href=\"https://profiles.wordpress.org/leecollings/\">Sotavento Collings</a> , <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> , <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> , <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> , <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> , <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> , <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> , <a href=\"https://profiles.wordpress.org/369work/\">miroku</a> , <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> , <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> , <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> , <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> , <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> , <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> , <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a> , <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> , <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> , <a href=\"https://profiles.wordpress.org/room34/\">room34</a> , <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> , <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> , <a href=\"https://profiles.wordpress.org/sailpete/\">Sailpete</a> , <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> , <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> , <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> , <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a> , <a href=\"https://profiles.wordpress.org/sppramodh/\">SP Pramodh</a> , <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> , <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a> , <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> , <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a> , <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a> , <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> , <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a> , <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> , <a href=\"https://profiles.wordpress.org/yowangdu/\">YoWangdu</a> , <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> y <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Cómo contribuir</h2>\n\n\n\n<p>Para participar en el desarrollo del núcleo de WordPress, dirígete al Trac, <a href=\"https://core.trac.wordpress.org/report/6\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">selecciona un ticket</a> y únete a la conversación en los canales <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">#core</a> y <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">#6-8-release-leads</a> . ¿Necesitas ayuda? Consulta el <a href=\"https://make.wordpress.org/core/handbook/\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">manual del colaborador del núcleo</a> .</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://es.wordpress.org/2024/11/21/wordpress-6-7-1-actualizacion-de-mantenimiento/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"667036\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:30:\"https://es.wordpress.org/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096054\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 14 Feb 2025 14:58:07 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 11 Feb 2025 20:25:51 GMT\";s:4:\"link\";s:61:\"<https://es.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1727767220;s:21:\"cache_expiration_time\";i:1739588287;s:23:\"__cache_expiration_time\";i:1739588287;}", "off");
INSERT INTO `webpyme_options` VALUES("2032", "_transient_timeout_feed_mod_69c933d8a78805efd0abe985766ffb51", "1739588287", "off");
INSERT INTO `webpyme_options` VALUES("2033", "_transient_feed_mod_69c933d8a78805efd0abe985766ffb51", "1739545087", "off");
INSERT INTO `webpyme_options` VALUES("2034", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1739588288", "off");
INSERT INTO `webpyme_options` VALUES("2035", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Do The Woo Community: Friday Shares: Back in 2025 v9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=90887\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://dothewoo.io/blog/friday-shares-back-in-2025-v9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"A bit ago I announced the end of Friday Shares but, due to community feedback, will continue them alongside a new newsletter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Feb 2025 11:41:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matt: Scale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=137506\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://ma.tt/2025/02/scale/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:340:\"<p>In high school when 5% of your class doesn&#8217;t like you it&#8217;s like 3-5 people. </p>\n\n\n\n<p>Running a company of 1,700+ when 5% doesn&#8217;t like you, that&#8217;s 85 people! That fills a room. </p>\n\n\n\n<p>150k followers and 5% don&#8217;t like you now you have a small stadium of 7,500 people. </p>\n\n\n\n<p>It&#8217;s still 5%.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Feb 2025 00:40:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: Woo Marketplace Hits 1000 Extensions—What’s Next?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=90625\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/woo-marketplace-hits-1000-extensions-whats-next/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:263:\"BobWP announces the WooCommerce Marketplace hitting 1,000 extensions and shares updates on streamlined workflows and quicker approvals within 1-4 days. WooCommerce is accepting both free and freemium products, encouraging builders to submit their extensions here.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Feb 2025 12:26:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Do The Woo Community: Building WordPress Agency Habits with Cami MacNamara\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=90590\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://dothewoo.io/building-wordpress-agency-habits/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:232:\"In this first episode of WP Agency Tracks, hosts Marcus Burnette and Cami McNamara discuss effective habits for agency owners, focusing on time management, mental health, and community engagement to enhance productivity and success.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Feb 2025 09:45:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WordCamp Central: WordCamp Mukono 2025: A Celebration of WordPress and Women in Tech\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://central.wordcamp.org/?p=9547410\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"https://central.wordcamp.org/news/2025/02/wordcamp-mukono-2025-a-celebration-of-wordpress-and-women-in-tech/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11035:\"<h2 class=\"wp-block-heading has-text-align-center\">Welcome to the Pearl of Africa’s first WordCamp 2025!</h2>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/02/Home-scaled.jpg\" alt=\"\" />\n\n\n\n<p>Uganda, known as the Pearl of Africa, is a land of breathtaking landscapes, diverse cultures, and warm hospitality. Within this vibrant country lies <strong>Mukono</strong>, a fast-growing town known for its dynamic community, top-tier educational institutions, and entrepreneurial spirit. Mukono is not just a town—it is a hub of ideas, innovation, and collaboration.</p>\n\n\n\n<p>This Year, Mukono will host one of the most anticipated WordPress events in East Africa: <a href=\"https://mukono.wordcamp.org/2025/\">WordCamp Mukono 2025</a>. This gathering of WordPress enthusiasts, developers, designers, marketers, and content creators will take place on <strong>March 8, 2025</strong>, at the <a href=\"https://www.google.com/search?client=firefox-b-d&q=mukono+synod+hall&sei=nfuqZ53JM4ewhbIP6MmCqQc\">Synod Hall Mukono</a>, near <a href=\"https://www.bishopss.com/\">Bishop’s Senior School</a>.<br /><br />The Venue has been specifically selected to accommodate everyone. This is the easiest venue to get to Ever.  It is in the CBD and in a serene and quiet environment. You will not be suffering from Noise Pollution. Whether you&#8217;re a seasoned WordPress professional, an aspiring entrepreneur, a curious beginner, or someone passionate about technology and community building, this event is designed for you.</p>\n\n\n\n<h2 class=\"wp-block-heading has-text-align-center has-medium-font-size\">A Theme That Matters: WP HERoes – Women Powering the WordPress Universe</h2>\n\n\n\n<p>For WordCamp Mukono 2025, we are embracing a powerful and transformative theme: “<strong>WP HERoes: Women Powering the WordPress Universe</strong>”. This year’s event is dedicated to celebrating, empowering, and amplifying the voices of women in the WordPress community. Women have played a pivotal role in shaping WordPress, from coding and design to content creation and community leadership. However, their contributions often go unnoticed.</p>\n\n\n\n<p>At WordCamp Mukono 2025, we will shine a spotlight on these incredible women—the <strong>HER</strong>oes—who are making WordPress a more inclusive, innovative, and vibrant ecosystem. Just as Mukono is a center for education and opportunity, this event aims to foster growth, learning, and collaboration among WordPress users of all backgrounds. We believe that when diverse voices are heard and empowered, the entire community thrives.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Why Attend WordCamp Mukono 2025?</strong></h3>\n\n\n\n<p>This is more than just another tech conference. <a href=\"https://mukono.wordcamp.org/2025/\">WordCamp Mukono 2025</a> is a place where ideas spark, collaborations begin, and knowledge is shared. Here’s what you can expect:</p>\n\n\n\n<h3 class=\"wp-block-heading has-text-align-center\"><strong>World-Class Speakers and Engaging Sessions</strong></h3>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/02/Speakerlst.jpg\" alt=\"\" />\n\n\n\n<p><strong>Prepare to be inspired!</strong> We are bringing together an incredible lineup of local and international speakers who will share their expertise on various aspects of WordPress. Whether you&#8217;re new to WordPress or an advanced user, there&#8217;s something for everyone:<br /><br /><strong>Design &amp; User Experience (UX)</strong> – Master the art of crafting visually stunning and user-friendly websites.<br /><strong>Business &amp; Digital Marketing</strong> – Explore strategies for freelancers, bloggers, and entrepreneurs looking to monetize their WordPress skills.<br /><strong>Women in Tech</strong> – Hear firsthand stories of empowerment, success, and resilience from female leaders in the WordPress community.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Unmatched Networking Opportunities</h4>\n\n\n\n<p>WordCamp Mukono 2025 is not just an event—it’s an experience. It’s a rare opportunity to meet like-minded individuals, expand your professional network, and forge lasting collaborations. Whether you’re looking for a mentor, business partner, or simply want to connect with fellow WordPress enthusiasts, this is the place to be.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Hands-On Learning &amp; Workshops</h4>\n\n\n\n<p>Our workshops are designed to be interactive and practical, giving you hands-on experience with WordPress tools and technologies. Learn from seasoned experts and walk away with real-world skills you can apply immediately.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Showcasing Mukono: A City of Growth and Culture</h4>\n\n\n\n<p>Mukono is a blend of urban convenience and natural beauty. From its bustling markets to its serene landscapes, Mukono offers a unique experience for visitors. If you’re traveling from outside the town, you’ll find comfortable accommodations ranging from budget-friendly guesthouses to upscale hotels.<br />We encourage attendees to arrive early and explore Mukono—its culture, food, and hospitality will make your visit even more memorable!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Event Details: When and Where?</h2>\n\n\n\n<p><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4cd.png\" alt=\"📍\" class=\"wp-smiley\" /> Location:</strong> <a href=\"https://maps.app.goo.gl/rir2trT2GUuGb2kK8\">Synod Hall Mukono</a>, near Bishop’s Senior School<br /><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" /> Date:</strong> March 8, 2025<br /><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f465.png\" alt=\"👥\" class=\"wp-smiley\" /> Capacity: </strong>Over 400 attendees<br /><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> Tickets:</strong> <a href=\"https://mukono.wordcamp.org/2025/tickets/\">Buy Tickets Here</a> (Limited slots available—get yours now!)</p>\n\n\n\n<p><br /><a href=\"https://mukono.wordcamp.org/2025/location/\">Our venue</a>, Synod Hall Mukono, is a spacious and well-equipped location with excellent lighting, ventilation, and accessibility. Its proximity to Mukono’s central business district makes it the perfect setting for an event of this magnitude.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Be a Part of Something Bigger: Sponsorship Opportunities</h2>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/01/Sponsors.jpg\" alt=\"\" />\n\n\n\n<p>WordCamp Mukono 2025 is made possible through the generosity of <a href=\"https://mukono.wordcamp.org/2025/sponsors/\">sponsors</a> who believe in empowering the WordPress community. If your company or organization wants to gain exposure while supporting a great cause, we invite you to <a href=\"https://mukono.wordcamp.org/2025/call-for-sponsors/\">become a sponsor!</a></p>\n\n\n\n<h4 class=\"wp-block-heading\">Sponsorship offers unique benefits, including: </h4>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2705.png\" alt=\"✅\" class=\"wp-smiley\" /> <strong>Brand Visibility </strong>– Reach a targeted audience of WordPress professionals and enthusiasts. <br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2705.png\" alt=\"✅\" class=\"wp-smiley\" /> <strong>Community Engagement</strong> – Connect with potential customers, partners, and talent. <br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2705.png\" alt=\"✅\" class=\"wp-smiley\" /> <strong>Networking &amp; Recruitment </strong>– Identify and engage with skilled WordPress developers, designers, and marketers.</p>\n\n\n\n<p><strong>Interested in sponsoring? Learn more here: <a href=\"https://mukono.wordcamp.org/2025/call-for-sponsors/\">https://mukono.wordcamp.org/2025/call-for-sponsors/</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading has-text-align-center\">Accommodation &amp; Travel Tips</h2>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/02/Accomodation-2.jpg\" alt=\"\" />\n\n\n\n<p>Mukono offers a variety of accommodation options, from budget guesthouses to high-end hotels. If you’re traveling from outside Mukono, we recommend booking early to secure the best options near the venue. For more details, visit: <a href=\"https://mukono.wordcamp.org/2025/accommodation-guide-for-visitors-to-mukono-town/\">Location Post</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Secure Your Spot – Get Your Ticket Today!</h2>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/02/Tickets-scaled.jpg\" alt=\"\" />\n\n\n\n<p><a href=\"https://mukono.wordcamp.org/2025/tickets-now-available/\">Tickets for WordCamp</a> Mukono 2025 are now available! We offer different ticket categories, including:<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> Regular Ticket – <strong>UGX 15,000. </strong>Each ticket includes access to all sessions, networking opportunities, swag, refreshments, and a truly unforgettable experience!<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> Actual Cost Ticket – <strong>UGX 100,000. </strong>Each ticket includes access to all sessions, networking opportunities, swag, refreshments, and a truly unforgettable experience! A ticket for people who love and Support wordPress and want to ensure that the Event moves super smoothly.<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> Reserve your spot today: <a href=\"https://mukono.wordcamp.org/2025/tickets/\">Click Here</a></p>\n\n\n\n<p><strong>Join the WordCamp Mukono 2025 Movement!</strong><br />WordCamp Mukono 2025 is more than just an event—it’s a movement that celebrates WordPress, women in tech, and the power of community. Whether you&#8217;re a beginner, expert, entrepreneur, or enthusiast, there is something for you.</p>\n\n\n\n<p><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4ac.png\" alt=\"💬\" class=\"wp-smiley\" /> Let’s start the conversation! Use the official hashtags:</strong><br />#WCMukono25 #WordPressMukono #WPHeroes #WomenInWordPress</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4e7.png\" alt=\"📧\" class=\"wp-smiley\" /> Contact Us: mukono@wordcamp.org<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f310.png\" alt=\"🌐\" class=\"wp-smiley\" /> Official Website: <a href=\"https://mukono.wordcamp.org/2025\">https://mukono.wordcamp.org/2025/</a><br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> Tickets Info: <a href=\"https://mukono.wordcamp.org/2025/tickets/\">Buy Tickets Here</a> (Limited slots available—get yours now!)<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f91d.png\" alt=\"🤝\" class=\"wp-smiley\" /> Sponsorship: <a href=\"https://mukono.wordcamp.org/2025/call-for-sponsors-wordcamp-mukono/\">https://mukono.wordcamp.org/2025/call-for-sponsors-wordcamp-mukono/</a><br /><strong>See you in Mukono for an unforgettable WordPress celebration!</strong></p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Feb 2025 08:53:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Moses Cursor Ssebunya\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Matt: Hash tables\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=137372\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2025/02/hash-tables/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"<p>“You didn’t just come up with a cool hash table,” he remembers telling Krapivin. “You’ve actually completely wiped out a 40-year-old conjecture!” <a href=\"https://www.quantamagazine.org/undergraduate-upends-a-40-year-old-data-science-conjecture-20250210/\">There&#8217;s a delightful article on an undergraduate discovering an optimization in a very basic computer science principle</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 22:03:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Gravatar: Simplify Link Sharing With Smart Redirects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2877\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://blog.gravatar.com/2025/02/12/simplify-link-sharing-with-smart-redirects/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4108:\"<p>You know what&#8217;s better than easy-to-share links? Easy-to-share links on your own custom domain. </p>\n\n\n\n<p>We just rolled out Smart Redirects for all Gravatar custom domains. Zero setup required.</p>\n\n\n\n<p><em>And right now, we&#8217;re offering free custom domains for your first year.</em> </p>\n\n\n\n<h2 class=\"wp-block-heading\">What Are Smart Redirects?</h2>\n\n\n\n<p>They&#8217;re simple shortcuts that make sharing your online presence a breeze. Add the name of any of your verified services to the end your domain:</p>\n\n\n\n<pre class=\"wp-block-preformatted\"><code>your-name.link/bluesky<br />your-name.link/linkedin<br />your-name.link/calendar</code></pre>\n\n\n\n<p>That&#8217;s it. Your domain automatically redirects to your connected accounts. No configuration. No DNS wizardry. Just connect your accounts to Gravatar and the redirects work instantly.</p>\n\n\n\n<p>These are perfect for email signatures, business cards, social media profiles, and more.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Simplified Payments With /pay</h2>\n\n\n\n<p>Here&#8217;s something cool: Smart Redirects make sharing payment links much nicer. Instead of dropping a long payment URL in your messages or emails, just use:</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-group has-global-padding is-layout-constrained wp-block-group-is-layout-constrained\">\n<pre class=\"wp-block-preformatted\"><code>your-name.link/pay</code></pre>\n\n\n\n<p>This currently works with:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>PayPal</li>\n\n\n\n<li>Venmo</li>\n\n\n\n<li>Crypto currencies</li>\n\n\n\n<li>Custom (any link you want)</li>\n</ul>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<img width=\"490\" height=\"374\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/02/cleanshot-2025-02-12-at-12.55.50402x.png\" alt=\"\" class=\"wp-image-2885\" />\n</div>\n</div>\n\n\n\n<p>Just add your payment details to your Gravatar profile, and your /pay link automatically directs people to all of your preferred payment methods. Perfect for freelancers, creators, splitting the bill among friends, or anyone who needs to receive payments.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Free Domain? Tell Me More</h2>\n\n\n\n<p>For a limited time, claim your .link, .bio, or .social domain (or choose from other popular TLDs) through Gravatar. Just log in to your dashboard and look for the domain claim option at the top of your profile. Free for the first year. </p>\n\n\n\n<p>Once you have your domain, Smart Redirects are automatically enabled. No extra steps needed.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Available Now</h2>\n\n\n\n<p>Smart Redirects work with most major platforms including GitHub, LinkedIn, Bluesky, Mastodon, Tumblr, and many more. We&#8217;ve also added handy shortcuts for your calendar (/calendar), contact (/contact), and payment info (/pay).<br /></p>\n\n\n\n<h2 class=\"wp-block-heading\">Getting Started</h2>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Claim your free domain (if you haven&#8217;t already)</li>\n\n\n\n<li>Connect your accounts in your Gravatar profile</li>\n\n\n\n<li>Start sharing your shorter, sweeter links</li>\n</ol>\n\n\n\n<p>And fun fact: both <code><em>/twitter</em></code> and <code><em>/x</em></code> work for your X profile. We&#8217;ve got you covered either way.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Why Your Own Domain Matters</h2>\n\n\n\n<p>Your domain is your identity on the open web. It&#8217;s not just for your Gravatar profile – use it everywhere to build your presence and own your digital footprint. And with Smart Redirects, it&#8217;s now even more useful.</p>\n\n\n\n<p>Want to see all the available redirects and learn more? Check out our <a href=\"https://support.gravatar.com/smart-redirects\">Smart Redirects guide</a>.</p>\n\n\n\n<p>Smart Redirects are live for all <a href=\"https://gravatar.com/custom-domains\">Gravatar custom domains</a>. And remember, domains are free for your first year. Go ahead, claim yours and give Smart Redirects a try!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 19:52:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: #156 – Derek Ashauer on Analytics Options and Privacy Challenges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=187359\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/podcast/156-derek-ashauer-on-analytics-options-and-privacy-challenges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:57075:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, analytics options and privacy challenges for WordPress site owners.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast, player of choice. Or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Derek Ashauer.</p>\n\n\n\n<p>Having spent over 15 years in the WordPress arena, Derek has transitioned from building client sites to creating specialized WordPress plugins. Today we get to hear about his journey creating Conversion Bridge, a tools specifically designed to streamline the process of implementing analytics platforms and conversion tracking on WordPress websites.</p>\n\n\n\n<p>We start with an overview of analytics, tracing its evolution from the simple server logs of the early internet days, to the sophisticated data gathering mechanisms provided by Google Analytics and others.</p>\n\n\n\n<p>We explore how the introduction of European privacy laws has significantly impacted the data landscape, challenging marketers and businesses to adapt to a new era where data privacy is regarded differently in different locales.</p>\n\n\n\n<p>Derek offers his perspectives on this rapidly changing field, discussing the rise of modern privacy focused analytics platforms like Fathom, Plausible and others. He explains how these technologies employ cookieless tracking techniques to respect user privacy, while still providing valuable insights for website owners.</p>\n\n\n\n<p>We also address the problem of data accessibility and user privacy. Derek, sharing his personal views as a marketer, acknowledges the complexity of balancing effective marketing strategies with ethical data use. He explains his thoughts on why modern solutions might strike a better balance, ensuring that user data remains private, while allowing businesses to glean just the insights they need.</p>\n\n\n\n<p>Whether you are managing a WooCommerce store, or building sites for clients, Derek&#8217;s insights into conversion tracking will be of interest. He talks about some of the hurdles site builders face with traditional systems and how Conversion Bridge simplifies conversion tracking across various platforms and plugins without the need for extensive coding.</p>\n\n\n\n<p>If you&#8217;re an agency, developer, or digital marketer, this discussion will help equip you with the knowledge and strategies to navigate the ever evolving landscape of web analytics.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast. Where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Derek Ashauer.</p>\n\n\n\n<p>I am joined on the podcast by Derek Ashauer. How you doing, Derek?</p>\n\n\n\n<p>[00:03:40] <strong>Derek Ashauer:</strong> I am doing well, thank you so much.</p>\n\n\n\n<p>[00:03:41] <strong>Nathan Wrigley:</strong> Thank you very much for joining me. We&#8217;ve had various chats over the years, but this is going to be a chat that we&#8217;ve never had before. This is going to be all about analytics.</p>\n\n\n\n<p>We&#8217;ll talk about all of the different bits and pieces, perhaps get into the future of analytics, the past of analytics, who knows? But stay with us, dear listener. It&#8217;s going to be a really interesting conversation. I feel like things are at a bit of an inflection point, and people definitely have strong opinions on this, and I think that can often lie on geographical grounds, where you live in the world and things like that.</p>\n\n\n\n<p>So before we get into that conversation, Derek, do you just want to give us a little potted bio? Tell us who you are.</p>\n\n\n\n<p>[00:04:15] <strong>Derek Ashauer:</strong> Yeah, my name&#8217;s Derek Ashauer, I&#8217;m in Colorado US. I&#8217;ve been in the WordPress community for, well, I guess I&#8217;ve been working with WordPress for about 15 years, I think. Doing client sites and things like that. So I&#8217;ve done the independent freelancer agency, but now I&#8217;ve moved to making WordPress plugins. So I have one for photographers called Sunshine Photo Cart.</p>\n\n\n\n<p>But my big one that I&#8217;m working on lately is called Conversion Bridge, which really makes it easy to add analytics platforms to your WordPress website, and also make it really easy to do conversion tracking, which is something that a lot of agencies and people are building sites for clients just neglect to do. And one reason why is because it&#8217;s kind of a pain in the butt.</p>\n\n\n\n<p>So the goal is to make it a lot easier so that I can do it for myself, and my client sites that I&#8217;ve worked on, but also then to make it easier for everyone else. So that&#8217;s how I got the idea for that.</p>\n\n\n\n<p>[00:05:02] <strong>Nathan Wrigley:</strong> Prior to hitting the record button, Derek and I were saying that, you are on a journey with this, you know, you&#8217;re not putting yourself up here as the definitive authority. I think you were basically saying that a little while ago your knowledge was not that deep in this arena and you&#8217;ve really had to educate yourself. And I think it&#8217;s fair to say that you were trying to summarise it as you&#8217;re still learning.</p>\n\n\n\n<p>So let&#8217;s have a conversation about this and see where we end up. The thought occurs to me that if we were to go back, oh gosh, I mean the internet, every time I say this sentence the internet does obviously get a little bit older, but let&#8217;s go for 20 years, something like that. I feel that if you went to a website, there wasn&#8217;t even the thought that there was any kind of analytics. Maybe there was some server log somewhere that was recording that, okay, we served up a page, but that was about it.</p>\n\n\n\n<p>And then at some point analytics software came along and very quickly started to leverage all of the existing technologies and became really, really sophisticated ever so quickly. You would copy and paste a code, and it was typically Google, I think that dominated the arena right from the outset. They offered a free service, Google Analytics. You could copy and paste one line of code. There was no barrier to entry to that technology. And it would give you all sorts of fascinating information really quickly.</p>\n\n\n\n<p>I think everybody was happy with that status quo, but in the more recent past, let&#8217;s say decade or so, but definitely it seems to be ramping up at the moment. There seems to be concerns about who gets the data, why is this data necessary? Is this data consumable by, I don&#8217;t know, an American company looking at a European who&#8217;s browsing on a particular website and things like that?</p>\n\n\n\n<p>With all of this, just give us your overarching opinion on it, and then we can go from there. What&#8217;s the state of play at the moment with analytics? Where are we? The year 2025 at the moment. Do you have any sort of overarching insight into where analytics, in air quotes, is at the moment?</p>\n\n\n\n<p>[00:06:55] <strong>Derek Ashauer:</strong> Yeah, it&#8217;s a lot harder because of the European privacy laws for the analytics platforms to get the data that marketers and other people have been used to for a long time. Where people came from, you used to be able to get like exactly what search terms people were looking at and landed on your site and what they did. You know, if someone searched Fort Collins landscaper, local landscape company could see that that&#8217;s exactly what they searched, and then what that user did on their website from that search term. And that&#8217;s just kind of gone. That deep level of data is unfortunately not possible anymore to follow those type of European laws, and privacy restrictions and things like that. So there&#8217;s a lot of people who are struggling to get the data that they were used to. That&#8217;s kind of the short of it, I guess.</p>\n\n\n\n<p>[00:07:40] <strong>Nathan Wrigley:</strong> Do you think that we kind of let the horse escape from the barn a little bit, and we&#8217;re now just trying to get the horse back into the barn and get it under control again? And what I mean by that is, do you think that these technologies, the analytics and what have you, do you think it kind of just crept up upon us? There was this slow but inexorable extension of what analytics software could do. And all the while it felt like completely benign, you know, there&#8217;s no problem with it. How could anybody possibly make use of this in a way which might be harmful or, I don&#8217;t know, intrusive or what have you?</p>\n\n\n\n<p>So the software became more and more clever. But then I think people, especially like you said on the European side of things, started to take a look at it and thought, hmm, it&#8217;s interesting, a lot of this data is going to, in many cases, big North American companies. Google, I suppose would be a perfect example, but you&#8217;ve obviously got other things like Facebook and what have you.</p>\n\n\n\n<p>Just try to maybe restore something a bit more where the user is in control, as opposed to these giant corporations being in control. So just trying to bring it back to the starting line, if you like, to the moment before the horse got out so that we can reestablish some rules.</p>\n\n\n\n<p>So, I don&#8217;t know. It sounds from what you were saying as if you&#8217;re kind of regretful that the analytics solutions can&#8217;t do what they once could. I suppose the European argument would be, well, that&#8217;s because it never really, with hindsight, we should never have let it get that far in the first place. What&#8217;s your thoughts on that?</p>\n\n\n\n<p>[00:09:07] <strong>Derek Ashauer:</strong> I mean, I kind of see it. The way I often describe a lot of things is like a pendulum swing. In the beginning it went really far in one direction, we got all kinds of data, and then the laws popped up and now it feels like, we can&#8217;t get nearly enough data for advanced marketing, for large corporations that are really doing massive campaigns.</p>\n\n\n\n<p>And then there&#8217;s the alternatives, Fathom, Plausible, Pirsch, you know, lots of great, Usermaven. There&#8217;s a lot of new alternative analytics platforms now that are out there, and now finding clever ways to claw back some of that.</p>\n\n\n\n<p>It&#8217;s never going to be nearly as detailed as it was a decade ago, that was kind of like the heyday of marketing where you could get so much great data on stuff. But you know, so we had too much maybe in some people&#8217;s opinions, and then maybe there&#8217;s a bit of not enough, and now those companies are finding some ways to move maybe towards a middle ground of what works for everyone.</p>\n\n\n\n<p>And as an American, I&#8217;m like, yeah, whatever. You saw that I visited these several websites in a row, I really don&#8217;t care. That never really bothered me, I haven&#8217;t understood the massive problem with it.</p>\n\n\n\n<p>Going through all this, I have learned, you know, maybe there&#8217;s a few spots where it would be good to protect that and maybe they don&#8217;t know that but, yeah, I&#8217;m the person that does accept all on every single website that I got to as a marketer, because I&#8217;m just like, yeah, great, I&#8217;ll give this website some data on me, I don&#8217;t mind.</p>\n\n\n\n<p>[00:10:20] <strong>Nathan Wrigley:</strong> Yeah, you&#8217;ve got a very open mind to all of that, haven&#8217;t you? And obviously, you are digging into this and your business is kind of largely tied up to that, so very understandable position to have.</p>\n\n\n\n<p>You mentioned there several platforms, and you rattled them off one after another, Fathom and others. So a lot of these will be unfamiliar, I think, to this audience. What is the proposition?</p>\n\n\n\n<p>So it sounds like many of them are quite new. What is it that they bring to the table, and are these SaaS based products, or are in some cases a WordPress plugin? Or something that can install on your own hardware? What&#8217;s going on there? Just rattle off those names again and maybe just give us the low down on what they do, and how they&#8217;re getting into the market, and competing against giants like Google.</p>\n\n\n\n<p>[00:11:01] <strong>Derek Ashauer:</strong> Yeah, so there&#8217;s definitely some great new options and a lot of the initial ones were SaaS based. So there&#8217;s ones, like I said, Plausible, Fathom, Usermaven, Pirsch is another great one that I really enjoy. My plugin Conversion Bridging integrates with like 12 different analytics platforms, so there&#8217;s tons of them, and there&#8217;s still many more that I have on my list to do. So there&#8217;s lots of alternatives, which there weren&#8217;t any before, until Google Analytics 4 kind of came out and people were like, we don&#8217;t like GA4, and that opened the door for a lot of platforms.</p>\n\n\n\n<p>But to get back to your question, yeah, one of the differences that they offer is they do what&#8217;s called cookieless tracking. So that&#8217;s one of the big things that the privacy laws in Europe were like, it was around cookies and tracking the cross websites. So that the user, they go to landscaper website, then they go, no, I&#8217;m going to go to Home Depot and I&#8217;m going to look for my own lawnmower, and now I&#8217;m going to price check against Lowe&#8217;s and all these different things. And Google Analytics could see where they were going, and all these different places. Or Facebook ads could track all these different websites that they went to and gauge this type of person and who they are and what they&#8217;re shopping for and things like that. So trying to crack down on that.</p>\n\n\n\n<p>Well, these alternative platforms do it without cookies. They have a way, a method, without getting too technical of just basically fingerprinting the user, and know for that one session when they&#8217;re on your website, what they&#8217;re doing. But then it stops there. It doesn&#8217;t go to all the other websites and give your entire four hours you were online, and all the different websites that you&#8217;re browsing to a company to let them know what you&#8217;re doing everywhere.</p>\n\n\n\n<p>So that&#8217;s kind of their main offering. And they are SaaS, you know, they&#8217;re just like Google Analytics, but they do cost. So that&#8217;s, they can be affordable. They&#8217;re anywhere, I think there&#8217;s some that are like $6, $7 a month for what a basic blog would ever need, up to $50 to, or even $100 a month depending on the amount of traffic, which is hard to reconcile for a lot of people who were used to free Google Analytics.</p>\n\n\n\n<p>So it&#8217;s hard to make that leap when you&#8217;re going, wait, I could do Google Analytics for free and there&#8217;s some countries, and even like a state or two in the US that have some laws where it&#8217;s like, erm, what&#8217;s the setup involved in that? There might be law violations, simply by using Google Analytics you could be violating some of those things in a couple countries.</p>\n\n\n\n<p>But there are some setups you can do to try and make it work with European privacy laws and stuff. Takes some extra work. But it&#8217;s a challenge. Is it worth it? We&#8217;ve been so used to, for 20 years, for having free analytics to then now suddenly switch and pay for analytics can be hard for some site owners.</p>\n\n\n\n<p>Or as if you&#8217;re an agency doing that to convince your client&#8217;s like, well, we should actually start paying for this. And because you get 200,000 visits a month, it&#8217;s going to cost you $100 a month. They go, or I could use the free version. Yeah, well, I&#8217;ll just stick to the free version. So it is, it&#8217;s a hard conversation to have. When is it worthwhile? It just really depends on, I mean, you&#8217;ve got to really try it out.</p>\n\n\n\n<p>[00:13:44] <strong>Nathan Wrigley:</strong> I suppose no matter how wonderful the staff at Google are, they&#8217;re not in the business of losing money. And so I&#8217;m guessing that at some point the pendulum does swing in Google&#8217;s favor. So what might be free at the point of use, so in other words, you download a snippet from Google, and you put it into the back end of your website, or you pay, let&#8217;s say $20 a month, or $50 a month, or whatever. I&#8217;m guessing that Google are doing quite well, let&#8217;s say, in terms of the data that they gather, and the way that they can use that themselves. Or, I don&#8217;t know if they sell that data onto any other brokers or what have you. But presumably there&#8217;s that concern.</p>\n\n\n\n<p>Just going back to what you said about these other, and I&#8217;m going to use modern platforms, let&#8217;s go for that, the ones that you mentioned. You said fingerprinting, and I&#8217;ve heard this phrase before, and I have the merest idea of what that means. So Google Analytics traditionally came about with a cookie, and we get what that is. But what are the ways around that, that fingerprinting, well, essentially, what is fingerprinting? What are some examples of how that works?</p>\n\n\n\n<p>[00:14:40] <strong>Derek Ashauer:</strong> Yeah, it&#8217;s a term that I just use in this moment. It&#8217;s not necessarily a term that you&#8217;ll see as you go around, it&#8217;s just the word that came out. But it&#8217;s just a way to uniquely identify somebody through various different points. You check these five different things about a person, and because of exactly what they are, those five elements, then we can say, that&#8217;s this person. So that&#8217;s kind of, each platform, I call them alternative platforms, you said modern platforms, they have their slightly different way of doing it, but they have their way of identifying without using cookies.</p>\n\n\n\n<p>So the traditional way is like Google Analytics, you set a cookie, random value in the browser, and then every time they go to a new page, you just check for that cookie and that value. That&#8217;s how we know they are, because that&#8217;s how we know who they are. Again, the modern platforms are doing it every time the page loads, it&#8217;s saying, who is this again? Let&#8217;s check these five points. I think sometimes it&#8217;s browser, it&#8217;s various different elements that they&#8217;ll check to then determine who that person is, and then know who you are as you go down the path on the website, but it&#8217;s not setting cookies to do that.</p>\n\n\n\n<p>[00:15:38] <strong>Nathan Wrigley:</strong> So what kind of information might it be? I mean, I can imagine an obvious one would be things like, okay, what browser are you using, for example? That might be one indicator, and then if you match that with another indicator, and then a third one, and a fourth one, over four or five different indicators, you are going to be, well, what are the chances that that&#8217;s a different person?</p>\n\n\n\n<p>[00:15:58] <strong>Derek Ashauer:</strong> General location, stuff like that, yeah. Using this specific browser, this version of their browser. In my stuff, I haven&#8217;t fully identified what those platforms are actually using. I&#8217;ve just kind of, at this point left it. They do cookieless tracking, they have a way of doing it, okay great.</p>\n\n\n\n<p>Some are better than others. To be honest, there are, Fathom has improved this. I know it was a struggle when I started Conversion Bridge about a year ago. For example, when someone landed on your page and then they did a conversion, say they fill out a form or made a purchase 10 pages later, those two weren&#8217;t associated with, because it was just one page view at a time, wholly independent things. They couldn&#8217;t tell that you are that person on that page view, and that person on that page view. I actually did this, I think last week just to check in on them, and it actually did finally say, okay, yeah, that was the same person. That came in and did that. So yeah, they&#8217;re finding ways to make it work and better identify those across one website.</p>\n\n\n\n<p>[00:16:50] <strong>Nathan Wrigley:</strong> Yeah, is the promise of these platforms though that they are different, or are they trying without cookies to get back to the point where cookies were? In other words, a cookie, until it was cleared out, could literally follow you everywhere. You know, it would know which website you&#8217;d been to, and could last for a long, long time and all of those concerns.</p>\n\n\n\n<p>Is the intention of these other analytics platforms to sort of step away from that and say, okay, we&#8217;re going to track you on this one domain. So if you&#8217;ve got example.com as your domain, and it&#8217;s an e-commerce store, whilst you&#8217;re there, our platform will keep an eye on you, and we&#8217;ll learn if you have gone through a bunch of pages, and whether you&#8217;ve converted and bought a thing or not. But once you step away from that domain, that&#8217;s it, we are done with you.</p>\n\n\n\n<p>Or do you get the intention that they are somehow just, humans always figure out a way, right? If we give them enough time, they&#8217;ll figure out a way. Is the intention for these other platforms, do you perceive that they would like to get to the point where cookies were?</p>\n\n\n\n<p>[00:17:45] <strong>Derek Ashauer:</strong> No. They&#8217;re number one selling point, I think if you went to the homepage of every single one of them is they do privacy first analytics, is like the banner thing. That&#8217;s what they&#8217;re offering. And that&#8217;s why it&#8217;s so much bigger in Europe than it is here in the US and North America and stuff like that.</p>\n\n\n\n<p>But, yeah, that&#8217;s their main thing, their privacy focused analytics. Google Analytics alternatives that are privacy focused is their main draw. I think someone reminded me of, Katie Keith from Barn2, she reminded me of the story from Fathom. They specifically sent Google Analytics a cake to thank them for being so bad at what they do that they allowed them to create a whole industry as an alternative to them. Stuff like that. So, I think they&#8217;re trying to do the privacy focused stuff, and then backfill in the features to give people as much data as they possibly can that they were used to in Google Analytics.</p>\n\n\n\n<p>[00:18:39] <strong>Nathan Wrigley:</strong> You said earlier, and we&#8217;ll just touch on this briefly, you said earlier that, the implication of what you said, and you may not have meant this, but I&#8217;ll say it as if you are saying it, and then you can criticise whatever I say. It sounds like, if you could rewind the clock and get rid of the European legislation and what have you, you would do that, and you&#8217;d be happy with that position. You are okay with being tracked and all bets are off. So firstly, let&#8217;s address that. Would you be okay with all of that?</p>\n\n\n\n<p>[00:19:03] <strong>Derek Ashauer:</strong> I think there&#8217;s got to be a balance between the two. I get that there&#8217;s, you know, for me it&#8217;s a thing. I don&#8217;t care if you know all the different things of where I went. You know, you see those futuristic movies where it&#8217;s individualised ads on video screens, and I&#8217;m like, that&#8217;s actually kind of cool. It helps give me gift ideas for my wife, stuff like that, because I&#8217;m a terrible gift giver. So, yeah, recommend me some products. I wouldn&#8217;t have thought to do that. I&#8217;ve bought things off of ads I&#8217;ve seen on Facebook or Twitter, things like that. Because I was like, that was a great gift for my dad. I never would&#8217;ve purposely found that if I hadn&#8217;t been shown that ad because for whatever reason, so I&#8217;m not against that personally.</p>\n\n\n\n<p>[00:19:37] <strong>Nathan Wrigley:</strong> My guess though is that it&#8217;s not really that that&#8217;s the problem in most people&#8217;s minds. It&#8217;s like, who&#8217;s holding that data, and where does that data get moved to? Just the idea that, as an example, there might be a data broker firm who may purchase that data. And in some cases, let&#8217;s imagine that you ended up on a website which you regret going to. You can read into that, dear listener, whatever you like. But you end up somewhere and all of a sudden connections are made between you as a person. And you can also imagine scenarios in which, I don&#8217;t know, data gets linked from various data brokers and they start to create an impression of who you are.</p>\n\n\n\n<p>I can imagine scenarios where that could get out of hand, and potentially come back to bite you as an individual. So I suppose there&#8217;s a little bit of that muddled up in it. It&#8217;s not that the business, the WooCommerce store or whatever, is going to have any nefarious reason to have that data. Or wish to know where you&#8217;ve come from, where you&#8217;re going to, what ad you might have clicked on, what were the previous page that you came from, and so on and so forth.</p>\n\n\n\n<p>It&#8217;s more that there just seems to be this fairly bizarre industry of data brokers who managed to get their hands on this data, and at that moment, you don&#8217;t know what&#8217;s going to happen with it. And we&#8217;ve all made mistakes in life, but we can erase them just with the passage of time. But with the advent of the internet, some of those mistakes might stick with us for a long time. Does that make any sense?</p>\n\n\n\n<p>[00:21:04] <strong>Derek Ashauer:</strong> No, it makes sense. I mean, I could see how someone would visit, again, visit the landscaper website, and all of a sudden they did not know that the fact that they went to a landscaper website was sent to Meta. They&#8217;re like, well, I didn&#8217;t know that was, I was going to a landscaper website. Why does Meta need to know that I was checking out who was going to cut my grass?</p>\n\n\n\n<p>I get that in some regards, that there&#8217;s just not a knowledge of where things are going. I think it&#8217;s a pretty safe thing to say that cookie popups, that was just not the right way to go about it. That&#8217;s just made things, made the internet significantly worse. What are the solutions to give website owners the data they need to make good marketing decisions?</p>\n\n\n\n<p>Because otherwise, I mean, I think of it even on a bigger macro level that that landscaper, if they don&#8217;t know any of the ads are working or what&#8217;s going on or what people are doing, then they don&#8217;t know what ads, where to spend their money that works best. Now they have to increase their costs to cover the blanket marketing that they have to do because they don&#8217;t know exactly what attribution, what marketing channel is actually working for them. So to pay for the 50 different marketing channels they have to do, they have to increase the cost for everybody.</p>\n\n\n\n<p>So if they were able to narrow it down and say, well, we know that mailers and these Google ads are actually our best ways to make money, we don&#8217;t need to spend on email newsletter, or all these different things, our marketing spends only 5% of what it would be otherwise, that means we don&#8217;t have to charge as much.</p>\n\n\n\n<p>So it goes to bigger macro level discussions of economics of, in some ways for the consumer, it could be better for these companies to have some data about you.</p>\n\n\n\n<p>But I understand what you&#8217;re saying though. It is like, again, I don&#8217;t want Meta to have it, I want the landscaper company to have it. That&#8217;s okay. And that&#8217;s the line that I think a lot of people, I think would agree that, yeah, I don&#8217;t want Meta to have that data but, yeah, I&#8217;m okay with my local landscaper having the data so they knew what ads worked and things like that.</p>\n\n\n\n<p>And those privacy or the modern analytics platforms do at least get you a good amount of that data. So they are some good alternatives to that. But it&#8217;s not going to get you, those mega corporations are not going to get the, okay, well they clicked on our ad, they went to these other places, then came back to our site, and then did this and they came back to site, and then did this and came back to our site. And to get those really deep analytics. They&#8217;re not going to and that&#8217;s the challenge. But I would say, the WordPress space, that&#8217;s 90% of people are going to do fantastic with modern analytics platforms and get the data that they need.</p>\n\n\n\n<p>[00:23:29] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s really interesting because you are owning the domain, you&#8217;re running the domain, you probably don&#8217;t have any interest in brokering the data out to Facebook anyway. So what you can get out of that is probably useful. We&#8217;ll dig into that in a moment.</p>\n\n\n\n<p>I&#8217;m just curious, being a resident in the USA, and I&#8217;m obviously, you can tell by my accent, I&#8217;m based in the UK, we may have, and I don&#8217;t know if we do, we may have a very different experience of browsing the internet.</p>\n\n\n\n<p>I, for my part, if I was to open up a brand new browser, clean out everything that&#8217;s ever happened in that browser and start again, and browse around a whole variety of websites, I am inundated with cookie banners. Go to any large property, I am going to see cookie banners a lot, a very significant amount of the time because that&#8217;s how it goes over here.</p>\n\n\n\n<p>They can be confusing. They can be deliberately confusing. And in some cases they can be eye wateringly difficult to understand. The language is inverted so that you are kind of clicking on something you didn&#8217;t intend to click on. There can be so many options. I mean, it is really remarkable how many options there can be. You open up this little popup and you scroll, and you scroll, and you scroll, and you scroll, and you could do that whole scroll thing for like a whole minute and you still haven&#8217;t run out of options. And so we are living through this, and I don&#8217;t know if it&#8217;s the same where you are, I don&#8217;t know if you encounter any of this stuff.</p>\n\n\n\n<p>[00:24:51] <strong>Derek Ashauer:</strong> I definitely see them, but it&#8217;s not on every single website because those cookie banners can be configured so that they can be region specific. So if someone is located in a space where there are no laws around that, then just don&#8217;t show on the banner. And I happen to be in that one. So there&#8217;s some that aren&#8217;t as complex that have that feature, and so I still will see those. But I mean, yeah, it&#8217;s not every single website. Honestly not sure how many, but I would say maybe 50%.</p>\n\n\n\n<p>[00:25:16] <strong>Nathan Wrigley:</strong> Yeah, I mean, if I was going to a website which is just purely, I don&#8217;t know, informational in content, it&#8217;s like a blog basically, then I&#8217;m sure I won&#8217;t see those kind of things because, what possible thing could they be doing? But if it&#8217;s a website where there&#8217;s some sort of login option or an option where they clearly are using analytics and they&#8217;re intending to sell that on, you do get bombarded with, there&#8217;s so many things that you can opt into and opt out of. It&#8217;s bizarre.</p>\n\n\n\n<p>[00:25:40] <strong>Derek Ashauer:</strong> Yeah, it&#8217;s a challenge. And it&#8217;s definitely an area that I am working on with my plugin and stuff, and trying to wrap my head around and understand to help guide people on it. But that&#8217;s one great thing about like the modern ones. For example, if you use Plausible, you do not need a cookie banner because of Plausible. You don&#8217;t need one. It doesn&#8217;t set cookies. It doesn&#8217;t use cookies. So just because you have analytics doesn&#8217;t mean you have to have a cookie banner.</p>\n\n\n\n<p>And that&#8217;s one thing I think is something that some people may not understand. You may need it for other reasons, depending on what you have going on your site. But there are sites where you just, I think there&#8217;s a lot of sites that have cookie banners that don&#8217;t actually need them because they&#8217;re so terrified of the EU cookie laws or those privacy laws that they&#8217;re like, it&#8217;s better to be safe than sorry. Lets just throw it up there and put it on there, CYA type stuff, cover your ass. Let&#8217;s just put it on there so that we don&#8217;t have to worry about it.</p>\n\n\n\n<p>But Google Analytics is a little like, probably should but, you know, if you are using one of those alternatives, that analytics platform, just that itself does not mean you have to have a cookie banner. And so it&#8217;s worth investigating to see if you could switch to alternatives. Some of them have free plans that you could stay within for a website, have your clients set up their own account. And if they have very small usage then use their free plan, and stick under that limit. And then you don&#8217;t even need a cookie banner on their site. And that can help annoy their visitors less. It&#8217;s something definitely worth investigating.</p>\n\n\n\n<p>[00:27:04] <strong>Nathan Wrigley:</strong> I think what I&#8217;ve noticed is that, and I could be wrong about this, my intuition though, because I see the same UI often. The cookie banner is clearly provided by the same company. Everything is the same apart from the choices that you can make, but obviously at some point they&#8217;ve ticked boxes and what have you. And it does feel a little bit like that. We don&#8217;t have the capacity to figure out what we really need to do, so what we&#8217;ll do is just enable every single option. Here&#8217;s all the choices that we could possibly provide.</p>\n\n\n\n<p>And of course that itself, that feels very self-defeating. Looking at it from the end user perspective, no matter what you think about the legislation and the merits of it, the fact that every single one of us is being caught up in this sort of dragnet of clicking away, rejecting cookies and what have you. That does seem like something which is not a good experience. I mean, I don&#8217;t know how many hours humanity wastes every day rejecting cookie banners.</p>\n\n\n\n<p>[00:27:57] <strong>Derek Ashauer:</strong> I mean, yeah, the cookie banners is a whole other thing. In my opinion it should be, if you&#8217;re going to do it, it should be in the browser. There should be a setting in the browser and the analytics code snippet that you have obeys the browser setting so that there&#8217;s not, there should be no need for independent, every single website owner to do their own remediation of, you know, through cookie banners of doing all this kind of stuff.</p>\n\n\n\n<p>It&#8217;s bonkers to me when every single website, if every single website needs to follow this, then put it at the browser level. You can just configure in your browser, in Chrome, say, I want to accept marketing cookies and I want to not accept these types of cookies or whatever, and then call it done. And every website you go to then just includes Google Analytics, includes whatever thing. It just can look at the browser settings and follow that, and you&#8217;re done. And it saves everyone thousands of dollars, hours of headache and all this kind of stuff, and it is what it is.</p>\n\n\n\n<p>[00:28:47] <strong>Nathan Wrigley:</strong> It sounds like a very sensible position. I&#8217;m just wondering, is that a clarion call that is in the industries that you are following, the analytics and the marketing side of things, is that something that&#8217;s gaining momentum or no?</p>\n\n\n\n<p>[00:28:59] <strong>Derek Ashauer:</strong> I haven&#8217;t heard of any movement to actually make that happen. I don&#8217;t know why I haven&#8217;t looked into it too much, but I haven&#8217;t read in the stuff that I&#8217;ve come across and reading and learning about it on my journey through this and educating myself about it. To me it seems like a pretty simple approach.</p>\n\n\n\n<p>[00:29:12] <strong>Nathan Wrigley:</strong> Let&#8217;s imagine a scenario in which cookies across the board are just outlawed universally for this kind of thing in the future. And obviously that&#8217;s not something that you would desire, but let&#8217;s just imagine a scenario where that was the case.</p>\n\n\n\n<p>As you call them, these modern solutions, if we were to bind that, let&#8217;s say into WooCommerce website, and obviously with Conversion Bridge, you&#8217;re all about the conversion. Does somebody arriving at the website end up doing a particular action? Do they purchase something? Do they end up at a landing page after a particular transaction has occurred, or something along those lines?</p>\n\n\n\n<p>How credible do those things feel to you now? And it said that a year ago you couldn&#8217;t do it with this particular platform, and now you can. Does it feel like that whole conversion industry, you know, conversion tracking in particular, does it feel like it&#8217;s fighting a losing battle? Or does it feel like with those modern analytics companies that you&#8217;re still in the game. You can still get the data that you probably need all be it, it&#8217;s not going off to some giant third party?</p>\n\n\n\n<p>[00:30:11] <strong>Derek Ashauer:</strong> So the first answer that came to mind when you&#8217;re asking that is, for example, in my testing of some of the various modern platforms, even on those, you&#8217;re getting 70% of the conversions actually getting tracked. And that could be for various reasons of JavaScript blockers, ad blockers, or things like that. And that&#8217;s one of the reasons why I&#8217;m really focusing on doing API based tracking, so that it&#8217;s server to server, not aligned to JavaScript. Because server to server, behind like, through PHP and APIs and stuff like that. If you can track what people are doing, then it&#8217;s going to be a lot more accurate actually.</p>\n\n\n\n<p>That&#8217;s one thing that I&#8217;m working on for my plugin is so that whatever analytics platform you&#8217;re using, it can be as accurate as possible. But yeah, I think you&#8217;re trying to hint at it, are these other modern platforms going to go the way of Google and try and sell data? Is that kind of what you mean?</p>\n\n\n\n<p>[00:30:58] <strong>Nathan Wrigley:</strong> No, what I was meaning was, do you feel that they are credible in that, okay, so let&#8217;s imagine that I own a WooCommerce store, I&#8217;ve been using Google forever and it&#8217;s been giving me this incredibly valuable data, and I really don&#8217;t want to let go of that. But I feel, for one reason or another, maybe that&#8217;s legislation, or just a moral compulsion that I feel I have, I want to move over to these platforms. Am I throwing away a ton of useful data that I&#8217;ll never get back? Or are these modern platforms slowly but surely offering a solution, which gives me more or less what I need.</p>\n\n\n\n<p>[00:31:31] <strong>Derek Ashauer:</strong> Yeah. From my perspective, what I&#8217;m seeing is when Google Analytics 4 came out, they haven&#8217;t been able to get the same level of data they used to 10 years ago with UA, Universal Analytics. Which was what we were, most of us were used to when we said Google Analytics, that&#8217;s what we had for a very, very long time, and then Google Analytics 4 came out.</p>\n\n\n\n<p>I would say the platforms, some are better than others. There&#8217;s definitely some that have a lot more advanced features than others. Fathom, for example, is pretty straightforward. I wouldn&#8217;t say it&#8217;s very well geared towards detailed conversion tracking and getting good, detailed, in-depth insights. It&#8217;s good at getting page views, where they came from, what country they&#8217;re at. Something you would hand to a client so they could look at a nice little dashboard.</p>\n\n\n\n<p>And Universal Analytics, it used to be great. I used to say, hey, here&#8217;s Universal Analytics, go check it out. Didn&#8217;t even have to walk them through any of it. They could look at the screen, understand the data, it made sense. Now, Google Analytics 4 is a cluster. It is for professional level marketers, and that is it at this point. You have to really know the software. There&#8217;s week long classes on how to use Google Analytics 4 these days, because it is so overwhelmingly complex. And I think it went almost too far in that regard.</p>\n\n\n\n<p>But anyway, I think these modern platforms can get most site owners the data they need to make good decisions about, are my ads working if I&#8217;m doing Facebook ads? Or am I doing Google ads? Are they working for me? You know, if I&#8217;m doing link building from another site and you can tag those same UTM codes, that might be something, if you&#8217;re familiar. There are codes that you can add to the URL, with the little query and the query variables, to kind of identify that this link came from this source.</p>\n\n\n\n<p>And then that can track that user throughout the process. You know, the add to cart, checkout and complete the purchase. And then know that that user came from that UTM tracking code from either somewhere on your own website or from an external website. So it can do all those great things.</p>\n\n\n\n<p>So for a lot of mom and pop, WooCommerce stores I think can get a lot of great, useful data. It&#8217;s really when you are more an enterprise company, and maybe you&#8217;re doing like a million dollars a week in ad spend, you&#8217;re going to want something that is really, these crazy reports that you can run. And it&#8217;s more about the reporting than anything that you can do in GA 4 that maybe these modern platforms can&#8217;t quite do yet.</p>\n\n\n\n<p>And so, like I said, for my clients, any of the clients that I&#8217;ve built sites for over the last 20 years, they don&#8217;t need any of that stuff. They would be very happy with the reports from, say, Plausible. Many of them would be happy with even Fathom, which I said, which isn&#8217;t the most conversion oriented platform. Even they would be great with those ones.</p>\n\n\n\n<p>[00:34:14] <strong>Nathan Wrigley:</strong> So your plugin, which is called Conversion Bridge, what does it do? It feels from the outside as if it&#8217;s almost like a Zapier for analytics meets website, if you know what I mean. You bind your website to the analytics platform, and then you can give it, I don&#8217;t know, if this, then that kind of functionality to figure out, okay, what are the conversions?</p>\n\n\n\n<p>And also it just feels like you are stripping out the technical burden of learning those platforms. Is that basically what it&#8217;s doing or have I missed the target?</p>\n\n\n\n<p>[00:34:46] <strong>Derek Ashauer:</strong> That&#8217;s very close. The idea is, when I was building sites for clients, I didn&#8217;t set up any conversion tracking for a lot of them. One, because it&#8217;s just the cost, because you go buy Gravity Forms well, this site we&#8217;re going to use WS Form. Well, this site we&#8217;re going to use Ninja Forms, or this site we&#8217;re using WooCommerce, this other one we&#8217;re going to use this other, you know.</p>\n\n\n\n<p>There&#8217;s so many different ways that you could do a form, do a purchase. Page builders, what button? How do I add a click tracking? Like, every time someone clicks on the buy now button on my homepage and goes to that. So we want to really track all this kind of stuff. It was a challenge of, how did you add that to your WordPress site? And so oftentimes it just didn&#8217;t happen because it was such a pain in the butt to do it.</p>\n\n\n\n<p>So what Conversion Bridge tries to do is makes it easy to add the analytics tracking codes. A lot of people just cut and paste it into the header, footer, code snippets, type plugins and all this kind of stuff. That is a way to do it. It&#8217;s not really the ideal way. But it does allow you to quickly and easily add one of, I think I have 12 different analytics platforms, whether it&#8217;s Google Analytics, Fathom, all that kind of stuff. Toggle, copy and paste your just like little ID number. And then the analytics code has been added to the site where it needs to. Make sure it does it for the right users. Like, I don&#8217;t want to track admin users, let&#8217;s make sure we don&#8217;t track admin users. Stuff like that.</p>\n\n\n\n<p>But the real benefit is, is that conversion tracking. So say you have a form that you&#8217;re using, and it&#8217;s just a simple, yes, add conversion tracking, done. That&#8217;s all I had to do. Click a toggle. I didn&#8217;t have to think about code snippets. How do I do it? Researching the form plugin, where does it need to get output? When does it need to get output? All this kinda stuff, it just was a pain in the butt.</p>\n\n\n\n<p>And then the real benefit for agencies is that, regardless of what site they&#8217;re doing, whether they&#8217;re using Bricks Builder or Beaver Builder, using WS Form, Gravity Forms, it&#8217;s all one plugin that works for any site that you would need, because it integrates with 50 plus different WordPress plugins to just have one click toggle conversion tracking.</p>\n\n\n\n<p>And websites really need conversion tracking. They need to know what users are doing on their site. And I think it&#8217;s a huge value that especially professional site builders could add to their plugin stack that they put on every client site to just, oh, all I have to do is copy, paste the little ID number from Fathom, and then I just need to check one little box in WS Form, and suddenly I have, not only analytics on the site, but I&#8217;m also tracking every single form submission.</p>\n\n\n\n<p>And we can see where they&#8217;re coming from and which ones generate the most contact form leads on this website that is for a landscaper to fill out forms and get lead quotes. And now I can tell my client, these resources, whether it&#8217;s this external blog that linked to us, oh my God, we got mentioned in this blog, and all of a sudden they&#8217;re generating 50 leads a month from us. We need to do more outreach to all these blogs. And to really understand where your leads are coming from. It&#8217;s a huge value to add to client sites.</p>\n\n\n\n<p>[00:37:28] <strong>Nathan Wrigley:</strong> I have a couple of questions following on from that. The first one is, have you got any examples, like curious examples, maybe unexpected examples? Because everybody gets the, okay, I want to convert, I want to track that a person arrived at the website, looked at this product and then ended up buying it, you know? Brilliant.</p>\n\n\n\n<p>But are there any quirky ones that people have reached out to you that they&#8217;ve used and you thought, oh gosh, I never imagined people would want to track that conversion?</p>\n\n\n\n<p>[00:37:52] <strong>Derek Ashauer:</strong> Not yet. It is pretty straightforward, you know, the things that you need to track. Form submissions, email newsletter signups are a good one. I mean purchases, stuff like that. What buttons on your page? You know, maybe you have a homepage and you want to know which button on that page actually got them to go to the buy now?</p>\n\n\n\n<p>So maybe you have one in the main banner. Maybe you have one near the FAQ section. Maybe you have one near the testimonials. Which one actually got people to actually go to that page. So button tracking, link tracking is good ones. Yeah, there&#8217;s not too many surprises on that regard.</p>\n\n\n\n<p>[00:38:23] <strong>Nathan Wrigley:</strong> And then the other one is about the plugins that you work with. So, and again, it sounds like your UVP really is that, look, we&#8217;ve looked at how their plugin works, how the code works, and you just tick the button. You say, I&#8217;ve got WS Form, I&#8217;ve got Gravity Forms, or whatever it may be, and now it&#8217;s just done. That&#8217;s part of the deal. You&#8217;re buying it so that you don&#8217;t have to do any coding.</p>\n\n\n\n<p>[00:38:45] <strong>Derek Ashauer:</strong> Yeah, because that&#8217;s, you know, what everyone wants these days. There&#8217;s no code. And they don&#8217;t even want to, even cutting and pasting code snippets. Before it was, a lot of plugins were like, add this, you had to use this hook, and then add this code. I mean, they provided this snippet, and then you had to kind of customise it and all this kinda stuff. It&#8217;s no. Just toggle and it&#8217;s done.</p>\n\n\n\n<p>You know, like for WooCommerce, it&#8217;ll send all the detailed data about the purchase. What product they purchased. How much it cost. What the order total was. So you can get all that good data in there so you can do some advanced reporting in Google Analytics or even Plausible and some other, Pirsch, and stuff like that. So these alternatives you can do as well.</p>\n\n\n\n<p>[00:39:18] <strong>Nathan Wrigley:</strong> No code solution. Yeah, that&#8217;s nice. And the other one I suppose would be, where do you feel your audience is? Is it kind of agencies, or do you have customers who are, I don&#8217;t know, just building their own website and really don&#8217;t have any technical background? Or is it more, like I said, is it more kind of agencies who are deploying this for their clients and they have an understanding of how to set these things up?</p>\n\n\n\n<p>[00:39:39] <strong>Derek Ashauer:</strong> You know, I&#8217;m doing my own market research and learning that as a business owner of how to do your, what is ICP? Ideal Customer Profile. And I&#8217;m kind of identifying that it, I think agencies would, so far, I think are the top of the list.</p>\n\n\n\n<p>I know there&#8217;s some people that have bought it that are single site owners, but then I&#8217;ve learned, you know, they bought a one site license, but then I learned that they were just trying it on one site to see how it worked.</p>\n\n\n\n<p>And they&#8217;re like, okay, yeah, this makes sense, and then they&#8217;re going to upgrade to, you know, a 20 site license because then they&#8217;re like, now I&#8217;m going to use this on all my client sites. This is what I&#8217;ve noticed those one site license purchases have been so far. So yeah, I think agencies do get the best of it.</p>\n\n\n\n<p>But it&#8217;s also a great tool to try out because I can actually, and I have it on my development test site, but I can enable 12 different analytics platforms at once. It&#8217;s obviously not something that you would do, but you technically could. And it&#8217;s great because you can actually test different things.</p>\n\n\n\n<p>Say, if you&#8217;re using Google Analytics, I want to test out Plausible. Let me try it out. Well, let me just add Google Analytics and Plausible, and everywhere you&#8217;ve checked that box on WS Form to do conversion tracking, it&#8217;ll send it to every single platform for you. You don&#8217;t have to then do a different snippet or code for, okay, now let me cut, do this snippet for WS Form in Plausible. Do this snippet for WooCommerce and Plausible. This snippet for Google Analytics and WooCommerce. It just takes care of all that for you.</p>\n\n\n\n<p>So you could try, do the free trial for a week for three or four different analytics platforms. Look at the data. Okay, we ran it for a week, let&#8217;s see which one I actually do like. So it&#8217;s one little side benefit. I allowed multiple analytics platforms to make it easy for me to develop, but then I quickly realised, this is actually an advantage to test out these different platforms and see if I can get good data, and data that is usable without losing Google Analytics data while you keep maintaining that.</p>\n\n\n\n<p>[00:41:13] <strong>Nathan Wrigley:</strong> It feels like there&#8217;s very few parts of our industry where politics gets in. There&#8217;s just no politics in the kind of things that I deal with. You know, what I mean by that, international politics. Not the kind of politics within the kind of baseball of WordPress, but the international politics.</p>\n\n\n\n<p>It feels like this is a bit of a moving target at the moment. And it&#8217;d be curious to see if we were to do this episode again in a year&#8217;s time, whether or not the sand has shifted, and you&#8217;ve had to pivot your product because it&#8217;s moved in one direction or another. Yeah, just absolutely fascinating.</p>\n\n\n\n<p>I wish you all the best. Just before we wrap it up, where do people find you? What&#8217;s the URL or the social network or both? Where can we find you? And of course, Conversion Bridge.</p>\n\n\n\n<p>[00:41:55] <strong>Derek Ashauer:</strong> Yeah, conversionbridgewp.com is the Conversion Bridge plugin, and then I am pretty active on Twitter. You can find me @derekashauer on Twitter or X, I guess, sorry.</p>\n\n\n\n<p>[00:42:05] <strong>Nathan Wrigley:</strong> Yeah. As is always the case, I will drop all of the links for anything that we discuss today, including the host of analytics platforms and what have you that we mentioned. I&#8217;ll put all of those into the show notes. If you head to wptavern.com, search for the episode with Derek in, all of the links will be right there.</p>\n\n\n\n<p>So, Derek, it just remains for me to say thank you very much for chatting to me today. I really appreciate it. It.</p>\n\n\n\n<p>[00:42:24] <strong>Derek Ashauer:</strong> It&#8217;s been a pleasure. Thanks for having me on.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/derekashauer\">Derek Ashauer</a>.</p>\n\n\n\n<p>Having spent over 15 years in the WordPress arena, Derek has transitioned from building client sites to creating specialised WordPress plugins. Today, we get to hear about his journey creating <a href=\"https://conversionbridgewp.com/\">Conversion Bridge</a>, a tool specifically designed to streamline the process of implementing analytics platforms and conversion tracking on WordPress websites.</p>\n\n\n\n<p>We start with an overview of analytics, tracing its evolution from the simple server logs of the early internet days, to the sophisticated data gathering mechanisms provided by Google Analytics and others.</p>\n\n\n\n<p>We explore how the introduction of European privacy laws has significantly impacted the data landscape, challenging marketers and businesses to adapt to a new era, where data privacy is regarded differently in different locales.</p>\n\n\n\n<p>Derek offers his perspectives on this rapidly changing field, discussing the rise of modern, privacy-focused analytics platforms like Fathom, Plausible, and others. He explains how these technologies employ cookieless tracking techniques to respect user privacy, while still providing valuable insights for website owners.</p>\n\n\n\n<p>We also address the problem of data accessibility and user privacy. Derek, sharing his personal views as a marketer, acknowledges the complexity of balancing effective marketing strategies with ethical data use. He explains his thoughts on why modern solutions might strike a better balance, ensuring that user data remains private while allowing businesses to glean just the insights they need.</p>\n\n\n\n<p>Whether you&#8217;re managing a WooCommerce store or building sites for clients, Derek’s insights into conversion tracking will be of interest. He talks about some of the hurdles site builders face with traditional systems and how Conversion Bridge simplifies conversion tracking across various platforms and plugins without the need for extensive coding.</p>\n\n\n\n<p>If you&#8217;re an agency, developer, or digital marketer, this discussion will help equip you with knowledge and strategies to navigate the ever-evolving landscape of web analytics.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://x.com/derekashauer\">Derek on X</a></p>\n\n\n\n<p><a href=\"https://www.sunshinephotocart.com/\"> Sunshine Photo Cart</a></p>\n\n\n\n<p><a href=\"https://conversionbridgewp.com/\">Conversion Bridge</a></p>\n\n\n\n<p><a href=\"https://usefathom.com/\">Fathom Analytics</a></p>\n\n\n\n<p><a href=\"https://plausible.io/\">Plausible Analytics</a></p>\n\n\n\n<p><a href=\"https://pirsch.io/\">Pirsch Analytics</a></p>\n\n\n\n<p><a href=\"https://usermaven.com/\">Usermaven</a></p>\n\n\n\n<p><a href=\"https://support.google.com/analytics/answer/10089681?hl=en\">Introducing the next generation of Analytics, Google Analytics 4</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Do The Woo Community: Cami MacNamara Joins the Do the Woo Hosting Team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=90706\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://dothewoo.io/blog/cami-macnamara-joins-the-do-the-woo-hosting-team/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:330:\"Here at Do the Woo we are thrilled to announce that Cami McNamara is joining WP Agency Tracks as a co-host with Marcus. Cami, a long-time WordPress professional and the founder of WebCami Agency, brings years of experience in running a successful solo agency. As the creator of the Web Designer Habits newsletter and the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 13:24:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WordPress.org blog: WordPress 6.7.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18445\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2025/02/wordpress-6-7-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8485:\"<h2 class=\"wp-block-heading\">WordPress 6.7.2 is now available!</h2>\n\n\n\n<p>This minor release includes <a href=\"https://make.wordpress.org/core/tag/6-7-2/\">35 bug fixes</a>, addressing issues affecting multiple components including the block editor, HTML API, and Customize.</p>\n\n\n\n<p>WordPress 6.7.2 is a short-cycle release. The next major release will be <a href=\"https://make.wordpress.org/core/6-8/\">version 6.8</a> planned for April 15, 2025.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.7.2.zip\">download WordPress 6.7.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-7-2\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.7.2 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-long\"><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/ajlende\">Alex Lende</a>, <a href=\"https://profiles.wordpress.org/alexandrebuffet\">Alexandre Buffet</a>, <a href=\"https://profiles.wordpress.org/bowedk\">Andreas Pedersen</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/ankitkumarshah\">Ankit Kumar Shah</a>, <a href=\"https://profiles.wordpress.org/apermo\">apermo</a>, <a href=\"https://profiles.wordpress.org/benniledl\">Benedikt Ledl</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>, <a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>, <a href=\"https://profiles.wordpress.org/cbravobernal\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/coquardcyr\">Cyrille</a>, <a href=\"https://profiles.wordpress.org/danielpost\">Daniel Post</a>, <a href=\"https://profiles.wordpress.org/darerodz\">darerodz</a>, <a href=\"https://profiles.wordpress.org/dpcalhoun\">David Calhoun</a>, <a href=\"https://profiles.wordpress.org/get_dave\">David Smith</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhewercorus\">dhewercorus</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/ellatrix\">Ella</a>, <a href=\"https://profiles.wordpress.org/im3dabasia1\">Eshaan Dabasiya</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/gaambo\">Fabian Todt</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/ffffelix\">Felix Renicks</a>, <a href=\"https://profiles.wordpress.org/franciscabusas22\">Francis Cabusas</a>, <a href=\"https://profiles.wordpress.org/frankbiganski\">Frank B.</a>, <a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/ghinamt\">ghinamt</a>, <a href=\"https://profiles.wordpress.org/glynnquelch\">Glynn Quelch</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/jameskoster\">James Koster</a>, <a href=\"https://profiles.wordpress.org/jsnajdr\">Jarda Snajdr</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jdnd\">jdnd</a>, <a href=\"https://profiles.wordpress.org/jeryj\">jeryj</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/juanwp22\">juanwp22</a>, <a href=\"https://profiles.wordpress.org/jrf\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/karthickmurugan\">Karthick</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">Kazuto Takeshita</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/ketanniruke\">Ketan Niruke</a>, <a href=\"https://profiles.wordpress.org/0mirka00\">Lena Morita</a>, <a href=\"https://profiles.wordpress.org/levskipg\">levskipg</a>, <a href=\"https://profiles.wordpress.org/maciejmackowiak\">Maciej Ma?kowiak</a>, <a href=\"https://profiles.wordpress.org/santosguillamot\">Mario Santos</a>, <a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mayanktripathi32\">Mayank Tripathi</a>, <a href=\"https://profiles.wordpress.org/czapla\">Michal Czaplinski</a>, <a href=\"https://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/presstoke\">Mitchell Austin</a>, <a href=\"https://profiles.wordpress.org/mreishus\">mreishus</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/assassinateur\">Nadir Seghir a11n</a>, <a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>, <a href=\"https://profiles.wordpress.org/nareshbheda\">Naresh Bheda</a>, <a href=\"https://profiles.wordpress.org/neotrope\">neotrope</a>, <a href=\"https://profiles.wordpress.org/ndiego\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/oglekler\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/parthvataliya\">Parth vataliya</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/paullb\">paullb</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/pitamdey\">Pitam Dey</a>, <a href=\"https://profiles.wordpress.org/redkite\">redkite</a>, <a href=\"https://profiles.wordpress.org/rishavdutta\">Rishav Dutta</a>, <a href=\"https://profiles.wordpress.org/robertstaddon\">robertstaddon</a>, <a href=\"https://profiles.wordpress.org/rvoigt\">rvoigt</a>, <a href=\"https://profiles.wordpress.org/mi5t4n\">Sagar Tamang</a>, <a href=\"https://profiles.wordpress.org/sainathpoojary\">Sainath Poojary</a>, <a href=\"https://profiles.wordpress.org/seanlanglands\">seanlanglands</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/shyamkariya\">Shyam Kariya</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/sukhendu2002\">Sukhendu Sekhar Guria</a>, <a href=\"https://profiles.wordpress.org/TobiasBg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/vishy-moghan\">Vishy Moghan</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/wongjn\">wongjn</a>, <a href=\"https://profiles.wordpress.org/yogeshbhutkar\">Yogesh Bhutkar</a>, <a href=\"https://profiles.wordpress.org/zaoyao\">zaoyao</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\">#6-8-release-leads</a> channels. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\"https://profiles.wordpress.org/joedolson/\">@joedolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">@joemcgill</a> and <a href=\"https://profiles.wordpress.org/audrasjb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>audrasjb</a> for proofreading.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Feb 2025 16:52:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Aaron Jorbin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: Inside the WooCommerce Release Process with Julia Amosova\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=90545\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://dothewoo.io/inside-the-woocommerce-release-process-with-julia-amosova/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:214:\"In this episode, James and Julia discuss WooCommerce\'s enhanced release process, focusing on improved testing, community involvement, and future goals like faster fix releases and compatibility tools for merchants.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Feb 2025 10:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Ed Catmull on Change\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=137101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ma.tt/2025/02/ed-catmull-on-change/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1839:\"<p>I&#8217;ve been really enjoying the book <a href=\"https://www.amazon.com/Creativity-Inc-Overcoming-Unseen-Inspiration/dp/0812993012\">Creativity Inc by Ed Catmull of Pixar</a>, it was recommended to me by my colleague <a href=\"https://davemart.in/\">Dave Martin</a> a while back and I finally got around to it. There&#8217;s an interesting story in it where George Lucas had asked him to develop a film editing system that was digital.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>While George wanted this new video-editing system in place, the film editors at Lucasfilm did not. They were perfectly happy with the system they had already mastered, which involved actually cutting film into snippets with razor blades and then pasting them back together. They couldn&#8217;t have been less interested in making changes that would slow them down in the short term. They took comfort in their familiar ways, and change meant being uncomfortable. [&#8230;] If left up to the editors, no new tool would ever be designed and no improvements would be possible.</p>\n</blockquote>\n\n\n\n<p>This made me think a lot about the early days of <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a> and the huge resistance it had in the community, including causing the fork of ClassicPress. Now that we&#8217;re much further along there&#8217;s a pretty widespread acceptance of Gutenberg, and it&#8217;s responsible for the vast majority of all WP posts and pages made, however if we had taken a vote for whether it should happen or not, it probably wouldn&#8217;t have ever gotten off the ground.</p>\n\n\n\n<p>What’s funny is if you go back even further, using a visual WYSIWYG editor in the first place was very controversial, and many people didn’t want the classic editor brought into WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Feb 2025 05:38:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"Gutenberg Times: WordPress 6.8 Roadmap, Advanced Debugging Course,  Invoker Commands —   Weekend Edition 319\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=37577\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://gutenbergtimes.com/wordpress-6-8-roadmap-advanced-debugging-course-invoker-commands-weekend-edition-319/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21606:\"<p>Hi there, </p>\n\n\n\n<p>So I&#8217;ll be off next week to Manila, Philippines. After a 15 hrs flight to a  seven-hour time difference, I need a couple of days to acclimate, and I also want to get some sightseeing in before immersing into WordCamp Asia. The next weekend edition will be published after my return to Munich.</p>\n\n\n\n<p>I will be sharing <a href=\"https://bsky.app/profile/bph.social\">photos on Bluesky</a> if you would like to follow along my adventures.  I&#8217;m excited about an infinite  amount of 3D interactions with my fellow WordPressers. Sending virtual hugs to you. 🤗</p>\n\n\n\n<p> Have a wonderful weekend, and if you are coming to Manila, too, have a safe journey! </p>\n\n\n\n<p>Yours, 💕</p>\n\n\n\n<p><em>Birgit</em></p>\n\n\n\n<p>PS: <a href=\"https://gutenbergtimes.com/getting-ready-for-wordcamp-asia-2025-in-manila-philippines/\">Getting ready for WordCamp Asia 2025 in Manila, Philippines</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-8-roadmap-advanced-debugging-course-invoker-commands-weekend-edition-319/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-8-roadmap-advanced-debugging-course-invoker-commands-weekend-edition-319/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-8-roadmap-advanced-debugging-course-invoker-commands-weekend-edition-319/#five-newest-block-themes-in-the-wordpress-repository-are\">Six newest block themes </a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-8-roadmap-advanced-debugging-course-invoker-commands-weekend-edition-319/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-8-roadmap-advanced-debugging-course-invoker-commands-weekend-edition-319/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ol>\n</div></div>\n\n\n\n<p>In the 407th episode of WP Build, titled <a href=\"https://wpbuilds.com/2025/02/03/407-at-the-core-with-birgit-pauli-haack-and-anne-mccarthy-episode-2/\"><strong>“At The Core” with Birgit Pauli-Haack and Anne McCarthy</strong></a>, we had a fun chat with <strong>Nathan Wrigley</strong> about all the cool updates and features from the last three months. We dove into the neat experimental features aimed at making collaborative editing in WordPress a reality, which feels a lot like using Google Docs! Plus, we covered some handy tools and resources spotlighted on the Developer Blog, from nailing light and dark modes in block themes to figuring out data views and form components. And let’s not forget about &#8220;WordPress Playground,&#8221; an awesome tool that lets you whip up a site right in your browser without any hassle!</p>\n\n\n\n<a href=\"https://wpbuilds.com/2025/02/03/407-at-the-core-with-birgit-pauli-haack-and-anne-mccarthy-episode-2/\"><img width=\"652\" height=\"343\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/WP-Builds-Podcast-Episode-407.jpg?resize=652%2C343&ssl=1\" alt=\"\" class=\"wp-image-37668\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>Aaron Jorbin </strong>announced<strong> <a href=\"https://make.wordpress.org/core/2025/02/04/wordpress-6-7-2-rc1-is-now-available/\">WordPress&nbsp;6.7.2&nbsp;RC1 is now available</a></strong>&nbsp;for testing. Final release is expected next week on February 11, 2025. The post has the list of all the bug fixes from trac tickets and GitHub pull requests. With the minor release, we will also see a new version of the default theme, Twenty-Twenty-Five.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>George Mamadashvili</strong> worked on this week&#8217;s Gutenberg plugin release. Here is the <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v20.2.0\">changelog of Gutenberg 20.2</a>. At first glance, two enhancements stood out for me:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Details block: Add name attribute for exclusive accordion. (<a href=\"https://github.com/WordPress/gutenberg/pull/56971\">56971</a>)</li>\n\n\n\n<li>Post-content block header color support. (<a href=\"https://github.com/WordPress/gutenberg/pull/67783\">67783</a>)</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Krupal Lakhia</strong> published the <a href=\"https://make.wordpress.org/core/2025/02/06/roadmap-to-6-8/\">Roadmap to WordPress 6.8</a>. WordPress 6.8 is dropping on April 15, 2025, and it&#8217;s all about making site building smoother and faster. Expect an improved editing flow with an enhanced “Zoom Out” mode, better style controls, and more typography options. The update also introduces “Write” and “Design” modes, so you can focus on content or layout separately. Under the hood, new tools like Block Hooks and Block Bindings make it easier to customize, while performance boosts—like speculative loading—help sites run faster. Plus, accessibility upgrades and continued PHP 8.x support keep WordPress user-friendly and future-proof. Lakhia goes into much more detail in his post and shares corresponding PRs from the tracking systems.</p>\n\n\n\n<a href=\"https://make.wordpress.org/core/2025/02/06/roadmap-to-6-8/\"><img width=\"652\" height=\"326\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/image-3.png?resize=652%2C326&ssl=1\" alt=\"Change section design from style variations\" class=\"wp-image-37666\" /></a>\n\n\n\n<p><em>Did you know that you can use Playground to test single Gutenberg PRs? </em></p>\n\n\n\n<img width=\"652\" height=\"124\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Screenshot-2025-02-07-at-18.50.20.png?resize=652%2C124&ssl=1\" alt=\"\" class=\"wp-image-37682\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-114-reflections-on-gutenberg-times-and-do-the-woo/\">Gutenberg Changelog #114 – Reflections on Gutenberg Times and Do the Woo</a> with Bob Dunn aka BobWP as host and guest Birgit Pauli-Haack, each publication started 7 years ago. </p>\n\n\n\n<img width=\"652\" height=\"328\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Gutenberg-Changelog-114-Bob-Dunn-Birgit-pauli-Haack-edited.png?resize=652%2C328&ssl=1\" alt=\"\" class=\"wp-image-37614\" />\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>After building multiple extensions for Gravity Forms, <a href=\"https://x.com/johnofhousejohn\"><strong>Johnathon Williams</strong>,</a> owner of Odd Jar, has released his first plugin for the Block Editor – <a href=\"https://oddjar.com/wordpress-plugins/quicklink-pro/\"><strong>QuickLink Pro</strong></a>, a link management solution designed specifically for the block editor. It adds external links to the standard link dialog in the block editor for easy linking after you manage your link library on a settings page. This is a great tool to manage your affiliate links, subscription links, or documentation pages you keep referencing in your tutorials. It&#8217;s not free, and hopefully, there are a few more features added later this year. Williams also has some <a href=\"https://oddjar.com/five-tips-for-making-wordpress-plugins-with-ai/\">helpful tips on coding with AI</a>. <em>Hat tip to Davinder Singh Kainth from the WP Weekly for finding the plugin.</em></p>\n\n\n\n<a href=\"https://oddjar.com/wordpress-plugins/quicklink-pro/\"><img width=\"652\" height=\"346\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Screenshot-2025-02-08-at-12.06.01.png?resize=652%2C346&ssl=1\" alt=\"\" class=\"wp-image-37686\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Eric Karkovack</strong>, The WP Minute, dives into <a href=\"https://thewpminute.com/how-wordpress-block-patterns-improve-your-workflow/\"><strong>How WordPress Block Patterns Improve Your Workflow</strong></a>. WordPress block patterns are pre-designed sections that enhance your workflow by offering a quick way to build websites. Karkovack explains the value of patterns because they save time and offer ready-made reusable designs for common content. Multiple patterns can be combined to create landing pages and shorten their production time.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"five-newest-block-themes-in-the-wordpress-repository-are\">Six newest block themes </h3>\n\n\n\n<p>in the WordPress repository are: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.org/themes/hr-management/\"><strong>HR Management</strong></a> by Peter Williams &#8211; helps you showcase HR services with eleven patterns and five Style variations</li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/gutenify-bold/\"><strong>Gutenify Bold</strong></a> by Code Yatri, a child theme of Gutenify Starter, comes with 10 Style variations and 16 patterns.</li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/edugrove/\"><strong>EduGrove</strong></a> by Theme Grove &#8211; designed to meet the needs for educational institutions of all kinds. It entails 30 (!) patterns and 7 style variations.</li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/wens-food-palette/\"><strong>WENS Food Palette</strong></a> by WEN Solutions, a child theme of WENS Haelo, for food related business with 20 patterns.</li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/healthy-food-blogger/\"><strong>Healthy Food Blogger</strong></a> by Creta Themes &#8211; for passionate food bloggers, recipe creators, and culinary enthusiasts, with 10 patterns and a slider.</li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/nas-construction-build/\"><strong>NAS Construction Build</strong></a> by Template House a theme for a construction company with 9 style variations and 16 patterns.</li>\n</ul>\n\n\n\n<p>The total number of Block themes in the repository is <strong>1,130 as of today</strong>.</p>\n\n\n\n<img width=\"652\" height=\"385\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Screenshot-2025-02-08-at-15.35.55.png?resize=652%2C385&ssl=1\" alt=\" Six newest block themes\" class=\"wp-image-37691\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>In his post <a href=\"https://haurand.com/circles-wp-developing-a-block-theme/\"><strong>Block Theme Circles WP – Developing and Customization</strong></a>, Hans-Gerd Gerhards takes you along his development journey of the block theme <em>Circles WP</em>, which is available in the WordPress repository. Gerhards characterizes his theme as &#8220;lightweight and therefore extremely fast.&#8221; <em>Circles WP</em> is already prepared for an accessibility-ready website. The font used is <a href=\"https://fonts.google.com/specimen/Lexend\">Lexend</a> – an accessible font – as standard. Alternatively, the <a href=\"https://fonts.google.com/specimen/Atkinson+Hyperlegible\">Atkinson Hyperlegible Font</a> – Braille Institute (also accessibility-ready) or “System Font” are available. <em>Circles WP</em> was deliberately developed without any additional CSS, i.e., he only uses the settings of the block editor.</p>\n\n\n\n<a href=\"https://haurand.com/circles-wp-developing-a-block-theme/\"><img width=\"652\" height=\"285\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/circles_height-1024x448-1.jpg?resize=652%2C285&ssl=1\" alt=\"Screenshot CirclesWP in the block editor\" class=\"wp-image-37670\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>The co-founder of <em>simplenet</em>, a hosting and web development agency from Romania, <em>Andrei Chira</em>, announced that their first theme, a block theme called <strong><a href=\"https://wordpress.org/themes/simplenet/\">Simplenet</a></strong>, was accepted into the WordPress repository. Chira also shared the genesis of the theme and its features. It&#8217;s meant to be used as a base theme to get started building a website with WordPress. &#8220;The <strong>Simplenet</strong> theme is the result of this learning process. I was inspired by other existing themes and tried to understand how the structure of a block theme works,&#8221; he wrote. The theme is also <a href=\"https://github.com/andreik6v/simplenet\">available on GitHub</a>.</p>\n\n\n\n<a href=\"https://simplenet.io/introducing-simplenet-wordpress-block-theme/\"><img width=\"650\" height=\"427\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/style-variations-simplenet-650x427-1.webp?resize=650%2C427&ssl=1\" alt=\"\" class=\"wp-image-37679\" /></a>\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p><strong>Geoff Graham</strong> created a <a href=\"https://css-tricks.com/baseline-status-in-a-wordpress-block/\"><strong>WordPress block Baseline Status</strong></a> of a web feature base, meaning its browser compatibility. It&#8217;s the baseline status component formatted as a WordPress block. Graham then takes you along the journey of how he built it and what design decisions he made along the way. The <a href=\"https://wordpress.org/plugins/baseline-status/\">plugin is available in the WordPress repository</a></p>\n\n\n\n<img width=\"582\" height=\"150\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Screenshot-2025-02-08-at-15.14.20.png?resize=582%2C150&ssl=1\" alt=\"Baseline Status block \" class=\"wp-image-37687\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>A new course for WordPress developers is now available: <a href=\"https://learn.wpvip.com/course/advanced-wordpress-debugging/\"><strong>Advanced WordPress Debugging Course</strong></a>. Although published by Learn VIP, the learning site of WordPress VIP, the course is open and free to the public. &#8220;Debugging is a critical skill for any software developer. We understand how important it is to quickly find and resolve issues, reducing downtime and ensuring users have a seamless experience on your site. For your organization, this means saving time, avoiding unnecessary costs, and having the flexibility to grow and adapt without worrying about technical hiccups,&#8221; Rick Hurst wrote on <a href=\"https://lobby.vip.wordpress.com/2025/01/21/new-advanced-wordpress-debugging-course-for-vip-learn/\">the announcement post</a>. And the course is a &#8220;comprehensive exploration of advanced WordPress debugging techniques, equipping learners with the skills and tools needed to troubleshoot and resolve complex issues in WordPress applications.&#8221; The estimated course completion time is 5 to 8 hours. Other courses from the same team are:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://learn.wpvip.com/course/enterprise-wordpress-security/\">Enterprise WordPress Security</a></li>\n\n\n\n<li><a href=\"https://learn.wpvip.com/course/enterprise-performance/\">Enterprise WordPress Performance</a></li>\n\n\n\n<li><a href=\"https://learn.wpvip.com/course/wordpress-vip-architecture-and-tooling/\">WordPress VIP Architecture and Tooling</a></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his post, <a href=\"https://www.briancoords.com/getting-the-block-editor-ready-for-ai/\"><strong>Getting the Block Editor Ready for AI</strong></a>, Brian Coords discusses his conversation with Matt Medeiros about the shortcomings of AI and then offers a few strategies on how to help AI become smarter about WordPress.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>So there is a new thing called <a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Invoker_Commands_API\"><em>Invoker Commands API</em></a> coming to browsers. It&#8217;s so new, it&#8217;s only available in pre-release browsers like Chrome Canary, Firefox Nightly, or Safari TP (Technical Preview) behind a feature flag that you need to enable. So if you are not interested in these new experimental browser features, you can skip this paragraph. <strong>Pascal Birchler</strong>, WordPress core committer sponsored by Google, explored what <a href=\"https://pascalbirchler.com/invoker-commands-api-wordpress/\"><strong>Invoker Commands in WordPress</strong></a> would look like. He explains what the Invoker Commands API tries to accomplish and how, and then he switches to what this would mean for Blocks and how it relates to the Interactivity API. Then Birchler introduces the Block Invokers plugin and how you can provide Invoker commands to a custom block in WordPress.</p>\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Featured Image: Photo by <a href=\"https://unsplash.com/de/@mbcaptures?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash\">Michael Buillerey</a> on <a href=\"https://unsplash.com/de/fotos/stadtbildfotografie-von-gebauden-und-booten-KwgEwVEsao8?utm_content=creditCopyText&utm_medium=referral&utm_source=unsplash\">Unsplash</a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Feb 2025 23:42:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: On Logan Bartlett Show\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=136823\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/02/logan-bartlett/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:551:\"<p>You may not have heard of <a href=\"https://x.com/loganbartlett\">Logan Bartlett</a>, but he&#8217;s one of the most hilarious people on Twitter and does a really interesting podcast. (<a href=\"https://pca.st/9p91u5lv\">He had a cool episode with Marc Benioff recently</a>.) We sat down for a discussion on managing through crisis, open source and AI, employee liquidity, future of WordPress, and more. You can watch on YouTube below or <a href=\"https://pca.st/j368ze4b\">listen on Pocket Casts</a>.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Feb 2025 20:50:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Gravatar: How to Set Up a Custom Domain Handle on Bluesky\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2814\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://blog.gravatar.com/2025/02/06/bluesky-handle/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13865:\"<p>&#8220;<em>Why does everyone on Bluesky have cooler handles than me?</em>&#8220;</p>\n\n\n\n<p>If you&#8217;ve joined <a href=\"https://bsky.app/\">Bluesky</a> recently, you might have noticed something different about the usernames. While you&#8217;re stuck with @yourname.bsky.social, others are rocking handles like @sarah.cool or @team.company. These custom domain handles are one of Bluesky&#8217;s standout features – but until recently, getting one meant diving into the complex world of domain registration and DNS configuration.</p>\n\n\n\n<p>With <a href=\"https://edition.cnn.com/2024/11/13/tech/x-musk-bluesky-users-post-election/index.html\">Bluesky&#8217;s user base doubling in just 90 days</a>, standing out matters more than ever. But who has time to become a DNS expert just to get a better username?</p>\n\n\n\n<p>Here&#8217;s some good news: <a href=\"https://gravatar.com/\">Gravatar</a> now offers free domains that connect directly to Bluesky. No complex setup required. These domains come pre-configured, so you can skip the technical hurdles and start using your custom handle right away.</p>\n\n\n\n<p>Let&#8217;s explore how to <a href=\"https://blog.gravatar.com/2024/06/26/link-your-gravatar-profile-with-a-free-custom-domain/\">claim your free domain from Gravatar</a>, connect it to Bluesky, and get a verified custom handle in minutes.</p>\n\n\n\n<a href=\"https://wordpress.org/plugins/gravatar-enhanced/\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_enhanced_cta.png\" alt=\"\" class=\"wp-image-2634\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Why custom domain handles make your Bluesky profile stand out</strong></h2>\n\n\n\n<p>A custom domain handle on Bluesky (@yourname.cool instead of @yourname.bsky.social) signals that you&#8217;ve taken an extra step to establish your presence on the platform. This verification proves you own the domain – something that adds credibility to your profile, no matter your title or type of profile.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Creators and professionals: </strong>Writers like @sarah.ink and artists like @studio.art are using custom handles to build recognizable personal brands.</li>\n\n\n\n<li><strong>Small businesses:</strong> Local shops are claiming handles like @cafe.place to stand out in their communities.</li>\n\n\n\n<li><strong>Teams and organizations:</strong> Companies use handles like @news.company for announcements and @support.company for customer service.</li>\n\n\n\n<li><strong>Early adopters: </strong>Tech-savvy users are grabbing memorable handles like @me.cool before they&#8217;re gone.</li>\n</ul>\n\n\n\n<p>The best part? While others are still struggling with complex DNS setups, you can claim your free domain from Gravatar and have your custom handle running in minutes.</p>\n\n\n\n<p>Until now, getting a custom handle meant:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Finding a domain registrar.</li>\n\n\n\n<li>Paying yearly fees (usually $10-30).</li>\n\n\n\n<li>Figuring out DNS records.</li>\n\n\n\n<li>Adding TXT entries.</li>\n\n\n\n<li>Waiting for verification.</li>\n\n\n\n<li>Hoping you didn&#8217;t mess anything up.</li>\n</ul>\n\n\n\n<p>Gravatar&#8217;s solution? Skip all that. Our domains come pre-configured for Bluesky, and your first year is free. Here&#8217;s everything you need to know:</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>The simplest way to get a custom Bluesky handle: Gravatar domains</strong></h2>\n\n\n\n<p>Getting a custom Bluesky handle just got much easier. Gravatar now <a href=\"https://support.gravatar.com/profiles/custom-domains/\">offers free domains</a> that come pre-configured, removing all the technical setup typically needed for custom handles.</p>\n\n\n\n<p>These free domains work with Bluesky right out of the box – no DNS configuration required. When you sign up for a Gravatar profile, you can choose from fifteen different domain extensions:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Classic options like .info, .pro, and .link</li>\n\n\n\n<li>Personal branding choices like .guru, .ninja, and .bio</li>\n\n\n\n<li>Social media-focused extensions like .social and .cool</li>\n\n\n\n<li>Professional options like .contact and .place</li>\n</ul>\n\n\n\n<p>The best part? <strong>These domains are free for the first year.</strong> After claiming your domain through Gravatar, you&#8217;ll get full details about renewal pricing during checkout. This makes Gravatar&#8217;s solution perfect for anyone who wants a custom Bluesky handle without dealing with domain registrars or DNS configuration.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step-by-step: Connect your free Gravatar domain to Bluesky</strong></h2>\n\n\n\n<p>Ready to set up your custom Bluesky handle? Follow these simple steps to claim your free Gravatar domain and connect it to Bluesky in minutes:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Head to <a href=\"https://gravatar.com\">Gravatar</a> and click the <em>Get Started Now</em> button in the top right corner. Fill in your details and complete your profile setup.</li>\n</ol>\n\n\n\n<img width=\"1350\" height=\"998\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/get-started-now-button-gravatar.png\" alt=\"Button to create a new Gravatar profile\" class=\"wp-image-2818\" />\n\n\n\n<ol start=\"2\" class=\"wp-block-list\">\n<li>From your Gravatar dashboard, find the <em>Claim Domain</em> option in the top left menu. If you can’t find it, go to <em>Settings &gt; Profile URL </em>tab.&nbsp;</li>\n</ol>\n\n\n\n<img width=\"1351\" height=\"957\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/gravatar-claiming-custom-domain.png\" alt=\"Profile URL settings in Gravatar\" class=\"wp-image-2820\" />\n\n\n\n<ol start=\"3\" class=\"wp-block-list\">\n<li>Choose a domain extension that fits your style from the available options (e.g., .cool, .bio, .social). In this section, you can see how much the renewal would cost for each domain option.&nbsp;</li>\n</ol>\n\n\n\n<img width=\"1363\" height=\"1254\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/custom-domain-options.png\" alt=\"Choosing a custom domain through WordPress.com\" class=\"wp-image-2821\" />\n\n\n\n<ol start=\"4\" class=\"wp-block-list\">\n<li>Want a more personalized touch? Click the <em>Change</em> button next to your profile URL to adjust your domain before finalizing.</li>\n\n\n\n<li>You’ll be redirected to a <a href=\"http://wordpress.com\">WordPress.com</a> checkout page to register the domain, but don’t worry – your first year is free.&nbsp;</li>\n</ol>\n\n\n\n<img width=\"660\" height=\"294\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/domain-purchase-checkout-page.png?w=660\" alt=\"WordPress checkout page for a custom domain\" class=\"wp-image-2822\" />\n\n\n\n<ol start=\"6\" class=\"wp-block-list\">\n<li>Complete the checkout, and you’ll receive an email confirming that your domain is active.</li>\n</ol>\n\n\n\n<img width=\"1218\" height=\"925\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/domain-confirmation-email.png\" alt=\"Confirmation email for an activated custom domain by WordPress.com\" class=\"wp-image-2823\" />\n\n\n\n<ol start=\"7\" class=\"wp-block-list\">\n<li>Open the Bluesky app or website, navigate to <em>Settings &gt; Account &gt; Handle</em>, and select <em>Change Handle</em>.&nbsp;</li>\n</ol>\n\n\n\n<img width=\"871\" height=\"573\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/settings-handle.png\" alt=\"Handle settings in Bluesky app\" class=\"wp-image-2825\" />\n\n\n\n<ol start=\"8\" class=\"wp-block-list\">\n<li>Click <em>I Have My Own Domain</em>.</li>\n</ol>\n\n\n\n<img width=\"660\" height=\"357\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/choosing-personal-domain-for-bluesky.png?w=660\" alt=\"Changing the Bluesky handle with a custom domain\" class=\"wp-image-2826\" />\n\n\n\n<ol start=\"9\" class=\"wp-block-list\">\n<li>Enter your Gravatar domain (make sure it’s activated), and when you get the <em>Domain verified! </em>message, click on <em>Update to [domain name]</em>.&nbsp;</li>\n</ol>\n\n\n\n<img width=\"1219\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/domain-updated-confirmation.png\" alt=\"Confirmation for the changing of the Bluesky domain\" class=\"wp-image-2828\" />\n\n\n\n<ol start=\"10\" class=\"wp-block-list\">\n<li>You’re done! Enjoy your sleek, verified custom handle on Bluesky!</li>\n</ol>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Common questions on Gravatar’s custom Bluesky handles with Gravatar&nbsp;</strong></h3>\n\n\n\n<p><strong>Q: How long does it take to verify my custom domain handle on Bluesky?</strong><strong><br /></strong>A: Verification is quick and usually completes within a few minutes. However, if the system is busy, you might experience a short delay. Don’t worry – your handle will be ready shortly.</p>\n\n\n\n<p><strong>Q: Will I lose my original .bsky.social handle?</strong><strong><br /></strong>A: No. As of December 12, 2024, your previous .bsky.social handle is reserved for you. You won’t need to create a new account to keep it, and you can switch back to it anytime if you decide to stop using your custom domain.</p>\n\n\n\n<p><strong>Q: What happens to tags and mentions associated with my old handle?</strong><strong><br /></strong>A: All tags and mentions linked to your old .bsky.social handle will automatically point to your new Gravatar-powered handle. There’s no risk of losing connections or conversations.</p>\n\n\n\n<p><strong>Q: Is the handle change permanent?</strong><strong><br /></strong>A: Not at all. You can change your handle again or revert to your original .bsky.social handle anytime. Your Gravatar domain will still belong to you, even if you stop using it on Bluesky.</p>\n\n\n\n<p><strong>Q: What else can I do with my Gravatar domain?</strong><strong><br /></strong>A: Your Gravatar domain links directly to your Gravatar profile, which acts as a universal online identity. You can use it to <a href=\"https://blog.gravatar.com/2024/11/11/how-to-list-social-media-handles/\">showcase your other social media profiles</a> and build a cohesive online presence.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Using your existing domain? Here&#8217;s how to verify it&nbsp;</strong></h2>\n\n\n\n<p>If you already own a domain and want to use it as your Bluesky handle, you’ll need to verify it by adding a <strong>DNS TXT record</strong>. Here’s how:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>When you initiate the handle change on Bluesky, the platform will provide the specific TXT record you need. This record includes three key fields: <strong>host</strong>, <strong>type</strong>, and <strong>value</strong>.</li>\n</ol>\n\n\n\n<img width=\"1091\" height=\"767\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/dnx-records-for-custom-domain.png\" alt=\"DNS record for changing the Bluesky handle with a custom domain\" class=\"wp-image-2827\" />\n\n\n\n<ol start=\"2\" class=\"wp-block-list\">\n<li>Log in to your domain provider’s DNS management panel (or a third-party service like <a href=\"https://www.cloudflare.com/\">Cloudflare</a>). Locate the section for adding DNS records.</li>\n\n\n\n<li>Input the host, type, and value provided by Bluesky into the appropriate fields. Save the changes.</li>\n\n\n\n<li>Wait for propagation. While DNS propagation can take up to 24 hours, it usually completes within a few minutes if everything is configured correctly.</li>\n\n\n\n<li>Return to Bluesky and click <em>Verify DNS Record</em>. Once verified, your profile will automatically update to use your domain as the handle.</li>\n</ol>\n\n\n\n<p>This process adds a layer of credibility to your handle and ensures it’s uniquely tied to your domain ownership.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Managing multiple handles and subdomains</strong></h3>\n\n\n\n<p>Organizations often benefit from managing multiple handles under a single domain. For example, a company could use <em>@news.gravatar.com</em> for announcements and <em>@support.gravatar.com</em> for customer service. This creates a cohesive, professional identity across departments or teams.</p>\n\n\n\n<p>To set up multiple handles efficiently, it’s recommended to use HTTP verification instead of DNS TXT records. This involves creating a file in the <code>/.well-known/</code><strong> </strong>directory on your web server, which Bluesky checks to verify ownership of the subdomains.</p>\n\n\n\n<p>Bluesky provides a detailed guide on <a href=\"https://bsky.social/about/blog/4-28-2023-domain-handle-tutorial\">verifying multiple handles under a single domain</a>. Since the process requires some technical know-how, it’s best suited for developers or IT teams.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Get started with your custom Bluesky handle</strong></h2>\n\n\n\n<p>Using a free Gravatar domain for your Bluesky handle offers plenty of advantages:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Choose from a variety of TLD extensions, like .bio, .social, and .link.</li>\n\n\n\n<li>Enjoy your domain free for the first year, with no need for complex DNS configuration.</li>\n\n\n\n<li>Manage your online identity from a centralized Gravatar profile, making it easy to stay consistent across platforms.</li>\n</ul>\n\n\n\n<p>Gravatar domains also help <strong>future-proof your digital identity</strong>. As more platforms adopt domain-based verification, having your own domain now ensures you’re ready for the next phase of social media.</p>\n\n\n\n<p>To get started, visit <a href=\"https://gravatar.com\">Gravatar</a> and claim your free domain from the available options. While Gravatar simplifies the setup process, remember to complete Bluesky’s handle change steps to activate your custom domain handle.</p>\n\n\n\n<p>With just a few clicks, you’ll have a unique, verified handle on Bluesky – and a free domain for the next year!</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Feb 2025 20:24:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Do The Woo Community: Developer Takes, From Code to Connections with Tess Kriesel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=90490\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/developer-takes-from-code-to-connections-with-tess-kriesel/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:222:\"In this episode of DevPulse’s \"Expanding the Stack,\" hosts Carl and Zach explore diverse developer backgrounds, emphasize networking and soft skills, and discuss challenges in today\'s job market with guest Tessa Kriesel.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Feb 2025 10:02:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: #155 – Anthony Jackson on Trying to Figure Out His Way in the Tech World\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=187096\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/podcast/155-anthony-jackson-on-trying-to-figure-out-his-way-in-the-tech-world\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:53794:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, trying to figure out a way through the tech world.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wp tavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Anthony Jackson.</p>\n\n\n\n<p>Anthony is a true technophile whose journey has been shaped by a constant pursuit of understanding new technologies.</p>\n\n\n\n<p>From a young age, Anthony&#8217;s curiosity about technology laid the foundation for a lifetime of exploration. Starting from modest beginnings in computer repair, he steadily transitioned into the world of WordPress, and the complexities of server management.</p>\n\n\n\n<p>This episode really is a story, the story of trying new things, being creative, and always following curiosity wherever it may lead.</p>\n\n\n\n<p>Anthony talks about his early experiences describing the moment computers first sparked his interest, and the subsequent path he charted in the technology space. Despite hurdles and frustrations, particularly with initial web development and WordPress hosting, his story is a testament to determination and resilience.</p>\n\n\n\n<p>As you&#8217;ll hear, Anthony learned the ropes of many technologies from grappling with CSS for website customization, to exploring cloud computing, and the command line in Linux.</p>\n\n\n\n<p>His journey took a big turn when he discovered automated Bash scripts that facilitate the deployment of open source applications like WordPress. This is what Anthony is doing right now, but you&#8217;re going to hear many stories of different pathways that led to this situation.</p>\n\n\n\n<p>Throughout the episode, Anthony sheds light on his philosophy of embracing technology. He speaks about the numerous technologies he&#8217;s explored, the trials he faced along the way, and the value of cultivating his technical skills. With his Bash scripts ready to streamline server setups and deployments, Anthony envisions a future where technology is not just a tool, but a powerful ally for businesses and personal projects alike.</p>\n\n\n\n<p>If you&#8217;re keen to hear some inspirational stories about overcoming tech challenges, resilience and learning, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wp tavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Anthony Jackson.</p>\n\n\n\n<p>I am joined on the podcast today by Anthony Jackson. Hello.</p>\n\n\n\n<p>[00:03:32] <strong>Anthony Jackson:</strong> Hello, Nathan. How are you?</p>\n\n\n\n<p>[00:03:33] <strong>Nathan Wrigley:</strong> Yeah, great. I&#8217;m very, very pleased to chat with you today, not only because you&#8217;ve got some really nice audio equipment, which makes you sound amazing, but also it&#8217;s very nice to meet new faces, new people for the first time ever. That&#8217;s what&#8217;s happening here. I&#8217;ve never met Anthony before.</p>\n\n\n\n<p>But in order that both you, dear listener and I, the interviewer, get to know a bit about Anthony, would you mind giving us your little potted bio. I guess it would be best to keep that in the sphere of technology, perhaps WordPress. But just tell us a little bit about yourself, but not too many spoilers about the episode to come.</p>\n\n\n\n<p>[00:04:03] <strong>Anthony Jackson:</strong> Yeah, so my name is Anthony Jackson. I&#8217;m a technical person by nature. I&#8217;ve always loved technology, always had a thing for it. Went to school for computer technology. I have my own computer repair business. So I do that on the side, part-time, while I work a full-time job, as well as grow the business that you&#8217;re going to learn about here in a little bit.</p>\n\n\n\n<p>So I stay pretty busy, obviously. I love technology, I feel that it can help a lot of people. I don&#8217;t think you should ever be afraid of it. I think you should always embrace it. It&#8217;s one of those things, if you don&#8217;t get on the bandwagon now, you kind of get punished for it later.</p>\n\n\n\n<p>So I&#8217;m just really excited to share with your audience my journey because it hasn&#8217;t been easy, and I&#8217;m really glad I took the leap of faith because if I didn&#8217;t I certainly wouldn&#8217;t be where I am now. So I&#8217;m just really excited to get started and talk about it and share it with you guys.</p>\n\n\n\n<p>[00:04:47] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s great. Thank you so much. Can I just ask, I don&#8217;t know your age, but when I was at school, so I&#8217;m now in my very, very early fifties, but when I was at school, a child at school, computers were just starting to be something that was in the market, it wasn&#8217;t the domain of universities occupying an entire room. It was something which you could hold in both arms, but they weren&#8217;t ubiquitous.</p>\n\n\n\n<p>You know, maybe the school had one. It was very rare for an individual to own a computer. And so it wasn&#8217;t really until I was much older and had left school that computers became a bit of a thing which people could tinker with.</p>\n\n\n\n<p>What was the experience for you? Again, I&#8217;m not trying to wrangle your age out of you, but just give us an insight into how much computing had progressed by the time you were sort of at school?</p>\n\n\n\n<p>[00:05:28] <strong>Anthony Jackson:</strong> Oh my gosh, Nathan, I&#8217;ll tell you a little backstory. So my mom left me when I was younger. My dad had passed away. It was kind of just me and I lived with my aunt. She had given me a computer to go live with my mom. She had found my mom is what happened.</p>\n\n\n\n<p>I turned it on and it was just an old compact, it booted up so slowly. I had no idea what it was, how it worked, what the purpose of it was. All I knew was I wanted to be on the internet. At that time it was AOL, that was the place to be.</p>\n\n\n\n<p>I remember turning it on and I pressed the button on the DVD player and the tray opened, and I was like, wait, what is the sorcery? Like, and I&#8217;m like, oh, that&#8217;s cool. Okay, we&#8217;ll go with that. And the neighbor knocked on the door and said, hey, you&#8217;ve got some mail, and she gave me this disk, remember the AOL 3.0 Running Man disk? And I was like, what is this? Like, 30 minutes of the free internet. I&#8217;m like, what is the internet, right?</p>\n\n\n\n<p>And I put it in this tray and I ended up setting up my account and the first words I heard were, welcome, you&#8217;ve got mail. And I&#8217;m like, no I don&#8217;t, I just checked it. And I got totally hooked immediately on this whole email thing. And I just, it blossomed, man, and I&#8217;ve been doing computers for, God, 20 years now.</p>\n\n\n\n<p>So I love the backstory on it because it really changed my life. Like, I discovered the internet, email. I spent five years homeless without the internet. I never would&#8217;ve known like who to ask for help, how to get help. It truly changed my life, Nathan. It really did.</p>\n\n\n\n<p>[00:06:40] <strong>Nathan Wrigley:</strong> I think there&#8217;s something quite addictive about it, but also I think, and this is from personal experience, I have no reference to psychology of the human race in general, but it would seem that some people really from a very, very early age are drawn to it on a level which is indescribable. You just have this desire to be in close proximity to a computer that&#8217;s switched on, and to be tinkering with it.</p>\n\n\n\n<p>I have that, but I know people who are very dear to me that if you put them near a computer, the first thing they want to do is get out the chair and walk away. You know, there&#8217;s just no interest in it whatsoever. But I think it is something that you can be passionate about in a heartbeat.</p>\n\n\n\n<p>So in your case, you know, you press the DVD button, something happened, you did it on a keyboard and something happened elsewhere over there. It&#8217;s like, ooh, these two things are connected. There&#8217;s something clever going on there.</p>\n\n\n\n<p>And all of a sudden alarm bells are ringing. Like, wow, I&#8217;ve got to dig deeper into this. I know already though that you are younger than I am because you joined the computer world at a time when the internet existed. When I was playing with the first computers, basically, you switched it on and a cursor blinked, and that was it. That was the fun that you had, you had to type things in.</p>\n\n\n\n<p>[00:07:45] <strong>Anthony Jackson:</strong> My first experience was Windows 3.1, back when the briefcase was around.</p>\n\n\n\n<p>[00:07:49] <strong>Nathan Wrigley:</strong> Okay, so as a child leaving school, you&#8217;ve got this interest in computers and what have you. So where did the journey go from there? What were the next steps from Windows 3.1? What are some of the things that began early on? What were the dominoes that fell?</p>\n\n\n\n<p>[00:08:00] <strong>Anthony Jackson:</strong> Well, I discovered Windows XP, it was the hottest thing since sliced bread. I loved XP. Vista was a hot mess. Fast forward, seven was good, eight was terrible. And then Windows 10, and now Windows 11. I figured if I learned Windows 3.1, I kind of had to follow the journey. So I started Googling the different features of Windows, realised quickly that an operating system is an operating system, it&#8217;s just where you find stuff, right?</p>\n\n\n\n<p>I love the fact that I could see it progress, that I could be a part of that and help people. And that&#8217;s what really turned me onto it. So the technology thing is what really kind of gets me. I love technology. I love the fact that we can use it to have a good time, to leverage it, to grow our businesses, to do a lot of things, like podcasting and other things.</p>\n\n\n\n<p>[00:08:40] <strong>Nathan Wrigley:</strong> Are you the kind of person that upon receiving a computer, desktop computer, do you like to take it apart and see what the bits are inside there, or assemble your own? Or are you purchase it from the store and let the dust gather on the inside and then dispose of it at some point, 5, 10 years later whatever it may be?</p>\n\n\n\n<p>[00:08:55] <strong>Anthony Jackson:</strong> The thing that I love the most, Nathan, this is going to sound so crazy, I don&#8217;t enjoy building them. I actually don&#8217;t know how to build them. I tried once and failed miserably. But what I love nothing more in my computer repair business is when somebody comes to me and says, Tony, I need to buy a new one, I don&#8217;t know what to do, where do I start?</p>\n\n\n\n<p>I love that conversation because it&#8217;s so overwhelming for a lot of people, and I have a unique way. I took a Tony Robbins class a long time ago for personal development, and they did this whole assessment on me and the results yielded that I had a way of breaking down technical information into a manner that someone can understand.</p>\n\n\n\n<p>So when someone comes to me and says, I need a new computer, I&#8217;m like, okay, I got you, it&#8217;s okay. What do you need? What are you looking for? What are your concerns? And I can have a nice conversation and ease them into making a confident purchase instead of buyer&#8217;s remorse. It makes such a difference.</p>\n\n\n\n<p>[00:09:43] <strong>Nathan Wrigley:</strong> I&#8217;m firmly on the Mac side of things, and when you purchase a Mac, you really only have three or four decisions to make, one of which is color. What color do you want the computer to be? But beyond that, it&#8217;s things like how much memory, how much ram, there&#8217;s very few components that you really get to choose about that.</p>\n\n\n\n<p>But on the Windows side of things, for a family member, I have recently built a computer and I was actually fairly alarmed at how many choices there were for every single thing. And it really did make me realise that there&#8217;s a whole career in just being able to understand what range of graphics cards there are, what range of CPUs there are, what kind of panel could you have as a display, what the keyboards are, what the mouse are.</p>\n\n\n\n<p>And that was really interesting to me. Is that something that you nerd out on then? Do you know all of the kind of serial numbers of the different graphics cards which are available?</p>\n\n\n\n<p>[00:10:32] <strong>Anthony Jackson:</strong> I&#8217;m not that big of a nerd. My nerd comes out when I started Learn WordPress, that&#8217;s when the nerd came out.</p>\n\n\n\n<p>[00:10:38] <strong>Nathan Wrigley:</strong> Okay. Well, we&#8217;ve established your nerd credentials. That&#8217;s lovely. Let&#8217;s move on to WordPress then. When did you, firstly, when was the first time you came across WordPress, and in what context? What did you need it for?</p>\n\n\n\n<p>[00:10:48] <strong>Anthony Jackson:</strong> So a long time ago I started my computer repair business, probably about eight or nine years ago. And the first thing that came to mind was a website. I was like, I have to have a website. I have a business, it&#8217;s a known fact you have to have a website, right?</p>\n\n\n\n<p>Well, I didn&#8217;t know WordPress had never heard of WordPress, so I went where any other person would go, and that was to the internet to find web hosting, and I found godaddy.com. And I was like, GoDaddy it is.</p>\n\n\n\n<p>I had a budget of around $3,000, and what happened was they ended up coding me a really nice HTML, CSS, web development website. But I realised quickly that I&#8217;m a picky person. I wanted things changed. I didn&#8217;t like how things aligned. OCD, like the CSS and stuff wasn&#8217;t aligning. And I wanted more control. I wanted to be able to control that.</p>\n\n\n\n<p>And I remember Googling how to control your website and it said WordPress, the number one platform. I&#8217;m like, what the hell is WordPress? Okay. And I clicked, best decision of my life. I ended up going back to GoDaddy to get hosting, WordPress hosting. I didn&#8217;t know what it was, I had to kind of figure it out. And I realised quickly about shared hosting, and what it was, and how it acted, and I didn&#8217;t like the fact that I was being shared with people, it made me very angry.</p>\n\n\n\n<p>I went through seven different hosting providers, 15 different WordPress for Dummies books, trying to figure things out. Was very, very hard. One day I ended up going to like, I think it was Namecheap or something, and getting a little bit better WordPress hosting with more resources because I thought that would help. And I was sitting there so frustrated because I saw a template but had no idea what to do.</p>\n\n\n\n<p>And all of a sudden after tinkering with WordPress in the back end, I put the word home in what we call the primary menu. And at that point it clicked. I was like, oh my God, I can build a fully fledged website with content that&#8217;s branded to me without having to pay extra to add revisions and stuff like that.</p>\n\n\n\n<p>And so for like two weeks straight, I learned how to install WordPress. I learned the art of the primary menu. I had so much fun just adding the same buttons every time, home, about, services, contact. And then I discovered page builders. That&#8217;s when things really turned. Divi was my first love, and always will be.</p>\n\n\n\n<p>[00:12:50] <strong>Nathan Wrigley:</strong> Did you have to really persevere then, because it sounds like you&#8217;ve got all of the equipment in your head for dealing with technical problems. You&#8217;ve got that sort of passion to see it through to the end. I think I get quite frustrated with certain tasks and give up fairly quickly, but it sounds like you&#8217;ve got all of the bits and pieces.</p>\n\n\n\n<p>10 years ago when you installed WordPress, I&#8217;m guessing it was a much more difficult enterprise than it is now. You know, you&#8217;ve got these hosting companies that you basically click one button and not only will they set your WordPress website up, they&#8217;ll send you the login links, you can probably just click a button to log in on the backend and what have you. Was it fairly frustrating, and do you think that, if you&#8217;d had a different personality type, you would&#8217;ve just thrown the baby out the bathwater and gone, nope?</p>\n\n\n\n<p>[00:13:29] <strong>Anthony Jackson:</strong> A hundred percent. If I did not have my technical background, I would&#8217;ve gave up years ago. I called GoDaddy so many times for support. I can&#8217;t even begin to tell you how many times I called them. And I enjoyed calling them because when I did call them, I got to give them some great feedback because they understood completely what I was trying to do. So it was really cool. I got to see them improve and I got to see myself improve. But it was also nice to be able to call them and get it fixed because I didn&#8217;t have to explain what I was trying to do. I knew what I was trying to do.</p>\n\n\n\n<p>And the design element stuff did not come until later. I spent so much time tinkering with WordPress, buying plugins. Nathan, I&#8217;ve got a repository on themeforest.net of plugins and themes that I haven&#8217;t even touched. I bought anything from caching plugins, to improve performance, to membership plugins, not knowing any idea what they&#8217;ve been. I just went on as spending spree and just bought everything. And now I&#8217;m like, what do I do with it all? Like, I don&#8217;t even know what I want to build.</p>\n\n\n\n<p>[00:14:27] <strong>Nathan Wrigley:</strong> There&#8217;s a definite learning curve there. Just dealing with the nature of the internet. I don&#8217;t know quite how to put this. When I talk to people about how interesting I think the internet is, I can very often sense that people&#8217;s eyes are glazing over. You know, oh Nathan, dear Nathan, what&#8217;s the matter with you?</p>\n\n\n\n<p>But I think on a very profound level that it is amazing that we live in a time where you can download free software, and with a few dollars invested in hosting, and it doesn&#8217;t have to be a lot, you can have something that the entire world, well, by that I mean people who have access to the internet, the entire world can see.</p>\n\n\n\n<p>And conceptually, I just think that&#8217;s utterly remarkable. And I don&#8217;t know if it ever sort of hits you in the same way that it hits me. But you said, you know, you put the word home on your webpage, or you put something for your home screen and you have that moment of, I can do the internet. I can be on the internet.</p>\n\n\n\n<p>I think that is something which gets lost so quick. But occasionally I stare at what I&#8217;m doing and think, I just click publish and there it is, and everybody can see it. And I think that&#8217;s phenomenal.</p>\n\n\n\n<p>[00:15:35] <strong>Anthony Jackson:</strong> That hit me when I discovered the actual blog portion of WordPress. When I discovered that my content could go out to anybody and everybody with a click of a button. I was a little blown away. I was a little overwhelmed because I was like, this is really cool. I&#8217;ve created a piece of content for somebody that might need my help. They can just click a button and within a few seconds potentially see it. Like that is, you&#8217;re right, it&#8217;s remarkable. But it&#8217;s also really overwhelming for somebody who&#8217;s never experienced it.</p>\n\n\n\n<p>[00:16:00] <strong>Nathan Wrigley:</strong> Yeah, and I guess, you&#8217;ve got to be a little bit careful about what you publish and what have you. But I still think we are in an age where I think it&#8217;s easy to forget how privileged we are that we have access. Well, you and I, for example, we&#8217;ve never met. We&#8217;ve only communicated on the internet via a social network. I messaged to say would anybody enjoy coming on this podcast? You contacted me. Here we are. We&#8217;re using a browser based application to communicate with each other. And this is just totally normal now. And yet my 14-year-old self staring at the computer in the school, what we&#8217;re doing now was the realm of Star Trek.</p>\n\n\n\n<p>This was the kind of thing that people in spaceships did, and yet now it&#8217;s totally normal. And sometimes I try to sort of impress upon my children how remarkable it is, but for them it&#8217;s just, no, no, no, this is what all humans have had for all time. And it just gets lost.</p>\n\n\n\n<p>[00:16:49] <strong>Anthony Jackson:</strong> It is remarkable.</p>\n\n\n\n<p>[00:16:50] <strong>Nathan Wrigley:</strong> Where from there then? So we&#8217;ve reached the point where you&#8217;ve discovered WordPress. What&#8217;s happened subsequently since then? It sounds like you&#8217;ve got your business all pivoted around WordPress as well. What&#8217;s the next step in the story?</p>\n\n\n\n<p>[00:17:01] <strong>Anthony Jackson:</strong> Well, I went through multiple page builders, never really learned another one because I got so comfortable with Divi. I tried Elementor, didn&#8217;t really like it all that much. Tried every block builder. Discovered Gutenberg was the worst thing known to mankind. Tried buying Astra, some other, I forget the other company that has the block builder.</p>\n\n\n\n<p>[00:17:20] <strong>Nathan Wrigley:</strong> Kadence maybe.</p>\n\n\n\n<p>[00:17:21] <strong>Anthony Jackson:</strong> Kadence, yes, I tried them. But the thing that I didn&#8217;t like about WordPress, I loved the page builders, they made things easy, but the one thing that I hated the most is I never really had control of where to put stuff. It always was just like, this is your block, this is where it goes. I didn&#8217;t know CSS. I didn&#8217;t know HTML. I did not know how to move things, and I hated that.</p>\n\n\n\n<p>Because the whole point of me going to WordPress was to have control. And when I lost control, it turned me off. I was the person who built the entire website and canceled my hosting because I wanted more control. That&#8217;s how I learned. I canceled, and bought, and canceled, and bought and thought it would get better and it didn&#8217;t, and I just pushed, and pushed, and pushed and learned.</p>\n\n\n\n<p>So I started to just Google how to move things with CSS. I taught myself the basics of CSS and HTML, and a little bit of JavaScript. Not a lot, just enough to be dangerous. But I wanted control, Nathan. I wanted to be able to do things, and when I discovered that I could do that, that put me in another whole new rabbit hole. Then I discovered plugins that control CSS, selectors and all of that, so it gave me an opportunity.</p>\n\n\n\n<p>[00:18:20] <strong>Nathan Wrigley:</strong> Yeah, I always think that WordPress kind of has been pitched at me by other human beings as this kind of catchall, easy to use solution. I think maybe you&#8217;ll get lucky and you&#8217;ll be satisfied in a way that you clearly are not, you know, if you want every pixel to be mapped perfectly from your head onto the screen, that&#8217;s not going to be the case. But maybe for many people it&#8217;s enough.</p>\n\n\n\n<p>Okay, I&#8217;ve got this templated layout, it&#8217;s fine, I&#8217;m happy with that. I&#8217;ll click publish and whatever&#8217;s there is fine. But if you do want to move things around, and you do want to have a particular layout, and you want to show only these posts here and these posts here, but you want it to look entirely different from the theme that you&#8217;re using, I think it&#8217;s still very confusing.</p>\n\n\n\n<p>And I think the underlying languages of HTML, CSS and JavaScript, which really these days are the underpinnings of certainly the front end of web development, they&#8217;re fairly difficult to acquire if it&#8217;s not your job. If you&#8217;re just doing this evening, weekend, it&#8217;s a bit of a hobby, I still think those things are really difficult to acquire and they&#8217;re not slowing down. You know, in the year 2025 when we&#8217;re recording this, CSS is really on a clip, it&#8217;s really modifying itself quickly. All these different sort of layout systems, flex, grid to learn and what have you.</p>\n\n\n\n<p>So I think the promise of the page builders in WordPress is probably why it&#8217;s as successful as it is. If you rewind the clock 10 years, when they just started to come about, you mentioned Divi and there was Beaver Builder and, oh, all sorts of other ones. I would imagine that if you could chart the growth of WordPress, it would&#8217;ve been the novice user wanting a sort of what you see as what you get, point, click, drag, save solution that meant that WordPress grew. And it sounds like you fitted into that niche quite nicely.</p>\n\n\n\n<p>[00:19:56] <strong>Anthony Jackson:</strong> Yeah, I wanted to know why. Why it wasn&#8217;t working. Why the block couldn&#8217;t move. I was very irritated by that because I had certain expectations for my logo to be correct. And what really got me into WordPress was the fact that it was drag and drop. And I love the word drag and drop, because if you don&#8217;t know how to code, well, drag and drop is the alternative, and it&#8217;s your best friend. But it&#8217;s not a true, genuine, drag and drop experience.</p>\n\n\n\n<p>Because to me, drag and drop genuine experience means to put things where I want to put them. I don&#8217;t want to be limited by the block builder, you know, the blocks that you&#8217;re provided. I want to be able to move it, control it, customise it. Because at the end of the day, people buy into you and not your products and services. But at the same time, your website never gets built because you spend way too much time customising, Googling the 20 best page builders of 2025, and buying a whole bunch of stuff you never needed in the first place, right?</p>\n\n\n\n<p>[00:20:45] <strong>Nathan Wrigley:</strong> So have you doubled down on your page builder of choice and your website building experience is based upon the UI, and becoming an expert and having the perfect muscle memory for doing things in that? Is that how you build your pages, and themes, and structures for web pages now?</p>\n\n\n\n<p>[00:21:00] <strong>Anthony Jackson:</strong> So, ironically enough, Nathan, I&#8217;ve actually got away from doing WordPress. I transitioned into something different, which we&#8217;re going to get to here in a minute. I learned everything about WordPress. I wanted to learn. The only thing I didn&#8217;t learn was WooCommerce. I understand what it is, I just didn&#8217;t want to learn it. I didn&#8217;t have a need for, my business didn&#8217;t sell digital products.</p>\n\n\n\n<p>I got out of it because it just became frustrating because I just couldn&#8217;t do what I wanted to do, and I didn&#8217;t have the budget to pay someone to fix it. I knew if I did, I would probably just cancel anyways because I wanted it to look even better. So I just stopped because I didn&#8217;t want to do it. I discovered that I wanted to learn how to actually deploy WordPress for myself instead of using a hosting provider because that&#8217;s the easy way.</p>\n\n\n\n<p>So one day I was Googling and I came across the word Linux. I was like, Linux, okay, that sounds like a fun rabbit hole. Let&#8217;s check it out. I discovered my first cloud computing company, which was Linode. I called them up and, you know, I got to be honest with you, I wasn&#8217;t super impressed with them, because the one thing that I realised quickly is that there&#8217;s no support at all. It is all community driven. If you think about WordPress, the open source, there&#8217;s no support. It&#8217;s all just learning community based forums, podcast episodes, wherever you can get content. Thank God WordPress, the audience is so big that you can get help. But to this day, there&#8217;s still things that I still want to know the answers to about WordPress, but I just can&#8217;t find anymore.</p>\n\n\n\n<p>But I discovered Linux and I had a very, very difficult time of spinning up a server. I struggled so badly with the command line, so badly. And then I discovered that Linode had one click apps and one of them was WordPress. I was like, here we go again. I installed WordPress. I grew a little bit of a fascination with trying to find my credentials inside the terminal, realised quickly that shared hosting was not the only option to deploy WordPress.</p>\n\n\n\n<p>My biggest problem with the server stuff was there was no support. I struggled very badly. Everything I Googled said, copy this, copy that. I&#8217;d copy and paste, I wouldn&#8217;t get the result. I was throwing things around, spinning up servers left and right, getting so frustrated. I&#8217;m like, what do I need to do?</p>\n\n\n\n<p>So I ended up buying a course on Udemy, and went through this very, very great course for absolute beginners and discovered quickly what I was doing wrong. Completely stopped the course and started learning again, because I&#8217;m not that type of person who takes the course. I find my fix, and then I go back to like tinkering with things. I spun up, I don&#8217;t know, probably 300 little VPSs trying to figure things out. Needless to say, I&#8217;m a master of installing WordPress with Linode now.</p>\n\n\n\n<p>[00:23:24] <strong>Nathan Wrigley:</strong> Have you got into Linux server admin, sort of sys admin as a way, well, that was just the fun that you were having at the time, and then discovered that, okay, WordPress can bolt on top of that. And so now the two things have combined and you are back to WordPress, or have you entirely stopped with WordPress?</p>\n\n\n\n<p>[00:23:40] <strong>Anthony Jackson:</strong> I never got into the sys admin stuff, but the next journey for me was, I Googled Linux and I had WordPress. I hated the command line, Nathan. The commands, the black and white was so overwhelming. As it turns out now it&#8217;s like my best friend. I can&#8217;t live without it because it&#8217;s so much easier if you know what you&#8217;re doing.</p>\n\n\n\n<p>But I discovered something called cPanel, and when I got into cPanel I was like, okay, this is cool. I got a GUI, I can look at something, and lo and behold, guess what I found first? Install WordPress. I&#8217;m like, it&#8217;s back again, right? Everywhere I turn, WordPress kept coming back.</p>\n\n\n\n<p>So I learned how to install cPanel on my own server, trials galore, WordPress. Ended up getting super frustrated with cPanel, because cPanel is extremely technical, if you are not in a shared hosting environment where it&#8217;s managed. It&#8217;s extremely technical. They started giving me questions, I started asking for commands. I started taking notes of those commands, so when I broke something, I would know what to do.</p>\n\n\n\n<p>And I learned cPanel pretty proficiently, but got overwhelmed with it just because the technical. There&#8217;s a difference between documentation and technical documentation. Documentation is, click here, do this. Technical documentation is, before you get started, make sure that cPanel&#8217;s installed properly on your server. It&#8217;s like, okay, first of all, what is cPanel and how do you install it properly? Is there such a thing?</p>\n\n\n\n<p>Like it feels so overwhelming and you couldn&#8217;t contact Linode, you had no support. The only thing you had was cPanel. So I went through hundreds of cPanel trials trying to figure things out. Grew a fascination with the command line and installing cPanel. And I discovered pretty quickly that, even though I didn&#8217;t want to learn WordPress anymore, I wanted to provide hosting for WordPress.</p>\n\n\n\n<p>I wanted my own hosting provider. I wanted to be the guy who said, you know what you need, WordPress hosting, I got you. But as it turns out, hosting WordPress on your own server is difficult because you don&#8217;t have that system admin background to fix things. Makes it extremely challenging and it, your confidence goes way, way, way down, because you cannot provide that quality of hosting that you want to provide.</p>\n\n\n\n<p>So upon Googling more, I discovered something called WHMCS, Web Host Master Complete Solution. Loved this concept. This was a dark rabbit hole. I went down this rabbit hole, and discovered quickly that I would have to install it on my own server, which I lacked knowledge of. Biggest problem was the file manager, figuring out the file structure, how to navigate to the path, trying to figure all that out.</p>\n\n\n\n<p>And I finally got that installed and I learned about WHMCS. And through some Googling and YouTube, I hooked up my first server and I click install and it provisioned an instance of WordPress inside of WHMCS. I saw a button that said, log into WordPress. And I was like, oh my God. There&#8217;s a button.</p>\n\n\n\n<p>And I clicked this button and I was like, oh my God, it just launched WordPress. I was blown away, so I was like, let&#8217;s get a business going. So I started writing documentation and yeah, it wasn&#8217;t that easy.</p>\n\n\n\n<p>[00:26:26] <strong>Nathan Wrigley:</strong> Boy, I mean, you get the prize for commitment though. I mean, I don&#8217;t know if you&#8217;ve got just bucket loads of time on your hand, or if you are just the kind of person that, once you&#8217;ve set yourself a task, it&#8217;s going to annoy you until you finally cross that Rubicon. But you&#8217;ve got a lot stickability.</p>\n\n\n\n<p>[00:26:42] <strong>Anthony Jackson:</strong> I&#8217;m a determined individual. I went through multiple attempts at WordPress hosting, but I discovered that I was going to need help. I was going to have to find a way to provide this because I didn&#8217;t have the system admin background. So I discovered reseller hosting. And this is kind of where things blossomed.</p>\n\n\n\n<p>Reseller hosting was great, because they not only provided the WHMCS license free, they provided a cPanel license and I didn&#8217;t have to manage it. It was the perfect setup. I was like, oh my God, this is perfect. So I really started to dig into my business then. But then I discovered really quickly that without customers, this is going to be really difficult.</p>\n\n\n\n<p>[00:27:14] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s the crucial bit that you have to have somebody to resell it to.</p>\n\n\n\n<p>[00:27:17] <strong>Anthony Jackson:</strong> So after three, four months of messing with tech and mastering the art of cPanel, WHM and WHMCS, I stopped because I didn&#8217;t have any customers. Why pay 40 bucks a month if you&#8217;re not making any money, right? Didn&#8217;t make sense. So I was like, well, I need to figure out a different way to provide hosting. I came across something in Linode called Bash. Bash scripting.</p>\n\n\n\n<p>I did a little Googling, looked at some images, and I&#8217;m like, okay, it&#8217;s coded. I&#8217;m not a coder. How am I going to do this? And I went back and looked at cPanel, because I had installed it one day and I noticed that the word Bash was in their installation command. And I was like, what the hell is Bash? And what is it doing in this command?</p>\n\n\n\n<p>So Google, Google, Google. I discovered some commands, curl, Wget in Linux, all the stuff, and realised that I could pull a file down from the internet and run it as Bash. I was like, this is wicked cool. And I wanted to be able to deploy WordPress, but I wanted to be able to provide it to somebody else so that I didn&#8217;t have to deal with the server side. I wanted to be able to give them a script and say, you can download this script, click a button, add your domain, make sure your DNS is set up and you&#8217;re golden. And I was like, this is cool.</p>\n\n\n\n<p>But then I realised like, I need a way to deploy WordPress because I can&#8217;t use Linode because then I&#8217;m doing it. I don&#8217;t want to help them get to where they need to be because I don&#8217;t know how. So how do I offer WordPress hosting in a manner that they can do it in a session that they can understand? So what I ended up doing was I discovered Docker.</p>\n\n\n\n<p>[00:28:35] <strong>Nathan Wrigley:</strong> You have been everywhere.</p>\n\n\n\n<p>[00:28:36] <strong>Anthony Jackson:</strong> I discovered Docker, and I was like, okay, this is overwhelming, right? Docker Hub, command line. I installed my first WordPress image and I saw the welcome screen. So what we know as WordPress, when we log in, we just log in with our credentials and we&#8217;re good. This brought me to the actual installation screen of WordPress. Pick your language. And I was like, oh, this is where it really begins, right?</p>\n\n\n\n<p>So when I discovered Docker, I found the first image and I launched my first instance of WordPress using Docker, and it was local. And I went to go do everything and it said, error, database not found. I was like, this isn&#8217;t good, because I knew that the database was the core, right?</p>\n\n\n\n<p>So I learned in Docker how to set up a database with my SQL. And after some serious frustration around coding YAML files, I got with a guy on Fiverr and I said, listen, I said, I need you to make me a script.</p>\n\n\n\n<p>I need a Docker install that can install WordPress, have a database, and also be able to get an SSL on the domain, because adding SSLs in Linux is a pain in the butt. I don&#8217;t know if you&#8217;ve ever been down this road. One of the biggest things about cPanel and the shared hosting is the automatic SSL feature is flipping amazing. It&#8217;s one of the things you&#8217;ll fall in love with, because your site has to be secure for multiple reasons.</p>\n\n\n\n<p>But regardless, he ended up using something called Caddy server. Reverse proxies, all that stuff. He ended up just creating the script. And he goes, just run it. I&#8217;m like, how do I run it? I have no idea. He&#8217;s like, just make a file, do this. And I put the code in and all of a sudden I hit enter and this thing started running. It started updating packages, and servers, installing Docker, Docker Engine, Docker Compose, running and running and running and running. And I&#8217;m just watching it running. My eyes are just lighting up the whole time. I&#8217;m like, oh my God, what is doing?</p>\n\n\n\n<p>[00:30:14] <strong>Nathan Wrigley:</strong> It&#8217;s like watching the Matrix or something, isn&#8217;t it?</p>\n\n\n\n<p>[00:30:17] <strong>Anthony Jackson:</strong> It would pause, it would extract, it would unzip files. I thought it was broke. I restarted like seven times. And all of a sudden it stopped, Nathan, and said, your WordPress instance is ready, go here. And I was like, no way. No way. And I&#8217;ll be damned, man. I clicked the link and there it was on my own domain secure, and I was blown away.</p>\n\n\n\n<p>I didn&#8217;t even log in because I knew it right then and there that I could deploy WordPress and everything would be fine, right? And so I saw this WordPress and I was like, oh my God, I just deployed WordPress in minutes, not hours, on my own server with nearly no technical knowledge.</p>\n\n\n\n<p>[00:30:51] <strong>Nathan Wrigley:</strong> I don&#8217;t know, I think you&#8217;ve acquired quite a lot of technical knowledge on the way.</p>\n\n\n\n<p>[00:30:55] <strong>Anthony Jackson:</strong> Well, thank God, right? Because running that script was extremely challenging, but I was just, you know that moment when you discover something and you&#8217;re clapping and you&#8217;re smiling and you&#8217;re putting your hands over the air? I was clapping away. That&#8217;s where my mind was at. And when I did that, that&#8217;s when the business really started, because I wanted to be able to offer WordPress hosting without having to worry about the sys admin stuff. So I figured if I just provided a script.</p>\n\n\n\n<p>So now I have a script that&#8217;s made in Bash that you just copy and paste a command and the script runs and does what it needs to do. All you need to do is just add your A record for the DNS and your SSL and you&#8217;re good to go.</p>\n\n\n\n<p>[00:31:28] <strong>Nathan Wrigley:</strong> So is that, dare I ask, is that where you&#8217;re at now? Or is there another sort of, I don&#8217;t know, you just sort of, quick, pivot left? Is there something else coming?</p>\n\n\n\n<p>[00:31:36] <strong>Anthony Jackson:</strong> No, there&#8217;s more. So Bash is kind of where I stopped. I didn&#8217;t really learn Bash, but as you know there&#8217;s a lot of drama in the WordPress community, and it seems to shine on X. And I made a decision that it&#8217;s going to be really hard to market because of all the competition with WordPress. And I kind of stopped.</p>\n\n\n\n<p>And so the business now, this is where I&#8217;m at, I&#8217;m creating Bash scripts for popular open source applications. Because if there&#8217;s one thing that I&#8217;ve learned through my journey with WordPress and learning servers and Linux, it&#8217;s that the open source community is so powerful. Your privacy, your focus, your respect, your content, your everything is so important. So I&#8217;m actually creating Bash scripts that automate the process of those popular open source applications like WordPress, Plausible Analytics, Nextcloud, all those popular ones.</p>\n\n\n\n<p>I&#8217;m in the process of making scripts for all those, and it makes the process easy because when I first started deploying open source applications, my biggest challenge was the documentation. Trying to understand it, trying to read it, trying to make sense of it. And when I saw that WordPress script run, man, I was like, oh my God, I can make anything run, and now I&#8217;ve got five scripts.</p>\n\n\n\n<p>[00:32:46] <strong>Nathan Wrigley:</strong> And so is that going to be the business in the future there? Where you come along and you, I don&#8217;t know, you want Moodle or something, or you want Joomla or WordPress or whatever it may be, and you&#8217;ve got a script which you basically just put it on your server, run it, find the path to it, run it, and you&#8217;re off to the races.</p>\n\n\n\n<p>That&#8217;s an interesting business model and not one, well, I mean, obviously, that business model is encapsulated in many, many, many hosting companies and hosting solutions like cPanel and what have you, but yours is going to be just, buy the script, off me, run the script, and then you&#8217;re on your own.</p>\n\n\n\n<p>[00:33:16] <strong>Anthony Jackson:</strong> Because the biggest issue that I&#8217;m finding with people, it&#8217;s not so much the command line, it&#8217;s tying the SSL into it. And a lot of people are hosting these open source applications locally, but there&#8217;s a problem with that. There&#8217;s a big problem. We talked about at the very beginning of this podcast episode, it&#8217;s not on the internet. It&#8217;s local to your computer, nobody can see it.</p>\n\n\n\n<p>What Caddy does is creates that reverse proxy and puts it on your own domain so that the world can see it. It solves a big problem. Because Linux is so big, you not only have to learn the operating system. You not only have to learn the command line. You&#8217;ve got to learn the commands itself. You&#8217;ve got to have serious patience. You&#8217;ve got to be able to do a lot of things to get to where you need to be with Linux to be comfortable.</p>\n\n\n\n<p>These scripts make it super easy. Literally, like you point your A record, you let it propagate, you press a button and it goes. And I went as so far to this, this is really cool, I had someone else create a script that secures your server as well. So when you run this WordPress script it disables root login, it does all the security best practices, uses public key authentication, the whole nine yards. Then it installs Docker, Docker Compose, Docker Engine, runs the file, runs Caddy, installs WordPress, and you have a secure server set up in 10 minutes with your own WordPress instance on the internet ready to go.</p>\n\n\n\n<p>[00:34:27] <strong>Nathan Wrigley:</strong> Yeah, I remember the famous five minute install for WordPress, but this is more like five minute install for all the stack. Click the button, go off, make yourself a coffee, and by the time you&#8217;ve come back everything is done. That&#8217;s so interesting.</p>\n\n\n\n<p>[00:34:40] <strong>Anthony Jackson:</strong> There&#8217;s a couple of manual processes because of the way the script is built. But if you have a technical background, you&#8217;re good to go. And one of the reasons I did this, Nathan, was because I realised there was no support as we discussed, right? Well, I didn&#8217;t know everything about Linux. There&#8217;s no way I could be a system admin, no way in hell.</p>\n\n\n\n<p>So I wanted to make a way to where I could give it to someone and say, hey, here it is. Heads up, we&#8217;re not responsible. This is your server. You break it, you fix it. I&#8217;m here to give you the script, I&#8217;m here to troubleshoot why it&#8217;s not working and that&#8217;s it.</p>\n\n\n\n<p>[00:35:10] <strong>Nathan Wrigley:</strong> Yeah, you&#8217;re just the beginning. You are the first step on the journey, and then it&#8217;s hands off from your perspective, and then it&#8217;s over to you. I&#8217;ve got it.</p>\n\n\n\n<p>[00:35:17] <strong>Anthony Jackson:</strong> The scripts are all one-time fees. So you own it, do whatever you want with it. Remodify it, I don&#8217;t care. Make it better, improve it.</p>\n\n\n\n<p>[00:35:22] <strong>Nathan Wrigley:</strong> Where do you sell them then? How has that as a business idea gone down? Have you managed to find customers for that?</p>\n\n\n\n<p>[00:35:28] <strong>Anthony Jackson:</strong> I have not found customers yet. That&#8217;s part of the reason I&#8217;m on here, to help get exposure. I&#8217;m still trying to kind of validate the business idea. Anybody that knows anything about Bash scripts knows that they&#8217;re not sold. They&#8217;re free. I&#8217;ve put a lot of money into having these things created for me, so I want to get a little bit of return on them.</p>\n\n\n\n<p>And they&#8217;re not, I mean, the WordPress one is 27. It&#8217;s nothing crazy. You can deploy WordPress as many times as you want, SSLs, et cetera. It&#8217;s a slow process. I&#8217;m very much, my business in a phase where I&#8217;m building my audience. I&#8217;m trying to find out who that audience is, what their pain points are, what their problems are. And things will probably progress from there. So right now my biggest challenge is just trying not to learn anything else because I&#8217;ve learnt so much.</p>\n\n\n\n<p>[00:36:11] <strong>Nathan Wrigley:</strong> Yeah, it would seem that your history is littered with, well, not dead ends, but kind of temporary dead ends where it leads you to the next thing, and it leads you to the next thing. But actually the thread running through your story that I&#8217;m picking up is that each time you drop a piece of technology and move on to another one, it&#8217;s kind of elevating you towards something a bit more difficult.</p>\n\n\n\n<p>The technologies that we&#8217;re using at the beginning, the next one was a little bit more difficult to manage, and the next one, and the next one, and the next one. And it was that inexorable kind of rise to now where you are doing the full nine yards in this one script. That&#8217;s really interesting. What a fascinating story.</p>\n\n\n\n<p>I tell you what, you have more patience than I have. And I don&#8217;t know how many times you&#8217;ve thrown things at walls, but I suspect if it was me, it would&#8217;ve been quite a few. When those moments of clarity that I don&#8217;t really know what&#8217;s going on here, but I&#8217;m going to persevere. Remarkable.</p>\n\n\n\n<p>We kind of hit the sweet spot in terms of time. So we&#8217;ll sort of wrap it up. What a fascinating journey. I love that story. Tell me, Anthony, where would people find what it is that you are mentioning here, these Bash scripts? Where would we find those? And then another question, very much the same really is, where would we find you? Where do you hang out online, and where could people discover you?</p>\n\n\n\n<p>[00:37:19] <strong>Anthony Jackson:</strong> So my primary home is x.com. I really like X. You can visit my bio, there is a link to the website. Please note the website is being updated from what it is to something else. I was going to do the whole WordPress thing, but things changed a little bit. So I&#8217;ll leave you a link, Nathan, with a link to the shop and you can take a look at the scripts and decide if you want to purchase one. If you do, just know that I truly appreciate your support. Running a small business is extremely challenging on a very tight budget.</p>\n\n\n\n<p>I really feel that this is something that can help a lot of people get where they need to be because there&#8217;s a lot of digital scams in the world. And the one script that I love that I have is the Nextcloud script. And I love the fact that I can store my data securely and not have to worry about privacy and my data being sold. So if you&#8217;re looking for an alternative to keep your stuff safe, definitely a robust option.</p>\n\n\n\n<p>So I&#8217;ll send you a link, Nathan, to the scripts. I&#8217;m still in the middle of updating links and things like that. I&#8217;m just excited to finally have it off the ground and finally have a business after learning nine different technologies in a matter of two years.</p>\n\n\n\n<p>[00:38:17] <strong>Nathan Wrigley:</strong> It sounds like a lot. So what I&#8217;ll say is, when Anthony sends me the link, I will embed it into the show notes. So if you head to wptavern.com/podcast, if you search for Anthony Jackson, then you&#8217;ll be able to find that episode and I will make sure that all of the links that he sends me finally end up on the show notes over there.</p>\n\n\n\n<p>What a fantastic and interesting story. Anthony Jackson, I really hope that your endeavor, all of that hard work pays off. Good luck for the future. Thanks for joining me on the podcast today.</p>\n\n\n\n<p>[00:38:46] <strong>Anthony Jackson:</strong> It was great to meet you, Nathan. Thank you everyone for listening. I hope you enjoyed this story. I hope that it inspires somebody. Technology is an amazing thing. Remember, never fear it, always, always embrace it. It can take you places you&#8217;ve never imagined.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/wphasslefree\">Anthony Jackson</a>.</p>\n\n\n\n<p>Anthony is a true technophile whose journey has been shaped by a constant pursuit of understanding new technologies. From a young age, Anthony&#8217;s curiosity about technology laid the foundation for a lifetime of exploration. Starting from modest beginnings in computer repair, he steadily transitioned into the world of WordPress, and the complexities of server management.</p>\n\n\n\n<p>This episode really is a story, the story of trying new things, being creative and always following curiosity, wherever it may lead.</p>\n\n\n\n<p>Anthony talks about his early experiences, describing the moment computers first sparked his interest, and the subsequent path he charted in the technology space. Despite hurdles and frustrations, particularly with initial web development and WordPress hosting, his story is a testament to determination and resilience. As you’ll hear Anthony learned the ropes of many technologies, from grappling with CSS for website customisation, to exploring cloud computing and the command line in Linux.</p>\n\n\n\n<p>His journey took a big turn when he discovered automated Bash scripts that facilitate the deployment of open-source applications like WordPress. This is what Anthony is doing right now, but you’re going to hear many stories of different pathways that led to this situation.</p>\n\n\n\n<p>Throughout the episode, Anthony sheds light on his philosophy of embracing technology. He speaks about the numerous technologies he&#8217;s explored, the trials he faced along the way, and the value of cultivating his technical skills. With his Bash scripts ready to streamline server setups and deployments, Anthony envisions a future where technology is not just a tool, but a powerful ally for businesses and personal projects alike.</p>\n\n\n\n<p>If you’re keen to hear some inspirational stories about overcoming tech challenges, resilience and learning, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://wphasslefree.com/\">Anthony&#8217;s website</a></p>\n\n\n\n<p><a href=\"https://www.elegantthemes.com/gallery/divi/\">Divi</a></p>\n\n\n\n<p><a href=\"https://www.wpbeaverbuilder.com/\">Beaver Builder</a></p>\n\n\n\n<p><a href=\"https://elementor.com/\">Elementor</a></p>\n\n\n\n<p><a href=\"https://www.cpanel.net/\">cPanel</a></p>\n\n\n\n<p><a href=\"https://www.linode.com/\">Linode</a></p>\n\n\n\n<p><a href=\"https://www.whmcs.com/\">WHMCS</a></p>\n\n\n\n<p><a href=\"https://www.docker.com/\">Docker</a></p>\n\n\n\n<p><a href=\"https://hub.docker.com/\">Docker Hub</a></p>\n\n\n\n<p><a href=\"https://yaml.org/\">YAML</a></p>\n\n\n\n<p><a href=\"https://caddyserver.com/\">Caddy Server</a></p>\n\n\n\n<p><a href=\"https://plausible.io/\">Plausible Analytics</a></p>\n\n\n\n<p><a href=\"https://nextcloud.com/\">Nextcloud</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Feb 2025 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Gutenberg Times: Getting ready for WordCamp Asia 2025 in Manila, Philippines\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=37593\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://gutenbergtimes.com/getting-ready-for-wordcamp-asia-2025-in-manila-philippines/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15919:\"<p>Promoted as the <em>premier open-source summit of Asia</em>, <a href=\"https://asia.wordcamp.org/2025/\">WordCamp Asia 2025</a> will take place from February 20 to 22nd, 2025 in the great capital of the Philippines, Manila. The organizing team has published a ton of information over the last four months. If you, like me, are more a just-in-time preparer it might be overwhelming to get through all the posts and see the forest for the trees.</p>\n\n\n\n<p>First things first: If you haven&#8217;t purchased your ticket, it&#8217;s high time. You need to <a href=\"https://login.wordpress.org/register?locale=en_US&redirect_to=https%3A%2F%2Flogin.wordpress.org%2F%3Ffrom%3Dasia.wordcamp.org%26redirect_to%3Dhttps%253A%252F%252Fasia.wordcamp.org%252F2025%252Flp%252F%26locale%3Den_US\">register for a WordPress.org account</a> and login, before you can buy a ticket.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://asia.wordcamp.org/2025/tickets/\">Get your ticket now! </a></div>\n</div>\n\n\n\n<p>The <em>WordCamp Asia 2025</em> is not one event but three: <a href=\"https://asia.wordcamp.org/2025/contributor-day/\">Contributor Day</a>, a<a href=\"https://asia.wordcamp.org/2025/schedule/\"> conference with talks, and workshops</a>, and <a href=\"https://asia.wordcamp.org/2025/youthcamp/\">YouthCamp</a>, with a schedule for kids 8 &#8211; 17 years old. It will happen at the Philippines International Convention Center (PICC). That&#8217;s also where the <strong>After Party </strong>will take place on Saturday night that concludes this marvelous event. </p>\n\n\n\n<p>I like to get at least a few days of sightseeing in before I enter the convention center for all the fantastic WordCamp activities. The two posts from the local organizing team about <a href=\"https://asia.wordcamp.org/2025/ultimate-guide-philippine-culture-travel-etiquette-phrases/\"><strong>Philippine Culture</strong></a> and <a href=\"https://asia.wordcamp.org/2025/guide-to-filipino-food/\"><strong>Filipino Food</strong></a> gave me a great insight into what I can expect and how I can blend in. Or at least don&#8217;t make a fool out of myself and others. <a href=\"https://bsky.app/profile/bph.social\">I&#8217;ll share photos on Bluesky</a>.</p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>Hey friends! 🌴✨ Get ready for an epic adventure at&nbsp;<strong>WordCamp Asia 2025</strong>&nbsp;in vibrant Manila!</p>\n\n\n\n<p>I’ll be diving deep into the WordPress universe – hanging out at Contributor Day (February 20th) and rocking both conference days (February 21-22nd). Want to connect? I’m totally open to grabbing&nbsp;<strong>coffee, lunch, or catching up</strong>&nbsp;between sessions at the Philippine International Convention Center.</p>\n\n\n\n<p><a href=\"https://bit.ly/bph-wcasia\">Check out my public calendar</a>&nbsp;and snag a slot – let’s turn this tech gathering into an unforgettable networking experience! Can’t wait to swap stories, share insights, and soak up the incredible WordPress community energy in the Philippines. Who’s in? 🚀🇵🇭 #WordCampAsia2025</p>\n</div></div>\n\n\n\n<p>It&#8217;s not all about grinding away! Alongside the <strong><a href=\"https://asia.wordcamp.org/2025/after-party/\">After Party</a></strong>, sponsors have got some cool <a href=\"https://asia.wordcamp.org/2025/side-events/\"><strong>Side events</strong></a> lined up. Check out the list to see how you can join others for a fun run, a chill sunset hangout, Google&#8217;s Site Kit plugin workshop, or Omnisend&#8217;s agency meetup.</p>\n\n\n\n<p>Just today, WooCommerce announced its <a href=\"https://www.eventbrite.com/e/woo-community-meetup-wcasia-2025-registration-1226560478409?aff=oddtdtcreator\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Woo Community Meetup @ WCAsia 2025</strong></a>. </p>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day</h2>\n\n\n\n<img width=\"652\" height=\"434\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Contributor-Day-WordCamp-Asia-2024.jpg?resize=652%2C434&ssl=1\" alt=\"Contributor Day at WordCamp Asia\" class=\"wp-image-37621\" />NATIONAL THEKTE PIRAUR\n\n\n\n<p><a href=\"https://asia.wordcamp.org/2025/contributor-day/\"><strong>Contributor Day</strong></a> is always such a fun kickoff for me at a regional WordCamp. I finally get to hang out with the folks I&#8217;ve been teaming up with on Slack and GitHub for years, and now we can actually chill face-to-face. Some of them are old pals, while others are fresh faces who are already making waves in the open-source scene. Plus, it’s a lot easier to catch up with friends before we’re all swamped by 2,000 more people flooding into the conference center—otherwise, it’s just a nod, a smile, and a quick wave as we pass by each other!</p>\n\n\n\n<p>Make sure you check out the chance to connect with a <a href=\"https://asia.wordcamp.org/2025/human-library-books/\"><strong>Book in the Human Library</strong></a>! This awesome event lets you chat face-to-face with “<strong>Human Books</strong>,” folks who have some pretty amazing stories, unique viewpoints, and cool skills to share. You can ask me anything about Site Editor, Playground, Block development and contributing. My time slot is from 10:30 am to noon (12).</p>\n\n\n\n<p>If you have a hard time selecting one of the 20 team tables, check out our&nbsp;<a href=\"https://make.wordpress.org/contribute/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Contributor Wizard</strong></a>&nbsp;. It is a step-by-step wizard to help you decide which team might be a good fit for you!&nbsp;</p>\n\n\n\n<p>On Contributor Day, you will find me at the <strong>Test Team table</strong>, and I will enjoy working with the table leads <strong>Krupa Nanda</strong> and <strong>Olga Gleckler</strong>.</p>\n\n\n\n<p class=\"has-accent-color has-light-background-background-color has-text-color has-background has-link-color wp-elements-f1b325b7cd203bbfaf0660781c26212b\">🚨 <strong><em>Note:</em></strong><em> Appropriate attire is required for entry to PICC. Guests wearing shorts, undershirts (sando),or slippers/flip-flops will not be allowed to enter. PICC reserves the right to refuse entry to any person who is not appropriately </em>dressed.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Selected talks from the presentation schedule</h2>\n\n\n\n<p>The WordPress community totally crushed it with over 250 proposals for talks and workshops! We’ve got three tracks lined up, and if you can’t swing by, no worries—everything will be livestreamed on YouTube. Since everyone’s got their own interests, it’s tough to pick just a few talks to mention in one go, so I&#8217;m sticking with my own favorites. All in all, the program team has put together a <a href=\"https://asia.wordcamp.org/2025/schedule/\">fabulous schedule</a> featuring <a href=\"https://asia.wordcamp.org/2025/speakers/\">awesome speakers</a> and cool topics. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Friday, February 21, 2025</h3>\n\n\n\n<p><strong>Matias Ventura</strong> kicks off the talks with his <a href=\"https://asia.wordcamp.org/2025/session/keynote/\"><strong>Keynote about the future of WordPress and Gutenberg.</strong></a>Ventura has been the lead architect of the Gutenberg project.  <em>TIL<a href=\"https://gutenbergtimes.com/feed/#79eea268-d46c-461a-8637-58e2a4c62d19\">1</a> that Ventura was one of the co-designers of the <a href=\"https://wordpress.org/themes/twentyeleven/\">Twenty Eleven default theme</a>.</em></p>\n\n\n\n<p>The rest for Friday morning I will spend at <a href=\"https://asia.wordcamp.org/2025/session/the-block-developer-cookbook-wc-asia-2025-edition/\"><strong>Ryan Welcher&#8217;s Workshop: The Block Developer Cookbook</strong></a>. Welcher collected a few more real life examples on how to tackle topics like block transforms, adding editorial notes, creating a custom format and more. This year, I hope the keynote won&#8217;t go over, so everyone interested in the workshop has the opportunity to start it at the beginning.</p>\n\n\n\n<p><strong>Christy Nyiri</strong>, design lead at Special Project&#8217;s at Automattic, talk is next on my list. <a href=\"https://asia.wordcamp.org/2025/session/redefining-wordpress-design-innovating-block-themes-on-automattics-special-projects-team/\"><strong>Redefining WordPress Design: Innovating Block Themes</strong></a>. Nyiri will showcase front and back end of a range of websites, highlighting how the team uses the latest WordPress feature to push the boundaries of block theme design. </p>\n\n\n\n<p>On the re-run, I will watch <strong>Abhishek Rijal</strong>&#8216;s lightning talk on <a href=\"https://asia.wordcamp.org/2025/session/getting-started-with-wp-interactivity-api/\"><strong>Getting started with the Interactivity API.</strong></a> The senior software developer from Awesome Motive, explores the new possibilities this API brings to your Gutenberg blocks. I heard from quite a few developers who have a hard time finding a use case for the new API. </p>\n\n\n\n<a href=\"https://asia.wordcamp.org/2025/session/wordpress-speed-build-challenge/\"><img width=\"652\" height=\"368\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Speed-build-challenge-WordCamp-Asia-2025.jpg?resize=652%2C368&ssl=1\" alt=\"\" class=\"wp-image-37631\" /></a>\n\n\n\n<p>The <a href=\"https://asia.wordcamp.org/2025/session/wordpress-speed-build-challenge/\"><strong>WordPress Speed Build Challenge</strong></a> between <strong>Nick Diego </strong>and <strong>Jessica Lyschik,</strong> hosted by <strong>Jamie Marsland</strong>, starts us into the afternoon of the first day. If you are in Manila, I highly recommend being in the room for this spectacle! <a href=\"https://asia.wordcamp.org/2025/open-your-possibilities-by-learning-from-the-experts-wordpress-speed-build/\">See also the article in the news</a> </p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\"><div class=\"wp-block-image\">\n<img width=\"652\" height=\"652\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Do-the-woo-icon.jpg?resize=652%2C652&ssl=1\" alt=\"\" class=\"wp-image-37630\" /></div>\n\n\n<p class=\"has-light-background-background-color has-background\">I’m wrapping up my first day by hanging out with <strong>BobWP</strong> and some other cool hosts from the <strong><a href=\"https://dothewoo.io/\">Do The Woo Network</a></strong> at their sponsor booth. I’d totally love to see you there between 2 and 3 pm. Swing by and say hi! Can’t wait to meet you!</p>\n</div></div>\n\n\n\n<p>The rest of the afternoon, I’m planning to wander around the <a href=\"https://asia.wordcamp.org/2025/sponsors/\">Sponsor hall</a> and chat with everyone at the booths. I’m truly interested to see which AI tools have popped up in the WordPress scene and what cool new products the plugin developers have come up with.</p>\n\n\n\n<img width=\"652\" height=\"435\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Sponsor-hall-2024.jpg?resize=652%2C435&ssl=1\" alt=\"Sponsor hall WordCamp Asia \" class=\"wp-image-37629\" />Photo by Ryonosuke Kaneko\n\n\n\n<h3 class=\"wp-block-heading\">Solutions Spotlight</h3>\n\n\n\n<p>Another kind of presentation is listed under <a href=\"https://asia.wordcamp.org/2025/solutions-spotlight/\"><strong>Solutions Spotlight</strong></a>;  short presentation from selected sponsors. Here is the schedule as of today. It might fill up more as we get closer to the event. </p>\n\n\n\n<img width=\"652\" height=\"236\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Screenshot-2025-02-05-at-13.55.41.png?resize=652%2C236&ssl=1\" alt=\"\" class=\"wp-image-37620\" />\n\n\n\n<h3 class=\"wp-block-heading\">Saturday, February 22, 2025</h3>\n\n\n\n<p>After breakfast, I&#8217;m kicking off my Saturday with <strong>Riad Benguella</strong>&#8216;s talk on the <a href=\"https://asia.wordcamp.org/2025/session/dataviews-and-dataforms-the-future-of-structured-content-in-wordpress/\"><strong>new DataViews and DataForms and the future of structured content in WordPress</strong></a>. Benguella&#8217;s gonna share the story of how these two cool APIs came to be and give us the scoop on how they’ll fit into the wp-admin redesign project, plus what we can look forward to down the line.</p>\n\n\n\n<p><strong>Autumn Fjeld and Candy Tsai</strong> are going to take the audience on a fun ride into <strong><a href=\"https://asia.wordcamp.org/2025/session/content-modeling-custom-post-types-and-custom-fields-in-the-block-editor/\">Content Modeling, Custom Post Types, and Custom Fields.</a></strong> Both of them have been playing around with block bindings and patterns. They’re aiming for a totally Editor-based way to manage custom data, and they even thought about creating a “take it to go” data model plugin. I mean, who else is wondering: is there life after the Advanced Custom Fields plugin?</p>\n\n\n\n<p>Alongside the Data Model talk, <strong>Isotta Peira</strong> and <strong>Hari Shanker</strong> will chat about <a href=\"https://asia.wordcamp.org/2025/session/wordpress-contributions-building-a-transparent-system-for-a-stronger-community/\"><strong>WordPress Contributions: Building a Transparent System for a Stronger Community</strong></a>. It’s a topic I really care about, so I might just head over there instead and catch the other talk later on YouTube.</p>\n\n\n\n<p>After the lunch break I will get ready for my presentation to <a href=\"https://asia.wordcamp.org/2025/session/create-a-demo-with-playground/\"><strong>Create a demo with Playground</strong></a>. I chatted the other day with <strong>Roger Williams</strong> of Kinsta about the talk. </p>\n\n\n\n\n\n\n\n<p>The last speaker slot goes to <strong>Matt Mullenweg</strong> who might again hold an AMA. So prepare your questions. </p>\n\n\n\n<div class=\"wp-block-cover alignwide is-light has-parallax is-repeated\"><div class=\"wp-block-cover__image-background wp-image-37639 size-large has-parallax is-repeated\"></div><span class=\"wp-block-cover__background has-background-dim\"></span><div class=\"wp-block-cover__inner-container is-layout-constrained wp-block-cover-is-layout-constrained\">\n<p class=\"has-text-align-center has-large-font-size\"></p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<img width=\"652\" height=\"490\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Matt-Mullenweg-WordCamp-Asia-2024.jpg?resize=652%2C490&ssl=1\" alt=\"Matt Mullenweg at WordCamp Asia\" class=\"wp-image-37634\" />Photo by chiharu nagatomi\n</div></div>\n</div></div>\n\n\n\n<p>The <strong><a href=\"https://asia.wordcamp.org/2025/after-party/\">After Party</a></strong> will be a great place to unwind from three days of the WordCamp and to make more new friends at a true Filipino fiesta.</p>\n\n\n\n<p>On Sunday, the folks from WordCamp Asia will head out all over the globe, bringing along all the good vibes, tons of community energy, fresh ideas, and new pals to team up with, united in the purpose of democratizing publishing with WordPress. As they take their experiences and inspiration back home, you can bet they&#8217;ll be sharing stories about the incredible sessions they attended, the amazing connections they made, and the innovative projects they’re excited to launch. Together, they’ll work on spreading knowledge and fostering a collaborative spirit, ensuring that the power of WordPress continues to thrive in communities everywhere.</p>\n\n\n\n<img width=\"652\" height=\"92\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/horizontal-long-rgb.png?resize=652%2C92&ssl=1\" alt=\"\" class=\"wp-image-37639\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Feb 2025 14:39:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Do The Woo Community: Woo Gets a Fresh New Look and a Bold Product Direction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=89642\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/blog/woo-gets-a-fresh-new-look-and-a-bold-product-direction/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:180:\"Woo has unveiled a new branding identity, featuring a modern logo and colors, enhancing its support for over 4 million online stores while prioritizing customization and ownership.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Feb 2025 09:26:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Akismet: Version 5.3.6 of the Akismet WordPress plugin is available now\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=284301\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://akismet.com/blog/version-5-3-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:751:\"<p>Version 5.3.6 of <a href=\"http://wordpress.org/plugins/akismet/\">the Akismet plugin for WordPress</a> is now available. This update contains the following&nbsp;improvements:</p>\n\n\n<ul class=\"wp-block-list\"><li>We&#8217;ve improved how the &#8220;Mark as Spam&#8221; and &#8220;Not Spam&#8221; API requests work, making them more useful for improving&nbsp;accuracy.</li>\n\n<li>The styles for the much&#8209;beloved Akismet widget have been&nbsp;modernized.</li></ul>\n\n\n<p>To upgrade, visit the Updates page of your WordPress dashboard and follow the instructions. If you need to download the plugin zip file directly, links to all versions are available in <a href=\"http://wordpress.org/plugins/akismet/\">the WordPress plugins&nbsp;directory</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Feb 2025 21:11:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Christopher Finke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Do The Woo Community: Balancing Features and Focus: Avoiding Feature Creep with Bryce Adams\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=89322\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/balancing-features-and-focus-avoiding-feature-creep-with-bryce-adams/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:199:\"In this episode, Katie and Adam discuss feature creep in product development with guest Bryce Adams. They address balancing new features with core integrity and engaging customer support effectively.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Feb 2025 16:28:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Do The Woo Community: Marketing Across the Stages of Your Woo Biz with Emma Young and Adam Weeks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=89528\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://dothewoo.io/marketing-across-the-stages-of-your-woo-biz-with-emma-young-and-adam-weeks/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:192:\"In this episode, Emma and Adam discuss marketing strategies across business stages, emphasizing the importance of owned, earned, and paid media, audience understanding, and confident branding.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Feb 2025 13:54:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Gutenberg Times: Gutenberg Changelog #114 – Reflections on Gutenberg Times and Do the Woo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=37567\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-114-reflections-on-gutenberg-times-and-do-the-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48976:\"<p>As Gutenberg Times celebrates its 7th anniversary, we discovered an amazing coincidence: Bob Dunn, better known as BobWP, launched the DoTheWoo network in the exact same week back in 2018. Today, Bob and I take you behind the scenes to share the origin stories of our WordPress journeys, explore how key ideas took shape, and reveal the unexpected lessons we learned along the way.Today, Bob Dunn is the host, and I am Bob’s guest.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://dothewoo.io/\">Do The Woo</a></li>\n\n\n\n<li><a href=\"https://dothewoo.io/reflections-on-gutenberg-times-and-do-the-woo-with-birgit-and-bobwp/\">Reflections on Gutenberg Times and Do the Woo with Birgit and BobWP</a></li>\n\n\n\n<li><a href=\"https://bobwp.com/\">Bobwp.com</a></li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/about-us/#why-gutenberg-times\">About us > Why Gutenberg Times</a></li>\n</ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Well, I&#8217;m here with one of my favorite people in the WordPress world. Well, actually outside WordPress. You may know her from Gutenberg Times. How are you doing today?</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Well, hey, Bob. Oh, that&#8217;s so sweet. Yeah, well, I remember that we did some luncheon in Torino, and there was outside the workroom, we were talking about so many other things. Yeah, well, I&#8217;m really glad that we can do the show together.</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah. So I happen to see, and I don&#8217;t know if you had mentioned it somewhere or something, and I saw that you were coming up on seven years or something like that. And I thought, well, I wonder when that is. And it was in January, the same as what we&#8217;ve just celebrated. So I thought, wow. Then we can say 14 years combined. It sounds even more impressive.</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Well, and if you do it times three, seven times three, it&#8217;s 21. That&#8217;s WordPress celebration. Yes, it&#8217;s the 21st.</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>So I just thought we&#8217;d get on here and talk a little bit about, I don&#8217;t want to go into the whole journey, but some of the things maybe we&#8217;ve learned or whatever along the way. And I always wonder when somebody comes up with something, is it more or less a name that comes across in your brain, you think, oh, you just think of this and you wonder what I could do with that? Or is it a concept you have? I want to start this. I want to know which way you did it, and if it was what you wanted to do first—the concept of the idea—and then how did you come up with the name? Was it easy to come up with?</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Well, yeah. So I started at the end of June 2017 to curate news about this new thing that everybody hated—kind of the block editor. And I said, it can&#8217;t be that everybody hates it, but it&#8217;s really amazing and it&#8217;s going to be changing WordPress so much. And I saw it at WordCamp Europe in Paris, and it was kind of a really great—it wasn&#8217;t a live demonstration; it was just kind of a video showing how you do blocks and how you can add &#8217;em to a post and all that. It was very early on. I think the first Gutenberg commit on GitHub was just in February, four months earlier. So it wasn’t really, but it was absolutely fascinating to me. And I wanted to learn what other people do with it, what the plugin developers—if they are interested in it—what they&#8217;re talking about, what the developers are talking about, and where this is going and what the new features are. And I was really trying it out and seeing what’s coming up, and I wanted other people to know about it.&nbsp;&nbsp;</p>\n\n\n\n<p>So I put a Storyfy out. I dunno if some of you might remember Storyfy. That’s kind of a curation tool where you can embed things like posts and pictures and have just a running list of things. And that was very easy to do. And just when they published a blog post or showed off one of the little things that they found cool about the block editor or where a new feature was showcased, I just put it into the Storyfy. And there was up until probably October of 2017, and then I heard the news: Adobe had bought Storyfy and announced that they would end its life in May of 2018.&nbsp;&nbsp;</p>\n\n\n\n<p>I said, well, I&#8217;m not going to wait that long. I need to put it on a website. Well, I’m a web developer. There was this fun thing, WordPress; I should use that. It&#8217;s kind of the first one of many lessons I learned: that you have to put it on your own grounds and not do it on rented land.&nbsp;&nbsp;</p>\n\n\n\n<p>So I thought about it, and then I also had some requests from users in the space that they would like to have a newsletter—like an email newsletter that comes every week or something like that—because they cannot always go to a page. It’s just something new, typical publishing problems that people are not coming to your website to see what&#8217;s new. You need to pull &#8217;em over there. And so that was kind of the thing that came together.&nbsp;&nbsp;</p>\n\n\n\n<p>Because it was all about Gutenberg, I kind of just thought about, okay, what are names of things? And Gutenberg Times came up. Somebody else at the same time had a Gutenberg Hub—that was Munir Kamal—and then there were other people out there. But I really liked the Gutenberg Times kind of name, and it was available. So I registered it in January of 2018, and that&#8217;s how it came about. Then I migrated all the Storyfy updates into the site, and it took a while and I had some people to help me with that. And then I started the newsletter. It was actually pretty easy to kind of follow along because it was kind of that vision that I had.</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, for sure. Mine was kind of erratic when I started focusing. I think I actually dabbled in WooCommerce when it first came out—2011 or something like that. I think it was 2011, I’m pretty sure. Anyway, so I was writing a lot of stuff about it. I actually found on my blog, when I was more into affiliates, people were more willing to buy and spend for their e-commerce site on the plugin. So I just started writing about it, and I did a podcast in 2014 for a little over a year called *The WordPress Breakdown*.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>What?&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>*The WordPress Breakdown.* And I did it with kind of a twist on words. I was breaking down stuff, but then some of them had a WordPress breakdown.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, it’s troubleshooting.</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>And what I did basically was I was just doing 15-20 minute podcasts with just myself. I was talking about plugins or themes and stuff like that—some of the stuff I came across. I did it for, like I said, about 13 or 14 months. And it was just becoming&#8230; I just felt like this is boring. I&#8217;m on there by myself. I&#8217;m talking about this stuff, and it’s really stuff I’m already writing about, and I’m just kind of regurgitating it now through a microphone. And I thought, okay, I’m just going to quit it. I stopped it and I told myself that I wouldn’t start something until I had a really good idea.&nbsp;&nbsp;</p>\n\n\n\n<p>So in 2016, I thought of *Do the Woo*. I thought, okay, what’s out there in the landscape? What would be good to talk about? And I thought, well, there’s really nothing that focused on WooCommerce. And I knew the team there. I knew a lot about it. And so I thought, well, why don’t I go ahead? I got the name. It was one of those things—I wanted something a little bit fun.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, definitely it is. But it’s also that creation in there—*Do the Woo.* I really love it.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>And so the name just came to me. So I contacted WooCommerce and I said, “I want to do this. Is it cool to have Woo in the name?” And so we kind of verbally agreed on it. And so I started that. And about three or four episodes into it, I thought, well, is there enough to talk about with just WooCommerce right now? So I actually changed it to *The WP eCommerce Show* and ran that for two to three years, did quite a bit with that. So I was talking about a lot of stuff, and it was a lot of Woo in it.&nbsp;&nbsp;</p>\n\n\n\n<p>Then in 2018, I decided to kick *Do the Woo* back up in January, and I was actually doing both podcasts at the same time. And it just was becoming too much. So I said, I’ve got to drop one of these. And the WP eCommerce seemed like the one to drop. And so I just took off with *Do the Woo* again. And by episode—I was just saying on the episode before we started doing this one—I think it was episode five, I had Brad Williams come in as co-host because I realized I needed a co-host. It was more fun, whether we have a guest or not. And then it just kind of went from there.&nbsp;&nbsp;</p>\n\n\n\n<p>And the interesting thing is, when I actually came up with the site itself, what, two, three years ago? Whenever. Because it was all done under BobWP.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>There&#8230;&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>At that point, I wanted to get the domain, and *Do the Woo.io* was available. So I went back to Woo and I said, I wanted to buy this domain, but I’m stepping into another space here as far as having that in a domain. And so they said, “What was the agreement before?” And I can’t remember who it was at Woo, but we made an agreement—basically a verbal agreement—and they were cool with it and everything. But then when, like I said, I got the domain, it became a little bit more of a legal thing. So I negotiated with their attorney. They came up with a contract and something that was an agreement of what I could or couldn’t do, or should or shouldn’t do, or something like that. And it was perfectly fine. It was great. So I signed that, and then I was able to use that for the domain.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>It’s quite the journey.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, yeah. Well, you know me too well. My journeys are never nice, straight, narrow journeys with nothing happening.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Nice, quiet, but that’s perfectly okay. You need to stay in the moment, and then all of a sudden creativity strikes.&nbsp;&nbsp;</p>\n\n\n\n<p>It was, so in April of 2019, I started thinking&#8230; I had a podcast in the nonprofit space. So all my life before that was nonprofit space. I had just founded three years earlier a nonprofit technology company—a 501(c)(3)—to help nonprofits with technology because the social justice people are not equipped in doing technology. It’s all self-taught, and they needed a little bit more strategic approach to it. And I was really helping, trying to help with that. And I had a show called *What’s New in NP Tech*, with Ruth, a co-host, and Jim O’Reilly. And he had this wonderful radio voice as well, and he was very polished.&nbsp;&nbsp;</p>\n\n\n\n<p>I’m more about talking off the cuff, starting sentences and never finishing them. And he was very polished. So it was a very good contrast. And I said, okay. And in 2018, he had to stop doing the podcast. And by 2019, I was missing that energy—that you have somebody to talk through things and what’s new and what you want to kind of try out and what’s the purpose of it, then why that and not that?&nbsp;&nbsp;</p>\n\n\n\n<p>So I thought, okay, Gutenberg has a two-week release cycle, and every time there’s so much in it beyond what’s in the release post. In the release post, the release lead—whoever leads it—highlights six, four, or five things, but there’s so much other stuff in there that might be good for developers or theme builders. So I talked with a design director from Automattic at that point, and asked if he would spend every two weeks, two and a half hours or something like that, on our changelog. We’d go through the changelog, highlight things that we want to talk about that are very important, and talk about more than the six things that are highlighted in the release post.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>And that was really fantastic to put it together. We had a certain rhythm to it; we had a certain outline. We also talked about what other people do in the space—if there was a great plugin coming along or a question from listeners. So that was really a great start. We started—I think the first, the zero episode—was in June 2019.&nbsp;&nbsp;</p>\n\n\n\n<p>Since then, I&#8217;ve had a most regular biweekly kind of rhythm. Mark Re did about 40 episodes with me, and then he left Automattic—that was, I think, December 2020 or something like that, after a year of the pandemic kind of thing, or January. And then Greg Ziolkowski from Poland, who was also a Gutenberg developer, kind of came on for another 25 shows or 20 shows.&nbsp;&nbsp;</p>\n\n\n\n<p>And then I started to rotate co-hosts, and that made it much more fun to think about what other people are doing in this space. Can I bring that into the show and still talk about the changelogs? Yeah. We had Tammie Lister and Fabian Kägy, Ryan Welcher, Nick Diego, or Peter Tasker. One show was actually also with Mathias Ventura when he had this new phase of the site editor to announce.&nbsp;&nbsp;</p>\n\n\n\n<p>And with all the phases in Gutenberg, we always had something to talk about. And it was funny—this friend with whom I did the previous podcast, he&#8217;s still a very good friend of mine—and he kind of had the question for me: “So you call it the Gutenberg Times, so when Gutenberg is done, what do you do then?”&nbsp;&nbsp;</p>\n\n\n\n<p>And I said, well, once Gutenberg is merged to Core, wouldn’t your site be completely obsolete? I said, no, I don’t think so. There are a lot of other things that are going to come along. But it was really interesting to see how that, in other people&#8217;s minds, kind of made it, okay, it’s done now. But we all know it’s not done.&nbsp;&nbsp;</p>\n\n\n\n<p>In December 2018, it came into Core. And what are we now, 2025? And we are still working on phase three of the Gutenberg project. So it was kind of interesting to see.</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, I think a lot of people, they think of not an end in sight, but they don’t think of how to now twist it to this way or twist it to that way. Some people are very, I’m going to go to this point, and then this is the point I feel like there’s nothing else to be said, at least from my perspective.&nbsp;&nbsp;</p>\n\n\n\n<p>But you’re like me. I mean, when I had Brad come on—I don’t know how long it was just Brad and me—and then I had Jonathan Wold and Mendel Kurland from GoDaddy back then. They came on. So we started rotating because, again, like you said, it was fun. And then we were bringing in guests too.&nbsp;&nbsp;</p>\n\n\n\n<p>And then just after a while, I started thinking, well, could I build on this? And the more I got into it, the less I wanted to be on the podcast. I just thought—because it started coming to the point where it was, yeah, we’re talking about this and that and all these different things—but also I was seeing people that come on a podcast for the first time as a guest and, after, I mean, they were freaking out at the beginning. But then at the end, or later on, they said, “Wow, that was so much fun and stuff.” And I thought, well, I’d like to get more other voices and have other people talk about stuff, and pick out hosts to have their own specialty and their own knowledge and stuff.&nbsp;&nbsp;</p>\n\n\n\n<p>So it’s been kind of crazy. Some people look at me like&#8230;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah. When did you start with the network of shows? Was that two years ago? Three years?</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Brad came on. Then, on January 9th, 2020, I brought Jonathan in, and Mendel came in. And then, I think it was January 30th, 2021, I brought Zach in, and Ronald joined. Then after that, I just kept thinking, how far can I take this?&nbsp;&nbsp;</p>\n\n\n\n<p>And then, I think it was when I actually launched it as its own site. I had somebody design it. And then after about two years of that, I started doing some other stuff, and I thought, I want to make this more of a—I want to call it, I don’t really know—a network, but a collection of shows with all these different people. So then I had to look at redesigning everything.&nbsp;&nbsp;</p>\n\n\n\n<p>But yeah, it was just&#8230; for me, I mean, I’m at a point where I’ve got to kind of just deal with what I have here now. And all the hosts are volunteers, so they always know. We’ve had a few that have had to leave for one reason or another. They’re getting busy with their business, and they just said, I don’t have the bandwidth anymore. And I say&#8230;&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Thank you for what you’ve done. And I have a hall of fame on my post page and stuff for those that were on before and moved on. So it’s been very flexible with them, scheduling everything. Everybody’s busy and stuff, so we just kind of deal with stuff. We get things all scheduled in for a year, but then we move things around and people have times they can’t show up. Sometimes it’s a little crazy, but they all seem to enjoy doing it, and I’m lucky for that.</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, I have started rotating through. Well, I started to see, okay, the WordPress space is still a little bit more male-oriented, and I see it also in my audiences. Yeah, it’s all 65% male, between 35 and older, or it’s 80% on the podcast. I said, well, I guess I’m in a situation where I can actually also bring some more female voices, especially female engineer voices, to the space.&nbsp;&nbsp;</p>\n\n\n\n<p>And it’s a real joy for me to work with the engineers at Automattic, or other agencies, or other hosting companies. And I kind of want the person who comes on to not only be a one-time guest—if they want to, that’s okay—but if they are on multiple times, they get their own routine for that. And it’s much easier for them to say yes now than for the first time when they don’t really know what to expect.&nbsp;&nbsp;</p>\n\n\n\n<p>So I am really happy to have about 10 to 12 women engineers that kind of rotate through. Most of them are actually in the community. They’re all very knowledgeable about the subject anyway, but then they’ve also put in the grind in theme development or plugin development.&nbsp;&nbsp;</p>\n\n\n\n<p>So it’s really interesting to see what they do, and they bring a different perspective to the whole thing. When I was having a conversation with Greg, who is on the development team, I said, well, I could bring the user questions. What were you thinking? And then he would explain it quite nicely, and I learned a lot when talking with the volunteers—what software development is actually about. It’s&#8230; you have the architecture, but there’s so much behind the scenes that you can’t bring to the forefront. And if somebody says to content creators, it’s just, “What? Just change?” If I hear somebody say, “Well, it’s just an easy fix&#8230;” Yeah, that was kind of&#8230;&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>What?&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>&#8230;what I had when I was running my agency. It was never just an easy fix.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Never.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>It’s always more. Yeah. So it’s interesting to see and bring other voices in there.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah. Yeah, definitely. I know for me, the hosting has always been&#8230; I try to keep some kind of balance in some way, but I’m also asking—the person has to be willing to commit. Somebody. I’ve approached a lot of different people, and a lot of people just don’t have the time to commit or they just don’t. And also, it does take a certain comfort level to be a host. I mean, you want to be able to do it.&nbsp;&nbsp;</p>\n\n\n\n<p>And if you’re almost on the edge just going in as a guest—I mean, I give them the benefit of the doubt. Some of them have come in a little bit reluctant, and they ended up just loving doing it after a bit. So it’s kind of&#8230; And yeah, it’s good. All the different voices. I mean, I’ve had a lot of guests on. I swear that probably 65%, 70%, or maybe it’s higher—I don’t know—are first-time podcast guests. They’ve never been on. And sometimes I have to talk them into it a little bit, and often they’re surprised how much they can talk when they don’t think they can, and they get going.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, it really depends on the questions.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, for sure.&nbsp;&nbsp;</p>\n\n\n\n<p>Want to be a hero when it comes to your clients? You’ve built a site, and now you want to make sure that with your client’s Woo shop, they are ensured that they have accurate sales tax rates in place, especially in case of an audit. Avalara is a leader in automating sales tax and compliance for businesses selling online, both big and small.&nbsp;&nbsp;</p>\n\n\n\n<p>If you’re setting up a new WooCommerce site, get your client set for sales. If you currently manage several client sites, it may be time to make that recommendation. Either way, get their WooCommerce extension and let your clients take advantage of a 60-day free trial. There are also great resources for either you or your clients on their site, where you can learn more about sales tax calculation, among other services like returns and exemptions. So for peace of mind, Avalara.com has you covered.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>I have found that everybody brings something to it, and even if they’re missing knowledge, you can fill that in a conversation. It fills knowledge gaps for other people who are listening. And so I always have appreciation for things that don’t go well because those are the most important moments when you learn things.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Exactly. And I never really had anything that didn’t go well. Sometimes it was just&#8230; yeah, we had one the other day where we had 20&#8230; that’s a horror story. If you have a rundown that’s 29 pages because you have a changelog from three plugin releases because you had a holiday break.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Oh, geez.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah. That is kind of the horror story where you say, okay, you need a special guest for that, who deals with that. And even then, you sometimes get lost. Am I on page 15 or 25? Where am I? Because you scroll so fast. Yeah, we cut that out and regrouped and then came back to it. So it’s great.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>I had somebody&#8230; a couple of times this happened. One of the guests didn’t get recorded in the track. It just wasn’t there. It looked like it was recording and everything. So when I went to play it back, they were out.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>It looked like it was recording and everything. So when I went to play it back, they were out. And I believe one time, one of the hosts actually said, “Well, send me the episode, and I’ll fill in those spots. I’ll listen to it, and then I’ll reply, and then I’ll see what I asked next.” And they did it, and it worked fine, but it was a nightmare for them. Then I had to go in and put everything in.&nbsp;&nbsp;</p>\n\n\n\n<p>But I did have a guest once, and I felt so sorry for them. We don’t do a lot of upfront questions on ours, and sometimes people will request it. And this plugin developer was really pretty nervous about being on. So I said, “Well, let me send you a few questions about what I’ll talk about.” Well, I could tell even when we started, it wasn’t for them.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>So brilliant.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>And I always tell my guests, if you need to start over on something, it’s recorded. So I’m not live. I can go in and edit. And this poor person actually had created the answers for all the questions and was reading them. But he was so nervous that when he was reading them, he kept stopping and saying, “Oh, I got to start over.” And I could just feel his tenseness. And I wanted to say, if this isn’t comfortable, but then I didn’t want to. So we did it. I went in and did some editing, and it turned out fine, but I felt for him.&nbsp;&nbsp;</p>\n\n\n\n<p>I thought, oh, I know that feeling when you think something might be easier for you or something, and you get in there and you just don’t have it in you or something. And I don’t blame them. There are a lot of people that just refuse to come on the podcast. They’ll just say, “Ah, no, I can’t do it.” And I’m like, “Yeah, cool.”&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, I take that no very seriously because you don’t want to&#8230; yeah. But the other part was the horror stories only start when I screw up.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, that’s when I did.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>So at the beginning, I think I missed the record button with my mouse, and we had to do the show again.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>I had one of those.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>I think everybody has. But I have a very good editor who goes through that. She’s been a radio producer all her life, and she helps me with that. So now I just kind of record and record on QuickTime as a backup. So even if I screw up the Zoom recording&#8230; but now with Zoom, you actually get two tracks. And that’s really helpful because sometimes we just talk over each other. It happens when you’re in the moment and you want to—it’s something you’re excited about—then you talk over each other, and it’s hard.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>I have a few people that have been that stuck almost. And I’ll shift tracks, then I shift them and stuff. And I did have the one that I forgot to record—it was when I was doing my other e-commerce podcast. And she ran this company that sold cosmetics, and she was in Ghana. And it was just—she had a Woo online store. That’s why I brought her on. But she would give jobs to local women to go out because they would have to get the ingredients for it. So she provided jobs for a lot of the women there.&nbsp;&nbsp;</p>\n\n\n\n<p>It was a fascinating story, and I finally was able to get her on. And the most embarrassing thing is when you find out in the middle—I looked down, I thought, wow, that record button isn’t going. And I thought, now I have to tell her this right in the middle. Which is&#8230; I don’t know what’s worse: going through the whole thing and then saying, “Oh, sorry, it didn’t record.” So I kind of paused. I said, “Well, I have an interesting situation here. Obviously, I didn’t push the record button.” And she actually laughed, and she said, “Well, go ahead. We can do it again. Just send me your calendar again.” And she was real cool about it, but my heart just sunk.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, imagine no recording, especially when it was a good show and there was a good groove, and then all of a sudden I destroyed it. Oh, man.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>It’s interesting too because some people, when you were talking about somebody asking, “Well, what about when it goes into Core and the goal’s over?” It sounds like you’ve been through a lot. I have been over the seven years. You flex with whatever works. It’s like, okay, is this going to continue? Yeah, well, I can continue it.&nbsp;&nbsp;</p>\n\n\n\n<p>And you’ve tried different hosts and you’ve found that sweet spot. So I think both of us—I was going to ask about, did they ever change for our sites during the seven years? And they probably did in the sense that, yeah, we shifted to this a bit and nothing real maybe. I know that when I moved it to its own domain and kind of focused more on the bigger group of hosts, that was probably a big shift. But it was in my brain for nine months. I was working on stuff.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Well, there wasn’t really a big shift. So I think I changed the theme once, and it’s definitely overdue for a new one because I’m still on a classic theme and I should go on a block theme because then you can do a lot more. But I just didn’t have the time yet to migrate over.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>But I think I’m also&#8230; up until 2021, in summer 2021, it was all a hobby kind of thing. I did it alongside my agency work, and it was up and down in terms of how much time I could spend there. During the pandemic, I had about six—well, four—months of burnout because I had so much work to do, and I didn’t have a break. I had to take my break.&nbsp;&nbsp;</p>\n\n\n\n<p>And the only thing that I did during that break was keeping up with Gutenberg, keeping the Weekend Edition going, and keeping the podcast going. But I wasn’t doing any agency work. The developers and freelancers that I worked with—they were so good at taking over. I said, “I can’t deal with it, and if I have to step in, I’ll step in. But you know how we work.” And they were all many years with me.&nbsp;&nbsp;</p>\n\n\n\n<p>So it was between November 2020 and February 2021. I was only doing the Gutenberg Times, and I was really amazed to see how that always kept my excitement going. And there’s a lot of personal stuff that got in the way afterward. So we moved to Sarasota; we sold the house in Naples, renovated the house. There was a lot of non-work and non-publishing kind of stuff getting in the way.&nbsp;&nbsp;</p>\n\n\n\n<p>Then we organized our house in Sarasota, and after two years of not seeing our parents, we traveled to Europe in 2022. We met in Porto, and you were also moving. So I think we did this pretty much at the same time—moving back to Europe.&nbsp;&nbsp;</p>\n\n\n\n<p>And I was really happy that I got a job at Automattic. And part of that job is keeping Gutenberg Times and the Gutenberg Changelog going as a Developer Advocate. So having that was a real blessing for myself and for me because I couldn’t migrate my agency. I closed the agency when I knew I was going to Europe. And so keeping that going was really good. I’m very grateful for working with Automattic on that.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah. Yeah, I didn’t know that part of it. I mean, how that just seamlessly all worked, and you were able to bring that right into it. Yeah, that’s cool. And I think the big change for me probably was when I went to the bigger network of shows and everything, and started bringing more people in.&nbsp;&nbsp;</p>\n\n\n\n<p>And then at the same time, I was given the gift of a redesign of the site from the Special Projects team at Automattic. Matt gave that to me, which was phenomenal. For a few days, I was just thinking, is this really happening?&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Is this real?&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>I mean, it took us quite a few months to put it together and stuff. And I have one funny story about the launch. We had kind of a soft launch because&#8230;&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>And?&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>I was at CloudFest, and I got a message that said, “Your site is live.” And I’m like, oh, really? I had not planned for that.&nbsp;&nbsp;</p>\n\n\n\n<p>And the ironic part of it—we got such a kick out of it—was my site prior to that had Beaver Builder on it. And I was hanging out with Robbie from Beaver Builder when I got the message, and I told him. And we took this picture. We were having a beer, celebrating and everything. But it was so funny—he just got a kick out of that. I basically removed Beaver Builder, and here he was celebrating with me and stuff. But Robbie’s great.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>The new websites&#8230;&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>But yeah, it still is amazing—the support and everything I get with that side of stuff. A couple of times I’ve really messed it up. I keep saying, maybe I should just let you do more things. I shouldn’t be touching stuff.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>You don’t know where the boundaries are unless you kind of push past them. So yeah, what’s your own knowledge—you want to kind of kick it a little bit.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, yeah. I poke around a bit to kind of understand. Some of the stuff is custom work, so I don’t want to mess that up. But some of it’s adding stuff. I’ve probably learned more about the block editor and everything than I ever thought I would be—just getting in to try to figure out, okay, this has to be a small change. And it’s like, okay, an hour later&#8230; now what happened there?&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, I was doing that actually on WordPress.org. I am part of the editor of the Developer Blog that launched in late 2022. And then I got the note from the Meta team that the Developer Blog now has a block theme, and I have access to it.&nbsp;&nbsp;</p>\n\n\n\n<p>And then I said, “Oh, I can change the navigation.” And I went in there, changed the navigation, and it kind of dropped the whole navigation and added all the navigation to the top-level navigation too. One is the overall WordPress.org, and then on the subsites, you have the own navigation. All of a sudden, my UI was jammed. So it took about two days to fix it. But I said, okay, I’m not going to touch that anymore.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, yeah. I’ve kind of learned now that I did screw something up recently again, and having them look at it&#8230; I even tried revisions, and it seemed like the more revisions I went back to, the worse it got. So it was like, okay, this is hopeless. I don’t know where this stuff went, but it’s not here anymore.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>And here goes a half a day of your life.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, yeah.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>But that’s web development. I think it has&#8230; yeah, it’s always happened. Since when are you doing web pages? How far back is that going?&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Oh, so actually I started doing&#8230; let’s see, when did I first do? We still had our previous marketing and design business around in 2000—I dunno—2005, 2006, somewhere around there.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>&#8230;somewhere around there. I started doing—well, actually, it might’ve been even earlier than that—doing little HTML sites. We were doing print design. We started in 1993, the business. And so I had to kind of kick and scream and be pushed into it. And I made these godawful HTML sites with&#8230; oh, was it Adobe—what was it called? It was one of the&#8230;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Was it Dreamweaver or was it FrontPage?</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Dreamweaver, yeah.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Dreamweaver, yeah.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>And I remember I made one of our first sites, and I had Flash on there. Oh, it was just horrifying—bouncing letters, dancing around, or some crazy thing. And then, 2008 or 2009—I think 2008 or 2009—I got into WordPress, started dabbling in playing around with the blogging stuff. And I went to iThemes and got one of their themes there, and we did our business site.&nbsp;&nbsp;</p>\n\n\n\n<p>And it was like, wow, that took me one-hundredth of the time it took me to do any other site because it was&#8230; I mean, it actually looked good, and it would function well and stuff. So yeah, I did that till about 2014 or 2015, I think, when I finally quit designing. I was into content, and I knew what I wanted to focus on. I was tired of the design client side of things.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>So what was your first?&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Oh, yeah. Well, I don’t want to say&#8230; this was 1996. Yeah, I did a German site. It was all HTML tables—kind of horrible. Well, it’s still out there because it’s a reference site for books and all kinds of things in Germany. But yeah, so that was in 1996. I started—that was as a citizen in Munich—and I learned about it, and I learned about HTML.&nbsp;&nbsp;</p>\n\n\n\n<p>I found it so fascinating that you can put it up on the web and everybody can see it almost immediately. And that’s such a different experience from printing, where you have to wait till it comes from the printer and then you need to distribute it. That was instant distribution, and I really loved it.&nbsp;&nbsp;</p>\n\n\n\n<p>But then what I found was that all the neo-Nazis and Holocaust deniers were all on the German part—they were all in America on servers—and there was nothing in Germany that holds against it, what really happened. And we were a group of two people, each one of us had our site and started a site about the Holocaust and all that information.&nbsp;&nbsp;</p>\n\n\n\n<p>And mine was called *Shoah Project Internet.* And we collected information about the concentration camp in Dachau, before the concentration camp had their own website in 2000 or something like that. I connected with authors who had published poems and also some nonfiction about the wealth of Jews that was taken away by the government, and about the resistance in Germany.&nbsp;&nbsp;</p>\n\n\n\n<p>It was all in German, but there was no equivalent otherwise from private citizens to actually put this out. That really made me&#8230; and then there was this big discussion—there was an exhibition, a traveling exhibition. There was this myth that the German army had nothing to do with the concentration camps, but that was a myth, and it wasn’t true. And there was an exhibition that actually showed all the facts, and there was a big brouhaha and uproar.&nbsp;&nbsp;</p>\n\n\n\n<p>And it was traveling, so everywhere I was kind of picking up the snippets from the online sites, from websites. So it was kind of an interesting&#8230;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>I think I started using computers in the early 80s—or probably mid-80s. And I actually went to community college in the States in, I think, maybe the mid to late 80s. I took a year of computer programming, and I did learn—what was it?—BASIC, COBOL, Assembly&#8230;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Wow, yeah.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>There was one other thing. And after a year, I remember we had this great guy from&#8230;&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Fortran?&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah. Oh no, that was another one. Yeah, we had to dabble in all those in 12 months. And at the end of the 12 months, the instructor—he was great—he was a Brit, and he just had the craziest sense of humor. He said, “Well, now you’ve learned all this. It’s all going to be obsolete by the time you step out this door.”&nbsp;&nbsp;</p>\n\n\n\n<p>And we were like, “What?” And I discovered after a year of that, that was not what I was going to become—a computer programmer, I thought. But it gave me the comfort level to use computers. I was really comfortable with that. So that was good. But yeah, crazy times.&nbsp;&nbsp;</p>\n\n\n\n<p>So what’s going to happen in the next year for you, do you think?&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Well, the Weekend Edition is going to be quite interesting every time. And I see that in the community—that the block editor is more in the forefront more and more. And there’s some great stuff coming out with Playground and with Studio to do staging sites and to just play around with WordPress.&nbsp;&nbsp;</p>\n\n\n\n<p>So I know that Gutenberg—the Core contributors of Gutenberg—are still going to do the biweekly releases. So we are going to do maybe a monthly release podcast. And we’ll invite a few more people from the space that work with Gutenberg. There is now also&#8230; quite a few people have adopted the block theme space quite a bit on multiple levels.&nbsp;&nbsp;</p>\n\n\n\n<p>It’s for enterprise levels, which started very early. But on the agency level, WebDevStudios, for instance—Jesse Palm was on the show recently, who had the starter theme that’s a block theme for WebDevStudios—and they start every project with it.&nbsp;&nbsp;</p>\n\n\n\n<p>So these kinds of things show me that there’s quite another level of adoption happening about the Gutenberg project. And of course, I’m still hoping for a Google Docs-like real-time collaboration or async communication with comments.&nbsp;&nbsp;</p>\n\n\n\n<p>There are some great experiments in the Gutenberg plugin that I want to dive into quite a bit as well. So we’ll see what happens.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>So we’ll see what happens. Yeah, WordCamp Asia is going to be more of a research trip for me—to talk with the plugin developers and talk with some of the engineers and kind of see what’s next for them. And I’m sure I’ll find a few interview partners that I can make a show with in the space, because I already have. Some of them have left the space; some of them are coming back. So it’s really interesting to see.</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Very cool. Yeah, it’s interesting because I think of&#8230; there was a point where I started adding some shows that were more WordPress-based. What I’ve found with some of these shows is, everything always comes back to WordPress or WooCommerce. And a lot of it—the similarities kind of weave in and out of all this stuff. It’s good to be knowledgeable of other things, no matter what you’re doing.&nbsp;&nbsp;</p>\n\n\n\n<p>So I’m hoping we’re going to be stepping more into videos. I’ve been talking about it—we’re going to be doing more video with some of the shows, and we might do a little bit of live stuff here and there. I’ve kind of kicked and screamed into that, so that’s another piece that’s going to hopefully grow. I’ll be trying to focus a little bit on that part of it—what I do with that and how I present it and all that stuff.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>I have heard from quite a few people that there’s a generation out there that doesn’t read anymore.&nbsp; I know. They want to go on YouTube and be entertained or at least shown things. And of course, with software, if you want to teach somebody, you need to show it. That’s very hard to do on the podcast.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, it is. Yeah. So who knows what? Maybe we should make this a tradition now—every January.&nbsp; We come in and catch up and see what we did, what we blew, everything—what broke and what didn’t work.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>I would love to do that. Yeah, sure. Absolutely.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>We’ll make it a January tradition. So anyway, we have WordCamp Asia coming up. Like you said, you and I will both be there. In fact, you’re going to be joining—you’ll be coming and co-hosting the table, doing the little booth, I believe, for an hour.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yes, absolutely. Yeah. Friday, I think.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>If you haven’t caught up with her, you haven’t caught up with me. I’ll post when she’s going to be at the table, and that way you can tie her down because sometimes chasing people around&#8230; you know how that goes.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, no, no, absolutely. Yeah, no, I’m looking forward to WordCamp Asia. Also, I’ll be at CloudFest this year for the first time, so I’m not going to be at the hackathon. But there are too many people from Automattic going already that actually have a project. And then WordCamp Constance—that’s a camp with German speakers. So it’s really going to be interesting.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>So you’ll be at the regular CloudFest event and stuff? Yeah, I know there’s going to be a little bit more WordPress stuff going on, and that’ll be fun. So yeah, we’ll be seeing each other next month and the month after.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, yeah, yeah. I appreciate it. I’m really loving it.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Okay, well, we’ve said it enough times, but Gutenberg Times—and probably the URL is very easy and stuff—but do check that out. Is it *gutenbergtimes.com*?&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Dot com. And yeah, you can also find me on the Twitters and on the Bluesky and the&#8230; I still call it Twitter.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Sorry.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>&#8230;on the Bluesky and also on Mastodon. And of course on the WordPress Slack and WooCommerce Slack. So I’m everywhere.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, everywhere.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Well, thank you so much. It was wonderful chatting with you.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, well, thank you. Yeah, this was definitely a must-do show for January, so I appreciate everybody listening and&#8230;&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Happy anniversary.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Yeah, happy anniversary. And come back next January for our second Nova. I’m sure you’ll see Birgit more than—or sooner than—next January, for sure.&nbsp;&nbsp;</p>\n\n\n\n<p>**Birgit:**&nbsp;&nbsp;</p>\n\n\n\n<p>Well, thank you.&nbsp;&nbsp;</p>\n\n\n\n<p>**BobWP:**&nbsp;&nbsp;</p>\n\n\n\n<p>Well, take care. Bye-bye.&nbsp;&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 02 Feb 2025 14:50:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: My First Million\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=136139\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://ma.tt/2025/02/my-first-million/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:223:\"<p>I had a great chat with <a href=\"https://linktr.ee/thesamparr\">Sam Parr</a> and <a href=\"https://www.shaanpuri.com/\">Shaan Puri</a> on their podcast, My First Million.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 02 Feb 2025 01:18:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Gutenberg Times: The anatomy of a CMS, the state of block themes and WordPress 6.7.2 — Weekend Edition 318\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=37524\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://gutenbergtimes.com/the-anatomy-of-a-cms-the-state-of-block-themes-and-wordpress-6-7-2-weekend-edition-318/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:17358:\"<p>Howdy, </p>\n\n\n\n<p>It&#8217;s already February. 8.33% of 2025 is done. Phew. 91.67% to go. Most of my week I spent testing things. Maybe I jinxed it with  my mind set, I didn&#8217;t come across something really cool.  I am excited about WordCamp Asia where I can browse this huge sponsor hall and go exploring all the cools things there. </p>\n\n\n\n<p>What saved me a ton of time, this week, was using Claude AI. I used it to audit Playground blueprints in the Gallery. I pasted the description of the merged PR of modification on how blueprints work,  then fed it code to rewrite using the new way. Doing this a few times, I created a tracking issue with the necessary changes to implement next week. I felt really lazy. </p>\n\n\n\n<p>That was all off-set by trying to have Cursor AI write a block with some user input sections. It made great progress, but for some reason, it still doesn&#8217;t work. Sometimes debugging the AI is even more tedious than looking at your own code. </p>\n\n\n\n<p>This week, we have a few strategic posts and practical tips for you in this newsletter. Enjoy! </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/the-anatomy-of-a-cms-the-state-of-block-themes-and-wordpress-6-7-2-weekend-edition-318/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/the-anatomy-of-a-cms-the-state-of-block-themes-and-wordpress-6-7-2-weekend-edition-318/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/the-anatomy-of-a-cms-the-state-of-block-themes-and-wordpress-6-7-2-weekend-edition-318/#upcoming-events-beyond-wordcamps\">Upcoming events beyond WordCamps</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/the-anatomy-of-a-cms-the-state-of-block-themes-and-wordpress-6-7-2-weekend-edition-318/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/the-anatomy-of-a-cms-the-state-of-block-themes-and-wordpress-6-7-2-weekend-edition-318/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/the-anatomy-of-a-cms-the-state-of-block-themes-and-wordpress-6-7-2-weekend-edition-318/#what-s-new-in-playground\">What&#8217;s new in Playground</a></li></ol>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>George Mamadashvili</strong> made <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v20.2.0-rc.1\"><strong>Gutenberg 20.2 RC1</strong></a> is available now for testing. Final release will be on February 5, 2025. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Aaron Jorbin</strong> announced that <a href=\"https://make.wordpress.org/core/2025/01/22/wordpress-6-7-2-release-planning/\"><strong>WordPress 6.7.2 </strong>will be released soon</a>. RC will be released on February 4 and final release will hit the WordPress site near you on February 11. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-114-reflections-on-gutenberg-times-and-do-the-woo/\">Gutenberg Changelog #114 – Reflections on Gutenberg Times and Do the Woo</a> with Bob Dunn aka BobWP as host and guest Birgit Pauli-Haack, each publication started 7 years ago. </p>\n\n\n\n<img width=\"652\" height=\"328\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Gutenberg-Changelog-114-Bob-Dunn-Birgit-pauli-Haack-edited.png?resize=652%2C328&ssl=1\" alt=\"\" class=\"wp-image-37614\" />\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Darren Ethier </strong>and <strong>James Kemp</strong> from WooCommerce talk about <a href=\"https://www.youtube.com/watch?v=q2CXOsMwBF4&t=5s\"><strong>Building WooCommerce in Public</strong></a> in the latest episode of <em>DoThe Woo</em> Network They explore WooCommerce&#8217;s current state and future direction, with Darren highlighting his connection between Gutenberg and WooCommerce. They stress the importance of community and communication in development, discuss the significance of WordCamps, the need for key features, and WooCommerce&#8217;s evolution for better experiences. They also mention how changes in WordPress affect WooCommerce’s plans and the need for flexible, no-code solutions for developers. This conversation provides insights into WooCommerce’s development approach and plans.</p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On <em>Learn.WordPress.org</em>, <strong>Wes Theron</strong> published the lesson: <a href=\"https://learn.wordpress.org/lesson/explore-synced-pattern-overrides/\"><strong>Explore synced pattern overrides</strong></a>. It&#8217;s part of the Intermediate WordPress User course and covers what&#8217;s patterns are, and how you can maintain stylistic control while the  content of a pattern. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his post, <a href=\"https://blog.gravatar.com/2025/01/26/wordpress-author-page/\"><strong>Create a Custom Author Page</strong></a> Ronnie Burt introduces you to multiple ways how you can make use of the Gravatar profile for your website. He also explains why spending a moment on  the design of an author page is very important for a company blog. Then he walks you through the various method how you can use the user information stored on a self-hosted site can be used to expand on the normally neglected and thinly populated author information. </p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"upcoming-events-beyond-wordcamps\">Upcoming events beyond WordCamps</h3>\n\n\n\n<p>Apart from <a href=\"https://central.wordcamp.org/schedule/\"><strong>WordCamps,</strong></a>  additional conferences are on the schedule for this year. </p>\n\n\n\n<p><strong>February 24 &#8211; 28 2025</strong> The 2nd Annual <a href=\"https://www.stateofdigitalpublishing.com/wp-week/\"><strong>WP Publisher Success Week</strong></a>&nbsp;will take place. You can learn best practices from leading experts in the field of WordPress for publishers.</p>\n\n\n\n<p><strong>March 17 &#8211; 20, 2025 <a href=\"https://www.cloudfest.com/\">CloudFest</a>,</strong> Europa Park, Rust, Germany. As Bob Dunn, DoTheWoo <a href=\"https://dothewoo.io/blog/do-the-woo-is-a-media-partner-for-cloudfest-2025-and-the-hackathon/\">reports</a>, there will be a <a href=\"https://www.cloudfest.com/wp-zone\">WPZone</a> and a WPDay. </p>\n\n\n\n<p><strong>April 23 &#8211; 26, 2025</strong> <a href=\"https://pressconf.events/\"><strong>PressConf</strong></a> a conference for WordPress professionals will take place in Tempe, Arizona, USA. Speakers are among others Mary Hubbard, Matias Ventura, Rich Tabor, and Tammie Lister. </p>\n\n\n\n<p><strong>September 25, 2025</strong> <a href=\"https://loopconf.com/\"><strong>LoopConf</strong></a> returns to London, UK as a conference for WordPress developers. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>In his latest blog post, <strong>Nick Diego</strong> wants theme developers to <a href=\"https://nickdiego.com/stop-struggling-with-cumbersome-theme-json-files/\"><strong>stop struggling with cumbersome theme.json files</strong></a>. He shares how he and his new buddy, <em><a href=\"https://www.cursor.com/\">Cursor AI</a></em> succeeded in building a compiler/bundler to combine separate json file into an overall theme.json for a theme. Diego shares a video of the process and the final script, you can adopt for your workflow. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Hendrik Lührsen</strong> found that <a href=\"https://kraut.press/2025/crisis-of-themes/\"><strong>WordPress themes are facing a crisis.</strong></a> &nbsp;The introduction of Full Site Editing (FSE) has brought about complexities that are causing challenges in the WordPress theme ecosystem.&nbsp;This situation appears to be related to the rapid evolution of WordPress technology, particularly the implementation of the site editor, which is impacting how themes are developed and used. </p>\n\n\n\n<p>While calling it a crisis makes the post viable for the successful spread via outrage advertising economies, Lührsen is not wrong, lamenting about all the short-comings of block themes. His suggested paths to improve the situation can be walked by every theme developer building sites for clients on top of WordPress, except the discoverability of themes on the repository. A standardized onboarding process, was discussed among Themes team members. Turns out that the many, many use cases are not easily pulled into a cookie-cutter closed system. It&#8217;s the nature of the 21-year legacy of WordPress. It also means, any developer can fill the gaps for their clients, and if they want to go the extra mile, share it all back to the community. WordPress is not a one-size fits all system. Flexibility and extensibility is a feature, not a bug.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his YouTube video, <strong>David McCan</strong> looks into<a href=\"https://www.youtube.com/watch?v=WtZ3yZ7HPvE\"><strong> the current state of block themes</strong></a>, reviewing popular themes available in the WordPress repository, Then he looked under the hood to understand block themes. &#8220;I have a better understanding of block themes after going through this process.&#8221; McCan wrote in the description. If you rather read a blog post reader than watch a video, <a href=\"https://www.webtng.com/the-current-state-of-block-themes-and-a-reassessment/\">got here to read McCan&#8217;s thoughts</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his post <a href=\"https://humanmade.com/wordpress-for-enterprise/transitioning-to-fse-a-low-risk-high-reward-move-for-enterprises/\"><strong>Transitioning to FSE: A low-risk, high-reward move for enterprises</strong></a> HumanMade&#8217;s account director, <strong>Adam Jones</strong>, tells the story of how Human Made, &#8220;guided enterprise organizations through this process and seen the transformative benefits firsthand.&#8221; Adapting to the site editor and block themes allows businesses to enhance digital capabilities with minimized risk through careful planning and testing. Key benefits include improved scalability, workflow, and reduced reliance on developers, making full-site editing a valuable investment in digital infrastructure. Also on that topic: <a href=\"https://humanmade.com/wordpress-for-enterprise/enterprise-wordpress-the-3-competitive-advantages-of-fse/\">The three competitive advantages of full-site-editing</a> by senior account manage, <strong>Lorna Lim. </strong></p>\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p><strong>Riad Benguella</strong>, architect on the Gutenberg projects, explains in his latest post <a href=\"https://riad.blog/2025/01/31/the-anatomy-of-a-cms/\"><strong>The anatomy of a CMS</strong></a> and why any web developer should attempt to build a CMS just once. The magic happens through four key parts: how content is stored, how it looks, how you edit it, and how it gets shown to the world. Whether you want to create a personal blog, an online store, or a company website, a good CMS adapts to your needs. Benguella took a detailed view into the various parts of the WordPress CMS: block rendering, style engine and the fields system. If you wish to know how it all fits together, grab your favorite beverage and start reading.  </p>\n\n\n\n<img width=\"652\" height=\"392\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/CMS-1-by-Riad-Benguella.webp?resize=652%2C392&ssl=1\" alt=\"\" class=\"wp-image-37531\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"what-s-new-in-playground\">What&#8217;s new in Playground</h2>\n\n\n\n<p>Check out this article by Ján Mikláš, <a href=\"https://developer.woocommerce.com/2025/01/24/demo-your-woo-extension-with-wordpress-playground/\"><strong>Demo your Woo extension with WordPress Playground</strong></a>, where he breaks down how to set up WordPress Playground just for your needs. You’ll find out how to tweak your blueprint.json file with settings and steps, plus how to create a custom landing page and hide those pesky WooCommerce onboarding screens.</p>\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Featured Image: AI generated. </p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Feb 2025 01:26:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Do The Woo Community: Friday Shares Fadeout. Sign Up for Our New Newsletter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=89485\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://dothewoo.io/friday-shares-fade-out-sign-up-for-our-new-newsletter/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:339:\"In this episode of On WPCommunity, BobWP announces the conclusion of his regular Friday share posts on the blog due to time constraints and his new plans. He explains that after WordCamp Asia in February, a new newsletter will be launched alongside the release of version 5.0 of their site. The newsletter will feature actionable [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jan 2025 13:30:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Do The Woo Community: State of Enterprise WordPress 2024 Report with Brad Williams and Tom Willmot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=89448\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://dothewoo.io/state-of-enterprise-wordpress-2024-report-with-brad-williams-and-tom-willmot/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:208:\"In the latest Scaling Enterprise podcast episode, Tom and Brad discuss the 2024 State of Enterprise WordPress Report, highlighting trends in adoption, usage, and decision-making dynamics within organizations.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jan 2025 13:12:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: #154 – Anna Hurko on Managing a Growing Plugin Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=185997\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/podcast/154-anna-hurko-on-managing-a-growing-plugin-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39823:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case managing a growing plugin business.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Anna Hurko.</p>\n\n\n\n<p>Anna is the CEO of Crocoblock, a company with a suite of dynamic plugins designed to help developers build complex websites. With a background in computer science, Anna transitioned from support roles to leading Crocoblock, and has been with the company for over 11 years.</p>\n\n\n\n<p>Anna quickly rose through the ranks due to her technical knowledge and effective communication skills. Crocoblock, which started with just a handful of team members, has now grown to 85 employees. They offer a wide range of specialized plugins, such as JetEngine, JetSmartFilters, JetBooking, and more, primarily aimed at agency and freelance developers.</p>\n\n\n\n<p>Anna shares her journey and discusses the growth of Crocoblock. She highlights the company&#8217;s flexibility and commitment to meeting developers&#8217; needs, adapting to both the rapid changes within WordPress and the increasing demand for dynamic site capabilities.</p>\n\n\n\n<p>Anna also talks about the company&#8217;s marketing strategies and their active, and growing, participation in the WordPress community through WordCamps and Meetups.</p>\n\n\n\n<p>If you&#8217;re interested in how a company evolves within the WordPress ecosystem, and the challenges and successes that come with it. This episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you, Anne Hurko.</p>\n\n\n\n<p>I am joined on the podcast today by Anna Hurko. Hello Anna.</p>\n\n\n\n<p>[00:02:53] <strong>Anna Hurko:</strong> Hi Nathan.</p>\n\n\n\n<p>[00:02:54] <strong>Nathan Wrigley:</strong> Very nice to connect with you. I should probably say at the outset, Anna has several names. So if you know Anna better as Vanessa, or any combination thereof, it&#8217;s the same person. So do you just want to clear that up? How is it that you&#8217;ve got two different names?</p>\n\n\n\n<p>[00:03:09] <strong>Anna Hurko:</strong> So it&#8217;s from the beginning. I have started to work as a supporter, and it was like tradition to choose a nickname for support agent. And I decided like okay, I&#8217;m already Anna, I want something other, but which will suit me. And I decided to be Vanessa.</p>\n\n\n\n<p>And for a few years I was Vanessa, but somehow all my colleagues remembered me as Vanessa, and we used it till now, even if I don&#8217;t need it anymore. And that&#8217;s how it works. But now I feel more Vanessa than Anna because in whole work, so even financial departments, they say Vanessa, not Anna. Even the ex coworkers who are not anymore working with me, but they&#8217;re my friends, even their children say I&#8217;m Auntie Vanessa.</p>\n\n\n\n<p>[00:03:46] <strong>Nathan Wrigley:</strong> So several names, but hopefully by the time this podcast is finished, you&#8217;ll have figured out, dear listener, who it is that we&#8217;re talking to. But I&#8217;m going to go with Anna because that&#8217;s probably the easiest thing for me to say.</p>\n\n\n\n<p>So Anna, we are a WordPress podcast, so I guess it would be a good idea right at the outset to give you an opportunity to just tell us who you are, where you come from in terms of the geography and maybe the company that you work for, things like that. So really it&#8217;s a short bio moment. So could you just tell us a little bit about yourself?</p>\n\n\n\n<p>[00:04:13] <strong>Anna Hurko:</strong> Yes, sure. So I&#8217;m from Ukraine, from south of Ukraine, and the company is the Crocoblock is project I&#8217;m working with now, and it&#8217;s located in Ukraine as well. All our team members are in Ukraine, in one city actually. So now a little bit different. So I&#8217;m CEO of Crocoblock and I work for the holding company about 11 years for now.</p>\n\n\n\n<p>[00:04:32] <strong>Nathan Wrigley:</strong> So, what is Crocoblock? And I hope I&#8217;ve pronounced that correctly. By the way, everything that we mention will be linked in the show notes. So if you head to wptavern.com/podcast and look for the episode with Anna in it, then you&#8217;ll be able to find all the show notes. But, what is Crocoblock and what does it do?</p>\n\n\n\n<p>[00:04:49] <strong>Anna Hurko:</strong> So Crocoblock, I have always a long and short answers. Crocoblock is project who is making plugins for developers to build dynamic complex websites. And the idea was to have ecosystem which has all tools for developers needs.</p>\n\n\n\n<p>But for me as a CEO, Crocoblock is a team. So it doesn&#8217;t matter which technology will come tomorrow and what happened to WordPress, we are a team who can build products. So that&#8217;s why I have two answers.</p>\n\n\n\n<p>[00:05:14] <strong>Nathan Wrigley:</strong> Now, you mentioned at the outset that you are from the Ukraine originally, but just before we hit record, you talked about the fact that you are no longer in the Ukraine. But maybe that would be an interesting way to begin this podcast properly.</p>\n\n\n\n<p>I&#8217;m guessing that from the description, living in the south of Ukraine, that you moved against your will, possibly. You&#8217;ve had to move because of the situation over there.</p>\n\n\n\n<p>[00:05:36] <strong>Anna Hurko:</strong> So the are three years of the situation. I was in Ukraine, I just moved in September after WordCamp US. I just didn&#8217;t come home and then stayed in Europe because I am trying to visit more WordCamps and WordPress meetups. And if you&#8217;re in Ukraine, it takes too long time to get out, because you don&#8217;t have planes and you need to go with a bus to Europe and to take plane, and every country in Europe takes me two days to move.</p>\n\n\n\n<p>So I decided to stay in Romania because it&#8217;s kind of in the center and then can visit more events. So last year I visited about seven WordCamps, because I want to go closer to community, to customers, to speak offline with them, and we have results. So we have already ran a little bit growing in comparison.</p>\n\n\n\n<p>[00:06:20] <strong>Nathan Wrigley:</strong> The situation in Ukraine in terms of web development and tech, it always seems like Ukraine punches above its weight. I don&#8217;t know if there&#8217;s a particular kind of, I don&#8217;t know, like drive in school or anything like that to head towards technology and software development. But it seems, when I look at the about page of a lot of products, especially in the WordPress space, but technology more generally, it always feels like Ukraine is overrepresented with the amount of companies. I don&#8217;t know if that&#8217;s something that you think is true or if that is true.</p>\n\n\n\n<p>[00:06:53] <strong>Anna Hurko:</strong> It is true, but I think it&#8217;s not because of good reasons. Somehow we didn&#8217;t have good factories and job places, and web was very easy for people to just find a job and to have good salary because a lot of companies working as outsource, or they have customers from US and Europe. For example, like Crocoblock, we don&#8217;t work with Ukrainian market actually, we work with Europe and US.</p>\n\n\n\n<p>And it&#8217;s not something, we have good studying in school and university. Unfortunately it should&#8217;ve developed better. For example, I have studied computer science, but it was like old technologies in university. Just because we don&#8217;t have normal working places, people starting to self-educate and they work in IT. And somehow it&#8217;s very good now. So even government programs, they&#8217;re all digitalised.</p>\n\n\n\n<p>So from my phone, I can pay taxes, I can marry now from phone, but only with Ukrainians, of course. I can get any document I need, I don&#8217;t need to go anywhere. So now, for example, I&#8217;m outside of Ukraine, but I can have any document, new driver license. I can sell car with one application. So it&#8217;s somehow built in us.</p>\n\n\n\n<p>[00:07:59] <strong>Nathan Wrigley:</strong> So the propensity of Ukrainian web developers is as a result of people looking to improve their own lives and finding that distributed work was something that they could do, and they could earn a good, in air quotes, good salary if they took the initiative and did, what? Self-taught learning, that kind of thing.</p>\n\n\n\n<p>[00:08:17] <strong>Anna Hurko:</strong> Yes, yes. Because in university, school, it&#8217;s really bad now, I&#8217;ll say. It&#8217;s not practical. But, for example, as I have studied computer science, it was all technologies. It was like Pascal Delphi, if you even know, C++. Something very difficult and not attached to WordPress, for example. But it gives me understanding how database works, for example. And it helps me a lot, even now, I don&#8217;t work with WordPress itself, so I don&#8217;t build product, I mean. I work with a team. It helps me to understand my developers and how it works.</p>\n\n\n\n<p>[00:08:46] <strong>Nathan Wrigley:</strong> Okay. Yeah, well, it&#8217;s a nice idea that the CEO of the company actually has a background in technology. I think that&#8217;s interesting to be able to speak to the developers on their level.</p>\n\n\n\n<p>How did you start in the WordPress space then? I think you said that you started working with the support side of things over at Crocoblock. And if that&#8217;s the case, going from support to where you are now, CEO, that&#8217;s a pretty big move. How did it all begin?</p>\n\n\n\n<p>[00:09:09] <strong>Anna Hurko:</strong> First I need to say that I didn&#8217;t realise it&#8217;s a big move before attending WordCamps. Because it&#8217;s for me everyday life and it was kind of 10, 11 years. So when I have studied computer science, by side I was in NGO and Youth Politic. And I told, I will never have anything with programming languages, or with IT, or even with websites because we had website building in university as well, but it was, you know, when it was on the tables and HTML and so on. And the teacher was so awful. So I told, I will never do it, and now I&#8217;m here.</p>\n\n\n\n<p>So after I finished with Youth Politic, I have started to just looking for a job which need English language. So because I didn&#8217;t want IT and I sent a CV for everyone with English knowledge, and they picked up me in the holding company as a support member because I knew English. But somehow as I knew computer science, it was very easy for me to deal with WordPress. And in three months I was already a night shift team leader and I have started to mentor people and so on. So I have started with support, but my background with computer science helped me to be very good, very fast.</p>\n\n\n\n<p>So until now, I think it was the best thing I can do in my life is to be a supporter. Even now I think so. And because I have done Youth Politic, I had soft skills which helped me to communicate with customers in a nice way. And we have started to rebuild the support team as well, and there are rules in support and so on.</p>\n\n\n\n<p>[00:10:31] <strong>Nathan Wrigley:</strong> So you started out in support, and fairly quickly you rose through the ranks. And you mentioned just there that, you called it the, what did you call it?</p>\n\n\n\n<p>[00:10:38] <strong>Anna Hurko:</strong> Holding company.</p>\n\n\n\n<p>[00:10:39] <strong>Nathan Wrigley:</strong> The holding company, that&#8217;s it.</p>\n\n\n\n<p>[00:10:40] <strong>Anna Hurko:</strong> Yeah, we have holding company, it has several projects on side. And now Crocoblock is totally separated project.</p>\n\n\n\n<p>[00:10:45] <strong>Nathan Wrigley:</strong> So what&#8217;s the holding company, and is it a sort of WordPress thing, or is it just technology in general?</p>\n\n\n\n<p>[00:10:50] <strong>Anna Hurko:</strong> It&#8217;s a recent WordPress thing. So we have started as a team in Template Monster. And, yeah, I was a support member in Template Monster first. Our developers started as well with templates before the templates were starting to die.</p>\n\n\n\n<p>[00:11:04] <strong>Nathan Wrigley:</strong> And do you have a background in using WordPress, or has your experience with WordPress been on the journey in Crocoblock?</p>\n\n\n\n<p>[00:11:12] <strong>Anna Hurko:</strong> I don&#8217;t have my private experience, so I never worked for an agency. But what I need to say is that in support, when I have started support, it was not like just us answering general questions. I was very technical support member, very quick. And customers in Crocoblock even now, but even before when I was working, they come with the real projects. And they just come and say, I don&#8217;t know what is wrong, just do something. And you log in on the website and you start building it.</p>\n\n\n\n<p>And that time, to start working in support, we had training for one month. About four hours theoretical training, and then five hours of homework. And this first month, I never went out of my house, only for my grandmother&#8217;s birthday. And what we have done, we haven&#8217;t learned WordPress, we have learned CSS, JavaScript and HTML. We have built websites, and working with database was as well. So somehow I started to work with the websites first, but just I don&#8217;t have commercial experience, I think.</p>\n\n\n\n<p>[00:12:07] <strong>Nathan Wrigley:</strong> And what&#8217;s the structure of Crocoblock then? How many people do you have deployed into that project? If you are the CEO, I guess you&#8217;re at the top of that pyramid, how many people are working with you, for you? However you want to describe it.</p>\n\n\n\n<p>[00:12:18] <strong>Anna Hurko:</strong> We have started six years ago with five people, five, seven people. We don&#8217;t know exact number. All of us have different story of it. Now it&#8217;s 85.</p>\n\n\n\n<p>The story begins when we were in Template Monster and we have built templates. In some point we had new people for it and we needed more amount of it and so on. And we have started to build frameworks to speed up the process, and to have less errors because if every quarter developer makes it in own style, we have too much issues with it.</p>\n\n\n\n<p>And then we started to sell it. So because it was product for ourself, but it was too good and we have started to like, okay, can we just start to sell plugins? And then we have started it, it was enough, seven people. It was developers, one support member, and guy who was before me, the CEO.</p>\n\n\n\n<p>[00:13:00] <strong>Nathan Wrigley:</strong> So if I go to the Crocoblock website, which is crocoblock.com, and I look at the products that you&#8217;ve got. It opens up a fairly giant mega menu, and there&#8217;s literally dozens of things in there.</p>\n\n\n\n<p>When I first heard the word Crocoblock, firstly I assumed that it was plural, that it was Crocoblocks, and my assumption was that, okay, that&#8217;ll be a suite of WordPress blocks. So you&#8217;ll download a plugin, and then you&#8217;ll have a bunch of blocks that you can put into the block editor.</p>\n\n\n\n<p>And you go to the website and you realise, no, that&#8217;s really not what it is. That&#8217;s not even close to what it is. So what is it that you are offering into the market? What are the different products that I can find in your product section? I mean, there&#8217;s too many to talk about, but maybe just pick your favorites or a few that are particularly popular.</p>\n\n\n\n<p>[00:13:47] <strong>Anna Hurko:</strong> Yeah, so short answer is, well, it will be JetEngine and JetSmartFilters. But the issue is that we have invented the Crocoblock name before Gutenberg. There were no blocks, it was Crocoblock, and we have it because it was an old project that we had already some traffic and we left it.</p>\n\n\n\n<p>Now we have actually two names, Crocoblock and JetPlugins because all of our plugins are JetPlugins.</p>\n\n\n\n<p>And the issue is that the project was started with supporters and developers. We didn&#8217;t have marketer for a few years. So I have a head of marketing only last one year. That means we didn&#8217;t thought about the things like name, and now we have a lot of difficulties with it.</p>\n\n\n\n<p>And when I had started Crocoblock we have the first document with idea about what Crocoblock is, and it was one sentence that will make us laugh for even now. Crocoblock is not about dynamic, it&#8217;s only about static and nice design. And what is fun about it? Because it&#8217;s now only about dynamic plugins. So now we have big menu with a lot of plugins because it&#8217;s like our history and we can&#8217;t delete them, because people use them.</p>\n\n\n\n<p>But our main focus is on dynamic websites, and that means JetEngine, which is a competitor for ACF, but it has much more inside. JetSmartFilters, JetThemeCore, and all plugins, which helps you to create complex structured websites, like real estate, multi-vendor and so on. You can track user data, and you can manage what to show to different users, or see the user behavior and connect to it.</p>\n\n\n\n<p>[00:15:13] <strong>Nathan Wrigley:</strong> Yeah, there really is a lot in there. You really do run the whole gamut of what WordPress can do. So for example, there&#8217;s something called JetBooking, which I&#8217;m imagining helps you with booking. And JetGridbuilder, again, it speaks for itself. JetProductTables, JetWooBuilder, JetProductGallery, Jet Appointments, JetFormBuilder. You get the idea. You&#8217;ve got your fingers in everything.</p>\n\n\n\n<p>[00:15:35] <strong>Anna Hurko:</strong> The idea was to build this structure where developer has ever seen. We have started with Elementor. When Crocoblock was invented, it was few builders on the market, new builders. Elementor, Oxygen, and maybe, I don&#8217;t remember, Brizy or something like that. And they were on the equal stage. And our previous CEO came to us, I&#8217;m like, what will we choose? He asked me, and he asked our CTO. And we choose, both of us choose Elementor because of user experience and because of the cleanness of the code.</p>\n\n\n\n<p>Our idea was to build everything except hosting and page builder for building websites. So we have tried, at the beginning, to close all the tasks for users and it was very fresh. So we appeared at the same time when Elementor was developing. And Elementor had less features inside of it.</p>\n\n\n\n<p>So first of all, we have tried to close all tasks, and now we&#8217;re more specifically working on dynamic. For example, Elementor, in JetElements we haven&#8217;t added any new features for few years, but it&#8217;s still our best plugin in sellings. But we don&#8217;t develop it because we don&#8217;t like to develop, so I mean we&#8217;re fixing bug issues or compatibility issues, but we don&#8217;t add new features because Elementor has added all new features, HappyAddons. And we don&#8217;t want to build, if it&#8217;s already on market, we don&#8217;t build it. It&#8217;s a philosophy of Crocoblock. We don&#8217;t want to build anything which already exists.</p>\n\n\n\n<p>[00:16:54] <strong>Nathan Wrigley:</strong> So over there I can see, what is it? 21 on the mega menu, there&#8217;s 21 things there. I&#8217;m guessing that, probably started with 1 went to 2, 3, 4, and we&#8217;re up to 21 at the minute. How do you keep this going? Are you intending to go from 21 to 22, 23, 24? Do you keep adding products, or is this more a case of, okay, we&#8217;ve got what we&#8217;ve got. We&#8217;ve covered everything? How are you making decisions about what it is that you&#8217;re going to do in the future?</p>\n\n\n\n<p>[00:17:18] <strong>Anna Hurko:</strong> So as I came from support, when we invented Crocoblock, we had only one support member, and all developers were supporting as well. We have very tight connection with customers and what we&#8217;re building, we&#8217;re building after customer&#8217;s request. So it depends. If it will be need on market to build one more plugin, we&#8217;ll build it. If not, then not.</p>\n\n\n\n<p>So I can tell you we have strategy for number of plugins. We have strategy to cover developers&#8217; needs. So now, for example, we have user interviews, some pools, research and market to find what else developers need. So it&#8217;s not about number of plugins, it&#8217;s about to close the needs.</p>\n\n\n\n<p>For me, I don&#8217;t want more plugins, so it&#8217;s not the goal. But if it would be better to build it as a separate plugin, we&#8217;ll build it. For example, the JetProductTables, it&#8217;s a new plugin. It was a result of R and D departments, I would say. We have new department, new for one year and they made resource. It&#8217;s like an experiment. So we don&#8217;t have any goals and number of plugins. It&#8217;s just to make developers life easier.</p>\n\n\n\n<p>So we have some projects, for example, we have ideas for projects not related to plugins itself, but to developers. I can&#8217;t tell you now what will it be.</p>\n\n\n\n<p>So for me it&#8217;s, you know, like CEO, I don&#8217;t like a lot of plugins and I don&#8217;t want to have more team members. It&#8217;s always something you don&#8217;t want, to have more, because it&#8217;s easier to focus on one plugin. And as you say, it would be easier to focus only on JetEngine, but somehow Crocoblock can&#8217;t stop.</p>\n\n\n\n<p>[00:18:44] <strong>Nathan Wrigley:</strong> You mentioned at the start that you began the business with Elementor in mind, and Elementor, if you haven&#8217;t been keeping a track, dear listener, Elementor really has had just the most astronomical growth since its inception, and I think really is singularly responsible for a large proportion of WordPress&#8217; rise.</p>\n\n\n\n<p>Now, I don&#8217;t know if that is the sort of page builder of choice that you&#8217;ve hooked yourself into, or if you&#8217;ve got into the sort of more WordPressy way of doing things. And what I mean by that is, you know, the Block Editor and Full Site Editing and things like that, because that&#8217;s obviously where the Core of the WordPress project is focusing its energy. But obviously on the periphery of that, you&#8217;ve got all these different page builders.</p>\n\n\n\n<p>What do you do with all of that? Do you hunker down and stick with Elementor, or do you decide you&#8217;re going to go with like the Core way of doing things? How does that all fit in?</p>\n\n\n\n<p>[00:19:33] <strong>Anna Hurko:</strong> So we of course love Elementor and it helps us in the beginning so much. We have the same philosophy as Elementor in a lot of things, like treating customers and so on. And I think it was right choice to start with. But once it was announced, the Gutenberg project, and then WordPress started with Gutenberg, the same in half a year or something like this, we have started to rebuild our plugins.</p>\n\n\n\n<p>So all our main plugins, not design plugins, but all our main plugins for dynamic websites. So when the Gutenberg project was started, we rebuilt them, and they all are working with Gutenberg as with Bricks now and Elementor. So Elementor is just one of the builders customers need. And then Gutenberg is the core. So we have rebuilt inside the plugin, the code in the way it can work with Gutenberg and we can easily add other integrations. And we always perform something with WordPress and Gutenberg native features. It&#8217;s in the core. So of course Elementor has grown up.</p>\n\n\n\n<p>So the company itself, it&#8217;s 20 years in market and we have all the 20 years experience. And we know it can shine as a star and it can die next day. But WordPress, we believe will stay for a long time with us. That&#8217;s why all our main plugins are built for WordPress and Block Editor. And we try to connect it more natively.</p>\n\n\n\n<p>The issues we have, it takes a long time. For some of our projects, for example, we have JetThemeCore, it&#8217;s a plugin which builds templates for archive pages, WooCommerce card, profile page, so all sorts of pages you can make the structure with it. And for some time we haven&#8217;t developed it because we were waiting for FSE, for some new features from WordPress itself. But it take too long time, and we didn&#8217;t want to build something that WordPress will build natively. Or you need to wait or you build it, and then users will have it twice, once in Crocoblock and then in WordPress.</p>\n\n\n\n<p>So we have these issues, but we&#8217;re trying to work around. For example, we have JetStyleManager, it&#8217;s a free plugin. It was created specifically for Gutenberg, because when we have made integration and compatibility for our plugins, Gutenberg was very new and it didn&#8217;t have a lot of style options. And we have built separate plugin just for Gutenberg to make styles possible. And now users have this solution from every plugin provider different, and we will rebuild it because WordPress have changed and so on.</p>\n\n\n\n<p>So what I wanted to say, and it took a long time, even if you use Bricks, Elementor, and we will add some other integrations for Builder, WordPress is in Core and we would never ignore it. We&#8217;re part of WordPress, first of all.</p>\n\n\n\n<p>[00:22:04] <strong>Nathan Wrigley:</strong> You mentioned a few sort of little frustrations there with the pace of WordPress. So for example, you may want a particular feature, and you know it&#8217;s coming, but you take your foot off the pedal of your own project so that you&#8217;re not building it twice as you said. But what about the way that Gutenberg and Full Site Editing, but Gutenberg in particular has changed over the last six or seven years?</p>\n\n\n\n<p>I mean, there must have been times when, the fact that it was altering so rapidly, and in such a drastic way, you know, from one release to the next it might be an entirely different UI for a particular thing. And then you&#8217;ve got to scratch your head and think, okay, we just shipped something, and we did the documentation, and it all looked like that, and now it looks like this, we&#8217;ve got to redo all the documentation.</p>\n\n\n\n<p>Being honest, has it been a straightforward process or has it been a fairly frustrating process? I mean, it could have been a bit of both, I guess.</p>\n\n\n\n<p>[00:22:53] <strong>Anna Hurko:</strong> It&#8217;s both. It was frustrating because we so believe in WordPress, and we have waited for some changes before, early, and it took too much time from our opinion. But it&#8217;s part of WordPress life. So it&#8217;s part of probably open source and so on, so we&#8217;re okay with it. And I can say that probably we don&#8217;t feel that frustration all the time because Crocoblock itself, growing and changing so quick as well.</p>\n\n\n\n<p>In six years we started with five people, now 85. You can imagine how quick changes processes inside our team as well. Because every time, in marketing, you have few new people, you need new process. Or in developers teams, they have started like three, four developers and now 15. Every two, three, developers, you need to change the process. So what I mean, in our philosophy of Crocoblock, we are okay with changes. It doesn&#8217;t frustrate us. What frustrates us, if nothing happens.</p>\n\n\n\n<p>[00:23:44] <strong>Nathan Wrigley:</strong> Yeah. And over the last decade or more, we&#8217;ve just seen the line of market share for WordPress go up and up and up. And if I was a product maker in the WordPress space, that would&#8217;ve made me feel great. I&#8217;ve got a credible product, it works. We&#8217;ve got a load of people using it. And look, the amount of people who might use it just keeps rising. And then we get to about 43% of the web, whatever that means, I mean, we can ignore exactly what that means, but the point is the line just kept going up.</p>\n\n\n\n<p>More recently there&#8217;s more discussion about stagnation in the marketplace, and maybe that line tapers a little bit and it goes flat. Or, and I don&#8217;t really want to get into that, we&#8217;ve got this period of change at the moment, there&#8217;s a lot of politics inside of WordPress. I&#8217;m just wondering what your thoughts are on where the business is pitched. The fact that you are using WordPress is great, but do you have any concerns about the market share sort of stagnating, or do you feel that you still have a massive audience in WordPress that you&#8217;re still yet to reach?</p>\n\n\n\n<p>[00:24:41] <strong>Anna Hurko:</strong> We have different periods. For example, last years were very challenging for us. Because Crocoblock started, when we started it grows in geometrical progress, it was very quick growing. And then of course as a five, six years project, you have not so big changes in your revenue, but it&#8217;s good, it works. And last few months we have very good results. So I think we don&#8217;t feel that stagnation so much because we have started Crocoblock without marketing, it was selling itself, and of course with help of community influencers.</p>\n\n\n\n<p>And we have just started last year to build a brand and to work with marketing. It means we have a lot of potential yet. So if market is stagnating or it still feels for us to develop our customer base and so on, because we didn&#8217;t use it before. You know what I mean? So if you haven&#8217;t selling in right way, then now we have started. So we still have a lot customers.</p>\n\n\n\n<p>[00:25:32] <strong>Nathan Wrigley:</strong> Oh I see what you mean. So it was more kind of organic growth, or maybe it was social media or YouTube or what have you.</p>\n\n\n\n<p>[00:25:38] <strong>Anna Hurko:</strong> We have started with product team, and that&#8217;s why we didn&#8217;t have real marketing. No one from us really understood the marketing itself, because we have just done what people need. And somehow the product was built first for ourselves and for our needs. That means we know our customers, not only from support team or interviews, they know them because they are we. So we didn&#8217;t need marketing.</p>\n\n\n\n<p>And it was a time in our Crocoblock life when we didn&#8217;t believe in marketing. And we thought like, okay, marketing is just wasting of money. It changed. So last year we had head of marketing and I developed a marketing team as well. That&#8217;s why it&#8217;s very new for us and we still have where to grow.</p>\n\n\n\n<p>And about market share, we could say something about stagnation, but after we see new numbers of Elementor, and we can see where is no stagnation. And about the drama and the situation with WordPress, which we had since September, we don&#8217;t feel it.</p>\n\n\n\n<p>So for me, it was surprising that my life was only about the drama and no one in Crocoblock community talked about it. So we have 30,000 people in Crocoblock community in Facebook, and it was only two posts asking about what happens, that&#8217;s it. With five comments. So I think the companies care, but customers not so much.</p>\n\n\n\n<p>We have some feedback from agency customers. So our customer is an agency or freelance developer. They had few issues from clients, but not so much. So the main reason is to keep ecosystem healthy and that&#8217;s it.</p>\n\n\n\n<p>[00:27:05] <strong>Nathan Wrigley:</strong> And now that you&#8217;ve moved into marketing, by the way, I think you were right about marketing. If you spend your marketing money badly, it probably is an absolute waste of money, but if you spend it wisely, it&#8217;s probably the most effective money that you can ever spend. So where are you pitching that then?</p>\n\n\n\n<p>So if I just rewind and re-ask that question, who is your audience? Who are the people that are using this? Is this a product which is used by agencies to deploy to their client websites? Do you find that you are being purchased by, I don&#8217;t know, people who&#8217;ve just got one or two websites? Maybe it&#8217;s just a solopreneur, something like that. Is there a segment of the market that you identify with?</p>\n\n\n\n<p>[00:27:41] <strong>Anna Hurko:</strong> Yes, of course. First, when we have started, we were growing just naturally and we didn&#8217;t ask ourselves these questions. Now, we have made a lot of researches, and it&#8217;s the same answer. Our customers are agencies and freelance developers. They&#8217;re about 30, 35, 40 years old with five, six years experience.</p>\n\n\n\n<p>The issue is the Crocoblock is quite complicated solution. It gives you total freedom. You can build from admin panel anything, we have query builder where you can use SQL and other complicated stuff. You don&#8217;t need to go to database. You can reach your SQL database from the admin panel, or complex relations and so on.</p>\n\n\n\n<p>But to use it, even from admin panel by clicking buttons, you need to understand how it works. The learning curve is complicated. And our developers building product quicker is that all other 80 people can produce a content for it and tutorials. That means, so if you need one website, it&#8217;s not a marketing answer, but if you need one, two websites, you don&#8217;t need Crocoblock. It&#8217;ll be too complicated for you. But Crocoblock will save your time and 50, 60% if you have more websites, if you&#8217;re an agency.</p>\n\n\n\n<p>[00:28:47] <strong>Nathan Wrigley:</strong> Right, I understand. So if you&#8217;ve got a portfolio of websites and you&#8217;re willing to put the time in to learn over 2, 3, 4, 5, 10, 20 projects, you&#8217;ll get a return on your time back. But if it&#8217;s just one website, maybe the learning curve, unless you really into that kind of thing and you just want to learn for the sake of it.</p>\n\n\n\n<p>[00:29:04] <strong>Anna Hurko:</strong> I have visited a lot of WordCamps last year and meetups, just to talk to our customers. And we have a lot of fans who paid us once lifetime, but they&#8217;re still our fans and they talk about us on meetups and so on. Even unpaid, it&#8217;s so pleasure when someone talked about you, about meetup, and had presentation and you never paid for it.</p>\n\n\n\n<p>And it&#8217;s always about four or five people in agency who are building websites. And because of Crocoblocks, they can build one website in a week, starting from design into the launch. It&#8217;s very nice because we have components and query builder and glossary, so you can make some predefined elements and then reuse it all the time if you have some websites you built then, for example, booking and so on.</p>\n\n\n\n<p>[00:29:47] <strong>Nathan Wrigley:</strong> So do you sell your products separately? So all of the different ones that I mentioned, plus all ones that I didn&#8217;t have time to mention. Do you sell them as individuals or do you tend to sell it as a sort of bundle that people buy? How do you pitch that?</p>\n\n\n\n<p>[00:29:58] <strong>Anna Hurko:</strong> You can buy them separately or a bundle. So it&#8217;s a subscription for one year, but you can buy one plugin, we have custom subscription, you can choose a few plugins, so you can buy a lifetime with all the plugins or all inclusive yearly for all plugins. So it depends what you need. So of course the most popular is lifetime.</p>\n\n\n\n<p>[00:30:16] <strong>Nathan Wrigley:</strong> Do you get yourself involved in the community? I know personally you said you&#8217;d been to a load of WordCamps and things. Does Crocoblock give back? Do you sponsor events maybe locally or some of the bigger ones? I don&#8217;t know, maybe you even contribute time to Core in terms of developers or something, I don&#8217;t know.</p>\n\n\n\n<p>[00:30:30] <strong>Anna Hurko:</strong> So it was our plan. Honestly, we haven&#8217;t started to contribute into Core, but we sponsor WordCamps and we attend a lot of WordCamps. We have started from last year, I think, but because of the war, we couldn&#8217;t start before. So I mean, the Crocoblock started with all of these things. But from last year we started to sponsor big WordCamps and small WordCamps.</p>\n\n\n\n<p>[00:30:50] <strong>Nathan Wrigley:</strong> I mentioned the URL earlier, but I&#8217;ll say it one more time. It&#8217;s crocoblock.com, so C-R-O-C-O-B-L-O-C-K dot com. That&#8217;s where you can find all of the different bits and pieces that Anna&#8217;s been talking about. If anybody wants to speak to you, Anna, personally, do you hang out on any social media platforms, or have a thing that you&#8217;d like to mention where people can find you?</p>\n\n\n\n<p>[00:31:10] <strong>Anna Hurko:</strong> Yeah, Facebook or Twitter, but I&#8217;m as well in LinkedIn. And I can tell you the secret, and if you write in Facebook room community, you can find our CTO Andrew. And if you write him in DM, he will answer you as well.</p>\n\n\n\n<p>In all WordCamps I told to customers if they have complicate, but interesting case, they come to contact Andrew, and if it&#8217;s really interesting, he will help you. And even make some changes to plugin sometimes because of customer requests. So we are very reachable. I mean, all Crocoblock team will answer you if you write in DM.</p>\n\n\n\n<p>[00:31:42] <strong>Nathan Wrigley:</strong> Well, thank you very much for chatting to me today, Anna. I really appreciate it. One more time, if you want to find out what they&#8217;re doing, crocoblock.com is the URL. Anna, thanks so much for chatting to me today, I really appreciate it.</p>\n\n\n\n<p>[00:31:52] <strong>Anna Hurko:</strong> Thank you.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://www.linkedin.com/in/anna-hurko-25aa368a/\">Anna Hurko</a>.</p>\n\n\n\n<p>Anna is the CEO of <a href=\"https://crocoblock.com/\">Crocoblock</a>, a company with a suite of dynamic plugins designed to help developers build complex websites. With a background in computer science, Anna transitioned from support roles to leading Crocoblock, and has been with the company for over 11 years.</p>\n\n\n\n<p>Anna quickly rose through the ranks due to her technical knowledge and effective communication skills. Crocoblock, which started with just a handful of team members, has now grown to 85 employees. They offer a wide range of specialised plugins such as JetEngine, JetSmartFilters, JetBooking, and more, primarily aimed at agencies and freelance developers.</p>\n\n\n\n<p>Anna shares her journey, and discusses the growth of Crocoblock. She highlights the company&#8217;s flexibility and commitment to meeting developers&#8217; needs, adapting to both the rapid changes within WordPress, and the increasing demand for dynamic site capabilities.</p>\n\n\n\n<p>Anna also talks about the company&#8217;s marketing strategies and their active, and growing, participation in the WordPress community through WordCamps and meetups.</p>\n\n\n\n<p>If you&#8217;re interested in how a company evolves with the WordPress ecosystem, and the challenges and successes that come with it, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://crocoblock.com/\">Crocoblock website</a></p>\n\n\n\n<p>Anna on <a href=\"https://www.linkedin.com/in/anna-hurko-25aa368a/\">LinkedIn</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jan 2025 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"HeroPress: Building a WordPress Career Without a Map: Lessons from My Journey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=7760\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:204:\"https://heropress.com/essays/building-a-wordpress-career-without-a-map-lessons-from-my-journey/#utm_source=rss&utm_medium=rss&utm_campaign=building-a-wordpress-career-without-a-map-lessons-from-my-journey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7830:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2025/02/012825-1-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Be open to change, focus on what you do, and don’t fear big goals.\" />\nHere is Anna reading her own story aloud.\n\n\n\n\n\n<p>I never dreamed of being a CEO. Even now, when I am introduced as such, I feel a little shy. But every time I start thinking, &#8220;<em>Am I enough? Doesn’t the company deserve someone more qualified?</em>&#8220;—I return to my journey.</p>\n\n\n\n<p>I want to share this to inspire those who are just starting out, changing their path, or feeling lost along the way.</p>\n\n\n\n<p><strong>My career path looks like this:</strong><br />Senior Technical Support Specialist → Shift Support Manager → QA Manager → Release Manager → Project Manager → Product Owner → COO → CEO</p>\n\n\n\n<p>I started as a chat operator in technical support and quickly advanced to Senior Technical Support Specialist and mentor, later becoming Shift Support Manager. I transitioned to the production department as a QA Ma</p>\n\n\n\n<p>Soon after, my responsibilities grew to include roles like Release Manager and Project Manager.</p>\n\n\n\n<p>When we launched Crocoblock, I focused on product and strategic issues, working as a Product Owner, then COO, and finally, CEO.</p>\n\n\n\n<p>However, my journey began even earlier.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-a-story-that-inspired-me\">A story that inspired me</h2>\n\n\n\n<p>When I was a teenager, my father changed careers. He worked as a land-line network engineer, but as technology advanced, the role became obsolete. At 42, he started from scratch in the gas industry. His persistence and willingness to learn left a lasting impression on me. A few years later, he became the CEO of a company in a completely new field.</p>\n\n\n\n<p>Later, in 2014, due to war, he lost his job and started over again. Now, in 2025, after yet another wave of war, he has taken on a new role, proving to himself and others that it’s never too late. This story ingrained in me the belief that <strong>“you can always find a new beginning.”</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-how-i-entered-it\">How I entered IT</h2>\n\n\n\n<p>While studying at university, I promised myself, “<em>I will never work with websites!</em>” Before WordPress, web development with pure HTML didn’t appeal to me.</p>\n\n\n\n<p>However, in 2014, as the war began and tanks rolled past my house toward Crimea, I was looking for any job that required English. That’s how I ended up in technical support. The training lasted a month, with me spending 5 hours on mentorship and about the same amount of time on homework every single day. During that time, I left the house only once to celebrate my grandmother’s birthday—I was that captivated.</p>\n\n\n\n<p>My technical education, understanding of databases, and soft skills from public activities helped me adapt quickly. I chose to work a six-day schedule to fully immerse myself in the new world.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-a-defining-moment\">A defining moment</h2>\n\n\n\n<p>After my internship, I was introduced to the KPI system that affected salaries: 30 metrics and a calculation formula. Instead of analyzing the formula, I focused on the tasks at hand. My goal was simple: solve customer problems as effectively as possible.</p>\n\n\n\n<p>Two months later, I became the top chat operator. Within three months, I mentored newcomers, and in six months, I helped revamp the support system.</p>\n\n\n\n<p>This experience was key for me. I realized it’s not about chasing ratings or recognition—it’s about focusing on the value you create, which ultimately leads to success.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-the-transition-to-production\">The transition to production</h2>\n\n\n\n<p>After a year and a half in support, I wanted a broader impact. Thanks to regular reports and feedback I shared with the production team, they invited me to join their department. I didn’t know which role suited me or cared about titles—I simply did what was needed.</p>\n\n\n\n<p>Over time, I held several roles: QA Manager, Release Manager, Project Manager, and Product Owner. But none of them confined my scope of responsibilities.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-my-approach-to-work\">My approach to work</h2>\n\n\n\n<p>One of the most important principles I followed was <strong>a willingness to help</strong>—without letting it hinder my main work.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>If I knew the answer to a question, I responded immediately.</li>\n\n\n\n<li>If I didn’t know but knew where to find it, I searched quickly.</li>\n\n\n\n<li>If expert input was needed, I contacted the right person.</li>\n\n\n\n<li>If I was short on time, I guided colleagues on where and whom to ask.</li>\n</ul>\n\n\n\n<p>I always ensured the problem was solved and remembered the solution. This helped me build a broad network within the company and become the go-to person who &#8220;knows everything.&#8221;</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-why-i-grew-with-the-company\">Why I grew with the company</h2>\n\n\n\n<p>Throughout my career, I have never feared uncertainty. When responsibilities changed, I took them as challenges. My philosophy was simple: “<em>I need to do everything to help the project grow, and I’ll grow along with it.</em>”</p>\n\n\n\n<p>Of course, there were periods of anxiety and doubt. <strong>Remembering my goal helped me push forward, work harder, learn faster, and adapt to changes.</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-how-i-became-a-ceo\">How I became a CEO</h2>\n\n\n\n<p>With each new role, my understanding of the WordPress market and products deepened. My vision broadened, and my goals became more ambitious. This inspired me to build a strong team and take on more responsibility for decision-making.</p>\n\n\n\n<p>As COO, I honed my skills in achieving goals. However, the key to transitioning to CEO was realizing I was ready to take responsibility for defining the goals themselves. As a CEO, your work results in the work of your team. The main tasks of a CEO are to maintain the vision, support the team, and create conditions for growth.</p>\n\n\n\n<p>For me, being a CEO is about constant development, solving new challenges, and creating growth opportunities—not only for the company but also for the team. This role isn’t the ultimate goal but a tool for achieving results that matter to us all.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-key-takeaways\">Key takeaways</h2>\n\n\n\n<p>Over this journey, I’ve learned that it’s important to focus on tasks rather than how one is evaluated. <strong>Good work speaks for itself.</strong></p>\n\n\n\n<p>When you do what you love and constantly strive for new challenges, time flies unnoticed. That’s what happened to me: 10 years passed in the blink of an eye. And then, one day, I find myself still the same girl fighting in the name of customer happiness—but now, I’m also setting the budget for the entire project for the next year.</p>\n\n\n\n<p>During this time, I’ve observed my colleagues and subordinates build their careers, and I strive to share my experience. At Crocoblock, we actively help support team members grow into developers, managers, and marketers, taking on new roles. This path is open to anyone willing to work, learn, and aim higher.<br /><strong>My lesson is simple:</strong> Be open to change, focus on what you do, and don’t fear big goals. If you work toward them daily, they will become a reality.</p>\n<p>The post <a href=\"https://heropress.com/essays/building-a-wordpress-career-without-a-map-lessons-from-my-journey/\">Building a WordPress Career Without a Map: Lessons from My Journey</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jan 2025 06:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Anna Hurko\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Boom &amp; Deepseek\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=135630\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2025/01/boom-deepseek/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1317:\"<p>What an exciting time to be alive. I was <a href=\"https://x.com/karpathy/status/1872362712958906460\">hipped to Deepseek by Andrej Kaparthy&#8217;s tweet the day after Christmas</a>, it was clear then that something big had happened and that it was truly open source and open weights (not this fake Llama stuff). It&#8217;s been fun to see the rest of the world catch up to it, and how radically accessible and deployable these models will be for people to hack on. I don&#8217;t have any comment on public markets or stocks.</p>\n\n\n\n<p>The other super inspiring thing today was Boom&#8217;s first supersonic flight. It&#8217;s <a href=\"https://www.youtube.com/watch?v=-qisIViAHwI\">worth watching the video</a>. We&#8217;re 4-5 years away from halving flight times with supersonic flight. In that same timeframe we might have something even more dramatic from SpaceX, like Houston to Tokyo in 30 minutes. Really cool to see the spirit of entrepreneurship and innovation around all of these things. It&#8217;s tempting to get distracted by drama (WPE and legal battles), but there&#8217;s such freedom and joy in just continuing to build, to engineer, to solve problems. I&#8217;m so grateful I get to do so every day with such incredible colleagues at Automattic.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jan 2025 20:15:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Do The Woo Community: AI, WooCommerce Changes, and the WordPress Community in 2025 with Robbie, Robert and Marcus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=89413\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://dothewoo.io/ai-woocommerce-changes-and-the-wordpress-community-in-2025-with-robbie-robert-and-marcus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:227:\"In this Woo AgencyChat, the hosts discuss AI\'s role in web development, WooCommerce advancements, e-commerce simplification, and the resilience of the WordPress community amidst ongoing drama, highlighting their hopes for 2025.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jan 2025 12:38:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Do The Woo Community: Do the Woo is a Media Partner for CloudFest 2025 and the Hackathon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=89382\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://dothewoo.io/blog/do-the-woo-is-a-media-partner-for-cloudfest-2025-and-the-hackathon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"We are excited to partner with CloudFest again, featuring over 8,700 attendees and 250+ speakers at Europa-Park from March 17-20, 2025.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jan 2025 10:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Do The Woo Community: Reflections on the WooCommerce Releases from 2024 with Marcel and Mike\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=89403\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://dothewoo.io/exploring-woocommerce-2024-new-features-and-developer-insights-with-marcel-and-mike/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"In this episode of Woo DevChat, Marcel and Mike discuss significant WooCommerce updates from 2024, AI\'s impact, and their personal goals.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jan 2025 11:20:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"Gravatar: Create Unique Avatars With Backgrounds and Stickers!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2772\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://blog.gravatar.com/2025/01/22/new-background-and-sticker-features/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2777:\"<p>Has it been a while since you gave your Gravatar a fresh look? We just rolled out some fun new editing tools that let you remove backgrounds, add new ones, and decorate with stickers. Your avatar travels with you across the web — now it can show even more of your personality.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Background Magic</h2>\n\n\n\n<div class=\"wp-block-group has-contrast-background-color has-background has-global-padding is-layout-constrained wp-container-core-group-is-layout-2 wp-block-group-is-layout-constrained\">\n<img width=\"1200\" height=\"849\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/cleanshot-2025-01-22-at-11.08.30.gif\" alt=\"\" class=\"wp-image-2779\" />\n</div>\n\n\n\n<p>Take any photo and instantly remove its background. Drop yourself onto a beach, in front of a cityscape, or keep it clean with a solid color. </p>\n\n\n\n<p>That quick selfie can now look like a professional headshot.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Sticker Time</h2>\n\n\n\n<div class=\"wp-block-group has-contrast-background-color has-background has-global-padding is-layout-constrained wp-container-core-group-is-layout-3 wp-block-group-is-layout-constrained\">\n<img width=\"1200\" height=\"850\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/cleanshot-2025-01-22-at-11.13.25.gif\" alt=\"\" class=\"wp-image-2780\" />\n</div>\n\n\n\n<p>Add some flair with our collection of stickers. From sunglasses to speech bubbles, you can layer on elements that match your style. Use the search feature to find the perfect additions.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to Use the New Features</h2>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Head to <a href=\"https://gravatar.com/profile\">gravatar.com/profile</a></li>\n\n\n\n<li>Click on <strong>Avatars</strong></li>\n\n\n\n<li>Upload a new photo or click the three dots to edit an existing one</li>\n\n\n\n<li>Look for the <strong>Background</strong> and <strong>Stickers</strong> menus</li>\n\n\n\n<li>Start creating!</li>\n</ol>\n\n\n\n<p><strong>Pro tip:</strong> Try the search button in both the background and sticker menus – you might find something unexpected and perfect. </p>\n\n\n\n<p>Backgrounds come from <a href=\"https://www.pexels.com/\">Pexels</a> and stickers from <a href=\"https://giphy.com/stickers\">Giphy</a>. Or you can upload your own.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Why Update Your Avatar?</h2>\n\n\n\n<p>Remember, your Gravatar shows up automatically on millions of sites like WordPress, Slack, and Zapier. It&#8217;s the face you show the world across the web. With these new tools, you can make sure that face is exactly how you want it.</p>\n\n\n\n<p>Share your new look with us <a href=\"https://x.com/gravatar\">on X</a> or <a href=\"https://bsky.app/profile/gravatar.bsky.social\">Bluesky</a> — we can&#8217;t wait to see what you create!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 26 Jan 2025 16:30:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Gravatar: Enhance Your WordPress Blog: Create a Custom Author Page\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=1863\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://blog.gravatar.com/2025/01/26/wordpress-author-page/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16651:\"<p>Author pages contain information about a person who has written, edited, or contributed to an article. This usually includes things like their name, picture, short bio, social media links, and then a list of all their published posts on the same domain.&nbsp;</p>\n\n\n\n<p>If you have a blog, it’s generally always a good idea to have dedicated authors and pages to accompany them. This is important for many reasons, but one of the main ones is that it instantly improves the credibility of the content. It’s one thing to read a technical piece written by a credible software engineer than an anonymous user with no name!</p>\n\n\n\n<p>Author pages not only encourage users to read and interact with your content (because they know a real person is behind it), but they are also great for improving your search engine rankings, along with E-E-A-T (Expertise, Experience, Authoritativeness, Trustworthiness).&nbsp;</p>\n\n\n\n<p>Now that you’re convinced how important author pages are, you’re probably wondering: “Is there a way to customize them, make them look better and more engaging?”</p>\n\n\n\n<p>Absolutely!&nbsp;</p>\n\n\n\n<p>To help you do just that, we’ve created this useful guide that will explore the different ways of customizing the author template in <a href=\"https://wordpress.org/\" rel=\"nofollow\">WordPress</a>, show you how you can create a custom page, use template tags, and take advantage of tools like <a href=\"https://gravatar.com/\">Gravatar</a> to take your author pages to the next level.&nbsp;</p>\n\n\n\n<a href=\"https://docs.gravatar.com/getting-started/\"><img width=\"3242\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_integration_cta.png\" alt=\"\" class=\"wp-image-2632\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Customizing the default author template vs. creating a custom page</strong></h2>\n\n\n\n<p>There are two main approaches when it comes to improving your author pages: Customizing the default author page template and creating a custom author page from scratch.&nbsp;</p>\n\n\n\n<p>Let’s take a look at both methods.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Customizing the default author template</strong></h3>\n\n\n\n<p>Before we dive into this, it’s important to mention that there is a difference between the author of an article and the ‘Author’ user role that exists in WordPress. Technically, the author of a blog post can also be the administrator, an editor, a contributor, as well as an author. So take into account that when we mention author, we mean any person who has written the specific piece of content.&nbsp;</p>\n\n\n\n<p>Now, with that out of the way, let’s get into the default author pages. The information they include is the data of the specific user profile, which looks like this:&nbsp;</p>\n\n\n\n<img width=\"1289\" height=\"1170\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/07/author-page-backend.png\" alt=\"User information settings in WordPress\" class=\"wp-image-1864\" />\n\n\n\n<p>You can add information like names, websites, and bio, along with the profile picture linked to their specific Gravatar profile. If they don’t have a Gravatar profile, their profile picture displays as a mystery person.&nbsp;</p>\n\n\n\n<p>On the front end, the author page will look different depending on the theme of your choice. For example, this is how it would look with the <a href=\"https://wordpress.org/themes/bloghash/\" rel=\"nofollow\">Bloghash WordPress theme</a>:&nbsp;</p>\n\n\n\n<img width=\"1493\" height=\"949\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/07/bloghash-theme-author-page.png\" alt=\"Example of the default author page in WordPress with the theme Bloghash\" class=\"wp-image-1865\" />\n\n\n\n<p>Customizing the default author template is suitable for minor changes and maintaining a consistent design across your WordPress site. By utilizing template tags, you can modify the default template regardless of the theme you&#8217;re using, without the need for additional plugins or custom code.</p>\n\n\n\n<p>The benefits of customizing the default template include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Ease of implementation:</strong> Making changes to the existing template is relatively straightforward and doesn&#8217;t require extensive technical knowledge.</li>\n\n\n\n<li><strong>Maintaining a unified look:</strong> By working with the default template, you ensure that your author pages blend seamlessly with the rest of your site&#8217;s design.</li>\n</ul>\n\n\n\n<p>However, there are some limitations to this approach:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Less flexibility:</strong> Customizing the default template may not provide as much flexibility as creating a custom author page from scratch. You&#8217;re limited to the structure and elements already present in the template.</li>\n\n\n\n<li><strong>Potential conflicts with theme updates:</strong> If your theme receives an update that modifies the author template, your customizations may be overwritten, requiring you to reapply them.</li>\n</ul>\n\n\n\n<p>Despite these limitations, customizing the default author template can be a quick and effective solution for those who want to make minor improvements to their author pages while maintaining a consistent design across their WordPress site.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Creating a custom author page</strong></h3>\n\n\n\n<p>A custom author page gives you full control over the design, the amount of information, and how it’s displayed, and it also comes with extra opportunities for user engagement. It’s a separate page that is then linked to this specific user and shows up when you click on their name.&nbsp;</p>\n\n\n\n<p>Unlike the default author page, you’re not restricted to the information fields on the back end and can add virtually anything. For example, you can include customized links to guest post contributions, client testimonials, extra information about services, a donation block, share buttons, and much more.&nbsp;</p>\n\n\n\n<p>The only possible downfall of these pages is that they require more effort to set up and maintain, and depending on your goals, you might need technical knowledge or external tools and plugins for the job. The payoff, however, is worth it.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>How to use template tags to customize the author template</strong></h2>\n\n\n\n<p>The design of your WordPress blog is defined by the theme you are using, and themes are made of different templates. Template tags PHP functions built into WordPress to fetch and display dynamic content allowing you to customize your blog and make the pages look exactly how you want them to.&nbsp;</p>\n\n\n\n<p>In this next section, we’ll guide you through the process of using template tags for author page customization, including code snippets.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Creating the author.php file</strong></h3>\n\n\n\n<p>The first step is to check whether there is an author.php file in your theme directory and create one if that’s not the case. This is the file you’ll be using to customize the layout and the content of the author pages.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Basic template tags for author information</strong></h3>\n\n\n\n<p>There are a couple of tags you can use to access author information, including:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><code><strong>the_author_meta</strong>()</code>: Use this to simply display author information.</li>\n\n\n\n<li><code><strong>get_the_author_meta</strong>()</code>: Use this if you want to return a value and save it to a variable. Values you can request include <code>admin_color, first_name, last_name, user_url, </code>and<code> nickname.</code></li>\n\n\n\n<li><code><strong>get_the_author_posts</strong>()</code>: Use this to retrieve the current author’s total number of posts.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Combining template tags with HTML and CSS</strong></h3>\n\n\n\n<p>You can display this data on the frontend of your website using the echo command, like in the example below:</p>\n\n\n\n<pre class=\"wp-block-code\"><code>&lt;div class=\"author-info\"&gt;\n	&lt;h2&gt;About the Author&lt;/h2&gt;\n	&lt;p&gt;&lt;strong&gt;Name:&lt;/strong&gt; &lt;?php echo get_the_author_meta (\'display_name\'); ?&gt;&lt;/p&gt;\n	&lt;p&gt;&lt;strong&gt;Email:&lt;/strong&gt; &lt;?php echo get_the_author_meta (\'user_email\'); ?&gt;&lt;/p&gt;\n	&lt;p&gt;&lt;strong&gt;Bio:&lt;/strong&gt; &lt;?php echo get_the_author_meta (\'description\'); ?&gt;&lt;/p&gt;\n&lt;/div&gt;</code></pre>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Using conditional statements</strong></h3>\n\n\n\n<p>The <strong>is</strong>_author function introduces conditional logic, where you can check whether a page has an author, and display their information if it does. Use the following format:</p>\n\n\n\n<pre class=\"wp-block-code\"><code>&lt;?php if ( is_author() ) : ?&gt;\n// Your code here if it returns true\n&lt;?php endif; ?&gt;</code></pre>\n\n\n\n<p>This is ideal for sites with a very simple URL structure where, say, a landing page and a blog post would have the same structure.</p>\n\n\n\n<p>Pair this with the <code>get_the_author_meta()</code> command to retrieve the author’s ID and display their information on the frontend, as shown above.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Building a custom author page on WordPress through Gravatar integration</strong></h2>\n\n\n\n<img width=\"1473\" height=\"918\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/07/gravatar-profiles-as-a-service-1.png\" alt=\"Gravatar homepage\" class=\"wp-image-1871\" />\n\n\n\n<p><a href=\"https://gravatar.com/\">Gravatar</a>, a service built by <a href=\"https://automattic.com/\">Automattic</a>, offers a powerful solution for creating feature-rich and dynamic author pages on your website with minimal effort. While WordPress already uses Gravatar profile pictures for users logged in with the same email, you can take this integration a step further by leveraging Gravatar&#8217;s Profiles-As-A-Service REST API to import entire user profiles and create fully customized author pages.</p>\n\n\n\n<p>For example, all the blog posts written by yours truly (me, Ronnie) have a link to my <a href=\"https://gravatar.com/burtrw\">Gravatar page</a>:&nbsp;</p>\n\n\n\n<img width=\"821\" height=\"353\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/07/link-to-gravatar-profile.png\" alt=\"Example of author link in a Gravatar blog post\" class=\"wp-image-1872\" />\n\n\n\n<p>This is so that when people click on my name, they are redirected to my Gravatar profile where I’ve put all important information about myself.</p>\n\n\n\n<img width=\"1032\" height=\"776\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/07/ronnie-gravatar-profile.png\" alt=\"Ronnie Burt Gravatar\'s profile\" class=\"wp-image-1873\" />\n\n\n\n<p>However, the benefits of Gravatar integration go beyond simply linking to an author&#8217;s Gravatar page. By utilizing the <a href=\"https://blog.gravatar.com/2024/06/03/profiles-as-a-service/\">Profiles-As-A-Service</a> REST API, you can create custom author pages on your website that display information imported directly from Gravatar. This offers several advantages:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Automatically synced author data: </strong>When a new author or contributor signs up to your site with their Gravatar profile, all their data is automatically imported. This includes name, location, job title, pronouns, bio, important links to their other work, verified social media accounts, and contact information. This streamlines the process for everyone, especially the author, as they don&#8217;t need to input their entire information from scratch.</li>\n\n\n\n<li><strong>Simplified author page creation:</strong> With Gravatar&#8217;s API, you have access to pre-populated data, allowing you to build custom author pages quickly without the need to collect information manually. Everything falls into place seamlessly.</li>\n\n\n\n<li><strong>Data consistency:</strong> Since the custom author page is connected to the Gravatar profile, any changes made to the author&#8217;s information on Gravatar are automatically reflected on your website. This eliminates the need for admins and IT support to constantly update author information manually.</li>\n\n\n\n<li><strong>Pre-verified author information:</strong> Gravatar validates and vets certain user data, such as linked social media accounts and payment links. This ensures that authors are who they claim to be, making it easier for readers to connect with them and enhancing the credibility and accuracy of your articles.</li>\n</ul>\n\n\n\n<p>So, if you want to leverage Gravatar to build a custom author page, check out our <a href=\"https://docs.gravatar.com/api/profiles/\">documentation for developers</a>.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Customizing the WordPress author box with Jetpack and Gravatar</strong></h2>\n\n\n\n<p>One of the most important parts of the author&#8217;s profile is their bio – it’s what gives the article credibility and entices readers to check out more posts or even connect with the author. Besides ensuring it’s written well, you can enhance the bio’s design even further with the <a href=\"https://jetpack.com/\" rel=\"nofollow\">Jetpack</a> plugin and its <a href=\"https://jetpack.com/support/gravatar-hovercards/\">Gravatar hovercard integration</a>.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Customizing author info with Jetpack</strong></h3>\n\n\n\n<img width=\"1317\" height=\"724\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/07/jetpack-homepage.png\" alt=\"Jetpack homepage\" class=\"wp-image-1875\" />\n\n\n\n<p>Jetpack comes with many additional features, that allow you to customize and add new functionalities to the author pages.&nbsp;</p>\n\n\n\n<p>First, it fully integrates with Gravatar to pull author information and update it automatically. Besides that, it lets you enable the display of the author’s name and bio or their Gravatar profile on single post pages with all the information directly pulled from their WordPress profile.&nbsp;</p>\n\n\n\n<p>In this example, we’ve added a Gravatar profile widget to the sidebar next to the blog post.&nbsp;</p>\n\n\n\n<img width=\"1992\" height=\"1017\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/07/gravatar-widget-jetpack.png\" alt=\"The Gravatar widget in Jetpack\" class=\"wp-image-1876\" />\n\n\n\n<p>With <a href=\"https://docs.gravatar.com/sdk/web-components/hovercards/\">Gravatar Hovercards</a> enabled, when people hover over the profile with their mouse, they’ll see a mini version of the profile as a hovercard.&nbsp;</p>\n\n\n\n<p>This is how it would look in our example:&nbsp;</p>\n\n\n\n<img width=\"1283\" height=\"848\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/07/example-hovercards-sarah.png\" alt=\"Example of a Gravatar hovercard\" class=\"wp-image-1878\" />\n\n\n\n<p>You can easily enable that by going to <em>Jetpack &gt; Settings &gt; Discussion </em>and then enabling the option named “<em>Enable pop-up business cards over commenters’ Gravatars</em>”</p>\n\n\n\n<img width=\"660\" height=\"404\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/07/enable-hovercards-in-jetpack.png?w=660\" alt=\"Enabling Hovercards in the Jetpack settings\" class=\"wp-image-1879\" />\n\n\n\n<p>There are many other customization options, especially with <a href=\"https://jetpack.com/support/extra-sidebar-widgets/\" rel=\"nofollow\">Jetpack widgets</a>. Still, we recommend keeping it simple and not cluttering the page with too many elements, as this may overwhelm readers. As always, balance is key.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Transform your WordPress site with a stunning custom author page</strong></h2>\n\n\n\n<p>Custom author pages are essential for showcasing your authors&#8217; expertise, fostering reader connections, and enhancing user experience. While there are various approaches to creating custom author pages on WordPress, integrating with Gravatar&#8217;s Profiles-As-A-Service REST API is the most efficient and effective solution.</p>\n\n\n\n<p>By leveraging Gravatar&#8217;s API, you can save time and effort, ensure data accuracy and consistency, provide a seamless user experience, and boost your blog&#8217;s SEO and E-E-A-T.&nbsp;<a href=\"https://docs.gravatar.com/api/profiles/\">Learn more about how you can integrate Gravatar</a> with your WordPress website and begin your journey toward a more connected and personalized user experience.</p>\n\n\n\n<a href=\"https://docs.gravatar.com/getting-started/\"><img width=\"3242\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_integration_cta.png\" alt=\"\" class=\"wp-image-2632\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 26 Jan 2025 16:24:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"HeroPress: ‘Support Inclusion in Tech’ Grant Program Expansion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=7742\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:165:\"https://heropress.com/support-inclusion-in-tech-grant-program-expansion/#utm_source=rss&utm_medium=rss&utm_campaign=support-inclusion-in-tech-grant-program-expansion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2501:\"<img width=\"1024\" height=\"501\" src=\"https://heropress.com/wp-content/uploads/3025/01/includsion_in_tech_banner2-1024x501.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Support Inclusion In Tech Grant Program Banner\" /><p><a href=\"https://supportinclusionintech.com/\">SiNC (Support Inclusion In Tech)</a> in 2024 launched a grant program, supporting those who have contributed to the WordPress project.</p>\n\n\n\n<p>From the Open Collective:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>The grant program remains open to all WordPress contributors who have demonstrated significant contributions to the community through their involvement in local meetups, WordCamps, or code contributions. WordPress contributors can opt into a named directory starting in January 2025, and selections will be made in March 2025. Names will be entered into a random name picker for selection.</p>\n\n\n\n<p><a href=\"https://opencollective.com/support-inclusion-in-tech/updates/sinc-expands-grant-program-to-empower-wordpress-contributors-across-north-and-south-america\">https://opencollective.com/support-inclusion-in-tech/updates/sinc-expands-grant-program-to-empower-wordpress-contributors-across-north-and-south-america</a></p>\n</blockquote>\n\n\n\n<p>At the time of its announcement the grants were only available in Europe, Asia, and Africa.</p>\n\n\n\n<p><a href=\"https://supportinclusionintech.com/\">SiNC</a> is now pleased to announce that this grant program is also available in North and South America!  If you&#8217;d like to apply for a grant, <a href=\"https://www.jotform.com/243518481147055\">fill out this form</a>.</p>\n\n\n\n<h2 class=\"kt-adv-heading7742_b006f6-13 wp-block-kadence-advancedheading\">More Information</h2>\n\n\n\n<p><a href=\"https://supportinclusionintech.com/sinc-expands-grant-program-to-empower-wordpress-contributors-across-north-and-south-america/\">Official Press Release</a></p>\n\n\n\n<p><a href=\"https://opencollective.com/support-inclusion-in-tech/updates/sinc-expands-grant-program-to-empower-wordpress-contributors-across-north-and-south-america\">Open Collective Announcement</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/support-inclusion-in-tech-expands-grant-program-to-north-and-south-america\">WPTavern Article</a></p>\n<p>The post <a href=\"https://heropress.com/support-inclusion-in-tech-grant-program-expansion/\">‘Support Inclusion in Tech’ Grant Program Expansion</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Jan 2025 21:32:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"Gutenberg Times: Cursor AI, Block Themes, Fediverse, WordCamp Asia and more —   Weekend Edition #317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=37397\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://gutenbergtimes.com/cursor-ai-block-themes-fediverse-wordcamp-asia-and-more-weekend-edition-317/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19573:\"<p>Hi there, </p>\n\n\n\n<p>Did you start well into the new year? The first month is almost over. Working from home, I am really looking forward to seeing my WordPress friends at <a href=\"https://asia.wordcamp.org/2025/\">WordCamp Asia</a> in Manila. The team facilitates meeting contributors in one-on-one sessions and to ask questions: It&#8217;s called the <a href=\"https://asia.wordcamp.org/2025/human-library-books/\">Human Library and contributors are call Books</a>. My shift is from 10:30 to noon on Contributor Day. You can also meet Ryan Welcher, Nick Diego, Milana Cap, Hari Shanker to mention just a few.</p>\n\n\n\n<p>If FOMO (fear of missing out) is real for you, rest assured you can always ping me for a chat, email pauli@gutenbergtimes.com, or message me on Slack or <a href=\"https://bsky.app/messages\">Bluesky</a>. I would be delighted! </p>\n\n\n\n<p>In this week&#8217;s edition, you&#8217;ll find quite a few tutorials,  plugins, and podcast episodes and nowadays also AI. I hope you&#8217;ll enjoy ready and listening to it all as I did. </p>\n\n\n\n<p>Have a fantastic weekend! </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/cursor-ai-block-themes-fediverse-wordcamp-asia-and-more-weekend-edition-317/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/cursor-ai-block-themes-fediverse-wordcamp-asia-and-more-weekend-edition-317/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/cursor-ai-block-themes-fediverse-wordcamp-asia-and-more-weekend-edition-317/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/cursor-ai-block-themes-fediverse-wordcamp-asia-and-more-weekend-edition-317/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ol>\n</div></div>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>Hey friends! 🌴✨ Get ready for an epic adventure at&nbsp;<strong>WordCamp Asia 2025</strong>&nbsp;in vibrant Manila! </p>\n\n\n\n<p>I&#8217;ll be diving deep into the WordPress universe &#8211; hanging out at Contributor Day (February 20th) and rocking both conference days (February 21-22nd).Want to connect? I&#8217;m totally open to grabbing&nbsp;<strong>coffee, lunch, or catching up</strong>&nbsp;between sessions at the Philippine International Convention Center. </p>\n\n\n\n<p><a href=\"https://bit.ly/bph-wcasia\">Check out my public calendar</a> and snag a slot &#8211; let&#8217;s turn this tech gathering into an unforgettable networking experience! Can&#8217;t wait to swap stories, share insights, and soak up the incredible WordPress community energy in the Philippines. Who&#8217;s in? 🚀🇵🇭 #WordCampAsia2025</p>\n\n\n\n<img width=\"652\" height=\"433\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/01/proud-banner-speaker-2-smaller.png?resize=652%2C433&ssl=1\" alt=\"\" class=\"wp-image-37428\" />\n</div></div>\n</div>\n\n\n<p>As mentioned last week, <em>DoTheWoo</em> and <em>Gutenberg Times</em> were founded around the same time. <strong>Bob Dunn aka BobWP</strong> and I chatted about our starts in our 7th anniversary episode: <a href=\"https://dothewoo.io/reflections-on-gutenberg-times-and-do-the-woo-with-birgit-and-bobwp/\">The Evolution of WordPress Content: Insights on Gutenberg, Podcasting, and Community Growth</a>. Bob is the astounding supporter of the WordPress community and raises diverse voices with his network of 12 podcast and hosts. You will always find something or someone interesting to listen to or about.</p>\n\n\n\n<a href=\"https://dothewoo.io/reflections-on-gutenberg-times-and-do-the-woo-with-birgit-and-bobwp/\"><img width=\"652\" height=\"367\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/01/Do-the-Woo-Podcast-On-WPCommunity-Epiosde-600-edited.jpg?resize=652%2C367&ssl=1\" alt=\"\" class=\"wp-image-37480\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>Aaron Jorbin</strong> announced <a href=\"https://make.wordpress.org/core/2025/01/22/wordpress-6-7-2-release-planning/\">WordPress 6.7.2 Release Planning</a> with RC 1 on February 4 and final release on February 11, 2025. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-114-reflections-on-gutenberg-times-and-do-the-woo/\">Gutenberg Changelog #114 – Reflections on Gutenberg Times and Do the Woo</a> with Bob Dunn aka BobWP as host and guest Birgit Pauli-Haack, each publication started 7 years ago. </p>\n\n\n\n<img width=\"652\" height=\"328\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/02/Gutenberg-Changelog-114-Bob-Dunn-Birgit-pauli-Haack-edited.png?resize=652%2C328&ssl=1\" alt=\"\" class=\"wp-image-37614\" />\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><a href=\"https://x.com/Copons\"><strong>Jacopo &#8220;Copons&#8221; Tomasone</strong></a> wanted you to know about <a href=\"https://wordpress.com/blog/2025/01/22/interface-update/\"><strong>an Update to WordPress.com’s Interface</strong></a>: &#8220;The updated interface is the latest release in a larger project to bring the experience on WordPress.com much closer to a “core” WordPress experience.” Tomasone wrote and continued &#8220;This is just the beginning of a gradual process that will continue over the next few months as we continue to create a more unified and familiar experience across our products.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Brian Coords</strong> published a new episode of the <em>Webmasters</em> podcast.  He chatted with <strong><a href=\"https://x.com/iansvo\">Ian Svoboda</a> </strong>of Generate Blocks, how the plugin<a href=\"https://webmasters.fm/how-generateblocks-adds-modern-design-tools-to-gutenberg/\"><strong> adds modern design tools to Gutenberg</strong></a>. They also discussed all about building on top of the block editor and crafting tools that supercharge your site-building workflow. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In <a href=\"https://wordpress.com/blog/2025/01/16/fediverse-reactions-block/\"><strong>Improving Fediverse Engagement With the Reactions&nbsp;Block</strong></a>, <a href=\"https://x.com/mattwiebe\"><strong>Matt Wiebe</strong></a>  introduced&nbsp;Likes,&nbsp;Reposts, and the&nbsp;Fediverse Reactions block, and expanding the ActivityPub plugin. With the Reactions Block, likes and reposts from Mastodon and other Fediverse platforms are automatically added to the end of your posts (if you’re using the Site Editor).</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jeremy Holcombe</strong> discussed <a href=\"https://kinsta.com/blog/wordpress-dark-mode/\"><strong>WordPress dark mode: key benefits and how to set it up</strong></a> on the Kinsta blog. You’ll discover the advantages of dark mode, such as better accessibility, a healthier visitor experience, lower energy use, and meeting user preferences. He also shows you different ways to add dark mode to WordPress with plugins or custom code. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://x.com/aliaghdam\"><strong>Ali Aghdam</strong></a> from Istanbul, Turkey, and his team soft-launched <strong><a href=\"https://wordpress.org/plugins/blockera/\">Blockera</a></strong> &#8211; a plugin to add supposedly missing features to the Block editor for designers. The current version feels like a beta of the Pro-version. You&#8217;ll find a lot of &#8220;coming soon&#8221; or &#8220;upgrade now&#8221; prompts around the interface. It gives you a good indication where the various features will be placed. </p>\n\n\n\n<p>I test the additional text features, and they seem to be solid, adding enhanced text shadow and orientation capabilities. An already <a href=\"https://community.blockera.ai/\">active community</a> and the process of building public, allows for a fairly fast update cycle. It&#8217;ll be interesting to see how this compares to other tools, once the free and pro versions are more progressed. With 195 blocks, it&#8217;s definitely not for the faint of heart. You can join the waitlists for the pro version as well as for the Blockera One block theme on <a href=\"https://blockera.ai/\">blockera.ai.</a> The <a href=\"https://wordpress.org/plugins/blockera/\">plugin is available</a> in the WordPress repository. </p>\n\n\n\n<a href=\"https://wordpress.org/plugins/blockera/\"><img width=\"652\" height=\"318\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/01/Screenshot-2025-01-24-at-11.36.23.png?resize=652%2C318&ssl=1\" alt=\"\" class=\"wp-image-37462\" /></a>\n\n\n\n<p>WooCommerce 9.6 was released and <strong>Stephanie Pi</strong> highlight in the release announcement <a href=\"https://developer.woocommerce.com/2025/01/20/woocommerce-9-6-fresh-new-tools-and-modernizing-classics/\"><strong>WooCommerce 9.6: Fresh new tools and modernizing classics</strong></a>, she highlights: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://developer.woocommerce.com/2025/01/20/woocommerce-9-6-fresh-new-tools-and-modernizing-classics/#h-brands-has-landed\">Brands has landed</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/01/20/woocommerce-9-6-fresh-new-tools-and-modernizing-classics/#h-smarter-defaults-for-measuring-unit\">Smarter defaults for measuring unit</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/01/20/woocommerce-9-6-fresh-new-tools-and-modernizing-classics/#h-product-summary-block-enhanced\">Product Summary block, enhanced</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/01/20/woocommerce-9-6-fresh-new-tools-and-modernizing-classics/#h-more-new-features-and-updates\">More new features and updates</a></li>\n</ul>\n\n\n\n<a href=\"https://developer.woocommerce.com/2025/01/20/woocommerce-9-6-fresh-new-tools-and-modernizing-classics/\"><img width=\"652\" height=\"501\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/01/Screenshot-2025-01-24-at-14.16.03.png?resize=652%2C501&ssl=1\" alt=\"\" class=\"wp-image-37478\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>In episode #153, <strong>Nathan Wrigley</strong> chatted with <a href=\"https://wptavern.com/podcast/153-tammie-lister-on-modern-theme-development-and-artistic-exploration\"><strong>Tammie Lister on Modern Theme Development and Artistic Exploration</strong></a>. &#8220;The fact that Tammie is both a designer and a technical expert has allowed her to offer a well-rounded perspective on the evolution and future of WordPress themes. We explore the shift from classic themes to the new era of Full Site Editing and theme.json, and discuss whether the slower-than-anticipated adoption of these new tools signifies a deeper trend, or just a transitional phase.&#8221; wrote Wrigley in the summary. </p>\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<p><a href=\"https://maxiblocks.com/author/kp_oxctwsred/\"></a><strong><a href=\"https://x.com/kyralPieterse\">Kyra Pieterse</a></strong> of <em>Maxiblocks </em>shared <a href=\"https://maxiblocks.com/6-important-reasons-for-switching-to-wordpress-full-site-editing/\"><strong>six important reasons for switching to WordPress FSE</strong></a>. Working in the Site editor &#8220;simplifies customization, reduces the need for coding, and improves site performance by optimizing speed and functionality. With features like global styling, reusable templates, and responsive design tools, FSE provides a streamlined way to create professional WordPress websites that meet the needs of both website designers and businesses.&#8221; she wrote.  She dives deeper into each of the arguments in her article. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>Ever since <a href=\"https://wordpress.com/blog/2024/04/24/studio/\">Studio was released</a>, I wondered if I can make it the only local development app. Ever since my agency days, I have been using LocalWP. The latest Studio update: <a href=\"https://wordpress.com/blog/2025/01/06/studio-sync/\"><em>Build Locally, Deploy Globally: Meet Studio Sync for WordPress.com</em></a> had me wondered if all I need now is Studio. I have probably about two dozen sites in my LocalWP instance for various testing and building scenarios, so I was curious how fast can I migrate a site to Studio? Turns out it only takes a couple of minutes per site to export from Local and import into Studio. You can see a short video and some details on my blog post. <a href=\"https://icodeforapurpose.com/migrate-my-local-sites-to-studio/\"><strong>How do I migrate my LocalWP sites to Studio by WordPress.com?</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his post on the WordPress developer blog, <a href=\"https://developer.wordpress.org/news/2025/01/one-hook-to-rule-them-all-the-many-faces-of-block-categories/\"><strong>One hook to rule them all: The many faces of block categories</strong></a>, <strong><a href=\"https://x.com/troychaplin\">Troy Chaplin</a></strong> takes a deep dive into the ins and outs of Block categories for the Inserter of the Editor. &#8220;The hook is a versatile tool that allows developers to customize the way block categories are organized. Throughout this article, you will learn how to use this hook and build functions to add, reorder and rename single or multiple block categories.&#8221; Chaplin wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://x.com/carlodaniele\">Carlo Daniele</a></strong> set out to teach developers <a href=\"https://kinsta.com/blog/gutenberg-plugin/\"><strong>how to build a Gutenberg plugin to add functionality to the block editor</strong></a>. You&#8217;ll lean how to create a plugin without creating a custom block, add a sidebar to manage post metadata, and use block pattern overrides to automate your workflow. <br /> </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest video, <strong>Nick Diego</strong>, developer relations advocate for WordPress,  set out to show you how you can <a href=\"https://www.youtube.com/watch?v=3_TiyKdPNq4\"><strong>revolutionize your WordPress development with Cursor AI</strong></a>.  He demonstrated how to set up Cursor for seamless WordPress plugin creation by configuring it specifically for WordPress coding standards, and creating structure instructions. As an example,  Diego built  &#8211; AI assisted &#8211; a Copy Code block plugin. </p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n</div>\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jan 2025 23:14:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"Do The Woo Community: Reflections on Gutenberg Times and Do the Woo with Birgit and BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=89288\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://dothewoo.io/reflections-on-gutenberg-times-and-do-the-woo-with-birgit-and-bobwp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:212:\"In episode, Bob and Birgit discuss their journeys in the WordPress community, focusing on the evolution of Gutenberg, podcasting challenges, and the importance of diverse voices, while planning for future events.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jan 2025 15:44:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: #153 – Tammie Lister on Modern Theme Development and Artistic Exploration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=185775\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://wptavern.com/podcast/153-tammie-lister-on-modern-theme-development-and-artistic-exploration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47816:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast, from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case the underpinnings of modern theme development and artistic exploration within WordPress.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcasts players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea. Featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Tammie Lister. Tammie is a product creator focusing on WordPress. She has a hybrid background as a full stack product creator. She contributes to WordPress, and is passionate about open source and the WordPress community.</p>\n\n\n\n<p>Tammie has a rich history with WordPress, having worked with themes and the platform for many years. Her journey melds her artistic flair with technical expertise, something which is, I think, quite rare. Her experience spans theme building, design, development, and more recently guiding product developers through Guildenberg, an initiative which she co-founded.</p>\n\n\n\n<p>The fact that Tammie is both a designer and a technical expert has allowed her to offer a well-rounded perspective on the evolution and future of WordPress themes.</p>\n\n\n\n<p>We explore the shift from Classic Themes to the era of Full Site Editing and theme.json, and discuss whether the lower than anticipated adoption of these new tools signifies a deeper trend or just a transitional phase.</p>\n\n\n\n<p>Additionally, Tammie shares her insights on the necessity of beauty versus utility on the internet, the importance of experimentation in design, and how our definition of art and themes needs continual rethinking.</p>\n\n\n\n<p>We also get into her personal artistic endeavors, where she balances her tech workspace with an art studio, highlighting her lifelong passion for photography.</p>\n\n\n\n<p>If you&#8217;re curious about the current state of WordPress theming, the impact of emerging technologies on the platform, or how to infuse more creativity into your web projects, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so, without further delay, I bring you Tammie Lister</p>\n\n\n\n<p>I am joined on the podcast by Tammie Lister. Hello, Tammie.</p>\n\n\n\n<p>[00:03:14] <strong>Tammie Lister:</strong> Hello, how are you?</p>\n\n\n\n<p>[00:03:15] <strong>Nathan Wrigley:</strong> Very good. I love the way that on these podcasts, we talk as if we&#8217;ve just started the call, whereas Tammie and I have already managed to chat for about an hour at least about all sorts of things.</p>\n\n\n\n<p>But the endeavor today is to talk about themes. We&#8217;re going to come at it from a whole bunch of different angles, I hope.</p>\n\n\n\n<p>But before we do that, I think it&#8217;s probably good that Tammie gets an opportunity to paint a picture of where her experience lies with WordPress and themes. So really I&#8217;m just asking you for your potted bio, Tammie, if that&#8217;s all right.</p>\n\n\n\n<p>[00:03:43] <strong>Tammie Lister:</strong> Themes is really a thread that&#8217;s run throughout. I kind of started doing that within WordPress, and it&#8217;s actually the reason why I started doing WordPress. The best way I describe it is I was torturing my own CMS. And then I found, like everybody was doing that, right? Everyone had their own PHP insecure thing.</p>\n\n\n\n<p>And then I found WordPress because I was blogging about design and development and then I just found themes and just fell in love Kubrick And then just really got into, through BuddyPress themes, through theming, and that&#8217;s kind of been my thread.</p>\n\n\n\n<p>I would say I kind of work more on the product side now, and I also describe myself as a hybrid because I just like to do all the things. I like to do product, I like to do design and development. And I&#8217;m currently working both in creating things and supporting product developers through co-founding of Guildenberg, where we work with product makers, and I also work on so many different things, but I also work with themes as well.</p>\n\n\n\n<p>[00:04:36] <strong>Nathan Wrigley:</strong> Are you one of those lucky people who is a hybrid of designer and technical?</p>\n\n\n\n<p>[00:04:42] <strong>Tammie Lister:</strong> I mean, we could go that I&#8217;m not very good at either of them, but let&#8217;s go with I&#8217;m lucky in that I do both of them, yes.</p>\n\n\n\n<p>[00:04:48] <strong>Nathan Wrigley:</strong> And have you always, dare I ask, have you always had a sort of an artistic flare? You know, when you were at school, were you always drawn to sort of putting paint on canvas and those kind of things?</p>\n\n\n\n<p>[00:04:58] <strong>Tammie Lister:</strong> Yeah, so one of the things is because of my age, the web did not exist. I was creative, so therefore it was considered that because I was creative I had to go and do art. That was quite a narrow vision quite a few decades ago.</p>\n\n\n\n<p>And I always had this love of computers, Acorn Electrons, all those kind of early computers. I still loved all of that kind of stuff. I&#8217;m lucky enough to have been, I&#8217;m 50 coming up this year, so I was lucky enough to have been from the start of computers, going all the way through. And I think if you have that, you are hybrid by nature, because you got to see the technology as it happened, even if you are kind of more on the artistic side.</p>\n\n\n\n<p>So I did the art first of all. I actually did psychology, then I did art, and then I got to kind of retrain in software engineering. Most of my life I&#8217;ve done one, and then I&#8217;ve done the other, then I&#8217;ve done one, then I&#8217;ve done the other, and then this thing called product appeared in the universe, which we found a label to put on everybody. And I&#8217;ve adopted that because it actually fits.</p>\n\n\n\n<p>[00:05:56] <strong>Nathan Wrigley:</strong> Coming from somebody who is profoundly unskilled in the artistic side of life, I&#8217;m quite jealous that you have that in your background.</p>\n\n\n\n<p>[00:06:03] <strong>Tammie Lister:</strong> Thank you for saying I&#8217;m skilled. I&#8217;ll go with that.</p>\n\n\n\n<p>[00:06:06] <strong>Nathan Wrigley:</strong> Sorry, I know this is going off piste little bit, do you keep your hand in with the artistic side of things? I mean, I know that the listeners can&#8217;t see what I can see, but it looks like you&#8217;re in an environment where art materials may be a part of your daily life. Do you still do that?</p>\n\n\n\n<p>[00:06:20] <strong>Tammie Lister:</strong> Yeah. I&#8217;m really lucky. So my office is half working for tech, like my desk, and then the other half is my art studio. And the half of my art studio has over the years, got bigger and started invading. So my art forms are primarily, either digital art, painting, and it&#8217;s an easel the other side, or photography.</p>\n\n\n\n<p>So even like one of my art forms is very very technical. So when you actually study art, you have to pick mediums and those were the mediums. So photography is one of the mediums that&#8217;s run throughout, and that&#8217;s probably like one of the most technical art forms that you can do as well.</p>\n\n\n\n<p>[00:06:52] <strong>Nathan Wrigley:</strong> I am going to ask you a really unfair question, but if the universe conspired so that you could only keep one form of art, be that photography, painting or the online stuff or, I don&#8217;t know, Photoshop. What would be the one which speaks to you the most? The one that you would jettison as a last resort?</p>\n\n\n\n<p>[00:07:11] <strong>Tammie Lister:</strong> Photography, because it&#8217;s been something that I&#8217;ve just in different mediums. We were talking before, one of my, projects is weird cameras. I am currently playing with a camera that does thermo printing onto receipts. But, I love the idea that you can take pictures into different things, even if you do like pinhole cameras. So yeah, the idea that you can capture pictures that way, or that you can capture pictures and then even like through AI, manipulate them. That&#8217;s something that super interests me.</p>\n\n\n\n<p>[00:07:37] <strong>Nathan Wrigley:</strong> I always think there&#8217;s something really magical about holding that piece of equipment in your hand as well. I don&#8217;t know what it is, the internet, you can&#8217;t get your hands on it in the same way can you, as you can with a piece of art or a camera or what have you? And I think there&#8217;s just something very human there.</p>\n\n\n\n<p>[00:07:48] <strong>Tammie Lister:</strong> You get so nerdy about your cameras. If you find the cameras, I&#8217;m a Fuji person, and you find your kind of kits and your, yeah. That&#8217;s a different podcast. But like I could get equally as nerdy about themes as I could about my camera set up. So yeah.</p>\n\n\n\n<p>[00:08:03] <strong>Nathan Wrigley:</strong> So pivoting more towards the internet then, and again, we&#8217;re not getting into the subject at hand, but I&#8217;m enjoying this conversation, so lets keep it going for a few minutes. Do you think the internet requires beauty? Or is that kind of like an added benefit? So a typical website, does it need to be beautiful or is the internet a more utilitarian thing, or is it more of a website by website, case by case basis?</p>\n\n\n\n<p>[00:08:26] <strong>Tammie Lister:</strong> So I think it&#8217;s a little bit of case by case. It depends. I will always love experimentation, but I studied art in the days of installation rooms, and the really weird nineties art. So that&#8217;s kind of like my grounding is like the weird stuff. The modern art that a lot of people look at and go, huh I quite like a lot of that. But also, through experimentation, we also find out what can be maybe applied to more usable content.</p>\n\n\n\n<p>And I think that that&#8217;s something to be said like, will a real pushed experiment be used by everybody? Nope, not probably. But can it push the medium? Yes. And that is also something that&#8217;s been done time and time again in art.</p>\n\n\n\n<p>But I think it&#8217;s really careful to, the word art is used a little bit too broadly. Art means something very different from design, and those need to be defined separately a little bit when we&#8217;re saying it. The whole first year of studying art is trying to define the word art, when you study it. Trying to define the word art as a whole thing. And we just, particularly in the digital world, we&#8217;re like, yeah, it&#8217;s art. I don&#8217;t think the people that studied art, and art history, would be saying that as well. Sometimes we apply words in our industry that we are maybe applying that we shouldn&#8217;t as well.</p>\n\n\n\n<p>So where I like to see it is experimentation, and I think we need more experimentation in our medium to get it forward a little bit. But then for use case, yeah, that deviated quite a lot in saying it.</p>\n\n\n\n<p>[00:09:52] <strong>Nathan Wrigley:</strong> No, no, but that&#8217;s interesting because I guess with things like the advent of CMSs and the growing popularity of CMSs, it is possible to go into a very cookie cutter kind of approach to websites. You know, it&#8217;s got a header, it&#8217;s got a footer, it&#8217;s got a hero and what have you.</p>\n\n\n\n<p>And the internet for many people has become a bit of a stale place, and there&#8217;s not much innovation. You know, if you go to a bookshop and you look at the magazines, especially if you&#8217;re probably not looking at car mechanics, but if you&#8217;re heading towards the more artistic side of things, the innovation there is really profound. And I know you can find examples of that on the internet.</p>\n\n\n\n<p>[00:10:24] <strong>Tammie Lister:</strong> But that happens also in art. Homogenisation of art also happens. So you&#8217;ll find that, you&#8217;ll go through periods where great art, artistic periods and just liveliness and periods where boundaries are pushed in art, and it&#8217;s amazing and it&#8217;s great. And then this homogenised periods of just like beige art comes out, and doesn&#8217;t feel that anyone&#8217;s pushing any boundaries or anyone&#8217;s doing it, and it just all feels the same.</p>\n\n\n\n<p>We are maybe going through one of those. I would argue that what we are going through is maybe some of the technology is the bit that&#8217;s changing, and experimental. So maybe the things that we are not seeing on the top are the things that are changing, and the top needed to distill anyway. And I think that that&#8217;s probably the biggest change we are going to be experiencing or we should be experiencing is the top doesn&#8217;t matter. And I think that&#8217;s going to be quite ground breaking to a lot of us.</p>\n\n\n\n<p>Back not too long ago, we used to be very precious about the design. You&#8217;d get this design and you&#8217;d be pixel perfect making it, and you&#8217;d be measuring it, and you&#8217;d be getting out your, how many widget screen rulers, right? And you&#8217;d be measuring it and doing break widths, and points and all these kind of things. And I don&#8217;t know what that word is, the break points and doing all these kind of measures and being very precise about it.</p>\n\n\n\n<p>And now that time is changing. Now you are looking at fluid typography. Now you are looking at, how does this respond? And it&#8217;s not that it responds in breakpoints, you don&#8217;t know what device someone&#8217;s going to be viewing on. They could be viewing it through goggles. All these kind of different experiences, and you may not have ever used the device that they&#8217;re experiencing on. Try browser testing every single browser in the world, good luck.</p>\n\n\n\n<p>But that&#8217;s the reality that you&#8217;re working in now. And when you&#8217;re working in that, the interface has to be secondary, and personalisation is quite key for the user. And that&#8217;s quite hard for us to understand, that the interface could be heavily changed and should be heavily changed depending on the user need, rather than it being this perfect vision.</p>\n\n\n\n<p>But then again, some things are just going to be an experience. So you are going to wander in, and it&#8217;s going to be a beautifully kept shop front because it feels like that. It&#8217;s use case, right?</p>\n\n\n\n<p>[00:12:31] <strong>Nathan Wrigley:</strong> The changes that have happened in the WordPress space, let&#8217;s say over the last five or six years. So we went from what we might call Classic Themes. I guess that&#8217;s the term that most people would be familiar with, where you are interacting with template files. And now we&#8217;re in an era of Full site editing or Site Editing. The interface in WordPress, if you don&#8217;t install a Classic Theme, allows you to do all of that in a, kind of more or less what you see what you get. You can interact with the templates, for want of a better word, inside of a GUI, and you can use the mouse instead of using a text editor and what have you.</p>\n\n\n\n<p>Now, that project, on the face of it, five or six years ago, obviously it was hoped that that would receive wide adoption, and I think maybe the upper echelons of the WordPress project were maybe assuming that people would jump on board with this. But it seems like that really hasn&#8217;t happened.</p>\n\n\n\n<p>I have a memory, I don&#8217;t really know if the numbers I&#8217;m about to say are correct, but I have a memory that it was hoped that within a year of Full Site Editing coming around, that there&#8217;d be 5,000 themes inside the .org repo.</p>\n\n\n\n<p>I think we&#8217;ve really only just now, so five years later, gone past 1000. I wonder if you&#8217;ve got any intuitions as to why it hasn&#8217;t been adopted, not just by end users, but also developers, and agencies, and all these different people? Has it stagnated? Is it a project which has got no legs? Are people going to use classic themes forever? What&#8217;s your thoughts?</p>\n\n\n\n<p>[00:13:52] <strong>Tammie Lister:</strong> So I think there&#8217;s a lot of points there, but I think there&#8217;s a couple points. Splitting out the infrastructure from the interface is kind of important. So are people using the underpinning technologies? Or are they only using the interface? And I think that&#8217;s something to consider.</p>\n\n\n\n<p>So the, page builder, the site editor is different from, using theme json maybe. So that&#8217;s also something to consider. So some agencies maybe aren&#8217;t turning on Site Editor, but they&#8217;re using theme json. That&#8217;s like a really basic example of that.</p>\n\n\n\n<p>I think that, is actually probably quite a strong case. Using the org theme repo as the measure. I&#8217;m not sure that necessarily holds up to adoption, all the time. Whilst I would love there to be so many things available for people and all that kind of thing, I don&#8217;t know whether people or times are different, I don&#8217;t know the answer to that. I think that, what I try and look at are agencies using it? Are people using it? Are people separating their plugin from their theme? Because that&#8217;s one impact. Are people looking at ways to improve their classic base to onboard off? Are they looking at ways to do it slowly and all those kind of things. And that has been happening more and more. So I think that.</p>\n\n\n\n<p>But honestly, it takes a change. Theme development has been the same for a very very long time. Yeah, I was lucky enough to be around when the changes happened. So it&#8217;s easy to change if you are around when the changes happen. It&#8217;s easy, right? Like I can understand that. I also, for me being a hybrid, it&#8217;s a little bit easier to adopt different things, because I can just be a bit more flexible, I think about different things.</p>\n\n\n\n<p>But if you are using a big stack, agencies as well go to, if you&#8217;re an enterprise agency and you&#8217;ve got a big stack, and you are pre-compiling SaaS, and you&#8217;re doing all these kind of things, to then suddenly change to theme json, that&#8217;s a big mind flip to suddenly do that.</p>\n\n\n\n<p>And that requires you to either pause, do lots of retraining, or to look at your foundation theme that you&#8217;re using, or to do some refactoring of infrastructure. So maybe to do some training. There&#8217;s all manner of different things that you&#8217;ve got to do, so I don&#8217;t think you&#8217;re going to do it in that kind of turnaround time.</p>\n\n\n\n<p>And also the time it happened was quite a boom time for agencies to be actually creating sites, which is kind of awesome. Lots of agencies were creating lots of sites at the same time. So for them to pause and say, hang on, not going to go and work on all these projects.</p>\n\n\n\n<p>What I actually saw was people thinking how they could sprinkle bits of it in, that has been really good. I think now most agencies that have found their path ,or found their groove with it,` or found the way that they are doing it. That&#8217;s kind of most pieces. But we haven&#8217;t necessarily seen that reflecting in the theme repo in the amount. So that would probably be a reflection of whether that number is going to be that measure or not.</p>\n\n\n\n<p>[00:16:43] <strong>Nathan Wrigley:</strong> So let me just try and sort of parse everything that you&#8217;ve just said, and see if what you&#8217;ve just said makes sense to me. So, what you are saying is that the adoption might not necessarily be reflected solely in the repo numbers. So whether it&#8217;s 2000, 1000, what have you. It&#8217;s the, and I think you called it underpinning technology, so the move to, for example, theme json and what have you. And you can dip your toes into bits of that.</p>\n\n\n\n<p>[00:17:07] <strong>Tammie Lister:</strong> Yeah, there was actually a really good post by Anne McCarthy right back in the day where she was like, here are the little pieces you can use, right back at the start And that was really powerful because I think before people were like, I have to do everything. No you don&#8217;t, is the answer. And once that message started to get out, there was a bit of a shift to people starting to be able to be, okay, I can do some sprinkles.</p>\n\n\n\n<p>[00:17:28] <strong>Nathan Wrigley:</strong> I think also the reality is, WordPress has been incredibly good at being backwards compatible, and really not changing a great deal for huge swathes of time. And then this fairly magnificently large change came along, and in other projects when they go through point releases, so Drupal is one that I&#8217;m familiar with, they sort of throw the baby out with the bath water a little bit. And as a result, I think over time they do lose people because of that, in their communities I mean, because of that backwards compatability thing has gone.</p>\n\n\n\n<p>And I&#8217;m just wondering if, like you said, if you&#8217;re an agency, and you&#8217;ve got a bulletproof process that you&#8217;ve worked out for the last decade or more, it would be unrealistic for you to suddenly change to the new paradigm, and to do everything with, for example, blocks or theme json. Rather than to just pick, well, either we&#8217;re going to do nothing, we&#8217;re going to stick with the way we&#8217;ve always done it, or we&#8217;re just going to take little bits here and there, because we can&#8217;t afford to just do everything. We&#8217;d have to retrain all of our staff, we&#8217;d have to retrain all of our clients and so on.</p>\n\n\n\n<p>So it sounds like you are buoyant. You don&#8217;t see the number in the repo as a negative thing, it&#8217;s just, this is the journey we&#8217;re on, but there&#8217;s way more, if you peel back the curtain, there&#8217;s more bits of in intel which need to be brought to bear. So that&#8217;s interesting, you are fairly sanguine about it.</p>\n\n\n\n<p>[00:18:40] <strong>Tammie Lister:</strong> Not everyone&#8217;s always going to have the interface on, or they may even use a different page builder. I think that&#8217;s something to kind of be aware. Maybe they are using the technology underneath, the infrastructure underneath, but they&#8217;re using a different page builder.</p>\n\n\n\n<p>Maybe they are using everything up to a point, but because their client doesn&#8217;t want it for the end user, they aren&#8217;t turning on the Site Editor interface for users. That is really common in enterprise, because they do not want color palettes and, all those kind of things, for end users. So those kind of like sliding scale.</p>\n\n\n\n<p>But also I think, from a release perspective and themes, I think we now need to be, and this is kind of a really curious conversation, is do we measure it by themes, or do we measure by patterns, or do we measure by templates? And if you look at the pattern directory, there have been quite a lot of, patterns, and there have been a lot of, the Museum of Block Art and the amount of patterns that have happened. Or if you look at Twenty Twenty Five, the amount of patterns in there. Now, that&#8217;s quite a lot. So if you think about that, that to me is almost like how we would consider themes to have been done.</p>\n\n\n\n<p>And we are getting to a point where, what is a theme? And that&#8217;s like a whole different discussion, which I love. Because for me, I&#8217;ve gone backwards and forwards in this every few years, of I think initially I was like, themes have to be a thing. And now I&#8217;m not in that position anymore. I wish I could time travel back and flick myself on the nose, but you know that&#8217;s age. Because I definitely feel that as</p>\n\n\n\n<p>long as we have a lot of the infrastructure, and we have a lot of the firm things in place, it&#8217;s a design system, and that&#8217;s what a theme should be. So what you are doing is you&#8217;re setting the tone and style as you load it. So this is the weird analogy I use, which is when you change clothes, you don&#8217;t take your arm off. Bear with me. The whole idea is that you should be able to take a theme on and off site without having any implications to it. That&#8217;s the whole point. It shouldn&#8217;t impact it. You should be able to use it like clothing. And it shouldn&#8217;t style it. So that gets to, is a theme just styles? And that&#8217;s the whole conversation of don&#8217;t put blocks in themes.</p>\n\n\n\n<p>Don&#8217;t just have it for super light. All those kind of like, that take the functionality out, don&#8217;t have plugins in it. All those kind of things that we go back to where we were a few years ago, which is don&#8217;t put plugins in themes as well. So yeah, there&#8217;s a lot there.</p>\n\n\n\n<p>[00:21:06] <strong>Nathan Wrigley:</strong> I remember probably three or four years ago, Rich Tabor, who at the time wasn&#8217;t working with Automattic but now is, raising the question of whether we should just have a theme, singular theme for WordPress. And everything else falls into the domain of patterns. And that was a really curious thought at the time. But the more that I&#8217;ve played with it, the more that I am fascinated by patterns, and not so much the theme. The theme is more of a sort of set it and forget it enterprise, you just do it this one time, set some basics in there.</p>\n\n\n\n<p>[00:21:36] <strong>Tammie Lister:</strong> See I guess now I&#8217;d be like, okay, what is the theme if it is the theme, and do we even need the theme? And is the package just, like I think we&#8217;ve come so far because WordPress has a design system. We&#8217;ve come so far that probably, like over the holidays because everyone does a project, right? Yet again, I did a theme and I literally used Site Editor&#8217;s Dreamweaver. That&#8217;s the best way I can describe how I create. I loaded it up and I haven&#8217;t used any custom CSS. I literally within a few hours had a theme. Hardly any customisation. No templates, anything, and that&#8217;s relying on mostly native stuff. I&#8217;m not relying on anything, and I move that across four different sites.</p>\n\n\n\n<p>It works. Am I going to release it and package it? No. I&#8217;m not going to give that to anyone else, because it&#8217;s not ready or worth it or like anything yet. And that may also be part of this. Maybe, going back to our initial conversation, maybe what we&#8217;re doing is encouraging more experimentation. That could be a problem if we&#8217;re not sharing our experiments. And that&#8217;s a whole different conversation about, we should share our experiments more, and we shouldn&#8217;t just leave them as experiments.</p>\n\n\n\n<p>But, to me what all of this has done is encouraged me to have that early. You know remember Kubrick? Being able to just experiment freely. And it probably was actually quite a hurdle we had to experiment. It was harder than, now looking back at it we&#8217;re like, that probably was really difficult. But I remember the first time, twice a year you would do the whole thing. Style switches were a big thing. I&#8217;ve now got a switcher on my site, just because I&#8217;m back there. What&#8217;s old is new again and all those kind of things.</p>\n\n\n\n<p>We could never settle on one style because we always wanted to do more than one. It was so easy to do. We were always obsessed with changing our themes because it was so cool to do. We were making them so many times. Maybe that&#8217;s part of, we&#8217;re in a period where everyone&#8217;s just experimenting and learning so much that we are not quite releasing yet. And that&#8217;s okay because we&#8217;re learning and we&#8217;re in our sketchbook, learning those boundaries.</p>\n\n\n\n<p>[00:23:36] <strong>Nathan Wrigley:</strong> Do you remember CSS Zen Garden?</p>\n\n\n\n<p>[00:23:38] <strong>Tammie Lister:</strong> Oh, I love that. Yeah, we should have that for block themes really.</p>\n\n\n\n<p>[00:23:42] <strong>Nathan Wrigley:</strong> It was fascinating, wasn&#8217;t it? How the content layer, and that was in the day when CSS was a brand new thing, and the idea that you could separate the markup from the styling was really revolutionary. And I remember being bowled over by that.</p>\n\n\n\n<p>[00:23:54] <strong>Tammie Lister:</strong> I mean the thing was with themes, that was why WordPress struck me originally was, I can just change, I don&#8217;t have to manage my content. I don&#8217;t have to worry about being insecure or being hacked. I don&#8217;t have to worry about that. I can just do the fun stuff. And then CSS got really cool, and then it got really complicated with SaaS. And then I started using JavaScript, I got really overly complicated. And then Modernizr, and all those kind of things. And life just got way too complicated.</p>\n\n\n\n<p>And one thing I like now is life is really, really easy when I want to make a theme. I&#8217;ll do a sketch, I don&#8217;t even do it in Figma anymore. I just do a little bit of a sketch, work out my colors, and then I just use it as Dreamweaver. But that&#8217;s not release ready that way. It would be taking it. You know I use Create Block Theme plugin and then I parse it, I clean it, and all those kind of things.</p>\n\n\n\n<p>[00:24:44] <strong>Nathan Wrigley:</strong> Just moving outside of the WordPress space for a moment, it seems like CSS is really interesting again. A lot of the JavaScript things that we&#8217;re familiar with only being possible with JavaScript, it feels like so much interesting stuff going on with just web standards and CSS in particular, and there&#8217;s a lot of fascinating stuff happening.</p>\n\n\n\n<p>[00:25:05] <strong>Tammie Lister:</strong> HSL is my current love. I&#8217;m completely nerdy. I&#8217;ve been, playing with that and just, I remember just the sheer pain of even doing parallax years ago, and all those kind of things that we don&#8217;t have those issues with.</p>\n\n\n\n<p>The fact now that we have such good libraries that we can have confidence in as well, that are open and universal as well for animations and different things that you can do.</p>\n\n\n\n<p>I think sometimes it does raise the expectation, if I put my front end developer hat on, it does raise the expectation, makes front end developers life really difficult, because we were always told don&#8217;t use libraries in one part, right, from performance perspective. And now it&#8217;s about knowing the right ones to use, in the right combination. Because you can achieve some of this stuff without using some of those libraries, and some of them are React as well. So it is like the, kind of where you use or what, you don&#8217;t use.</p>\n\n\n\n<p>[00:25:59] <strong>Nathan Wrigley:</strong> Just getting back to the conversation about the adoption, or lack thereof, of Full Site Editing and what have you, and theme json and all of that. We&#8217;ll obviously mention the fact that what you said 10 minutes ago is true. You know, the underpinning technology may well be being used by people.</p>\n\n\n\n<p>I do wonder though if the Block Editor or the Site Editor interface, do you think there&#8217;s something to be said about that whole interface and the fact that it&#8217;s constantly in flux? And it is quite difficult to realise where things are happening. And the fact that you&#8217;ve got menus that you have to return to. You know, you might not be able to find your way there quickly because the sort of whole menu structure disappears, and you have to click buttons to get back to it, and then remember where they all are, and they get upended all the time.</p>\n\n\n\n<p>I&#8217;m just wondering if the UI, where we are at the moment, January 2025, I do wonder if that puts people off because it&#8217;s in such a state of flux and it&#8217;s confusing and it&#8217;s not quite finessed yet.</p>\n\n\n\n<p>[00:26:55] <strong>Tammie Lister:</strong> So I have my kind of predictions I guess, of like where I would like see over the next kind of few years. I think we&#8217;re going to see that interface is going to do what it&#8217;s going to do. It&#8217;s core and it&#8217;s going to be iterated, but I think you&#8217;re going to see a lot of solutions building on top of that, or adapting to it. And I see more variations. You know I&#8217;d love to be able to say, hey, now I&#8217;m in sketch mode. Just let me do my sketching, right. And be able to see it. In fact, I&#8217;ve been playing around with that, with my rubber ducky cursor and all those kind of things, and trying to work out that, and I don&#8217;t think I&#8217;m alone with that. Like trying to figure out how do you get the editor interface to be exactly what you want. But that&#8217;s exactly what I want. That doesn&#8217;t mean that I&#8217;m necessarily going to have that as a final product.</p>\n\n\n\n<p>But I think that there&#8217;s an argument for types of users, and there&#8217;s definitely an argument for page builders for types. There&#8217;s definitely an argument for, niche, niches, could be a really big one. Or page builders that build on top of it. And we&#8217;ve seen quite a lot of that, like filling in the gaps. Core is always going to do the middle. Core is always going to be trying to, it&#8217;s always going to be the first attempt.</p>\n\n\n\n<p>So a good example is fluid typography, that&#8217;s just come out. So that&#8217;s the first version of it, right? Like the first version of where the things are going to be. The things I worked on in phase one, if they still look like the way they did in phase one in the Block Editor, we would have a problem. They do not look like that now. Because time has moved on. And the Site Editor, a lot of the bigger interface things came last. Because if you bear in mind when you build a house, you build the foundations first. So a lot of the interface stuff came last. So a lot of that stuff still needs to be iterated on.</p>\n\n\n\n<p>So, yes, it does need to be iterated on, point 1. But that doesn&#8217;t make it easy for what you were saying about documentation, for people learning and people doing things. So I do think there&#8217;s an argument for people having page builders. Page builders responding with a native layer. I don&#8217;t think there&#8217;s ever been an argument that people shouldn&#8217;t have page builders, or at least I personally haven&#8217;t said that. If you&#8217;re going to build a page builder on top of native, great. Find where the gaps are in the area you are pitching for, and make it work, and then keep a connection to it, and that&#8217;s going to work great. You know rise up. As Core rises up, rise up with your product. That&#8217;s kind of the open source way, right?</p>\n\n\n\n<p>So I&#8217;m kind of curious to see what happens. I would love to see the ability to customise a little bit more if I had, ifs and buts and wishes. But I just think that that&#8217;s maybe an expectation of interfaces that we have now. We got it with light and dark mode, and we seem to really have that now with like everything should be draggable. There&#8217;s a difference, right? AI has happened in a year, but also draggable interface have happened in six months. Suddenly most interfaces have draggy handles everywhere, and you can reposition things and pin them. Like we&#8217;ve only got one pinnable sidebar. So I think that would be nice. Because at the moment it kind of just says, I&#8217;m here, and you have to live with it being here. So things like that.</p>\n\n\n\n<p>My biggest thing has been able to just the latest situations of get out mode is the best way I can describe it is widescreen, right? I call it get out mode, because it just gets out of here. But that, things like that are polished. It&#8217;s done upon those extra bits. And they&#8217;re not bits that were there initially, and we often judge bits and we think the good bits we think have been there all along, well they haven&#8217;t been.</p>\n\n\n\n<p>[00:30:11] <strong>Nathan Wrigley:</strong> That UI is so great if you&#8217;ve got a long piece of content, and you can&#8217;t really encapsulate in your mind what the top to bottom of it looks like.</p>\n\n\n\n<p>[00:30:19] <strong>Tammie Lister:</strong> Remember like when, you used to have patterns out, then you&#8217;d lose sight of where the pattern was going to go, or like how it was going to look. Just the fact that it just goes a little bit small. It&#8217;s like yeah, yeah, yeah. There&#8217;s some perspective to what I&#8217;m creating, and it feels like okay, we&#8217;re not in like the inception world where I&#8217;m touchy feeling things and moving them around or whatever. We&#8217;re not in that. But we are kind of feeling like I&#8217;m building.</p>\n\n\n\n<p>And for me personally, the editor has a couple of different functions, and maybe one of the answers is it should, back when I was working on it, there was this kind of concept of modes, and it kind of didn&#8217;t have distinct modes, it flowed. I go backwards and forwards on whether it should have distinct or flow. I think by its nature it is having distinct modes. And one of the modes I find myself in a lot is build mode. If I&#8217;m in site editor, I&#8217;m a Bob the Builder. That&#8217;s what I&#8217;m doing. I&#8217;m getting in there. I&#8217;m Dreamweavering it. I&#8217;m digging in, and I want a very different experience to that than I want to,. Like Figma is my, or Penpot is where I&#8217;m building. And when I&#8217;m composing, I&#8217;m in a very different experience to that. I wouldn&#8217;t write in Figma.</p>\n\n\n\n<p>[00:31:24] <strong>Nathan Wrigley:</strong> I do like the idea, and I think you alluded to it earlier, I do like the idea of different, for want of a better word, editor modes. Where the UI is really different for a different user. And obviously we have the capability to kind of, historically WordPress, I don&#8217;t know, at the very least, remove a menu item for example, or a button doesn&#8217;t exist if you&#8217;re particular person. But the idea of amending the entire UI so that it binds itself more to the work that you are doing, that&#8217;s really interesting.</p>\n\n\n\n<p>[00:31:53] <strong>Tammie Lister:</strong> With AI we&#8217;ve got a bit more possibility of looking at what task you&#8217;re doing and then adapt. So one of the things that really excites me about AI isn&#8217;t necessarily the content generation, but is the realizing what you&#8217;re doing. At the moment, we have the set options and get things out of your way. But what I like is when applications are learning my behaviors, or learning what I like. Maybe I&#8217;m just selfish. I like that, and I like the fact that they&#8217;re learning, rather than me having to, when it loads up, me having to put the sidebar out the way, every single time. It&#8217;ll be like, oh no, you actually really like this to be out the way, and this is where you go. So when I load it up, it just does that each time.</p>\n\n\n\n<p>It&#8217;s such a small thing, but I mean it&#8217;s a persistent save mode of the screen and all those kind of things. But it feels magic when it works properly. Or recommending, it&#8217;s like hey, you like this? Have you tried this? Because you are obviously a builder. We&#8217;ve heard that other builders like this.</p>\n\n\n\n<p>[00:32:47] <strong>Nathan Wrigley:</strong> I imagine all of these things could come to pass. I know that there&#8217;s a lot of work to be done before those things. Just before we round it off, something that you said you wanted to mention, which we haven&#8217;t done, is something called hybrid themes.</p>\n\n\n\n<p>Now, I&#8217;ve not really touched on this with anybody thus far in any of the podcast episodes I&#8217;ve done. And it occurs to me that I would imagine most of the audience won&#8217;t be familiar with that term.</p>\n\n\n\n<p>[00:33:07] <strong>Tammie Lister:</strong> So I don&#8217;t actually like the term, that&#8217;s why we were talking about it. So it&#8217;s a term that currently is used for a theme that sits between Classic and Block Themes. And for me personally, and you can get into why it does, I don&#8217;t think we should use the term, that&#8217;s kind of why I wouldn&#8217;t get into them too much. And I know that there&#8217;s some really good documentation explaining them, and I don&#8217;t want to belittle or anything with that documentation. I think they have a place. But my kind of general point is I think they really confuse users.</p>\n\n\n\n<p>If I am working with a client and I am saying to them, hey, we&#8217;re working on a theme. It&#8217;s hard enough to get them to work with a Block Theme, or I don&#8217;t even actually use the term Classic, although I actually have a site that says Classic, but generally they&#8217;re not thinking Classic. They&#8217;re thinking that it is their theme. And it&#8217;s a classic, what it&#8217;s old?</p>\n\n\n\n<p>But generally to then say hybrid as well. I mean in cars it&#8217;s not so good at either. I made that joke of like, I&#8217;m a hybrid. I&#8217;m not good at either, kind of thing. It&#8217;s like the theme isn&#8217;t good at either. And really to me a Block Theme can just be, I go back to that post by Anne, you can just do a little bit, you could just have a little bit and it&#8217;s a Block Theme. But I think sometimes it&#8217;s used to distinguish when, and more templating all of those kind of things with hybrid. But there&#8217;s a lot more to it than terms like that. So I don&#8217;t want to dismiss it. But for me it&#8217;s a lot simpler if we think of it in those kind of opposites.</p>\n\n\n\n<p>I&#8217;m weird about Classic. So themes and block themes maybe? That&#8217;s maybe a kind of, I mean honestly it&#8217;s themes, and it just depends on how you are doing the theme really. And that&#8217;s what it comes down to. And I think if we saw it that way, then probably people would be like, okay, I&#8217;m going to make a theme that suits this purpose. And then they&#8217;d be popping on it. Because there was a time when people were taking offense to it being called Classic Themes, and that&#8217;s not maybe what we should be doing if we wanting people to use it.</p>\n\n\n\n<p>[00:35:05] <strong>Nathan Wrigley:</strong> I think it sounds from everything that you&#8217;ve said that you&#8217;re fairly bullish about the future with WordPress themes, and the theming engine that we&#8217;ve got, and the opportunities in the future.</p>\n\n\n\n<p>[00:35:14] <strong>Tammie Lister:</strong> Not just themes. I think that WordPress is always going to need a front visual, right? And you are going to be packaging, one of the core principles we have is you can package that style up, and I can give you that style, and you can go and take that and put it on any site. What that package, that theme is going to be in the future, I don&#8217;t know. That might be just a json file. That might be a file of an emoji smile. I don&#8217;t know. That might just be literally a json file. That could be all it is, is one file going forward. And that might be amazing, and it will pull in all these patterns, and it&#8217;ll pull in everything.</p>\n\n\n\n<p>But that still will be a theme, and that still will have had someone creative come along and determine that all these patterns and these colour combinations go. And they will work with an AI to come up with colour combination suggestion, all those kind of things. So you&#8217;re still going to have that. But it&#8217;s the idea that you can still take it from one site to the other, and still have that styling. I think that&#8217;s still there. I just think we&#8217;ve got to maybe be a bit more adaptive about what that term means, and maybe just all call it themes.</p>\n\n\n\n<p>[00:36:22] <strong>Nathan Wrigley:</strong> I imagine there&#8217;s going to be a bunch of people listening to this who are going to stick to what we&#8217;re going to call Classic Themes until they simply are no longer an option. There&#8217;ll be other people who are somewhere along the journey, and they&#8217;re dipping into, well, for want of a better word, hybrid. Or there&#8217;s people who are doing the whole thing with the Site Editor.</p>\n\n\n\n<p>Regardless of that, if people wanted to find you and talk to you about your journey and any help that you may be able to give them, making that migration, where&#8217;s the best place to get in touch with you, Tammie?</p>\n\n\n\n<p>[00:36:53] <strong>Tammie Lister:</strong> Yeah, So you can find me at my site, tammielister.com. And you can also find me on all the socials at Karmatosed. I also have a theme site called &#8216;Classic To Block&#8217;.</p>\n\n\n\n<p>[00:37:05] <strong>Nathan Wrigley:</strong> I will put all of those into the show notes so everybody can find all of the different places where you are available. But, Tammie Lister, thank you so much for chatting to me today. I really appreciate it.</p>\n\n\n\n<p>[00:37:15] <strong>Tammie Lister:</strong> Thank you.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://tammielister.com/\">Tammie Lister</a>.</p>\n\n\n\n<p>Tammie is a product creator focusing on WordPress. She has a hybrid background as a full stack product creator. She contributes to WordPress and is passionate about Open Source and the WordPress community.</p>\n\n\n\n<p>Tammie has a rich history with WordPress, having worked with themes and the platform for many years.&nbsp; Her journey melds her artistic flair with technical expertise, something which is, I think, quite rare. Her experience spans theme building, design, development, and more recently, guiding product developers through Guildenberg, an initiative which she co-founded.</p>\n\n\n\n<p>The fact that Tammie is both a designer and a technical expert has allowed her to offer a well-rounded perspective on the evolution and future of WordPress themes. We explore the shift from classic themes to the new era of Full Site Editing and theme.json, and discuss whether the slower-than-anticipated adoption of these new tools signifies a deeper trend, or just a transitional phase.</p>\n\n\n\n<p>Additionally, Tammie shares her insights on the necessity of beauty versus utility on the internet, the importance of experimentation in design, and how our definition of art and themes needs continual rethinking.</p>\n\n\n\n<p>We also get into her personal artistic endeavors, where she balances her tech workspace with an art studio, highlighting her lifelong passion for photography.</p>\n\n\n\n<p>If you&#8217;re curious about the current state of WordPress theming, the impact of emerging technologies on the platform, or how to infuse more creativity into your web projects, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://tammielister.com/\">Tammie&#8217;s website</a></p>\n\n\n\n<p><a href=\"https://guildenberg.com/\">Guildenberg</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/patterns/\">Pattern Directory</a></p>\n\n\n\n<p><a href=\"https://block-museum.com/\">Museum of Block Art</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/create-block-theme/\">Create Block Theme plugin</a></p>\n\n\n\n<p><a href=\"https://www.figma.com/\">Figma</a></p>\n\n\n\n<p><a href=\"https://penpot.app/\">Penpot</a></p>\n\n\n\n<p><a href=\"https://classictoblock.com/\">Classic to Block website</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jan 2025 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"Do The Woo Community: Building WooCommerce in Public: A Conversation with James Kemp and Darren Ethier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=89275\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://dothewoo.io/building-woocommerce-in-public/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:242:\"In this Inside Woo, James Kemp and Darren Ethier from WooCommerce highlight the importance of community engagement, evolving development practices, and the initiative \"More in Core\" to enhance core functionalities while balancing flexibility.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jan 2025 14:15:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Akismet: How to Collect Emails from Website Visitors (for Email Marketing)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=284285\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://akismet.com/blog/how-to-collect-emails/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:26547:\"<p>When it comes to digital marketing, social media platforms seem to get all the love. But while it might not be as flashy, email marketing remains one of the most powerful tools for your business when it needs to communicate directly with its&nbsp;audience.</p>\n\n\n<p>Before you can use this powerful marketing medium, however, you need an audience. This is where a list of email subscribers comes in. These lists are made up of people who’ve given you permission to message them. It’s a vote of confidence in your brand and an invaluable opportunity for you to develop a new customer relationship.&nbsp;</p>\n\n\n<p>So how do you convince someone to give you their (correct) email address? There are a number of viable&nbsp;strategies.</p>\n\n<p>Let’s look at everything you need to know about how to collect emails for email&nbsp;marketing.</p>\n\n\n<span id=\"more-284285\"></span>\n\n\n\n<img width=\"1600\" height=\"1066\" src=\"https://akismet.com/wp-content/uploads/2025/01/image.jpeg\" alt=\"phone with an email newsletter signup form\" class=\"wp-image-284287\" />\n\n\n<h2 id=\"why-collect emails\" class=\"wp-block-heading\">Why collect&nbsp;emails?</h2>\n\n\n<p>Before we get into how to capture email addresses from website visitors, it&#8217;s important to consider why you want to gain new subscribers in the first place.&nbsp;</p>\n\n\n<h3 id=\"to-establish-a-direct-line-of-communication-with-potential customers\" class=\"wp-block-heading\">To establish a direct line of communication with potential&nbsp;customers</h3>\n\n<p>Email marketing creates a direct link between you and your audience. When someone subscribes, you can ensure your message reaches them without interference from algorithms or third&#8209;party&nbsp;platforms.</p>\n\n<p>Whether you want to announce a new product, share some testimonials of others who’ve enjoyed your product or service, or promote a flash sale, emails are a personal and effective way to communicate with potential&nbsp;customers.</p>\n\n<h3 id=\"to-keep-your-audience-informed-and engaged\" class=\"wp-block-heading\">To keep your audience informed and&nbsp;engaged</h3>\n\n<p>Marketing to a strong email list helps you keep your audience in the loop about your latest updates, promotions, and news. Regular newsletters and targeted emails keep your brand top&#8209;of&#8209;mind, ensuring your subscribers remain engaged and interested in what you have to&nbsp;offer.</p>\n\n<p>Staying connected to potential subscribers by periodically offering valuable insights is a great way to keep your funnel filled with quality&nbsp;leads.</p>\n\n<h3 id=\"to-send-personalized offers\" class=\"wp-block-heading\">To send personalized&nbsp;offers</h3>\n\n\n<p>Marketing is most effective when the message relates, very specifically, to the recipient. This is known as personalization and email marketing is perfect for it. The most simple version of personalization is using a recipient’s first name in the subject line or email. A bit of a more advanced tactic is segmenting email messages to different lists based on broad criteria like age or gender.&nbsp;</p>\n\n\n\n<p>Even better, though, is sending emails addressed to a subscriber’s first name that contains an offer for a specific product or category that the subscriber expressed interest in. Most WooCommerce <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/marketing-extensions/email-marketing-extensions/?categoryIds=1763&collections=product&page=1\">email marketing extensions</a> have this or a similar capability.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"857\" src=\"https://akismet.com/wp-content/uploads/2025/01/image.png\" alt=\"WooCommerce extension library with a grid of email extensions\" class=\"wp-image-284288\" />\n\n\n<h3 id=\"to-yield-a-high-return-on investment\" class=\"wp-block-heading\">To yield a high return on&nbsp;investment</h3>\n\n\n<p>Because it costs relatively little to produce, and it reaches interested subscribers directly, the ROI of email marketing tends to be quite high. Some report it as high as <a href=\"https://www.litmus.com/blog/infographic-the-roi-of-email-marketing\">36:1</a>.&nbsp;</p>\n\n\n\n<p>This might not take into account the expense of attracting first-time subscribers or the time it will take a small business owner to learn the technical processes if they need to do it themselves.&nbsp;</p>\n\n\n\n<p>However, it’s still clear that reaching interested consumers through email is well worth the effort and one of the most essential parts of the digital marketing mix for any size business. You just need to get subscribers and start your first campaign.&nbsp;</p>\n\n\n<h2 id=\"what-to-know-from-a-legal-and-ethical standpoint\" class=\"wp-block-heading\">What to know from a legal and ethical&nbsp;standpoint</h2>\n\n<p>When learning how to collect email addresses, you need to consider a few ethical and legal&nbsp;conundrums.</p>\n\n<h3 id=\"the-importance-of-user-consent-and transparency\" class=\"wp-block-heading\">The importance of user consent and&nbsp;transparency</h3>\n\n\n<p>You have to be honest with your target audience when collecting email addresses. Tell your target audience what you are doing and present them with opt-in forms so they can provide informed consent.&nbsp;</p>\n\n\n\n<p>Avoid deceptive practices, such as pre-checking boxes or using vague language on email sign-up forms. These tactics can harm your credibility and even cause inbox providers to send your messages to spam —&nbsp;even for legitimate subscribers. Potential customers should be able to easily subscribe (and unsubscribe) from your email campaigns.</p>\n\n\n\n<p>In general, just because you <em>have </em>an email address does not mean you should send it promotional messages. A person should give explicit consent and <em>subscribe </em>to your list.&nbsp;</p>\n\n\n<h3 class=\"wp-block-heading\">Compliance with GDPR and the CAN&#8209;SPAM&nbsp;Act</h3>\n\n\n<p>The <a href=\"https://gdpr-info.eu/\">General Data Protection Regulation</a> is a sweeping consumer privacy law in the European Union. It protects the data privacy rights of all EU citizens and can directly impact the way you gather email addresses.&nbsp;</p>\n\n\n<p>If your company does business in the EU or targets EU consumers, familiarize yourself with the GDPR and adhere to its&nbsp;provisions.</p>\n\n<p>If you do business in the U.S., you’ll need to be aware of the <a href=\"https://www.fcc.gov/general/can-spam#:~:text=Congress%20passed%20the%20CAN%2DSPAM,phones%E2%80%94not%20email%20in%20general.\">CAN&#8209;SPAM Act</a>. Passed in 2003, the law protects consumers and businesses from unwanted electronic email messages. Failing to adhere to either law can lead to fines and other severe&nbsp;penalties.</p>\n\n<h3 id=\"privacy-policy-and-terms-of service\" class=\"wp-block-heading\">Privacy policy and terms of&nbsp;service</h3>\n\n<p>Ensure your website includes a clear privacy policy and terms of service that outline how you collect, use, and protect personal information. Add details about how you collect email addresses and what you use them&nbsp;for.</p>\n\n<p>Collecting email addresses is perfectly legal and ethically acceptable, provided you’re transparent about it and do your best to protect consumer information. In most cases, you can send transactional messages (order confirmations, password reset emails, etc.) without express permission, but promotional messages should only be sent with&nbsp;consent.</p>\n\n<h2 id=\"what-is-needed-to-collect-emails-from-website visitors\" class=\"wp-block-heading\">What is needed to collect emails from website&nbsp;visitors?</h2>\n\n<p>You&#8217;ll need the following to collect email&nbsp;addresses:</p>\n\n<h3 id=\"1-a-website-or-landing page\" class=\"wp-block-heading\">1. A website or landing&nbsp;page</h3>\n\n\n<p>Landing pages are web pages you create for a specific campaign or purpose. Users typically end up on a landing page after they click on an ad or other online CTA.&nbsp;</p>\n\n\n<p>You should build a landing page for every specific campaign designed to collect email addresses. This allows you to hyper&#8209;focus the language, visuals, and CTA most impactful to your target audience. As a result, you can expect a much greater rate of success in attracting new&nbsp;subscribers.</p>\n\n\n<p>This doesn’t mean you can&#8217;t also include a lead capture button or sign-up form on other areas of your website. You can, and should, put these in places people expect — in the footer, halfway through a blog post, in the sidebar, etc.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"818\" src=\"https://akismet.com/wp-content/uploads/2025/01/image-1.png\" alt=\"Email signup form in the footer of the Magna-Tiles site\" class=\"wp-image-284289\" /><em>Email signup form in the footer of <a href=\"https://www.magnatiles.com/\" rel=\"nofollow\">https://www.magnatiles.com/</a></em>\n\n\n<h3 id=\"2-a-compelling-offer-or-lead magnet\" class=\"wp-block-heading\">2. A compelling offer or lead&nbsp;magnet</h3>\n\n<p>Most people won&#8217;t give up their contact info just because you asked them to. It doesn&#8217;t matter how great your landing pages are, they probably aren&#8217;t going to opt&#8209;in unless you give them something of value in exchange for their&nbsp;email.</p>\n\n\n<p>A lead magnet is a great way to incentivize visitors to sign up for your email list. Showcase your lead magnet on your landing page and let people know that they can access the resource for free in exchange for their email subscription. Common lead magnets include eBooks, webinars, and discount codes.&nbsp;</p>\n\n\n\n<p>Though often not as strong, for the right entities, a lead magnet could be the promise of something in the future —&nbsp;early access to a Black Friday sale or exclusive content released on a regular basis.&nbsp;</p>\n\n\n<p>And no matter what you offer, once a customer completes the sign&#8209;up form, send the lead magnet or some sort of follow up to their email address right&nbsp;away.</p>\n\n<h3 id=\"3-a-form-to-capture emails\" class=\"wp-block-heading\">3. A form to capture&nbsp;emails</h3>\n\n<p>Your website or landing page should include a simple sign&#8209;up form where folks can input their email address. Make sure the form is easy to fill out without too much hassle. Don&#8217;t play <em>twenty questions</em>. Ask the basics so you can avoid annoying your&nbsp;visitors.</p>\n\n<p>We suggest limiting your sign&#8209;up form to three or four fields, which can include the person&#8217;s first and last name, email address, and an opt&#8209;in checkbox. Don&#8217;t push your luck by asking for the person&#8217;s birthday, phone number, or other information unless absolutely&nbsp;necessary.</p>\n\n\n<img width=\"1600\" height=\"708\" src=\"https://akismet.com/wp-content/uploads/2025/01/image-2.png\" alt=\"Jetpack CRM page with information about the features\" class=\"wp-image-284290\" />\n\n\n<h3 id=\"4-an-email-marketing-tool-or crm\" class=\"wp-block-heading\">4. An email marketing tool or&nbsp;CRM</h3>\n\n<p>You&#8217;ll need a <a href=\"https://jetpackcrm.com/\" target=\"_blank\" rel=\"noreferrer noopener\">customer relationship management (CRM)</a> system or email marketing tool to put all of those email addresses to use. Explore several options and find the platform that best supports your email marketing&nbsp;efforts.</p>\n\n<h3 id=\"5-a-source-of-targeted traffic\" class=\"wp-block-heading\">5. A source of targeted&nbsp;traffic</h3>\n\n\n<p>Most importantly, you need a source of traffic. If you already have a strong flow of site visitors, then sure, you can add a sign-up form to a conspicuous location on your site.&nbsp;</p>\n\n\n\n<p>But it’s not likely to generate a ton of new subscribers unless you have a good lead magnet to accompany it or a particularly eager audience.&nbsp;</p>\n\n\n<h2 id=\"effective-strategies-to-collect emails\" class=\"wp-block-heading\">Effective strategies to collect&nbsp;emails</h2>\n\n<p>After you&#8217;ve put the right infrastructure in place, you’re ready to start collecting new email subscribers. Here are some strategies to jumpstart your&nbsp;efforts:</p>\n\n<h3 id=\"leverage-gamification-such-as-quizzes-and surveys\" class=\"wp-block-heading\">Leverage gamification such as quizzes and&nbsp;surveys</h3>\n\n<p>Great marketing should never be boring. The best marketing campaigns and email capture strategies are fun and&nbsp;engaging.</p>\n\n<p>Consider using interactive quizzes or surveys to gamify email collection. People may be more likely to share their contact information if you have quiz results or a prize dangling on the other&nbsp;side.</p>\n\n\n<p>For instance, you could ask someone to complete a quick 3-5 question survey and offer an exclusive discount code after they submit their results. When they’re finished, thank them for participating and ask for their email address so you can send them their code. At that point, offer the opportunity to also subscribe to your email list —&nbsp;many will!&nbsp;</p>\n\n\n<h3 class=\"wp-block-heading\">Implement a timed slide&#8209;in or&nbsp;pop&#8209;up</h3>\n\n\n<p>A timed pop-up triggers when a site visitor has spent a certain amount of time on your page. They’re a can’t-miss — so use the opportunity to promote your best lead magnet.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"810\" src=\"https://akismet.com/wp-content/uploads/2025/01/image-3.png\" alt=\"email pop-up on the Dan-O\'s website\" class=\"wp-image-284291\" /><em>Example of an email pop-up on </em><a href=\"https://danosseasoning.com/\"><em>https://danosseasoning.com/</em></a><em>&nbsp;</em>\n\n\n<p>Slide&#8209;ins are another option. They perform the same task, but slide onto the visitor’s screen instead of popping up out of nowhere. They tend to take up less space and are often more mobile responsive than&nbsp;pop&#8209;ups.</p>\n\n<p>You may also want to consider a pop&#8209;up that triggers when someone exhibits exit intent. When a visitor seems like they’re about to leave by clicking the &#8220;Back&#8221; button in their browser or closing the tab altogether, they’re met with a timely&nbsp;message.</p>\n\n<h3 id=\"run-contests-or-giveaways-that-require-email entry\" class=\"wp-block-heading\">Run contests or giveaways that require email&nbsp;entry</h3>\n\n\n<p>People love the chance to win a free prize. Create a truly valuable offer (bonus points if you can tie the prize back to your business in some way) and sensational graphics that demand attention.&nbsp;</p>\n\n\n\n<p>This is what you might advertise in your pop-up or slide-in, but you can also promote the giveaway on social media and <a href=\"https://woocommerce.com/posts/influencer-marketing-how-to-build-trust-with-new-audiences/\">partner with influencers</a> to get the contest in front of a highly-targeted audience.&nbsp;</p>\n\n\n<p>Social media platforms are some of the best mediums for these kinds of promotions. Just be sure to send traffic to your site and collect entries through a simple form. When registering for the giveaway, ask people to subscribe to receive special updates and deals through&nbsp;email.</p>\n\n<h3 id=\"collect-email-addresses-through-webinars-and-event registrations\" class=\"wp-block-heading\">Collect email addresses through webinars and event&nbsp;registrations</h3>\n\n<p>Networking events are a great opportunity to gather email addresses. You can host digital meetings or webinars and require users to provide their email during the registration process. This approach is great if you operate in the business&#8209;to&#8209;business space or have an audience of&nbsp;professionals.</p>\n\n<p>Make sure to record the webinar. You can recycle this lead magnet again and again to keep capturing emails with little extra&nbsp;work.</p>\n\n<h3 id=\"capture-emails-through-live-chat sessions\" class=\"wp-block-heading\">Capture emails through live chat&nbsp;sessions</h3>\n\n\n<p>If you have live chat on your site, encourage visitors to provide their email address for customer service follow-up and ask if they’re interested in receiving special offers after the chat ends. Make sure your chatbot is programmed to ask this automatically.&nbsp;</p>\n\n\n<h2 id=\"tips-to-make-the-most-of-your-email-collection efforts\" class=\"wp-block-heading\">Tips to make the most of your email collection&nbsp;efforts</h2>\n\n\n<p>Once you know <em>how </em>you want to collect the emails — through a contest, hosting a webinar, or something else —&nbsp;you can work to optimize your efforts for the best results.</p>\n\n\n<h3 id=\"1-build-a-clear-value proposition\" class=\"wp-block-heading\">1. Build a clear value&nbsp;proposition</h3>\n\n<p>Ask yourself, &#8220;Would I give out my email address after visiting this landing page?&#8221; If you can&#8217;t confidently answer that question with a yes, it&#8217;s time to rethink your value&nbsp;proposition.</p>\n\n\n<p>What are the pain points most common for your audience? Why do they typically buy from you? While you don’t want to offer your solution or product completely for free, you can offer something adjacent. Or help them take the first steps for free.&nbsp;</p>\n\n\n<p>If you run an ecommerce business, a product giveaway or style guide might be more&nbsp;appropriate.</p>\n\n<h3 id=\"2-create-a-sense-of-scarcity-or urgency\" class=\"wp-block-heading\">2. Create a sense of scarcity or&nbsp;urgency</h3>\n\n<p>Nothing gets people to act fast like the fear of missing out. If you want people to sign up for your mailing list when they visit your site, create a sense of urgency with a strong call to&nbsp;action.</p>\n\n<p>Use phrases like &#8220;Join Now&#8221; or put a ticking clock next to your sign&#8209;up button that lets them know they’ll get a coupon if they complete the form in the next 15 minutes. Convey that your free gift is only “while supplies last,” or that the deadline to enter your contest is&nbsp;near.</p>\n\n<h3 id=\"3-display-social-proof-and-trust badges\" class=\"wp-block-heading\">3. Display social proof and trust&nbsp;badges</h3>\n\n<p>Build trust by showing that others have already signed up. Include testimonials, subscriber counts, or trust badges from reputable companies to reassure potential&nbsp;subscribers.</p>\n\n<p>Make sure they know you’ll never sell their information to a third party or send them an overwhelming number of messages. You could even promise a specific volume — “Only two emails a&nbsp;month!”</p>\n\n<h3 id=\"4-avoid-using captcha\" class=\"wp-block-heading\">4. Avoid using&nbsp;CAPTCHA</h3>\n\n<p>You should avoid including a CAPTCHA on your lead capture form at almost all costs. CAPTCHAs drive visitors wild. Only 71% of users even <a href=\"https://web.stanford.edu/~jurafsky/burszstein_2010_captcha.pdf\" target=\"_blank\" rel=\"noreferrer noopener\">try to solve a CAPTCHA</a>. The rest just bounce as soon as they see that annoying&nbsp;box.</p>\n\n<p>Yes, spam <em>is </em>a real problem. It can lead to security issues and definitely clog up your email and submission lists with useless entries. The good news is that there are better options for blocking spam, such as&nbsp;Akismet.</p>\n\n\n<img width=\"1600\" height=\"774\" src=\"https://akismet.com/wp-content/uploads/2025/01/image-4.png\" alt=\"Akismet homepage with the text \" />\n\n\n\n<p><a href=\"https://akismet.com/\">Akismet</a> is an anti-spam solution that works completely in the background. And it’s just as effective —&nbsp;if not more so — than CAPTCHA. In fact, it works with 99.99% accuracy! To date, the tool has removed over 500 billion pieces of spam. That&#8217;s not a typo — it&#8217;s billions with a &#8220;b.&#8221;&nbsp;</p>\n\n\n\n<p>Without yet another annoyance standing in their way, people will be much more likely to complete the form. So you get better conversion rates without the spam. That’s a big win.&nbsp;</p>\n\n\n<h3 id=\"5-use-a-heatmap-to-optimize-form placement\" class=\"wp-block-heading\">5. Use a heatmap to optimize form&nbsp;placement</h3>\n\n<p>A heatmap analyzes how visitors interact with your website. It visualizes the hottest spots on your site so you know where to place sign&#8209;up buttons and calls to action. Use these insights to place your email capture form in a high&#8209;visibility area where visitors are most likely to&nbsp;engage.</p>\n\n<h3 id=\"6-enhance-your-email-capture-campaign-with-video content\" class=\"wp-block-heading\">6. Enhance your email capture campaign with video&nbsp;content</h3>\n\n<p>Video can stop a visitor&#8217;s scrolling in its tracks. Consider embedding a short video on your webpage next to your sign&#8209;up form to draw attention and give visitors a chance to scan that section of your&nbsp;site.</p>\n\n\n<p>Videos can also work well on landing pages —&nbsp;feature your lead magnet to really convey the value in a way only video can. You can also include video testimonials or anything else related to the email capture campaign. The point is:&nbsp;an investment in video content for any part of the campaign is probably worth it. Just be sure to A/B test to see what kind of impact, positive or negative, it actually has. Speaking of A/B testing…&nbsp;</p>\n\n\n<h3 id=\"7-ab-test-on-a-regular basis\" class=\"wp-block-heading\">7. A/B test on a regular&nbsp;basis</h3>\n\n<p>A/B testing involves comparing two different landing pages to see which one resonates with your target audience. During each test, publish two nearly identical landing pages. Change only one detail, such as the form placement, CTA, or&nbsp;headline.</p>\n\n<p>See which option visitors respond better to, and then move on to the next round of testing. You can do this as much as your resources allow and your performance should get better after each&nbsp;time.</p>\n\n<h3 id=\"8-create-a-compelling-thank-you page\" class=\"wp-block-heading\">8. Create a compelling thank you&nbsp;page</h3>\n\n<p>After a user subscribes, redirect them to a thank you page that reinforces their decision and provides additional value. Tell them what to expect or what to do&nbsp;next.</p>\n\n<h2 id=\"frequently-asked questions\" class=\"wp-block-heading\">Frequently asked&nbsp;questions</h2>\n\n<h3 id=\"what-is-email marketing\" class=\"wp-block-heading\">What is email&nbsp;marketing?</h3>\n\n<p><a href=\"https://woocommerce.com/posts/ecommerce-email-marketing/\">Email marketing</a> involves connecting with prospective customers via email. You can promote your products, share exciting news, or re&#8209;engage subscribers who haven’t purchased anything from you in a&nbsp;while.</p>\n\n<p>It’s a great way to build a case for your products or services, stay top of mind, and inspire leads on the fence to go ahead and make a buying&nbsp;decision.</p>\n\n<p>Email marketing allows you to target individual audience segments. You can focus on subscribers who signed up through a particular offer, have shown specific behavior (like buying products from a specific category), or nearly anything else you can think of (as long as you have the&nbsp;data).</p>\n\n<h3 id=\"is-email-marketing-suitable-for-small businesses\" class=\"wp-block-heading\">Is email marketing suitable for small&nbsp;businesses?</h3>\n\n\n<p>Absolutely! Email marketing is a great strategy for small businesses because it&#8217;s affordable and can offer a strong ROI.&nbsp;</p>\n\n\n<p>Many email marketing software solutions offer tiered pricing. If you’re a small business, you might even be able to start for&nbsp;free!</p>\n\n<p>As you see success with your efforts, you can upgrade to a higher plan and unlock even more great features to power your&nbsp;campaigns.</p>\n\n<h3 id=\"what-are-some-best-practices-for-designing-a-landing-page-for-email collection\" class=\"wp-block-heading\">What are some best practices for designing a landing page for email&nbsp;collection?</h3>\n\n<p>Start by identifying your value proposition. Determine why someone would want to give up their email address and ensure you’re providing them with something useful in exchange. Minimize distractions on your landing page like a CAPTCHA. Keep it short and&nbsp;focused.</p>\n\n\n<p>Include a strong CTA and trust signals. Finally, constantly test and adapt!&nbsp;</p>\n\n\n<h3 id=\"what-are-lead-magnets-and-how-can-i-create-one-that-appeals-to-my audience\" class=\"wp-block-heading\">What are lead magnets, and how can I create one that appeals to my&nbsp;audience?</h3>\n\n\n<p>A lead magnet is a valuable offer that you provide in exchange for a user&#8217;s email address. Think of it as a bartering tool. Customers get something for free in exchange for subscribing to your email list.&nbsp;</p>\n\n\n\n<p>Consider your business model and the preferences of your target audience. Ecommerce businesses might send customers a discount code. A B2B company might offer a guide or access to a related tool.&nbsp;</p>\n\n\n\n<p>You aren&#8217;t trying to make a sale. An email subscription is your invitation to establish a relationship with a new contact and convey your value proposition over a period of time.&nbsp;</p>\n\n\n<h3 id=\"should-i-use-captcha-to-protect-my-forms-from spam\" class=\"wp-block-heading\">Should I use CAPTCHA to protect my forms from&nbsp;spam?</h3>\n\n\n<p>No, not if you want to run the most successful campaign possible.&nbsp;</p>\n\n\n\n<p>To get the most subscribers, you need a frictionless sign-up experience. So, while you don’t want your CRM flooded with fake bot emails, you need a better solution: <a href=\"https://akismet.com/\">Akismet</a>. This AI-powered tool stops 99.99% of spam without annoying users.&nbsp;</p>\n\n\n<h3 id=\"what-is-akismet-and-how-can-it-improve-my-email-collection strategy\" class=\"wp-block-heading\">What is Akismet, and how can it improve my email collection&nbsp;strategy?</h3>\n\n<p>Akismet is an advanced spam filtration tool that uses the power of artificial intelligence. It blocks 99.99% of comment, form, and user registration spam. To date, the platform has blocked over 554 billion pieces of spam and is trusted by more than 100 million&nbsp;websites.</p>\n\n<h3 id=\"what-types-of-companies-use akismet\" class=\"wp-block-heading\">What types of companies use&nbsp;Akismet?</h3>\n\n<p>All types of companies trust Akismet to stop spam in its tracks. Roughly 100 million websites use Akismet, including enterprise brands such as Microsoft, ConvertKit, Bluehost, and more. If some of the world&#8217;s biggest brands trust Akismet to beat spam without annoying pop&#8209;up CAPTCHAs, you can,&nbsp;too.</p>\n\n<h3 class=\"wp-block-heading\">Where can I learn more about Akismet&#8217;s&nbsp;solutions?</h3>\n\n\n<p>Explore the Akismet website and blog to learn about its features and real-world use cases like<a href=\"https://akismet.com/blog/convertkit-customerstory/\"> ConvertKit</a>. Find out why millions of companies trust Akismet to put an end to spam.&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jan 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jen Swisher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Do The Woo Community: WooCommerce Security Tips: Lessons from Melapress’s annual security survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=88459\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://dothewoo.io/blog/woocommerce-security-tips-lessons-from-melapresss-annual-security-survey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:213:\"The Melapress WordPress security survey highlights critical gaps in WooCommerce security, emphasizing the need for password policies, team training, and 2FA adoption to enhance website protection against breaches.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jan 2025 11:04:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Joel Barbara\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Do The Woo Community: Why Sponsor WordCamp Asia 2025?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=88864\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://dothewoo.io/blog/why-sponsor-wordcamp-asia-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"WordCamp Asia 2025 is just around the corner. Hear why Do the Woo and others are sponsoring this year.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jan 2025 08:30:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Matt: What’s in My Bag, 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=134660\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://ma.tt/2025/01/2025-bag/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15502:\"<p>It&#8217;s another year, I have ordered all the things and tested all the cables, there&#8217;s a little bit about tech and a little bit about life. Here&#8217;s what made the cut, now I&#8217;m going to be factoring in weight of everything as well.</p>\n\n\n\n<p>The flat-lay this year was taken at my sister <a href=\"https://charleen.mullenweg.com/\">Charleen&#8217;s</a> house, where she hosted Christmas for our family for the very first time. Charleen and I have worked on the home in Austin for several years and it was awesome to see it all spruced up for the holidays and also for my Mom to visit it for the first time in 13 years. Part of the idea of my sister being in Austin is that if there&#8217;s a hurricane or anything in Houston my Mom can just drive up a few hours and be totally comfortable, so we put in an elevator, solar panels, Powerwalls, fiber, and Starlink. Her house is also my Austin headquarters when I&#8217;m in town, she set up a nice desk for me to work. Christmas was the beta-test, with Mom + nurse + four dogs all up in Austin; the whole circus was cozy and comfy for the holidays.</p>\n\n\n\n<p>I was telling my friend <a href=\"https://after-on.com/about-rob\">Rob Reid</a> the stories of my Mom and sister&#8217;s homes said I had to listen to the song <a href=\"https://open.spotify.com/track/0vb5XuWzpyzuW3Tw8wLVRW?si=81e796c8f1b84cab\">Get Mama a House by Teddybears and B.o.B</a>, it&#8217;s a good earworm and I will say that getting them both in beautiful homes they love has been one of the most rewarding things I&#8217;ve spent money on. So as advice for other entrepreneurs, get your momma a house! <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /></p>\n\n\n\n<p>TL;DR on the gadgets: The most significant change to my bag has been the introduction of the <a href=\"https://daylightcomputer.com/\">Daylight Computer</a>, which I think everyone should have and is a genuinely new platform, and that we&#8217;ve finally reached reliability and excellence on retractable USB-C cords, <a href=\"https://www.amazon.com/gp/product/B0C855QRDN/?tag=photomatt08-20\">these Baseus cords available in a variety of colors and 3.3ft and 6.6ft lengths</a>. I give them out like candy, everybody loves them. I&#8217;ve also started wearing <a href=\"https://havnwear.com/\">Havn hats/underwear/shirts/etc</a> to block unnecessary EMF. (They used to be called Lambs.) And I&#8217;ve found great nootropic benefits with <a href=\"https://drywater.com/products/45-pack-variety-bundle\">DryWater</a> and <a href=\"https://a.co/d/2yiywIO?tag=photomatt08-20\">Celsius</a>. Without further ado, here&#8217;s the list:</p>\n\n\n\n<img width=\"604\" height=\"453\" src=\"https://i0.wp.com/ma.tt/files/2025/01/FEEFC5A6-82C0-4208-95ED-0C0267274F02_1_102_o-1024x768.jpeg?resize=604%2C453&ssl=1\" alt=\"\" class=\"wp-image-134662\" />\n\n\n\n<p>THE BACKPACK</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><a href=\"https://aersf.com/collections/backpacks/products/fit-pack-3?country=US\">Aer Fit Pack 3 backpack</a>. This is still my go-to, and it&#8217;s embroidered with Automattic and WordPress logos. This is part of our standard swag at <a href=\"https://automattic.com/\">Automattic</a>, and I&#8217;d like to get a WP-embroidered one on our .org swag store when that&#8217;s back up.</li>\n</ol>\n\n\n\n<p>DEVICES</p>\n\n\n\n<ol start=\"2\" class=\"wp-block-list\">\n<li><a href=\"https://www.amazon.com/dp/B0DLHMYX53?tag=photomatt08-20\">16&#8243; Macbook Pro</a>, right now the M4 Max with 128 GB RAM, amazing what you can run locally on this this thing. I&#8217;m very excited about inference at the edge in the coming years. </li>\n\n\n\n<li><a href=\"https://www.amazon.com/dp/B0D3J98VKZ/?tag=photomatt08-20\">iPad Pro</a>, which I use as a second display when I&#8217;m on the road using Apple&#8217;s screen mirroring giving me another 10 inches of screen.</li>\n\n\n\n<li><a href=\"https://daylightcomputer.com/product\">Daylight Computer DC-1</a> represents the first truly new platform I spend time on. It&#8217;s a healthier way of computing and I would like to increase my % screentime on it in the coming years. Also amazing for kids.</li>\n\n\n\n<li><a href=\"https://www.amazon.com/gp/product/B08B495319/?tag=photomatt08-20\">Kindle Paperwhite</a>, this might lose to the Daylight in the future but I do like its form factor.</li>\n\n\n\n<li><a href=\"https://www.apple.com/shop/buy-iphone/iphone-16-pro\">iPhone 16 Pro</a>, you use your phone so much just always have the latest model. This is my primary phone.</li>\n\n\n\n<li><a href=\"https://store.google.com/config/pixel_9_pro?hl=en-US&selections=eyJwcm9kdWN0RmFtaWx5IjoiY0dsNFpXeGZPVjl3Y204PSIsInZhcmlhbnRzIjpbWyI3IiwiTVRFPSJdLFsiMiIsIk5URT0iXV19\">Google Pixel 9 Pro</a> finally is iPhone-parity for me, I use this mostly for tethering with <a href=\"https://fi.google.com/\">Google Fi</a> and testing our apps on Android. I got the pink one, it&#8217;s really a beautiful device and I could imagine a world where it was my daily driver but there&#8217;s just so much convenience in the continuity features of an all-Apple life. It&#8217;s the little things, like copy and paste, that really hook you.</li>\n</ol>\n\n\n\n<p>One nice thing is that the iPad and two phones all have connectivity plans, which I try to spread across different providers so I always have something that works or I can tether to.</p>\n\n\n\n<p>POWER/ADAPTER</p>\n\n\n\n<p>You should ABC, Always Be Charging!</p>\n\n\n\n<ol start=\"8\" class=\"wp-block-list\">\n<li><a href=\"https://a.co/d/2mfeqw4?tag=photomatt08-20\">Baseus 8-in-1 USB-C hub</a>, 99% of the time this is used as an ethernet or HDMI connector, it&#8217;s pretty reliable and not too heavy. (86 grams)</li>\n\n\n\n<li><a href=\"https://a.co/d/bQb5n19?tag=photomatt08-20\">Anker 150W Charger Block</a>, this is just a little extra, I could probably drop it.</li>\n\n\n\n<li><a href=\"https://a.co/d/fzb7i3Y?tag=photomatt08-20\">Anker 47W Nano Charger</a>, nice for setting up a charging station by the bed.</li>\n\n\n\n<li><a href=\"https://www.amazon.com/dp/B0D3Q9JW2G?tag=photomatt08-20\">Baseus 100W</a> power cable, with detachable charging block. This is the core of the entire system, and most of the time I just use this. It&#8217;s chunky at 236 grams but anchors everything else.</li>\n\n\n\n<li><a href=\"https://a.co/d/9FfU7Wp?tag=photomatt08-20\">Belkin 37W Dual USB Car Charger</a>, which I find myself using mostly in Europe when in transfers.</li>\n\n\n\n<li><a href=\"https://a.co/d/cMb9YYc?tag=photomatt08-20\">USB-C adapters</a>, just in case.</li>\n\n\n\n<li><a href=\"https://a.co/d/dA4UKRv?tag=photomatt08-20\">Whoop 4.0 Charger/Battery Pack</a>, I really enjoy the stress and sleep tracking features of the Whoop, and this keeps it charged. <a href=\"https://ma.tt/2023/06/whoop-podcast/\">I did a podcast with their founder Will Ahmed</a>.</li>\n</ol>\n\n\n\n<p>CABLES</p>\n\n\n\n<ol start=\"15\" class=\"wp-block-list\">\n<li><a href=\"https://www.bestbuy.com/site/insignia-4-micro-usb-3-0-charge-and-sync-cable-black/6380169.p?skuId=6380169&intl=nosplash\">Insignia Micro USB 3.0 Charger</a>, this is by far the most cursed cable I carry around, which is for taking photos off my Nikon SLR.</li>\n\n\n\n<li><a href=\"https://a.co/d/9B9FaYI?tag=photomatt08-20\">Cable Matters 4K HDMI Cable</a>, I like the ultra-thin and this can be clutch when connecting to a conference room or hotel TV.</li>\n\n\n\n<li>Baseus 100W/5A retractable cables, now in two sizes <a href=\"https://a.co/d/6Q8UFj6?tag=photomatt08-20\">3.3ft </a>and <a href=\"https://a.co/d/dSqfFjF?tag=photomatt08-20\">6.6ft </a>(about 100cm/200cm). These are my favorite new things! Love love love.</li>\n\n\n\n<li><a href=\"https://www.apple.com/shop/product/MT0H3AM/A/apple-watch-magnetic-fast-charger-to-usb-c-cable-1-m\">Apple Watch Magnetic Fast Charger</a>, I also usually wear an Apple Watch Ultra. I don&#8217;t do too many notifications, but it&#8217;s amazing for finding my phone.</li>\n</ol>\n\n\n\n<p>AUDIO</p>\n\n\n\n<ol start=\"19\" class=\"wp-block-list\">\n<li><a href=\"https://a.co/d/5mkyrML?tag=photomatt08-20\">AirPods Pro Gen 2</a> for pairing with the iPhone, these are so good and if I forget them it&#8217;s the first thing I pick up at the airport electronics store.</li>\n\n\n\n<li><a href=\"https://a.co/d/fSvMQHK?tag=photomatt08-20\">Pixel Buds Pro</a>, for pairing with the Pixel 9 Pro, also amazing I just don&#8217;t use as much.</li>\n\n\n\n<li><a href=\"https://soundgear.com/collections/custom-earplugs\">Custom ear plugs</a>, for protecting hearing when the sound or music is too loud.</li>\n\n\n\n<li><a href=\"https://pro.ultimateears.com/pages/ue-premier\">UE Premier custom headphones</a>, this is still the best audiophile experience I have, great on planes.</li>\n\n\n\n<li><a href=\"https://www.apple.com/shop/product/MW2Q3AM/A/usb-c-to-35-mm-headphone-jack-adapter?fnode=5ecb8873ff26cd324e22e1f34b2f927d64f27701993c1c25726ce6e7419c4f3f4c5a72cfb3887a8d74ba087a48c83b222ea9716d9237d80fded92fe23a58f41e2eb8cac0c255a4ad06d249fff0439d2ee2f05abb10bc7abf8f257c671cf9bb7d\">USB-C Headphone Jack Adapter</a></li>\n\n\n\n<li><a href=\"https://a.co/d/9A9r8Uw?tag=photomatt08-20\">Belkin RockStar 5-Jack Audio Splitter</a></li>\n\n\n\n<li><a href=\"https://a.co/d/8AhUQDT?tag=photomatt08-20\">Belkin RockStar 3.5mm Audio w/USB-C Charge Adapter</a></li>\n</ol>\n\n\n\n<p>MISCELLANEOUS ELECTRONICS&nbsp;</p>\n\n\n\n<ol start=\"26\" class=\"wp-block-list\">\n<li><a href=\"https://www.amazon.com/dp/B07YY7BH2W/?tag=photomatt08-20\">Aranet4 CO2 monitor</a>, this can change your life, if the area you&#8217;re in isn&#8217;t well ventilated then you run cognitively lower without even noticing it.</li>\n\n\n\n<li><a href=\"https://a.co/d/3c2R6iQ?tag=photomatt08-20\">Logitech mouse</a>, with quiet clicks, I find a mouse is just ergonomically an easy productivity upgrade from the built-in trackpad.</li>\n\n\n\n<li><a href=\"https://flipperzero.one/\">Flipper Zero</a>, the funnest little cloning gadget I&#8217;ve tried.</li>\n\n\n\n<li><a href=\"https://a.co/d/0ptXcgm?tag=photomatt08-20\">Pixel G1s RGB Video Light</a>, can be used in party mode to set lights.</li>\n\n\n\n<li><a href=\"https://a.co/d/3mWpYCR?tag=photomatt08-20\">USB-C chargeable Candle Lighter</a></li>\n\n\n\n<li><a href=\"https://a.co/d/0ovjqEv?tag=photomatt08-20\">Petzl E_LITE Headlamp</a></li>\n\n\n\n<li><a href=\"https://www.amazon.com/gp/product/B09P8CNRK1/?tag=photomatt08-20\">Universal Airplane Phone Holder</a></li>\n</ol>\n\n\n\n<p>PERSONAL ITEMS</p>\n\n\n\n<ol start=\"33\" class=\"wp-block-list\">\n<li>Passport</li>\n\n\n\n<li><a href=\"https://www.hermes.com/us/en/product/calvi-card-holder-H064954CK0L/\">Hermes business card holder</a>, which I&#8217;ve been using more since spending more time in Asia with the increased community activity there.</li>\n\n\n\n<li><a href=\"https://a.co/d/1e49QG0?tag=photomatt08-20\">Thread Wallet elastic card holder/wallet</a>&nbsp;</li>\n\n\n\n<li><a href=\"https://hayshop.com.au/products/portemonnaie-denim\">Hay catch-all Pouch</a></li>\n\n\n\n<li><a href=\"https://www.sea2see.org/products/treviso-sun?variant=20495073771618\">Sea2See Sunglasses</a></li>\n\n\n\n<li><a href=\"https://www.marunao.com/cms_en/products/308/\">Marunao mint case</a></li>\n\n\n\n<li><a href=\"https://lockpicktools.com/folding-pocket-set/\">Lockpick set</a>, you can learn to unlock most locks in a few hours of training. Like the Flipper this is kinda a hacker tool.</li>\n\n\n\n<li>Blue Rock, a little worry stone you can hold in your hand and rub.</li>\n\n\n\n<li>WordPress ring, because I&#8217;m married to the game.</li>\n\n\n\n<li>WordPress pin, spruces up any outfit with a little open source rizz.</li>\n\n\n\n<li>Plastic holder with stickers&nbsp;for our various brands and products, I love seeing WordPress or Tumblr stickers in random places, and sometimes place them myself.</li>\n\n\n\n<li><a href=\"https://ugmonk.com/pages/analog\">Notecards from Ugmonk Analog</a>, you can rabbit hole their entire site to upgrade your desk game. Lovely stuff.</li>\n\n\n\n<li><a href=\"https://www.amazon.com/dp/B00T9CHYOU/?tag=photomatt08-20&th=1\">Maruman N196A Nemosine Notebook</a>.</li>\n\n\n\n<li><a href=\"https://a.co/d/j9aIm7e?tag=photomatt08-20\">OHTO Needle-point Pen 0.7mm</a>, picked up in Japan and I like for when I want to draft something more thin-lined.</li>\n\n\n\n<li><a href=\"https://www.montblanc.com/en-us/ballpoint-pens_cod1647597318123131.html\">Montblanc Heritage Egyptomania Doue ballpoint pen</a>, which I like for signing important things and also crossing out todos on the Ugmonk cards.</li>\n</ol>\n\n\n\n<p>TRAVEL ESSENTIALS</p>\n\n\n\n<ol start=\"48\" class=\"wp-block-list\">\n<li><a href=\"https://www.icewear.is/us/hvitanes-neckband-merino-wool?gad_source=1&gclid=Cj0KCQiAj9m7BhD1ARIsANsIIvAXoVrkR68S3b-R-AM4uZUOiy8SUMSmcGuLjL06XZ33ixkMkepkM5waAvJ_EALw_wcB\">Icewear Merino wool gaiter</a></li>\n\n\n\n<li><a href=\"https://havnwear.com/product/wavestopper-beanie?Style=Grey+Ribbed\">Lambs EMF WaveStopper beanie</a>, literally a tin-foil hat.</li>\n\n\n\n<li><a href=\"https://a.co/d/16Y5C4t?tag=photomatt08-20\">RAINS insulated gloves</a></li>\n\n\n\n<li><a href=\"https://www.gorewear.com/us/en-us/m-windstopper-thermo-beanie-100391\">Gore Thermo Beanie</a></li>\n\n\n\n<li><a href=\"https://olospace.myshopify.com/products/invision-eye-mask\">Olo InVision Eye Mask</a>&nbsp;</li>\n\n\n\n<li><a href=\"https://www.theherbbar.com/product/thieves-ready-to-roll-1-3-oz-/936?cp=true&sa=false&sbp=false&q=false&category_id=30\">Herb Bar essential oil blend</a>, always nice to have something good-smelling around. Not endorsing this specifically, but I always have some essential oil around.</li>\n\n\n\n<li><a href=\"https://www.amazon.com/dp/B0062ALC9U/?tag=photomatt08-20\">Immunity Throat Spray</a>, suggested to me by the mushroom GOAT himself, Paul Stamets, I saw him use this at an event we were both at. When I travel or am around a bunch of people I&#8217;ll do three sprays in morning and night, and I&#8217;ve often been the one in my group to not get the &#8220;conference cold&#8221; that goes around.</li>\n\n\n\n<li><a href=\"https://a.co/d/cu0IIMj\">Z-Biotics</a>, introduced to me by my friend Sid, it&#8217;s kind of a game-changer anytime you drink, lessens the negative effects of alcohol. It works so well there&#8217;s a possibility of <a href=\"https://en.wikipedia.org/wiki/Moral_hazard\">moral hazard</a>. They have some new stuff around fiber, it&#8217;s an interesting company to follow.</li>\n\n\n\n<li><a href=\"https://a.co/d/2yiywIO?tag=photomatt08-20\">Celsius energy powder packet</a>, this is nice to turn any drink into a Celsius, when you need an extra boost. Be careful with these as they have 200mg of caffeine! I try to avoid after 2pm, and not in first hour I wake up.</li>\n\n\n\n<li><a href=\"https://drywater.com/products/45-pack-variety-bundle\">DryWater electrolytes powder packet</a>, I&#8217;ve switched to this over LMNT because I like the ingredients and sourcing better. Electrolytes when you first wake up is better than coffee, I&#8217;ll often mix this with tea.</li>\n</ol>\n\n\n\n<p>If you want to get super-nerdy, <a href=\"https://docs.google.com/spreadsheets/d/1_YM7K7OUMc2_8qqsCRHAAe2T2bgrciC4TRtDlO_aZfU/edit?usp=sharing\">here&#8217;s a spreadsheet with the weights</a>. Basically I&#8217;m 10.7 pounds of computing devices (Macbook, iPad, Daylight, Flipper, iPhone, Pixel), and ten pounds of other stuff. Add in a bottle of water or other random things I put in the bag ends up being ~22-28 pounds most of the time, which I&#8217;d like to get down.</p>\n\n\n\n<p>But with my backpack I can tackle a really wide variety of situations. It&#8217;s fun! If you have any tips or suggestions please leave them in the comments! I&#8217;m always trying out new gear.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jan 2025 06:13:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Do The Woo Community: Celebrating Seven Years of the Do the Woo Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=89092\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://dothewoo.io/celebrating-seven-years-of-do-the-woo-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:183:\"BobWP celebrates the seven-year anniversary of Do the Woo, with hosts discussing its evolution, hosts’ experiences, digital accessibility, and exciting future plans for the podcast.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jan 2025 09:58:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"Gutenberg Times: Gutenberg Changelog 113 – WordPress 6.8, Gutenberg 19.9, 20.0 and 20.1 Plugin Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=37388\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-113-wordpress-6-8-gutenberg-19-9-20-0-and-20-1-plugin-releases/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58717:\"<p>Birgit Pauli-Haack and Tammie Lister talked about WordPress 6.8, Gutenberg 19.9, 20.0 and 20.1 plugin releases. </p>\n\n\n\n<p>Add a summary/excerpt here</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Tammie Lister</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://profiles.wordpress.org/karmatosed/\">WordPress</a> | <a href=\"https://x.com/karmatosed\">X (former Twitter)</a> | <a href=\"https://bsky.app/profile/karmatosed.art\">BlueSky</a></li>\n\n\n\n<li>making @ <a href=\"https://compositionproducts.com/\" target=\"_blank\" rel=\"noreferrer noopener\">compositionproducts.com</a> </li>\n\n\n\n<li>delivering @ <a href=\"https://logicalbinary.com/\" target=\"_blank\" rel=\"noreferrer noopener\">logicalbinary.com</a> </li>\n\n\n\n<li>thinking @ <a href=\"https://binatethoughts.com/\" target=\"_blank\" rel=\"noreferrer noopener\">binatethoughts.com</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Cursor AI </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://www.youtube.com/watch?v=zhmRSFhbiGs\">Cursor AI vs Human Developer in Speed Build Special&#8230;shocking result!</a></li>\n\n\n\n<li><a href=\"https://www.youtube.com/watch?v=3_TiyKdPNq4\">Revolutionize Your WordPress Development with Cursor AI</a>&nbsp;</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress 6.8</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/01/11/wordpress-6-8-release-squad-timeline-and-focus/\">WordPress 6.8: Release Squad, Timeline, and Focus</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/design/2025/01/15/design-plans-for-wordpress-6-8/\">Design plans for WordPress 6.8</a> </li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Gutenberg plugin</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/12/18/whats-new-in-gutenberg-19-9-19-december/\">What’s new in Gutenberg 19.9? (19 December</a>)</li>\n\n\n\n<li><a href=\"https://wptavern.com/gutenberg-19-9-introduces-style-book-to-classic-themes\">Gutenberg 19.9 Introduces Style Book to Classic Themes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/01/11/whats-new-in-gutenberg-20-0-10-january/\">What’s new in&nbsp;Gutenberg&nbsp;20.0? (10 January)</a></li>\n\n\n\n<li><a href=\"https://wp-content.co/gutenberg-20/\">Gutenberg Plugin Reaches 200th Release Milestone with Version 20.0</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v20.1.0-rc.1\">Gutenberg 20.1 RC1</a> (final release Jan 22, 2025)</li>\n</ul>\n\n\n\n<p>Storybook</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.github.io/gutenberg/?path=/docs/docs-introduction--page\">WordPress Storybook </a></li>\n\n\n\n<li><a href=\"https://storybook.js.org/\">StorybookJS</a></li>\n</ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Hello, and welcome to our 113th episode of the Gutenberg Changelog.</p>\n\n\n\n<p>Dear listeners, I wish you all a happy New Year, lots of fun and laughter, good health, and most of all, prosperity and peace. Yes, we took a holiday break and there are still three plugin releases that happened in the meantime. And in today&#8217;s episode, we&#8217;ll talk about WordPress 6.8, Gutenberg 19.9, 20.0, and 20.1.</p>\n\n\n\n<p>I&#8217;m your host, Birgit Pauli-Haack, curator at the Gutenberg Times and developer advocate at Automattic. Today&#8217;s co-host is Tammie Lister, OG Gutenberg developer and designer, product consultant, and long-time core contributor to WordPress and BuddyPress, I recently noticed again.</p>\n\n\n\n<p>Thank you for joining me, Tammie. How are you today?</p>\n\n\n\n<p><em>Tammie Lister:</em> I am great. Thank you. How are you?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I&#8217;m good, I&#8217;m good. I&#8217;m done with winter, but I think I can control that. So if you&#8217;re done with winter too, let&#8217;s help and change the weather if we can do it.</p>\n\n\n\n<p><em>Tammie Lister:</em> Yeah, I am very done with winter, although it&#8217;s kind of nice as long as you just don&#8217;t go outside. But also, as long as you wrap up warm, I think that&#8217;s the thing, just&#8230;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. There are several days that I stay inside, which normally doesn&#8217;t happen, but yeah.</p>\n\n\n\n<p><em>Tammie Lister:</em> I have a wood burner, which makes winter a little bit more tolerable.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, we have central heating, which is very good. So, well, Tammie, you&#8217;re always on the forefront of web and WordPress development. What are you working on right now and what are your plans or outlook for 2025?</p>\n\n\n\n<p><em>Tammie Lister:</em> Yeah. So I guess over the holidays, I did what a lot of people did, which is I did some tinkering. So a lot of people take time off and the holidays appear to be the time when they sit down and do a project. And it appeared to be that everybody over the holiday has explored with AI development tools.</p>\n\n\n\n<p>The one that I chose, well, I chose, I did a bit of Bolt, but I also did Cursor specifically. And I was using it as a rubber duck that&#8217;s basically for development. So I was doing a lot of that in my work. I&#8217;ve been doing a combination of working on themes, but also working on some product consultancy, and that&#8217;s been really interesting to balance those. But also looking at contribution perspective, stepping back into releases. So really for me, it&#8217;s with a lot of these tools is how can I get the ideas that are in my head out faster into prototypes rather than maybe them just sitting in my head. But I don&#8217;t think I&#8217;m alone based on what I was seeing on the socials and seeing in Slack. A lot of people were just brewing ideas and just getting them out, so&#8230;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. No, no, I agree. And for those listeners who are not English natives, the rubber ducking is a process.</p>\n\n\n\n<p><em>Tammie Lister:</em> Ah, yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> &#8230; by developers who talk to actually inanimate object and get it out, but they have it ahead.</p>\n\n\n\n<p><em>Tammie Lister:</em> Sometimes a rubber duck.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That&#8217;s a rubber duck. And then by way of explaining it to somebody, most of the time a solution comes or at least, okay, another avenue to troubleshoot something opens up. So it&#8217;s a known process and it&#8217;s called rubber ducking.</p>\n\n\n\n<p><em>Tammie Lister:</em> Yeah. And a lot of these tools are really helpful for that, particularly with things like WordPress and Gutenberg, there&#8217;s always something you don&#8217;t know about or maybe there&#8217;s a feature you haven&#8217;t got to learn about. So one of the things I was able to do was be like it could teach me about that area whilst I was learning to code.</p>\n\n\n\n<p>I also did some things which are completely unrelated to that, but on the newer features. I was able to say, &#8220;How would you implement it and teach me as you are doing it each stage,&#8221; which is really helpful. It&#8217;s having that training guide as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. I really love it. And it prompts you. So speaking of Cursor AI, it actually prompts you. &#8220;Shall I explain this a little bit to you?&#8221; kind of thing.</p>\n\n\n\n<p><em>Tammie Lister:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And you say, &#8220;Yes, please do like I&#8217;m a 5-year-old,&#8221; or something.</p>\n\n\n\n<p><em>Tammie Lister:</em> &#8220;Explain it to me like I&#8217;m the rubber duck.&#8221;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And then one of the AIs, when I say, &#8220;Please make it readable for a non-technical person,&#8221; and every time they come with a legal analogy. Yeah, legal. Can they do these trademarks? Well, anyway.</p>\n\n\n\n<p><em>Tammie Lister</em>: I like whenever you&#8217;re saying with that, if you don&#8217;t set any boundaries with things like that, they try and go above and beyond. They&#8217;re very over-performing so you&#8217;ll find it&#8217;ll be like, I watched this when I watched Nick Diego when he did his block challenge and it was just, I think he just said, &#8220;Make it Christmas-y,&#8221; and it 